/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui.codemining;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.MUXFields;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.services.PinCfgGrammarAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codemining.AbstractXtextCodeMiningProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;

public class PinCfgCodeMiningProvider
extends AbstractXtextCodeMiningProvider {
    @Inject
    private PinCfgGrammarAccess grammar;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    @Inject
    private Provider<PinCfgHelper> cfgHelperProvider;

    protected void createCodeMinings(IDocument document, XtextResource resource, CancelIndicator indicator, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        boolean _isEmpty = resource.getContents().isEmpty();
        if (_isEmpty) {
            return;
        }
        List allPinSettings = EcoreUtil2.eAllOfType((EObject)((EObject)resource.getContents().get(0)), PinSetting.class);
        Keyword semiColumn = this.grammar.getPinSettingAccess().getSemicolonKeyword_6();
        for (PinSetting ps : allPinSettings) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)ps);
            PinProperties o = ps.getConfig();
            FunctionRef funcRef = this._pinCfgHelper.getFunctionRef(ps);
            if (funcRef != null && funcRef.getAlt() != null && funcRef.getAlt().getRef() != null || o == null || o.getAlt() != null) continue;
            PinCfgHelper helper = (PinCfgHelper)this.cfgHelperProvider.get();
            for (INode child : node.getAsTreeIterable()) {
                boolean _equals = semiColumn.equals((Object)child.getGrammarElement());
                if (!_equals) continue;
                String _mscrIndex = helper.getMscrIndex(ps);
                String _plus = " (MSCR_index: " + _mscrIndex;
                String annotationText = _plus + ")";
                acceptor.accept((Object)this.createNewLineContentCodeMining(child.getTotalOffset(), annotationText));
            }
        }
        List allPinProperties = EcoreUtil2.eAllOfType((EObject)((EObject)resource.getContents().get(0)), PinSetting.class);
        for (PinSetting pp : allPinProperties) {
            MUXFields _muxFields;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            ICompositeNode nodePP = NodeModelUtils.findActualNodeFor((EObject)pp);
            FunctionRef sf = this._pinCfgHelper.siulFunction(pp);
            if (sf != null) {
                PinProperties o = pp.getConfig();
                String hexValue = this._pinCfgHelper.toIOHex(o);
                FunctionRef funcRefMux = this._pinCfgHelper.getFunctionRefMux(pp);
                String _name = sf.getAlt().getRef().getName();
                String _plus = " " + _name;
                String _plus_1 = _plus + " (SSS: ";
                int _iO_SSS = this._pinCfgHelper.getIO_SSS((EObject)o);
                String _plus_2 = _plus_1 + Integer.valueOf(_iO_SSS);
                String _plus_3 = _plus_2 + ", value: ";
                String _plus_4 = _plus_3 + hexValue;
                String annotationIOText = _plus_4 + ")";
                Object annotationMUXText = "";
                if (funcRefMux != null) {
                    String _name_1 = funcRefMux.getAlt().getRef().getName();
                    String _plus_5 = " + " + _name_1;
                    String _plus_6 = _plus_5 + " (SSS: ";
                    int _sss = funcRefMux.getAlt().getSss();
                    String _plus_7 = _plus_6 + Integer.valueOf(_sss);
                    String _plus_8 = _plus_7 + ", value: ";
                    String _mUXHex = this._pinCfgHelper.toMUXHex(o, funcRefMux);
                    String _plus_9 = _plus_8 + _mUXHex;
                    String _plus_10 = _plus_9 + ")";
                    annotationMUXText = _plus_10;
                }
                String annotationText = annotationIOText + (String)annotationMUXText;
                acceptor.accept((Object)this.createNewLineContentCodeMining(nodePP.getEndOffset(), annotationText));
            }
            ArrayList list = CollectionLiterals.newArrayList();
            IOFields _ioFields = pp.getIoFields();
            boolean bl = _tripleNotEquals = _ioFields != null;
            if (_tripleNotEquals) {
                EList _reg = pp.getIoFields().getReg();
                Iterables.addAll((Collection)list, (Iterable)_reg);
            }
            boolean bl2 = _tripleNotEquals_1 = (_muxFields = pp.getMuxFields()) != null;
            if (_tripleNotEquals_1) {
                EList _reg_1 = pp.getMuxFields().getReg();
                Iterables.addAll((Collection)list, (Iterable)_reg_1);
            }
            int index = list.size();
            for (FieldInstance reg : list) {
                FieldType _attr;
                boolean _tripleNotEquals_2;
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)reg);
                int _endOffset = node.getEndOffset();
                int endOffset = _endOffset + 1;
                if (index == 1) {
                    --endOffset;
                }
                boolean bl3 = _tripleNotEquals_2 = (_attr = reg.getAttr()) != null;
                if (_tripleNotEquals_2) {
                    EnumeratedValuesType field = reg.getAttr().getEnumeratedValues();
                    if (field != null && !field.getEnumeratedValue().isEmpty()) {
                        EnumeratedValueType enumValue;
                        boolean _tripleNotEquals_3;
                        String _value = reg.getValue();
                        boolean bl4 = _tripleNotEquals_3 = _value != null;
                        if (_tripleNotEquals_3 && (enumValue = this.findEnumeratedValue(reg.getAttr(), reg.getValue())) != null) {
                            String _description = enumValue.getDescription();
                            String _plus = " // '" + _description;
                            String annotationText = _plus + "'";
                            acceptor.accept((Object)this.createNewLineContentCodeMining(endOffset, annotationText));
                        }
                    } else {
                        boolean _tripleNotEquals_4;
                        String _value_1 = reg.getValue();
                        boolean bl5 = _tripleNotEquals_4 = _value_1 != null;
                        if (_tripleNotEquals_4) {
                            boolean _tripleNotEquals_5;
                            String _description_1 = reg.getAttr().getDescription();
                            boolean bl6 = _tripleNotEquals_5 = _description_1 != null;
                            if (_tripleNotEquals_5) {
                                String _ellipsis = PinCfgHelper.ellipsis((String)reg.getAttr().getDescription(), (int)80);
                                String _plus_1 = " // '" + _ellipsis;
                                String annotationText_1 = _plus_1 + "'";
                                acceptor.accept((Object)this.createNewLineContentCodeMining(endOffset, annotationText_1));
                            }
                        }
                    }
                }
                --index;
            }
        }
    }

    public EnumeratedValueType findEnumeratedValue(FieldType field, String valueStr) {
        EnumeratedValueType _xblockexpression = null;
        EList values = field.getEnumeratedValues().getEnumeratedValue();
        EnumeratedValueType enumValue = null;
        long valueLong = this._pinCfgHelper.getLongValue(valueStr);
        if (valueLong < 0L) {
            String nameStr = valueStr.replaceAll("'", "").replaceAll("\"", "");
            Functions.Function1 _function = it -> it.getName().equals(nameStr);
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function);
        } else {
            Functions.Function1 _function_1 = it -> {
                boolean _xblockexpression_1 = false;
                long enumLong = this._pinCfgHelper.getLongValue(it.getValue());
                _xblockexpression_1 = Long.valueOf(enumLong).equals(valueLong);
                return _xblockexpression_1;
            };
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function_1);
        }
        _xblockexpression = enumValue;
        return _xblockexpression;
    }
}

