/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.MUXFields;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.RegisterConfig;
import com.st.stellar.pinmap.services.PinCfgGrammarAccess;
import com.st.stellar.pinmap.ui.contentassist.AbstractPinCfgProposalProvider;
import com.st.stellar.pinmap.validation.PinCfgValidator;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class PinCfgProposalProvider
extends AbstractPinCfgProposalProvider {
    @Inject
    private IQualifiedNameProvider qnp;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    @Inject
    private PinCfgGrammarAccess grammar;

    @Override
    public void completeInclude_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"pinmap"}));
            for (URI uri : _localModels) {
                InputOutput.println((Object)uri.toString());
                String decodedUri = URLDecoder.decode(uri.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
            Collection<URI> _models = this.getModels(model, "pinmap");
            for (URI uri_1 : _models) {
                String decodedUri = URLDecoder.decode(uri_1.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Collection<URI> getModels(EObject model, String ext) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        List _models = ModelProvider.getInstance().getModels(ext);
        for (ExtensionDescription desc : _models) {
            list.add(desc.getURI());
        }
        List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{ext}));
        for (URI uri : _localModels) {
            list.add(uri);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    @Override
    public void completeIncludeBoard_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            Collection<URI> _models = this.getModels(model, "board");
            for (URI uri : _models) {
                String decodedUri = URLDecoder.decode(uri.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
            List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"board"}));
            for (URI uri_1 : _localModels) {
                String decodedUri = URLDecoder.decode(uri_1.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void completePinProperties_Alt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinProperties pinProperties = (PinProperties)model;
        Direction direction = pinProperties.getDirection();
        EObject _eContainer = pinProperties.eContainer();
        PinSetting pinSetting = (PinSetting)_eContainer;
        EObject _eContainer_1 = pinSetting.eContainer();
        Module module = (Module)_eContainer_1;
        Package pack = this._pinCfgHelper.getPack(module);
        if (pack != null) {
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                EList _pinConfigurations = packagePin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration cfg = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = cfg.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _equals;
                        boolean _directionsAreCompatible = PinCfgValidator.directionsAreCompatible((com.st.stellar.pinmap.pinmapDsl.Direction)fct.getDirection(), (Direction)direction);
                        if (!_directionsAreCompatible || !(_equals = module.getName().getName().equals(fct.getName().getPeripheralRef().getName()))) continue;
                        String fctName = fct.getName().getName();
                        String pinName = "Pin_" + fctName;
                        this._pinCfgHelper.getRegInstances(pinProperties);
                        Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{fctName, packagePin.getName(), pinName}).toArray();
                        String proposal = NLS.bind((String)"{0} -> {1} as {2}\n\t;", (Object[])objs);
                        String _name = fct.getName().getName();
                        String _plus = _name + " on ";
                        String _name_1 = cfg.getName();
                        String _plus_1 = _plus + _name_1;
                        acceptor.accept(this.createCompletionProposal(proposal, _plus_1, null, context));
                    }
                }
            }
        }
    }

    @Override
    public void completePinSetting_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinSetting pinSetting = (PinSetting)model;
        PinProperties config = pinSetting.getConfig();
        if (config == null) {
            super.completePinSetting_Name(model, assignment, context, acceptor);
        } else {
            String _name = config.getAlt().getName();
            String nameFct = "Pad_" + _name;
            acceptor.accept(this.createCompletionProposal(nameFct, nameFct, null, context));
            String _name_1 = pinSetting.getPad().getName();
            String namePin = "Pad_" + _name_1;
            acceptor.accept(this.createCompletionProposal(namePin, namePin, null, context));
        }
    }

    @Override
    public void completeModule_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof PinSettings) {
            boolean _tripleEquals;
            PinSettings pinSettings = (PinSettings)model;
            IncludeBoard _includedBoard = pinSettings.getIncludedBoard();
            boolean bl = _tripleEquals = _includedBoard == null;
            if (_tripleEquals) {
                return;
            }
            Board board = PinCfgHelper.getBoard((PinSettings)pinSettings);
            if (board != null) {
                Package pack = board.getPackage();
                this.completeModule_Name(pack, assignment, context, acceptor);
            }
        } else if (model instanceof Board) {
            Board board_1 = (Board)model;
            Package pack_1 = board_1.getPackage();
            this.completeModule_Name(pack_1, assignment, context, acceptor);
        }
    }

    public void completeModule_Name(Package pack, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _eContainer = pack.eContainer();
        Family family = (Family)_eContainer;
        if (family != null) {
            EList _peripherals = family.getPeripherals();
            for (Peripheral module : _peripherals) {
                HashSet<Direction> directions = new HashSet<Direction>();
                if (pack == null) continue;
                EList _pins = pack.getPins();
                for (Pin packagePin : _pins) {
                    Iterable _filter = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                    for (ConfigurablePin pinConfig : _filter) {
                        Configuration cfg = pinConfig.getRef();
                        EList _functions = cfg.getFunctions();
                        for (FunctionRef fct : _functions) {
                            boolean _tripleEquals;
                            if (fct.getName().getPeripheralRef().getName() == null || !fct.getName().getPeripheralRef().getName().equals(module.getName())) continue;
                            RegisterConfig _alt = fct.getAlt();
                            boolean bl = _tripleEquals = _alt == null;
                            if (_tripleEquals) {
                                directions.add(Direction.DEFAULT_INPUT);
                                continue;
                            }
                            com.st.stellar.pinmap.pinmapDsl.Direction _direction = fct.getDirection();
                            if (_direction == null) continue;
                            switch (_direction) {
                                case INPUT: {
                                    directions.add(Direction.INPUT);
                                    break;
                                }
                                case INPUT_OR_OUTPUT: {
                                    directions.add(Direction.INPUT);
                                    directions.add(Direction.OUTPUT);
                                    break;
                                }
                                case INPUT_OUTPUT: {
                                    directions.add(Direction.INPUT_OUTPUT);
                                    break;
                                }
                                case GROUND: {
                                    break;
                                }
                                case INPUT_ALTERNATE: {
                                    break;
                                }
                                case OUTPUT: {
                                    directions.add(Direction.OUTPUT);
                                    break;
                                }
                                case OUTPUT_ALTERNATE: {
                                    break;
                                }
                                case POWER: {
                                    break;
                                }
                            }
                        }
                    }
                }
                int _size = directions.size();
                boolean _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                StringConcatenation _builder = new StringConcatenation();
                String _name = module.getName();
                _builder.append(_name);
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                String proposal = _builder.toString();
                acceptor.accept(this.createCompletionProposal(proposal, module.getName(), null, context));
            }
        }
    }

    @Override
    public void completePinSetting_Pad(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinSetting pinSetting = (PinSetting)model;
        EObject _eContainer = model.eContainer();
        Module module = (Module)_eContainer;
        Package pack = this._pinCfgHelper.getPack(module);
        if (pack == null) {
            return;
        }
        EObject _eContainer_1 = pack.eContainer();
        Family family = (Family)_eContainer_1;
        String fname = this.functionName(pinSetting.getConfig());
        if (family != null) {
            String moduleName = module.getName().getName();
            EList _pins = pack.getPins();
            for (Pin p : _pins) {
                Iterable _filter = Iterables.filter((Iterable)p.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : _filter) {
                    Functions.Function1 _function = it -> it.getName().getPeripheralRef().getName().equals(moduleName);
                    Iterable functions = IterableExtensions.filter((Iterable)pinConfig.getRef().getFunctions(), (Functions.Function1)_function);
                    for (FunctionRef fct : functions) {
                        if (fname == null || !fct.getName().getName().equals(fname)) continue;
                        String proposal = NLS.bind((String)"{0}", (Object)pinConfig.getRef().getName());
                        String _name = pinConfig.getRef().getName();
                        String _plus = "pad: " + _name;
                        acceptor.accept(this.createCompletionProposal(proposal, _plus, null, context));
                    }
                }
            }
        }
    }

    public String functionName(PinProperties properties) {
        boolean _tripleNotEquals;
        Object _xblockexpression = null;
        Function _alt = properties.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            Function fr = properties.getAlt();
            return fr.getName();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        EObject model = context.getCurrentModel();
        if (model instanceof PinSetting) {
            boolean _equals = "[".equals(proposal);
            if (_equals) {
                PinSetting ps = (PinSetting)model;
                FunctionRef funcRef = this._pinCfgHelper.getFunctionRef(ps);
                return funcRef.getAlt() != null && funcRef.getAlt().getInput() != null && funcRef.getAlt().getOutput() != null && funcRef.getAlt().getInputOutput() != null;
            }
            boolean _equals_1 = this.grammar.getIOFieldsAccess().getIOKeyword_0().getValue().equals(proposal);
            if (_equals_1) {
                PinSetting ps_1 = (PinSetting)model;
                return true;
            }
            boolean _equals_2 = this.grammar.getMUXFieldsAccess().getMUXKeyword_0().getValue().equals(proposal);
            if (_equals_2) {
                PinSetting ps_2 = (PinSetting)model;
                FunctionRef funcRef_1 = this._pinCfgHelper.getFunctionRef(ps_2);
                if (funcRef_1 == null || funcRef_1.getAlt() == null) {
                    return ps_2.getMuxFields() != null && ps_2.getMuxFields().getReg() != null;
                }
                return this.hasMux(ps_2, funcRef_1);
            }
        } else if (model instanceof Module) {
            boolean _equals_3 = this.grammar.getModuleAccess().getLeftCurlyBracketKeyword_2().getValue().equals(proposal);
            if (_equals_3) {
                return true;
            }
            boolean _equals_4 = proposal.equals("\"Comment\"");
            if (_equals_4) {
                return true;
            }
            Module module = (Module)model;
            Package pack = this._pinCfgHelper.getPack(module);
            HashSet<Direction> directions = new HashSet<Direction>();
            if (pack != null) {
                EList _pins = pack.getPins();
                for (Pin packagePin : _pins) {
                    Iterable _filter = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                    for (ConfigurablePin pinConfig : _filter) {
                        Configuration cfg = pinConfig.getRef();
                        EList _functions = cfg.getFunctions();
                        for (FunctionRef fct : _functions) {
                            boolean _tripleEquals;
                            boolean _equals_5 = fct.getName().getPeripheralRef().getName().equals(module.getName().getName());
                            if (!_equals_5) continue;
                            RegisterConfig _alt = fct.getAlt();
                            boolean bl = _tripleEquals = _alt == null;
                            if (_tripleEquals) {
                                directions.add(Direction.DEFAULT_INPUT);
                                continue;
                            }
                            com.st.stellar.pinmap.pinmapDsl.Direction _direction = fct.getDirection();
                            if (_direction == null) continue;
                            switch (_direction) {
                                case INPUT: {
                                    directions.add(Direction.INPUT);
                                    break;
                                }
                                case INPUT_OR_OUTPUT: {
                                    directions.add(Direction.INPUT);
                                    directions.add(Direction.OUTPUT);
                                    break;
                                }
                                case INPUT_OUTPUT: {
                                    directions.add(Direction.INPUT_OUTPUT);
                                    break;
                                }
                                case GROUND: {
                                    break;
                                }
                                case INPUT_ALTERNATE: {
                                    break;
                                }
                                case OUTPUT: {
                                    directions.add(Direction.OUTPUT);
                                    break;
                                }
                                case OUTPUT_ALTERNATE: {
                                    break;
                                }
                                case POWER: {
                                    break;
                                }
                            }
                        }
                    }
                }
                Functions.Function1 _function = it -> {
                    String _literal = it.getLiteral();
                    String _plus = _literal + " ";
                    return proposal.startsWith(_plus);
                };
                Direction d = (Direction)IterableExtensions.findFirst((Iterable)IterableExtensions.toList(directions), (Functions.Function1)_function);
                return d != null;
            }
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    public boolean hasMux(PinSetting pin, FunctionRef funcRef) {
        boolean _tripleNotEquals;
        boolean _xblockexpression = false;
        EObject _eContainer = funcRef.eContainer();
        Configuration cfg = (Configuration)_eContainer;
        RegisterType _ref = funcRef.getAlt().getRef();
        boolean bl = _tripleNotEquals = _ref != null;
        if (_tripleNotEquals) {
            boolean _equals = funcRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX");
            if (_equals) {
                return true;
            }
            EList _functions = cfg.getFunctions();
            for (FunctionRef fct : _functions) {
                if (!fct.getName().getName().equals(funcRef.getName().getName()) || !fct.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX")) continue;
                return true;
            }
            return false;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public FunctionRef getMuxFct(PinSetting pin, FunctionRef funcRef) {
        Object _xblockexpression = null;
        EObject _eContainer = funcRef.eContainer();
        Configuration cfg = (Configuration)_eContainer;
        if (funcRef.getAlt() != null && funcRef.getAlt().getRef() != null) {
            boolean _equals = funcRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX");
            if (_equals) {
                return funcRef;
            }
            EList _functions = cfg.getFunctions();
            for (FunctionRef fct : _functions) {
                if (!fct.getName().getName().equals(funcRef.getName().getName()) || !fct.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX")) continue;
                return fct;
            }
            return null;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static String ellipsis(String text, int max) {
        boolean _lessEqualsThan;
        String _xblockexpression = null;
        int _length = text.length();
        boolean bl = _lessEqualsThan = _length <= max;
        if (_lessEqualsThan) {
            return text;
        }
        int end = text.indexOf("\n", 0);
        String _xifexpression = null;
        if (end > 0) {
            String _substring = text.substring(0, end);
            _xifexpression = _substring + "...";
        } else {
            String _substring_1 = text.substring(0, max);
            _xifexpression = _substring_1 + "...";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public void completeFieldInstance_Attr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block20: {
            FunctionRef funcRef;
            ArrayList alreadyThere;
            Module module;
            PinSetting ps;
            block19: {
                MUXFields _muxFields;
                boolean _tripleNotEquals;
                EObject _eContainer = model.eContainer();
                ps = (PinSetting)_eContainer;
                EObject _eContainer_1 = ps.eContainer();
                module = (Module)_eContainer_1;
                alreadyThere = CollectionLiterals.newArrayList();
                funcRef = this._pinCfgHelper.getFunctionRef(ps);
                boolean _isPI = this._pinCfgHelper.isPI(funcRef);
                if (!_isPI) break block19;
                if (model instanceof IOFields) {
                    boolean _contains = funcRef.getAlt().getRef().getTypeIdentifier().contains("MUX");
                    if (_contains) {
                        FunctionRef first = this._pinCfgHelper.siulFunction(ps);
                        alreadyThere = ps.getIoFields().getReg();
                        RegisterConfig regConfig = first.getAlt();
                        RegisterType reg = regConfig.getRef();
                        if (reg != null) {
                            EList _field = reg.getField();
                            for (FieldType bf : _field) {
                                Functions.Function1 _function;
                                FieldInstance there;
                                boolean _equals = bf.getName().equals("SSS");
                                boolean _not = !_equals;
                                if (!_not || (there = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf.getName())))) != null) continue;
                                QualifiedName qn = this.qnp.getFullyQualifiedName((EObject)bf);
                                String kept = PinCfgProposalProvider.ellipsis(bf.getDescription().strip(), 25);
                                String _name = bf.getName();
                                String _name_1 = reg.getName();
                                String _plus = _name_1 + ".";
                                String _name_2 = bf.getName();
                                String _plus_1 = _plus + _name_2;
                                String _plus_2 = _plus_1 + " -> ";
                                String _plus_3 = _plus_2 + kept;
                                ICompletionProposal proposal = this.createCompletionProposal(_name, _plus_3, null, context);
                                acceptor.accept(proposal);
                            }
                            this.addMissingFunctionsProposal(ps, module, acceptor, context);
                        }
                    } else {
                        FunctionRef first_1 = this._pinCfgHelper.siulFunction(ps);
                        alreadyThere = ps.getIoFields().getReg();
                        RegisterConfig regConfig_1 = first_1.getAlt();
                        RegisterType reg_1 = regConfig_1.getRef();
                        if (reg_1 != null) {
                            EList _field_1 = reg_1.getField();
                            for (FieldType bf_1 : _field_1) {
                                Functions.Function1 _function_1;
                                FieldInstance there_1;
                                boolean _equals_1 = bf_1.getName().equals("SSS");
                                boolean _not_1 = !_equals_1;
                                if (!_not_1 || (there_1 = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_1 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf_1.getName())))) != null) continue;
                                QualifiedName qn_1 = this.qnp.getFullyQualifiedName((EObject)bf_1);
                                String kept_1 = PinCfgProposalProvider.ellipsis(bf_1.getDescription().strip(), 25);
                                String _name_3 = bf_1.getName();
                                String _name_4 = reg_1.getName();
                                String _plus_4 = _name_4 + ".";
                                String _name_5 = bf_1.getName();
                                String _plus_5 = _plus_4 + _name_5;
                                String _plus_6 = _plus_5 + " -> ";
                                String _plus_7 = _plus_6 + kept_1;
                                ICompletionProposal proposal_1 = this.createCompletionProposal(_name_3, _plus_7, null, context);
                                acceptor.accept(proposal_1);
                            }
                            this.addMissingFunctionsProposal(ps, module, acceptor, context);
                        }
                    }
                }
                boolean bl = _tripleNotEquals = (_muxFields = ps.getMuxFields()) != null;
                if (!_tripleNotEquals) break block20;
                alreadyThere = ps.getMuxFields().getReg();
                RegisterConfig regConfig_2 = funcRef.getAlt();
                RegisterType reg_2 = regConfig_2.getRef();
                if (reg_2 != null) {
                    EList _field_2 = reg_2.getField();
                    for (FieldType bf_2 : _field_2) {
                        Functions.Function1 _function_2;
                        FieldInstance there_2;
                        boolean _equals_2 = bf_2.getName().equals("SSS");
                        boolean _not_2 = !_equals_2;
                        if (!_not_2 || (there_2 = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_2 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf_2.getName())))) != null) continue;
                        QualifiedName qn_2 = this.qnp.getFullyQualifiedName((EObject)bf_2);
                        String kept_2 = PinCfgProposalProvider.ellipsis(bf_2.getDescription().strip(), 25);
                        String _name_6 = bf_2.getName();
                        String _name_7 = reg_2.getName();
                        String _plus_8 = _name_7 + ".";
                        String _name_8 = bf_2.getName();
                        String _plus_9 = _plus_8 + _name_8;
                        String _plus_10 = _plus_9 + " -> ";
                        String _plus_11 = _plus_10 + kept_2;
                        ICompletionProposal proposal_2 = this.createCompletionProposal(_name_6, _plus_11, null, context);
                        acceptor.accept(proposal_2);
                    }
                }
                break block20;
            }
            if (model instanceof IOFields && ps.getIoFields() != null) {
                alreadyThere = ps.getIoFields().getReg();
                if (funcRef.getAlt() != null && funcRef.getAlt().getRef() != null) {
                    RegisterType reg_3 = funcRef.getAlt().getRef();
                    EList _field_3 = reg_3.getField();
                    for (FieldType bf_3 : _field_3) {
                        Functions.Function1 _function_3;
                        FieldInstance there_3;
                        boolean _equals_3 = bf_3.getName().equals("SSS");
                        boolean _not_3 = !_equals_3;
                        if (!_not_3 || (there_3 = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_3 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf_3.getName())))) != null) continue;
                        QualifiedName qn_3 = this.qnp.getFullyQualifiedName((EObject)bf_3);
                        String kept_3 = PinCfgProposalProvider.ellipsis(bf_3.getDescription().strip(), 25);
                        String _name_9 = bf_3.getName();
                        String _name_10 = reg_3.getName();
                        String _plus_12 = _name_10 + ".";
                        String _name_11 = bf_3.getName();
                        String _plus_13 = _plus_12 + _name_11;
                        String _plus_14 = _plus_13 + " -> ";
                        String _plus_15 = _plus_14 + kept_3;
                        ICompletionProposal proposal_3 = this.createCompletionProposal(_name_9, _plus_15, null, context);
                        acceptor.accept(proposal_3);
                    }
                    this.addMissingFunctionsProposal(ps, module, acceptor, context);
                } else {
                    FunctionRef first_2 = this._pinCfgHelper.siulFunction(ps);
                    alreadyThere = ps.getIoFields().getReg();
                    RegisterConfig regConfig_3 = first_2.getAlt();
                    RegisterType reg_4 = regConfig_3.getRef();
                    if (reg_4 != null) {
                        EList _field_4 = reg_4.getField();
                        for (FieldType bf_4 : _field_4) {
                            Functions.Function1 _function_4;
                            FieldInstance there_4;
                            boolean _equals_4 = bf_4.getName().equals("SSS");
                            boolean _not_4 = !_equals_4;
                            if (!_not_4 || (there_4 = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_4 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf_4.getName())))) != null) continue;
                            QualifiedName qn_4 = this.qnp.getFullyQualifiedName((EObject)bf_4);
                            String kept_4 = PinCfgProposalProvider.ellipsis(bf_4.getDescription().strip(), 25);
                            String _name_12 = bf_4.getName();
                            String _name_13 = reg_4.getName();
                            String _plus_16 = _name_13 + ".";
                            String _name_14 = bf_4.getName();
                            String _plus_17 = _plus_16 + _name_14;
                            String _plus_18 = _plus_17 + " -> ";
                            String _plus_19 = _plus_18 + kept_4;
                            ICompletionProposal proposal_4 = this.createCompletionProposal(_name_12, _plus_19, null, context);
                            acceptor.accept(proposal_4);
                        }
                    }
                    this.addMissingFunctionsProposal(ps, module, acceptor, context);
                }
            } else if (model instanceof MUXFields && ps.getMuxFields() != null) {
                RegisterConfig regConfig_4;
                RegisterType reg_5;
                alreadyThere = ps.getMuxFields().getReg();
                FunctionRef funcMuxRef = this.getMuxFct(ps, funcRef);
                if (funcMuxRef != null && (reg_5 = (regConfig_4 = funcMuxRef.getAlt()).getRef()) != null) {
                    EList _field_5 = reg_5.getField();
                    for (FieldType bf_5 : _field_5) {
                        Functions.Function1 _function_5;
                        FieldInstance there_5;
                        boolean _equals_5 = bf_5.getName().equals("SSS");
                        boolean _not_5 = !_equals_5;
                        if (!_not_5 || (there_5 = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_5 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf_5.getName())))) != null) continue;
                        QualifiedName qn_5 = this.qnp.getFullyQualifiedName((EObject)bf_5);
                        String kept_5 = PinCfgProposalProvider.ellipsis(bf_5.getDescription().strip(), 25);
                        String _name_15 = bf_5.getName();
                        String _name_16 = reg_5.getName();
                        String _plus_20 = _name_16 + ".";
                        String _name_17 = bf_5.getName();
                        String _plus_21 = _plus_20 + _name_17;
                        String _plus_22 = _plus_21 + " -> ";
                        String _plus_23 = _plus_22 + kept_5;
                        ICompletionProposal proposal_5 = this.createCompletionProposal(_name_15, _plus_23, null, context);
                        acceptor.accept(proposal_5);
                    }
                }
            }
        }
    }

    public void addMissingFunctionsProposal(PinSetting ps, Module module, ICompletionProposalAcceptor acceptor, ContentAssistContext context) {
        boolean _not;
        Configuration pad = ps.getPad();
        Functions.Function1 _function = it -> {
            FieldType _attr = it.getAttr();
            return _attr != null;
        };
        Functions.Function1 _function_1 = it -> it.getAttr().getName();
        List iofields = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)ps.getIoFields().getReg(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        FunctionRef functionRef = this._pinCfgHelper.getFunctionRef(ps);
        Map missingInstances = this._pinCfgHelper.getDefaultFieldInstances(module, pad, functionRef.getName().getName(), IterableExtensions.toList((Iterable)iofields));
        Object registers = "";
        Map entries = missingInstances;
        List instanceList = IterableExtensions.toList(entries.entrySet());
        Collections.sort(instanceList, new Comparator<Map.Entry<String, String>>(this){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : instanceList) {
            boolean _greaterThan;
            int _length = ((String)registers).length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                String _registers = registers;
                registers = _registers + ",\n\t\t";
            }
            String _registers_1 = registers;
            String _key = (String)entry.getKey();
            String _plus = _key + " = ";
            String _value = (String)entry.getValue();
            String _plus_1 = _plus + _value;
            registers = _registers_1 + _plus_1;
        }
        boolean _isEmpty = ((String)registers).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ICompletionProposal proposal = this.createCompletionProposal((String)registers, "-- Add missing attributes with their default values", null, context);
            acceptor.accept(proposal);
        }
    }

    @Override
    public void completeFieldInstance_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        FieldInstance regInstance = (FieldInstance)model;
        this.completeValues(regInstance, context, acceptor);
    }

    public void completeValues(FieldInstance regInstance, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        FieldType _attr = regInstance.getAttr();
        FieldType field = _attr;
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            EList _enumeratedValue = field.getEnumeratedValues().getEnumeratedValue();
            for (EnumeratedValueType enum_ : _enumeratedValue) {
                String value = enum_.getValue();
                String desc = enum_.getDescription();
                String _xifexpression = null;
                _xifexpression = desc != null ? PinCfgProposalProvider.ellipsis(desc.strip(), 25) : value;
                String kept = _xifexpression;
                acceptor.accept(this.createCompletionProposal("\"" + value + "\"", "\"" + value + "\" -> " + kept, null, context));
            }
        } else if (field.getName() != null && field.getName().equals("SSS")) {
            PinProperties _config;
            EObject _eContainer = regInstance.eContainer();
            PinSetting ps = (PinSetting)_eContainer;
            PinProperties pp = _config = ps.getConfig();
            FunctionRef functionRef = this._pinCfgHelper.getFunctionRef(ps);
            String _hexString = Long.toHexString(functionRef.getAlt().getSss());
            String value = "0x" + _hexString;
            String _name = pp.getAlt().getName();
            String desc = "The only possible value for function: " + _name;
            acceptor.accept(this.createCompletionProposal("\"" + value + "\"", "\"" + value + "\" -> " + desc, null, context));
        }
    }

    public void complete_PinSetting(Module module, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList directions = CollectionLiterals.newArrayList((Object[])Direction.values());
        Package pack = this._pinCfgHelper.getPack(module);
        if (pack != null) {
            Functions.Function1 _function = it -> it.getConfig().getAlt().getName();
            List alreadyUsedFunctions = ListExtensions.map((List)module.getPins(), (Functions.Function1)_function);
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                EList _pinConfigurations = packagePin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration cfg = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = cfg.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _contains = alreadyUsedFunctions.contains(fct.getName().getName());
                        boolean _not = !_contains;
                        if (!_not) continue;
                        for (Direction direction : directions) {
                            boolean _directionsAreCompatible = PinCfgValidator.directionsAreCompatible((com.st.stellar.pinmap.pinmapDsl.Direction)fct.getDirection(), (Direction)direction);
                            if (!_directionsAreCompatible || fct.getName().getPeripheralRef() == null || !module.getName().getName().equals(fct.getName().getPeripheralRef().getName())) continue;
                            String directionStr = direction.getLiteral();
                            String fctName = fct.getName().getName();
                            String pinName = "Pin_" + fctName;
                            Map missingInstances = this._pinCfgHelper.getDefaultFieldInstances(module, cfg, fct.getName().getName(), Collections.unmodifiableList(CollectionLiterals.newArrayList()));
                            Object registers = "";
                            Set entries = missingInstances.entrySet();
                            List instanceList = IterableExtensions.toList(entries);
                            Collections.sort(instanceList, new Comparator<Map.Entry<String, String>>(this){

                                @Override
                                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                                    return o1.getKey().compareTo(o2.getKey());
                                }
                            });
                            for (Map.Entry entry : instanceList) {
                                boolean _greaterThan;
                                int _length = ((String)registers).length();
                                boolean bl = _greaterThan = _length > 0;
                                if (_greaterThan) {
                                    String _registers = registers;
                                    registers = _registers + ",\n\t\t";
                                }
                                String _registers_1 = registers;
                                StringConcatenation _builder = new StringConcatenation();
                                String _key = (String)entry.getKey();
                                _builder.append(_key);
                                _builder.append(" = ");
                                String _value = (String)entry.getValue();
                                _builder.append(_value);
                                registers = _registers_1 + String.valueOf(_builder);
                            }
                            Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{directionStr, fctName, cfg.getName(), pinName, registers}).toArray();
                            String proposal = NLS.bind((String)"{0} {1} -> {2} as {3}\n\tIO\n\t\t{4}\n\t\n;", (Object[])objs);
                            String _name = fct.getName().getName();
                            String _plus = directionStr + " " + _name;
                            String _plus_1 = _plus + " on pad: ";
                            String _name_1 = cfg.getName();
                            String _plus_2 = _plus_1 + _name_1;
                            acceptor.accept(this.createCompletionProposal(proposal, _plus_2, null, context));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void complete_PinSetting(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Module module = (Module)model;
        this.complete_PinSetting(module, ruleCall, context, acceptor);
    }
}

