/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui.wizard;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.pinmap.PinConfigurationComponent;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Include;
import com.st.stellar.pinmap.pinCfg.PinCfgFactory;
import com.st.stellar.pinmap.pinCfg.PinCfgPackage;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xtext.EcoreUtil2;

public class PinmapBoardWizard
extends Wizard
implements INewWizard {
    static final Logger LOG = Logger.getLogger(PinmapBoardWizard.class);
    protected PinCfgPackage pinCfgPackage = PinCfgPackage.eINSTANCE;
    protected PinCfgFactory pinCfgFactory = this.pinCfgPackage.getPinCfgFactory();
    protected PinCfgFileNamePage newFileCreationPage;
    protected PinCfgChooseModelPage chooseModelPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Creation of a board's predefined pins");
    }

    protected Collection<URI> getPinmapModels() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (ExtensionDescription desc : ModelProvider.getInstance().getModels("pinmap")) {
            list.add(desc.getURI());
        }
        Collection<URI> localModels = this.getLocalModels(this.getModelFile(), Arrays.asList("pinmap"));
        for (URI uri : localModels) {
            list.add(uri);
        }
        return list;
    }

    public Collection<Package> getPackages(URI modelURI) {
        ArrayList<Package> list = new ArrayList<Package>();
        IFile modelFile = this.getModelFile();
        if (modelFile != null) {
            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(fileURI);
            Resource r = EcoreUtil2.getResource((Resource)resource, (String)modelURI.toString());
            PinmapModel model = (PinmapModel)r.getContents().get(0);
            for (Family fam : model.getFamilies()) {
                for (Package p : fam.getPackages()) {
                    list.add(p);
                }
            }
        }
        return list;
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(0, i);
    }

    protected EObject createInitialModel(Resource resource) {
        PinConfigurationComponent config = new PinConfigurationComponent();
        config.setName("pinMapConfig");
        config.addToExportedFeatures("com.st.stellar.pinmap.pincfg");
        Include inc = this.pinCfgFactory.createInclude();
        try {
            String decodedUri = URLDecoder.decode(this.chooseModelPage.getModelURI().toString(), "UTF-8");
            inc.setImportURI(decodedUri);
            Board board = this.pinCfgFactory.createBoard();
            board.setIncludes(inc);
            board.setName(this.fileName(resource.getURI()));
            Package p = this.chooseModelPage.getPackage();
            board.setPackage(p);
            PinmapModel model = (PinmapModel)p.eContainer().eContainer();
            inc.setVersion(model.getVersion());
            inc.setIsSetVersion(true);
            config.setBoard(board);
            return config;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = PinmapBoardWizard.this.createInitialModel(resource);
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resource.save(options);
                        ComponentAPI.refreshApplication((Resource)resource);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)exception);
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable(){
                    final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
                return false;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new PinCfgFileNamePage(this, "Whatever", this.selection);
        this.newFileCreationPage.setTitle("Board predefined pin mapping");
        this.newFileCreationPage.setDescription("Creation of a board's predefined pins");
        this.newFileCreationPage.setFileName("myBoard.board");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = "myBoard";
                String defaultModelFilenameExtension = "board";
                String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.chooseModelPage = new PinCfgChooseModelPage("Whatever2");
        this.chooseModelPage.setTitle("Pinmap model");
        this.chooseModelPage.setDescription("Select your board MCU pinmap model and a package");
        this.newFileCreationPage.setChooseModelPage(this.chooseModelPage);
        this.addPage((IWizardPage)this.chooseModelPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public Collection<URI> getLocalModels(IFile resource, List<String> extensions) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        IFile file = resource;
        if (file == null) {
            return new ArrayList<URI>();
        }
        IProject project = file.getProject();
        ProjectVisitor visitor = new ProjectVisitor(files, extensions);
        ArrayList<URI> handles = new ArrayList<URI>();
        try {
            project.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage());
            return handles;
        }
        for (IFile iFile : files) {
            try {
                String decodedUri = URLDecoder.decode(iFile.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                handles.add(uri);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return handles;
    }

    public class PinCfgChooseModelPage
    extends WizardPage {
        protected Combo pinmapModelField;
        private Combo packagesField;
        protected ModifyListener validator;

        public PinCfgChooseModelPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PinCfgChooseModelPage.this.setPageComplete(PinCfgChooseModelPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText("&Pinmap model");
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.pinmapModelField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.pinmapModelField.setLayoutData((Object)data);
            int defaultIndex = -1;
            int index = 0;
            for (Object extDesc : ModelProvider.getInstance().getModels("pinmap")) {
                this.pinmapModelField.add(extDesc.getURI().toString());
                Boolean isDefault = Boolean.parseBoolean((String)extDesc.getKeyValuePairs().get("default"));
                if (isDefault.booleanValue()) {
                    defaultIndex = index;
                }
                ++index;
            }
            Collection<URI> localModels = PinmapBoardWizard.this.getLocalModels(PinmapBoardWizard.this.getModelFile(), Arrays.asList("pinmap"));
            for (URI uri : localModels) {
                this.pinmapModelField.add(uri.toString());
            }
            if (defaultIndex > 0) {
                this.pinmapModelField.select(defaultIndex);
            } else {
                this.pinmapModelField.select(0);
            }
            this.pinmapModelField.select(0);
            this.pinmapModelField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    URI model = PinCfgChooseModelPage.this.getModelURI();
                    PinCfgChooseModelPage.this.updatePackages(model);
                }
            });
            this.pinmapModelField.addModifyListener(this.validator);
            Label packagesLabel = new Label(composite, 16384);
            packagesLabel.setText("&Package");
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            packagesLabel.setLayoutData((Object)data2);
            this.packagesField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.packagesField.setLayoutData((Object)data2);
            this.packagesField.addModifyListener(this.validator);
            this.updatePackages(this.getModelURI());
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected void updatePackages(URI model) {
            if (this.packagesField != null) {
                this.packagesField.removeAll();
                for (Package pac : PinmapBoardWizard.this.getPackages(model)) {
                    this.packagesField.add(pac.getName());
                }
                this.packagesField.select(0);
            }
        }

        protected boolean validatePage() {
            return this.getModelURI() != null && this.getPackage() != null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.pinmapModelField.getItemCount() == 1) {
                    this.pinmapModelField.clearSelection();
                    this.packagesField.setFocus();
                } else {
                    this.pinmapModelField.setFocus();
                    this.packagesField.clearSelection();
                }
            }
        }

        public URI getModelURI() {
            URI res = null;
            if (this.pinmapModelField != null) {
                String label = this.pinmapModelField.getText();
                for (URI name : PinmapBoardWizard.this.getPinmapModels()) {
                    if (!name.toString().equals(label)) continue;
                    res = name;
                }
            }
            return res;
        }

        public Package getPackage() {
            String label = this.packagesField.getText();
            Collection<Package> packs = PinmapBoardWizard.this.getPackages(this.getModelURI());
            for (Package pac : packs) {
                if (!pac.getName().equals(label)) continue;
                return pac;
            }
            return null;
        }

        protected String getLabel(String typeName) {
            return typeName;
        }
    }

    public class PinCfgFileNamePage
    extends WizardNewFileCreationPage {
        private PinCfgChooseModelPage chooseModelPage = null;

        public PinCfgFileNamePage(PinmapBoardWizard this$0, String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                if (this.chooseModelPage != null) {
                    this.chooseModelPage.updatePackages(this.chooseModelPage.getModelURI());
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            if (this.getContainerFullPath() != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            }
            return null;
        }

        public void setChooseModelPage(PinCfgChooseModelPage choose) {
            this.chooseModelPage = choose;
        }
    }

    static class ProjectVisitor
    implements IResourceProxyVisitor {
        List<IResource> _list;
        List<String> _extensions;

        ProjectVisitor(List<IResource> list, List<String> extensions) {
            this._list = list;
            this._extensions = extensions;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                String ext = new Path(proxy.getName()).getFileExtension();
                if (this._extensions.contains(ext)) {
                    this._list.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

