/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui.wizard;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.pinmap.MyPinCfgFactoryImpl;
import com.st.stellar.pinmap.PinConfigurationComponent;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.PinCfgFactory;
import com.st.stellar.pinmap.pinCfg.PinCfgPackage;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.ui.handler.CopyBoardIntoProject;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xtext.EcoreUtil2;

public class PinmapConfigModelWizard
extends Wizard
implements INewWizard {
    static final Logger LOG = Logger.getLogger(PinmapConfigModelWizard.class);
    protected PinCfgPackage pinCfgPackage = PinCfgPackage.eINSTANCE;
    protected PinCfgFactory pinCfgFactory = this.pinCfgPackage.getPinCfgFactory();
    protected PinCfgFileNamePage newFileCreationPage;
    protected PinCfgChooseBoard chooseBoardPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private Collection<URI> boards = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Creation of a pinmap configuration from an existing board");
        this.boards = null;
    }

    protected Collection<URI> getBoardModels() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (ExtensionDescription desc : ModelProvider.getInstance().getModels("board")) {
            list.add(desc.getURI());
        }
        Collection<URI> localModels = this.getLocalModels(this.getModelFile(), Arrays.asList("board"));
        for (URI uri : localModels) {
            list.add(uri);
        }
        return list;
    }

    protected Collection<URI> getLocalModels(IFile resource, List<String> extensions) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        IFile file = resource;
        if (file == null) {
            return new ArrayList<URI>();
        }
        IProject project = file.getProject();
        ProjectVisitor visitor = new ProjectVisitor(files, extensions);
        ArrayList<URI> handles = new ArrayList<URI>();
        try {
            project.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage());
            return handles;
        }
        for (IFile iFile : files) {
            try {
                String decodedUri = URLDecoder.decode(iFile.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                handles.add(uri);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return handles;
    }

    public Collection<Package> getPackages(URI modelURI) {
        ArrayList<Package> list = new ArrayList<Package>();
        IFile modelFile = this.getModelFile();
        if (modelFile != null) {
            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(fileURI);
            Resource r = EcoreUtil2.getResource((Resource)resource, (String)modelURI.toString());
            PinmapModel model = (PinmapModel)r.getContents().get(0);
            for (Family fam : model.getFamilies()) {
                for (Package p : fam.getPackages()) {
                    list.add(p);
                }
            }
        }
        return list;
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(0, i);
    }

    protected EObject createInitialModel(Resource resource) {
        PinConfigurationComponent config = new PinConfigurationComponent();
        config.setName("pinMapConfig");
        config.addToExportedFeatures("com.st.stellar.pinmap.pincfg");
        PinSettings root = this.pinCfgFactory.createPinSettings();
        root.setName(this.fileName(resource.getURI()));
        ResourceSetImpl _resourceSet = new ResourceSetImpl();
        EPackage.Registry.INSTANCE.put((Object)"http://www.st.com/stellar/pinmap/PinCfg", (Object)PinCfgPackage.eINSTANCE);
        PinCfgPackage.eINSTANCE.setEFactoryInstance((EFactory)new MyPinCfgFactoryImpl());
        PinCfgFactory factory = PinCfgPackage.eINSTANCE.getPinCfgFactory();
        _resourceSet.getPackageRegistry().put((Object)factory.getEPackage().getNsURI(), (Object)this.pinCfgPackage);
        URI board = this.chooseBoardPage.getBoard();
        String fileName = null;
        String decodedUri = null;
        try {
            decodedUri = this.chooseBoardPage.mustImportBoard() ? ((fileName = CopyBoardIntoProject.copyBoardIntoProject(root, resource, board, _resourceSet.getURIConverter())) == null ? URLDecoder.decode(board.toString(), "UTF-8") : URLDecoder.decode(fileName, "UTF-8")) : (this.chooseBoardPage.mustCopyBoard() ? ((fileName = CopyBoardIntoProject.copyBoardIntoConfig(root, resource, board, _resourceSet.getURIConverter())) == null ? URLDecoder.decode(board.toString(), "UTF-8") : URLDecoder.decode(fileName, "UTF-8")) : URLDecoder.decode(board.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        IncludeBoard inc = this.pinCfgFactory.createIncludeBoard();
        inc.setImportURI(decodedUri);
        root.setIncludedBoard(inc);
        Resource r = EcoreUtil2.getResource((Resource)resource, (String)board.toString());
        PinConfiguration boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0));
        Resource boardResource = EcoreUtil2.getResource((Resource)r, (String)boardConfig.getBoard().getIncludes().getImportURI());
        PinmapModel model = (PinmapModel)PinmapModel.class.cast(boardResource.getContents().get(0));
        if (model.getVersion() != null) {
            inc.setVersion(model.getVersion());
            inc.setIsSetVersion(true);
        } else {
            inc.setIsSetVersion(false);
        }
        config.setPinSetting(root);
        return config;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = PinmapConfigModelWizard.this.createInitialModel(resource);
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resource.save(options);
                        EPackage.Registry.INSTANCE.put((Object)"http://www.st.com/stellar/pinmap/PinCfg", (Object)PinCfgPackage.eINSTANCE);
                        ComponentAPI.refreshApplication((Resource)resource);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)exception);
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable(){
                    final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
                return false;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new PinCfgFileNamePage(this, "Whatever", this.selection);
        this.newFileCreationPage.setTitle("Pinmap configuration");
        this.newFileCreationPage.setDescription("Create a pinmap configuration, based on a predefined board");
        this.newFileCreationPage.setFileName("myConfig.pincfg");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = "myConfig";
                String defaultModelFilenameExtension = "pincfg";
                String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.chooseBoardPage = new PinCfgChooseBoard("Whatever2");
        this.chooseBoardPage.setTitle("Pinmap board");
        this.chooseBoardPage.setDescription("Select a board");
        this.addPage((IWizardPage)this.chooseBoardPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    static class ProjectVisitor
    implements IResourceProxyVisitor {
        List<IResource> _list;
        List<String> _extensions;

        ProjectVisitor(List<IResource> list, List<String> extensions) {
            this._list = list;
            this._extensions = extensions;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                String ext = new Path(proxy.getName()).getFileExtension();
                if (this._extensions.contains(ext)) {
                    this._list.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }

    public class PinCfgChooseBoard
    extends WizardPage {
        protected Combo boardField;
        protected Button importBoardConfig;
        protected Button copyBoardConfig;
        protected Button noCopy;
        protected ModifyListener validator;

        public PinCfgChooseBoard(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PinCfgChooseBoard.this.setPageComplete(PinCfgChooseBoard.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            Object data = new GridData();
            ((GridData)data).verticalAlignment = 4;
            ((GridData)data).grabExcessVerticalSpace = true;
            ((GridData)data).horizontalAlignment = 4;
            composite.setLayoutData(data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText("&Board name");
            data = new GridData();
            ((GridData)data).horizontalAlignment = 4;
            containerLabel.setLayoutData(data);
            this.boardField = new Combo(composite, 2048);
            data = new GridData();
            ((GridData)data).horizontalAlignment = 4;
            ((GridData)data).grabExcessHorizontalSpace = true;
            this.boardField.setLayoutData(data);
            for (URI extDesc : PinmapConfigModelWizard.this.getBoardModels()) {
                this.boardField.add(extDesc.toString());
            }
            this.boardField.select(0);
            this.boardField.addModifyListener(this.validator);
            Group importMode = new Group(composite, 4);
            importMode.setText("Select how to use board configuration");
            importMode.setLayout((Layout)new GridLayout(1, false));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            importMode.setLayoutData((Object)data2);
            this.noCopy = new Button((Composite)importMode, 16);
            this.noCopy.setText("Do not import board");
            this.noCopy.setToolTipText("Use predefined board definitions");
            this.noCopy.setSelection(true);
            this.importBoardConfig = new Button((Composite)importMode, 16);
            this.importBoardConfig.setText("Import board into the workspace");
            this.importBoardConfig.setToolTipText("Import board definitions into the workspace to modify them");
            this.copyBoardConfig = new Button((Composite)importMode, 16);
            this.copyBoardConfig.setText("Copy board definitions into pin configuration");
            this.copyBoardConfig.setToolTipText("Create pin configuration pre-filled with board definitions");
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getBoard() != null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.boardField.getItemCount() == 1) {
                    this.boardField.clearSelection();
                } else {
                    this.boardField.setFocus();
                }
            }
        }

        public URI getBoard() {
            URI res = null;
            String label = this.boardField.getText();
            for (URI name : this.getPinmapBoards()) {
                if (!name.toString().equals(label)) continue;
                res = name;
            }
            return res;
        }

        public boolean mustImportBoard() {
            return this.importBoardConfig.getSelection();
        }

        public boolean mustCopyBoard() {
            return this.copyBoardConfig.getSelection();
        }

        private Collection<URI> getLocalModels(IFile resource, List<String> extensions) {
            ArrayList<IResource> files = new ArrayList<IResource>();
            IFile file = resource;
            if (file == null) {
                return new ArrayList<URI>();
            }
            IProject project = file.getProject();
            ProjectVisitor visitor = new ProjectVisitor(files, extensions);
            ArrayList<URI> handles = new ArrayList<URI>();
            try {
                project.accept((IResourceProxyVisitor)visitor, 0);
            }
            catch (CoreException e) {
                LOG.error((Object)e.getMessage());
                return handles;
            }
            for (IFile iFile : files) {
                try {
                    String decodedUri = URLDecoder.decode(iFile.getProjectRelativePath().toOSString(), "UTF-8");
                    URI uri = URI.createFileURI((String)decodedUri);
                    handles.add(uri);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return handles;
        }

        private Collection<URI> getPinmapBoards() {
            ArrayList<URI> list = new ArrayList<URI>();
            for (ExtensionDescription desc : ModelProvider.getInstance().getModels("board")) {
                list.add(desc.getURI());
            }
            Collection<URI> localModels = this.getLocalModels(PinmapConfigModelWizard.this.getModelFile(), Arrays.asList("board"));
            for (URI uri : localModels) {
                list.add(uri);
            }
            return list;
        }

        protected String getLabel(String typeName) {
            return typeName;
        }
    }

    public class PinCfgFileNamePage
    extends WizardNewFileCreationPage {
        public PinCfgFileNamePage(PinmapConfigModelWizard this$0, String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            return super.validatePage();
        }

        public IFile getModelFile() {
            if (this.getContainerFullPath() != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            }
            return null;
        }
    }
}

