/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap;

import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.ResourceUtils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Include;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import com.st.stellar.pinmap.pinmapDsl.RegisterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class PinCfgResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    @Inject
    private ImportUriResolver uriResolver;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    @Inject
    private IResourceServiceProvider.Registry reg;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xifexpression = false;
        if (!(eObject instanceof PinConfiguration)) {
            if (eObject instanceof com.st.stellar.pinmap.pinCfg.Include) {
                return this.createEObjectDescriptionForInclude((com.st.stellar.pinmap.pinCfg.Include)eObject, acceptor);
            }
            if (eObject instanceof RegisterConfig) {
                return super.createEObjectDescriptions(eObject, acceptor);
            }
            return super.createEObjectDescriptions(eObject, acceptor);
        }
        _xifexpression = this.myCreateEObjectDescriptions(eObject, acceptor);
        return _xifexpression;
    }

    protected boolean _myCreateEObjectDescriptions(Include include, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xblockexpression = false;
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)include.eResource(), (String)include.getImportURI()));
        DocumentRoot docRoot = (DocumentRoot)_resourceToEObject;
        ComponentType comp = docRoot.getComponent();
        EList _memoryMap = comp.getMemoryMaps().getMemoryMap();
        for (MemoryMapType m : _memoryMap) {
            this.myCreateEObjectDescriptions((EObject)m, acceptor);
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    protected boolean _myCreateEObjectDescriptions(MemoryMapType mmap, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xblockexpression = false;
        EList _addressBlock = mmap.getAddressBlock();
        for (AddressBlockType ab : _addressBlock) {
            EList _register = ab.getRegister();
            for (RegisterType r : _register) {
                this.myCreateEObjectDescriptions((EObject)r, acceptor);
            }
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    protected boolean _myCreateEObjectDescriptions(RegisterType reg, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xblockexpression = false;
        EList _field = reg.getField();
        for (FieldType f : _field) {
            this.myCreateEObjectDescriptions((EObject)f, acceptor);
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    protected boolean _myCreateEObjectDescriptions(FieldType field, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xblockexpression = false;
        acceptor.accept((Object)EObjectDescription.create((String)field.getName(), (EObject)field));
        _xblockexpression = true;
        return _xblockexpression;
    }

    protected boolean _myCreateEObjectDescriptions(PinSettings model, IAcceptor<IEObjectDescription> acceptor) {
        boolean _xblockexpression = false;
        Board board = PinCfgHelper.getBoard(model);
        if (board != null) {
            boolean _tripleNotEquals;
            ArrayList uris = CollectionLiterals.newArrayList();
            HashMap<String, String> userData = new HashMap<String, String>();
            com.st.stellar.pinmap.pinCfg.Include _includes = board.getIncludes();
            boolean bl = _tripleNotEquals = _includes != null;
            if (_tripleNotEquals) {
                uris.add(this.uriResolver.apply((EObject)board.getIncludes()));
                userData.put("includes", IterableExtensions.join((Iterable)uris, (CharSequence)","));
            }
            QualifiedName qn = QualifiedName.create((String)model.eResource().getURI().toString());
            acceptor.accept((Object)EObjectDescription.create((QualifiedName)qn, (EObject)model, userData));
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    protected boolean _myCreateEObjectDescriptions(PinConfiguration cfg, IAcceptor<IEObjectDescription> acceptor) {
        boolean _tripleNotEquals;
        boolean _xblockexpression = false;
        this._pinCfgHelper = PinCfgHelper.instance;
        Board _board = cfg.getBoard();
        boolean bl = _tripleNotEquals = _board != null;
        if (_tripleNotEquals) {
            acceptor.accept((Object)EObjectDescription.create((String)cfg.getBoard().getName(), (EObject)cfg.getBoard()));
        } else {
            boolean _tripleNotEquals_1;
            PinSettings _pinSetting = cfg.getPinSetting();
            boolean bl2 = _tripleNotEquals_1 = _pinSetting != null;
            if (_tripleNotEquals_1) {
                Board board;
                boolean _tripleNotEquals_2;
                PinSettings model = cfg.getPinSetting();
                ArrayList uris = CollectionLiterals.newArrayList();
                HashMap<String, String> userData = new HashMap<String, String>();
                IncludeBoard _includedBoard = cfg.getPinSetting().getIncludedBoard();
                boolean bl3 = _tripleNotEquals_2 = _includedBoard != null;
                if (_tripleNotEquals_2 && (board = PinCfgHelper.getBoard(model)) != null && board.getIncludes() != null) {
                    uris.add(this.uriResolver.apply((EObject)board.getIncludes()));
                    userData.put("includes", IterableExtensions.join((Iterable)uris, (CharSequence)","));
                }
                QualifiedName qn = QualifiedName.create((String)model.eResource().getURI().toString());
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qn, (EObject)model, userData));
            }
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public boolean createEObjectDescriptionForInclude(com.st.stellar.pinmap.pinCfg.Include include, IAcceptor<IEObjectDescription> acceptor) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        ArrayList uris = CollectionLiterals.newArrayList();
        String _importURI = include.getImportURI();
        boolean bl = _tripleEquals = _importURI == null;
        if (_tripleEquals) {
            return false;
        }
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)include.eResource(), (String)include.getImportURI()));
        PinmapModel importedPinmap = (PinmapModel)_resourceToEObject;
        if (importedPinmap == null) {
            return false;
        }
        Consumer<Include> _function = it -> uris.add(this.uriResolver.apply((EObject)it));
        importedPinmap.getIncludes().forEach(_function);
        QualifiedName qn = QualifiedName.create((String)include.eResource().getURI().toString());
        acceptor.accept((Object)EObjectDescription.create((QualifiedName)qn, (EObject)include));
        EList _families = importedPinmap.getFamilies();
        for (Family f : _families) {
            this.createEObjectDescriptionForFamilies(f, acceptor);
        }
        Consumer<Include> _function_1 = it -> uris.add(this.uriResolver.apply((EObject)it));
        importedPinmap.getIncludes().forEach(_function_1);
        EList _includes = importedPinmap.getIncludes();
        for (Include inc : _includes) {
            this.createEObjectDescriptions((EObject)inc, acceptor);
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public void createEObjectDescriptionForFamilies(Family family, IAcceptor<IEObjectDescription> acceptor) {
        IDefaultResourceDescriptionStrategy otherLangDescriptionStrategy = (IDefaultResourceDescriptionStrategy)this.reg.getResourceServiceProvider(family.eResource().getURI()).get(IDefaultResourceDescriptionStrategy.class);
        otherLangDescriptionStrategy.createEObjectDescriptions((EObject)family, acceptor);
    }

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return super.getQualifiedNameProvider();
    }

    public boolean createReferenceDescriptions(EObject from, URI exportedContainerURI, IAcceptor<IReferenceDescription> acceptor) {
        return super.createReferenceDescriptions(from, exportedContainerURI, acceptor);
    }

    @XbaseGenerated
    public boolean myCreateEObjectDescriptions(EObject cfg, IAcceptor<IEObjectDescription> acceptor) {
        if (cfg instanceof PinConfiguration) {
            return this._myCreateEObjectDescriptions((PinConfiguration)cfg, acceptor);
        }
        if (cfg instanceof PinSettings) {
            return this._myCreateEObjectDescriptions((PinSettings)cfg, acceptor);
        }
        if (cfg instanceof Include) {
            return this._myCreateEObjectDescriptions((Include)cfg, acceptor);
        }
        if (cfg instanceof FieldType) {
            return this._myCreateEObjectDescriptions((FieldType)cfg, acceptor);
        }
        if (cfg instanceof MemoryMapType) {
            return this._myCreateEObjectDescriptions((MemoryMapType)cfg, acceptor);
        }
        if (cfg instanceof RegisterType) {
            return this._myCreateEObjectDescriptions((RegisterType)cfg, acceptor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cfg, acceptor).toString());
    }
}

