/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.helpers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.Converter;
import com.st.stellar.pinmap.helpers.Pair;
import com.st.stellar.pinmap.helpers.ResourceUtils;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinCfgFactory;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Include;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import com.st.stellar.pinmap.pinmapDsl.RegisterConfig;
import com.st.stellar.pinmap.validation.PinCfgValidator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AccessType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ResetType1;

public class PinCfgHelper {
    public static String PINCFG_VERSION = "2.1.0";
    @Inject
    private IResourceServiceProvider.Registry rspr;
    @Inject
    private IQualifiedNameProvider qnprovider;
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    @Extension
    private Converter _converter;
    @Inject
    @Extension
    private Utils _utils;
    public static PinCfgHelper instance = new PinCfgHelper();
    private static Map<String, Resource> _resourceCache = new HashMap<String, Resource>();
    private static Map<String, String> BITFIELD_MAP = null;
    private static final Logger logger = Logger.getLogger(PinCfgHelper.class);
    private static int pageWidth = 80;
    private static final LinkedHashMap<com.st.stellar.pinmap.pinmapDsl.Direction, String> directionMap = CollectionLiterals.newLinkedHashMap((org.eclipse.xtext.xbase.lib.Pair[])new org.eclipse.xtext.xbase.lib.Pair[]{org.eclipse.xtext.xbase.lib.Pair.of((Object)com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OR_OUTPUT, (Object)"inout"), org.eclipse.xtext.xbase.lib.Pair.of((Object)com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT, (Object)"out"), org.eclipse.xtext.xbase.lib.Pair.of((Object)com.st.stellar.pinmap.pinmapDsl.Direction.INPUT, (Object)"in")});
    private static final boolean debug = false;

    public String getBitFieldMacro(String bitfieldStr) {
        String _xblockexpression = null;
        if (BITFIELD_MAP == null) {
            BITFIELD_MAP = CollectionLiterals.newHashMap();
            BITFIELD_MAP.put("OERC(\"0x0\")", " | SIUL2_MSCR_IO_OERC_WEAK");
            BITFIELD_MAP.put("OERC(\"0x1\")", " | SIUL2_MSCR_IO_OERC_MEDIUM");
            BITFIELD_MAP.put("OERC(\"0x2\")", " | SIUL2_MSCR_IO_OERC_STRONG");
            BITFIELD_MAP.put("OERC(\"0x3\")", " | SIUL2_MSCR_IO_OERC_VERY_STRONG");
            BITFIELD_MAP.put("ODC(\"0x0\")", " | SIUL2_MSCR_IO_ODC_DISABLED");
            BITFIELD_MAP.put("ODC(\"0x1\")", " | SIUL2_MSCR_IO_ODC_OPEN_DRAIN");
            BITFIELD_MAP.put("ODC(\"0x2\")", " | SIUL2_MSCR_IO_ODC_PUSH_PULL");
            BITFIELD_MAP.put("ODC(\"0x3\")", " | SIUL2_MSCR_IO_ODC_OPEN_SOURCE");
            BITFIELD_MAP.put("ODC(\"0x4\")", " | SIUL2_MSCR_IO_ODC_MICROSEC_LVDS");
            BITFIELD_MAP.put("ODC(\"0x5\")", " | SIUL2_MSCR_IO_ODC_LFAST_LVDS");
            BITFIELD_MAP.put("SMC(\"0x0\")", "");
            BITFIELD_MAP.put("SMC(\"0x1\")", " | SIUL2_MSCR_IO_SMC");
            BITFIELD_MAP.put("APC(\"0x1\")", " | SIUL2_MSCR_IO_APC");
            BITFIELD_MAP.put("ILS(\"0x0\")", " | SIUL2_MSCR_IO_ILS_AUTO");
            BITFIELD_MAP.put("ILS(\"0x1\")", " | SIUL2_MSCR_IO_ILS_TTL");
            BITFIELD_MAP.put("ILS(\"0x2\")", " | SIUL2_MSCR_IO_ILS_LVDS");
            BITFIELD_MAP.put("ILS(\"0x3\")", " | SIUL2_MSCR_IO_ILS_CMOS");
            BITFIELD_MAP.put("IBE(\"0x0\")", "");
            BITFIELD_MAP.put("IBE(\"0x1\")", " | SIUL2_MSCR_IO_IBE");
            BITFIELD_MAP.put("INV(\"0x1\")", " | SIUL2_MSCR_IO_INV");
            BITFIELD_MAP.put("HYS(\"0x1\")", " | SIUL2_MSCR_IO_HYS");
            BITFIELD_MAP.put("WPDE(\"0x1\")", " | SIUL2_MSCR_IO_WPDE");
            BITFIELD_MAP.put("WPUE(\"0x1\")", " | SIUL2_MSCR_IO_WPUE");
            BITFIELD_MAP.put("INV(\"0x1\")", " | SIUL2_MSCR_IO_INV");
            BITFIELD_MAP.put("FILPRESC(\"0x0\")", "");
            BITFIELD_MAP.put("FILPRESC(\"0x1\")", " | SIUL2_MSCR_IO_FILPRESC_PRCD1");
            BITFIELD_MAP.put("FILPRESC(\"0x2\")", " | SIUL2_MSCR_IO_FILPRESC_PRCD2");
            BITFIELD_MAP.put("FILPRESC(\"0x3\")", " | SIUL2_MSCR_IO_FILPRESC_PRCD3");
            BITFIELD_MAP.put("FILBYPASS(\"0x0\")", "");
            BITFIELD_MAP.put("FILBYPASS(\"0x1\")", " | SIUL2_MSCR_IO_FILBYPASS");
        }
        _xblockexpression = BITFIELD_MAP.get(bitfieldStr);
        return _xblockexpression;
    }

    public void printExportedObjects(Resource resource) {
        IResourceServiceProvider resServiceProvider = this.rspr.getResourceServiceProvider(resource.getURI());
        IResourceDescription.Manager manager = resServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(resource);
        Iterable _exportedObjects = description.getExportedObjects();
        for (IEObjectDescription eod : _exportedObjects) {
            QualifiedName _name = eod.getName();
            String _plus = String.valueOf(_name) + ": ";
            String _string = this.converter.toString(eod.getQualifiedName());
            String _plus_1 = _plus + _string;
            InputOutput.println((Object)_plus_1);
        }
    }

    public Iterable<IEObjectDescription> getExportedObjects(Resource resource) {
        Iterable _xblockexpression = null;
        IResourceServiceProvider resServiceProvider = this.rspr.getResourceServiceProvider(resource.getURI());
        IResourceDescription.Manager manager = resServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(resource);
        _xblockexpression = description.getExportedObjects();
        return _xblockexpression;
    }

    public static String bits(FieldType field) {
        int _intValue_1;
        boolean _tripleEquals;
        String _xblockexpression = null;
        Object res = null;
        BigInteger _bitOffset = field.getBitOffset();
        boolean bl = _tripleEquals = _bitOffset == null;
        if (_tripleEquals) {
            return res;
        }
        int start = field.getBitOffset().intValue();
        int _intValue = field.getBitOffset().intValue();
        int _plus = _intValue + (_intValue_1 = field.getBitWidth().getValue().intValue());
        int end = _plus - 1;
        if (end == start) {
            res = String.valueOf(31 - start);
        } else {
            String _valueOf = String.valueOf(31 - end);
            String _plus_1 = _valueOf + ":";
            String _valueOf_1 = String.valueOf(31 - start);
            String _plus_2 = _plus_1 + _valueOf_1;
            res = _plus_2;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static String bitsBigEndian(FieldType field) {
        String _xblockexpression = null;
        int start = field.getBitOffset().intValue();
        int _intValue = field.getBitOffset().intValue();
        int _intValue_1 = field.getBitWidth().getValue().intValue();
        int _plus = _intValue + _intValue_1;
        int end = _plus - 1;
        Object res = "";
        if (end == start) {
            res = String.valueOf(start);
        } else {
            String _valueOf = String.valueOf(start);
            String _plus_1 = _valueOf + ":";
            String _valueOf_1 = String.valueOf(end);
            String _plus_2 = _plus_1 + _valueOf_1;
            res = _plus_2;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static String ellipsis(String text, int max) {
        String _xifexpression = null;
        if (text == null || text.length() <= max) {
            return text;
        }
        String _xblockexpression = null;
        int end = text.indexOf("\n", 0);
        String _xifexpression_1 = null;
        if (end > 0) {
            String _substring = text.substring(0, end);
            _xifexpression_1 = _substring + "...";
        } else {
            String _substring_1 = text.substring(0, max);
            _xifexpression_1 = _substring_1 + "...";
        }
        _xifexpression = _xblockexpression = _xifexpression_1;
        return _xifexpression;
    }

    public String toHex(PinProperties pin) {
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(ps);
        Object hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
        Direction _direction = pin.getDirection();
        if (_direction != null) {
            switch (_direction) {
                case DEFAULT_INPUT: {
                    if (fct != null) {
                        hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
                        break;
                    }
                    hexValueStr = null;
                    break;
                }
                case INPUT: {
                    Object _elvis = null;
                    String _input = funcRef.getAlt().getInput();
                    _elvis = _input != null ? _input : hexValueStr;
                    hexValueStr = _elvis;
                    break;
                }
                case INPUT_OUTPUT: {
                    Object _elvis_1 = null;
                    String _inputOutput = funcRef.getAlt().getInputOutput();
                    _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                    hexValueStr = _elvis_1;
                    break;
                }
                case OUTPUT: {
                    Object _elvis_2 = null;
                    String _output = funcRef.getAlt().getOutput();
                    _elvis_2 = _output != null ? _output : hexValueStr;
                    hexValueStr = _elvis_2;
                    break;
                }
                default: {
                    hexValueStr = null;
                    break;
                }
            }
        } else {
            hexValueStr = null;
        }
        if (hexValueStr == null) {
            return "0x0";
        }
        long hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
        boolean _isSIUL = this.isSIUL(pin);
        hexValue = _isSIUL ? this.addIO_SSSToHexValue(pin, hexValue) : this.addMUX_SSSToHexValue(pin, hexValue);
        if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            EList<FieldInstance> regInstances = ps.getIoFields().getReg();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = PinCfgHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from, to);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
            }
        }
        String _hexString = Long.toHexString(hexValue);
        String _plus = "0x" + _hexString;
        hexValueStr = _plus;
        return hexValueStr;
    }

    public String toIOHex(PinProperties pin) {
        long hexValue;
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef pinFunctionRef = this.getFunctionRef(ps);
        FunctionRef funcRef = pinFunctionRef;
        if (funcRef == null || funcRef.getAlt() == null || funcRef.getAlt().getRef().getReset() == null) {
            funcRef = this.siulFunction(ps);
        }
        Object hexValueStr = null;
        if (funcRef != null && funcRef.getAlt() != null && funcRef.getAlt().getRef().getReset() != null) {
            hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
            Direction _direction = pin.getDirection();
            if (_direction != null) {
                switch (_direction) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case INPUT: {
                        Object _elvis = null;
                        String _input = funcRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        Object _elvis_1 = null;
                        String _inputOutput = funcRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        Object _elvis_2 = null;
                        String _output = funcRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        if ((hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16)) == 0L && funcRef != null && funcRef.getAlt() != null && funcRef.getAlt().getInput() == null && funcRef.getAlt().getInputOutput() == null && funcRef.getAlt().getOutput() == null) {
            FunctionRef fisrt = this.getFirstFunctionRef(ps);
            Object _direction_1 = pin.getDirection();
            if (_direction_1 != null) {
                switch (1.$SwitchMap$com$st$stellar$pinmap$pinCfg$Direction[((Enum)_direction_1).ordinal()]) {
                    case 1: {
                        if (fct != null) {
                            hexValueStr = fisrt.getAlt().getRef().getReset().getValue().getValue();
                            hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case 2: {
                        Object _elvis_3 = null;
                        String _input_1 = fisrt.getAlt().getInput();
                        _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                        hexValueStr = _elvis_3;
                        hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
                        break;
                    }
                    case 3: {
                        Object _elvis_4 = null;
                        String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                        _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                        hexValueStr = _elvis_4;
                        hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
                        break;
                    }
                    case 4: {
                        Object _elvis_5 = null;
                        String _output_1 = fisrt.getAlt().getOutput();
                        _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                        hexValueStr = _elvis_5;
                        hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        hexValue = this.addIO_SSSToHexValue(pin, hexValue);
        if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            EList<FieldInstance> regInstances = ps.getIoFields().getReg();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = PinCfgHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    String _hexString = Long.toHexString(hexValue);
                    String _plus = "toIOHex before: " + _hexString;
                    logger.debug((Object)_plus);
                    long input = hexValue;
                    hexValue = this.getBitFieldValue(field, inst.getValue(), input, from, to);
                    String _hexString_1 = Long.toHexString(hexValue);
                    String _plus_1 = "toIOHex after: " + _hexString_1;
                    logger.debug((Object)_plus_1);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                String _hexString_2 = Long.toHexString(hexValue);
                String _plus_2 = "toIOHex before1: " + _hexString_2;
                logger.debug((Object)_plus_2);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
                String _hexString_3 = Long.toHexString(hexValue);
                String _plus_3 = "toIOHex after1: " + _hexString_3;
                logger.debug((Object)_plus_3);
            }
        }
        String _format = String.format("%0" + Integer.valueOf(8) + "X", hexValue);
        String _plus_4 = "0x" + _format;
        hexValueStr = _plus_4;
        return hexValueStr;
    }

    public boolean isSIUL(PinProperties pin) {
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef funcRefMux = this.getFunctionRefMux(ps);
        return funcRefMux == null;
    }

    public boolean isMUX(PinProperties pin) {
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef functionRef = this.getFunctionRef(ps);
        if (functionRef == null) {
            return false;
        }
        return functionRef.getAlt().getRef().getName().startsWith("MSCR_MUX");
    }

    public long addMUX_SSSToHexValue(PinProperties pin, long hexValueInput) {
        long _xblockexpression = 0L;
        int sss = this.getMUX_SSS(pin);
        FieldType fieldSSS = null;
        long hexValueWithSSS = 0L;
        RegisterType register = this.getRef(pin);
        boolean isSIUL = false;
        if (register != null && register.getField() != null) {
            Functions.Function1 _function = it -> it.getName().equals("SSS");
            fieldSSS = (FieldType)IterableExtensions.findFirst((Iterable)register.getField(), (Functions.Function1)_function);
            if (fieldSSS != null) {
                String _hexString = Long.toHexString(sss);
                String _plus = "0x" + _hexString;
                hexValueWithSSS = this.addFieldValue(fieldSSS, _plus, hexValueInput);
            }
        } else {
            EObject _eContainer = pin.eContainer();
            PinSetting ps = (PinSetting)_eContainer;
            FunctionRef siulFunction = this.siulFunction(ps);
            if (siulFunction != null) {
                RegisterConfig _alt = null;
                if (siulFunction != null) {
                    _alt = siulFunction.getAlt();
                }
                Functions.Function1 _function_1 = it -> it.getName().equals("SSS");
                fieldSSS = (FieldType)IterableExtensions.findFirst((Iterable)_alt.getRef().getField(), (Functions.Function1)_function_1);
                if (fieldSSS != null) {
                    String _hexString_1 = Long.toHexString(sss);
                    String _plus_1 = "0x" + _hexString_1;
                    hexValueWithSSS = this.addFieldValue(fieldSSS, _plus_1, hexValueInput);
                }
            }
        }
        _xblockexpression = hexValueWithSSS;
        return _xblockexpression;
    }

    public long addIO_SSSToHexValue(PinProperties pin, long hexValueInput) {
        long _xblockexpression = 0L;
        int sss = this.getIO_SSS(pin);
        FieldType fieldSSS = null;
        long hexValueWithSSS = 0L;
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef siulFunction = this.siulFunction(ps);
        if (siulFunction != null) {
            RegisterConfig _alt = null;
            if (siulFunction != null) {
                _alt = siulFunction.getAlt();
            }
            Functions.Function1 _function = it -> it.getName().equals("SSS");
            fieldSSS = (FieldType)IterableExtensions.findFirst((Iterable)_alt.getRef().getField(), (Functions.Function1)_function);
            if (fieldSSS != null) {
                String _hexString = Long.toHexString(sss);
                String _plus = "0x" + _hexString;
                hexValueWithSSS = this.addFieldValue(fieldSSS, _plus, hexValueInput);
            }
        }
        _xblockexpression = hexValueWithSSS;
        return _xblockexpression;
    }

    public long addFieldValue(FieldType field, String instValue, long hexValueInput) {
        long _xblockexpression = 0L;
        String bits = PinCfgHelper.bits(field);
        long _xifexpression = 0L;
        if (bits != null) {
            long _xifexpression_1 = 0L;
            boolean _contains = bits.contains(":");
            if (_contains) {
                long hexValue;
                boolean _notEquals;
                long _xblockexpression_1 = 0L;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                long input = hexValueInput;
                _xifexpression_1 = _xblockexpression_1 = (hexValue = this.getBitFieldValue(field, instValue, input, from, to));
            } else {
                long hexValue;
                long _xblockexpression_2 = 0L;
                int from = Integer.parseInt(bits);
                _xifexpression_1 = _xblockexpression_2 = (hexValue = this.getBitFieldValue(field, instValue, hexValueInput, from));
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String IOValues(PinProperties pin) {
        return this.getValues(pin, false);
    }

    public String MUXValues(PinProperties pin) {
        return this.getValues(pin, true);
    }

    public String getValues(PinProperties pin, boolean mux) {
        boolean _equals;
        long hexValue;
        boolean _tripleNotEquals;
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(ps);
        String hexValueStr = null;
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            Direction _direction = pin.getDirection();
            if (_direction != null) {
                switch (_direction) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case INPUT: {
                        String _elvis = null;
                        String _input = funcRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_1 = null;
                        String _inputOutput = funcRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_2 = null;
                        String _output = funcRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L && funcRef.getAlt() != null && funcRef.getAlt().getInput() == null && funcRef.getAlt().getInputOutput() == null && funcRef.getAlt().getOutput() == null) {
            FunctionRef fisrt = this.siulFunction(ps);
            Direction _direction_1 = pin.getDirection();
            if (_direction_1 != null) {
                switch (_direction_1) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = fisrt.getAlt().getRef().getReset().getValue().getValue();
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case INPUT: {
                        String _elvis_3 = null;
                        String _input_1 = fisrt.getAlt().getInput();
                        _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                        hexValueStr = _elvis_3;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_4 = null;
                        String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                        _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                        hexValueStr = _elvis_4;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_5 = null;
                        String _output_1 = fisrt.getAlt().getOutput();
                        _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                        hexValueStr = _elvis_5;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        EList<FieldInstance> regInstances = CollectionLiterals.newArrayList();
        int sss = this.getIO_SSS(pin);
        if (mux) {
            if (ps.getMuxFields() != null && ps.getMuxFields().getReg() != null) {
                regInstances = ps.getMuxFields().getReg();
            }
        } else if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            regInstances = ps.getIoFields().getReg();
        }
        Object fieldStr1 = "";
        int _length = hexValueStr.length();
        int lineLength = _length + 6;
        int _size = regInstances.size();
        boolean bl2 = _equals = _size == 0;
        if (_equals) {
            String _fieldStr1 = fieldStr1;
            fieldStr1 = _fieldStr1 + "SSS -> " + Integer.valueOf(sss);
            int _lineLength = lineLength;
            int _length_1 = ((String)fieldStr1).length();
            lineLength = _lineLength + _length_1;
        }
        int nb = 0;
        Object fieldStr2 = "";
        int _size_1 = regInstances.size();
        int max = _size_1 - 1;
        for (FieldInstance inst : regInstances) {
            if (inst.getAttr() != null && inst.getValue() != null) {
                int _length_2;
                int _plus;
                boolean _greaterThan;
                FieldType field = inst.getAttr();
                String attr = field.getName();
                String value = inst.getValue();
                if (nb == 0) {
                    String _fieldStr2 = fieldStr2;
                    fieldStr2 = _fieldStr2 + "SSS -> " + Integer.valueOf(sss) + ", ";
                }
                boolean bl3 = _greaterThan = (_plus = (_length_2 = ((String)fieldStr2).length()) + lineLength) > 55;
                if (_greaterThan) {
                    int _length_3 = ((String)fieldStr2).length();
                    int _plus_1 = _length_3 + lineLength;
                    int _minus = pageWidth - _plus_1;
                    int spaces = _minus - 6;
                    Object _fieldStr1_1 = fieldStr1;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((String)fieldStr2);
                    String _repeat = " ".repeat(Math.max(spaces, 1));
                    _builder.append(_repeat);
                    _builder.append("\\");
                    _builder.newLineIfNotEmpty();
                    fieldStr1 = (String)_fieldStr1_1 + String.valueOf(_builder);
                    fieldStr2 = "";
                    lineLength = 0;
                } else if (nb < max) {
                    Object _fieldStr2_1 = fieldStr2;
                    fieldStr2 = (String)_fieldStr2_1 + attr + " -> " + value + ", ";
                } else {
                    Object _fieldStr2_2 = fieldStr2;
                    fieldStr2 = (String)_fieldStr2_2 + attr + " -> " + value;
                }
            }
            ++nb;
        }
        Object _fieldStr1_1 = fieldStr1;
        fieldStr1 = (String)_fieldStr1_1 + (String)fieldStr2;
        int _length_2 = ((String)fieldStr2).length();
        int _plus = _length_2 + lineLength;
        int _minus = pageWidth - _plus;
        int nbSpaces = _minus - 9;
        Object _fieldStr1_2 = fieldStr1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("*/");
        String _repeat = " ".repeat(Math.max(nbSpaces, 1));
        _builder.append(_repeat, " ");
        _builder.append("\\");
        _builder.newLineIfNotEmpty();
        fieldStr1 = (String)_fieldStr1_2 + String.valueOf(_builder);
        Object fieldStr = "";
        ArrayList macrosList = CollectionLiterals.newArrayList();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)sss);
        macrosList.add(_builder_1.toString());
        nb = 0;
        for (FieldInstance inst_1 : regInstances) {
            if (inst_1.getAttr() != null && inst_1.getValue() != null) {
                FieldType field = inst_1.getAttr();
                String attr = field.getName();
                CharSequence value = this.toHexString(inst_1.getValue());
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(attr);
                _builder_2.append("(");
                _builder_2.append((Object)value);
                _builder_2.append(")");
                String macro = _builder_2.toString();
                String fieldStrMacro = this.getBitFieldMacro(macro);
                if (fieldStrMacro != null) {
                    macrosList.add(macro);
                }
            }
            ++nb;
        }
        if (mux) {
            RegisterType r = funcRef.getAlt().getRef();
            ArrayList<String> values = this.getValues(r, hexValueStr);
            for (String v : values) {
                boolean _alreadyPresentIn = this.alreadyPresentIn(v, macrosList);
                boolean _not = !_alreadyPresentIn;
                if (!_not) continue;
                macrosList.add(v);
            }
        } else {
            RegisterType r_1 = this.siulFunction(ps).getAlt().getRef();
            ArrayList<String> values_1 = this.getValues(r_1, hexValueStr);
            for (String v_1 : values_1) {
                boolean _alreadyPresentIn_1 = this.alreadyPresentIn(v_1, macrosList);
                boolean _not_1 = !_alreadyPresentIn_1;
                if (!_not_1) continue;
                macrosList.add(v_1);
            }
        }
        Object macros = fieldStr;
        int lenSSS = 0;
        for (String m : macrosList) {
            String fieldStrMacro = this.getBitFieldMacro(m);
            if (fieldStrMacro != null) {
                boolean _greaterThan;
                int _length_4;
                int _length_3 = ((String)macros).length();
                int _plus_1 = _length_3 + 2;
                int _plus_2 = _plus_1 + (_length_4 = fieldStrMacro.length());
                int _plus_3 = _plus_2 + lenSSS;
                boolean bl4 = _greaterThan = _plus_3 > 65;
                if (_greaterThan) {
                    int _length_5 = ((String)macros).length();
                    int _plus_4 = _length_5 + 4;
                    int _plus_5 = _plus_4 + lenSSS;
                    int _minus_1 = pageWidth - _plus_5;
                    int spaces = _minus_1 - 2;
                    Object _fieldStr = fieldStr;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _repeat_1 = " ".repeat(Math.max(spaces, 1));
                    _builder_2.append(_repeat_1);
                    _builder_2.append("\\");
                    _builder_2.newLineIfNotEmpty();
                    String _plus_6 = (String)macros + String.valueOf(_builder_2);
                    fieldStr = (String)_fieldStr + _plus_6;
                    macros = "";
                    lenSSS = 0;
                }
                String _macros = macros;
                macros = _macros + fieldStrMacro;
                continue;
            }
            try {
                int v_2 = Integer.parseInt(m);
                String _fieldStr_1 = fieldStr;
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("SIUL2_MSCR_IO_SSS(");
                _builder_3.append((Object)v_2);
                _builder_3.append(")");
                fieldStr = _fieldStr_1 + String.valueOf(_builder_3);
                lenSSS = ((String)fieldStr).length();
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return (String)fieldStr1 + (String)fieldStr + (String)macros;
    }

    public CharSequence toHexString(String string) {
        StringConcatenation _xblockexpression = null;
        String s = string.replaceAll("\"", "").replaceAll("'", "");
        StringConcatenation _xifexpression = null;
        boolean _startsWith = s.startsWith("0x");
        if (_startsWith) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append(s);
            _builder.append("\"");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"0x");
            String _hexString = Integer.toHexString(Integer.parseInt(s));
            _builder_1.append(_hexString);
            _builder_1.append("\"");
            _xifexpression = _builder_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean alreadyPresentIn(String v, ArrayList<String> list) {
        Pattern pattern = Pattern.compile("(.+)\\(.*\\)$");
        Matcher matcher = pattern.matcher(v);
        boolean _find = matcher.find();
        if (_find) {
            String attribute = matcher.group(1);
            Predicate<String> _function = it -> {
                boolean _xblockexpression = false;
                int i = it.indexOf("(");
                boolean _xifexpression = false;
                if (i > 0) {
                    boolean present;
                    boolean _xblockexpression_1 = false;
                    String a = it.substring(0, i);
                    _xifexpression = _xblockexpression_1 = (present = a.equals(attribute));
                } else {
                    _xifexpression = false;
                }
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            };
            List macthingAttrList = list.stream().filter(_function).collect(Collectors.toList());
            int _size = macthingAttrList.size();
            return _size > 0;
        }
        return false;
    }

    public String toUpper(String s) {
        return s.toUpperCase(Locale.US);
    }

    public String toMUXHex(PinProperties pin) {
        boolean _tripleNotEquals;
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(ps);
        Object hexValueStr = null;
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            Direction _direction = pin.getDirection();
            if (_direction != null) {
                switch (_direction) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case INPUT: {
                        Object _elvis = null;
                        String _input = funcRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        Object _elvis_1 = null;
                        String _inputOutput = funcRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        Object _elvis_2 = null;
                        String _output = funcRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        long hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
        hexValue = this.addMUX_SSSToHexValue(pin, hexValue);
        if (ps.getMuxFields() != null && ps.getMuxFields().getReg() != null) {
            EList<FieldInstance> regInstances = ps.getMuxFields().getReg();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = PinCfgHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl2 = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from, to);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
            }
        }
        String _hexString = Long.toHexString(hexValue);
        String _plus = "0x" + _hexString;
        hexValueStr = _plus;
        return hexValueStr;
    }

    public String toMUXHex(PinProperties pin, FunctionRef funcRef) {
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        Object hexValueStr = null;
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        long hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
        hexValue = this.addMUX_SSSToHexValue(pin, hexValue);
        if (ps.getMuxFields() != null && ps.getMuxFields().getReg() != null) {
            EList<FieldInstance> regInstances = ps.getMuxFields().getReg();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = PinCfgHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from, to);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
            }
        }
        String _hexString = Long.toHexString(hexValue);
        String _plus = "0x" + _hexString;
        hexValueStr = _plus;
        return hexValueStr;
    }

    public long getBitFieldValue(FieldType field, String instValue, long hexInput, int from, int to) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return 0L;
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        String _binaryString = Long.toBinaryString(mask);
        String _plus = "mask:     " + _binaryString;
        logger.debug((Object)_plus);
        String _binaryString_1 = Long.toBinaryString(hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL));
        String _plus_1 = "hexValue: " + _binaryString_1;
        logger.debug((Object)_plus_1);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = this.getLongValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        long enumvalue = this.getLongValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                if (enumDisplay == null) {
                    hexValue = 0L;
                    _xifexpression_2 = 0L;
                } else {
                    long _xblockexpression_3 = 0L;
                    long longValue = this.getLongValue(enumDisplay.getValue());
                    long _xifexpression_3 = 0L;
                    if (longValue > 0L) {
                        long _xblockexpression_4 = 0L;
                        long valmask = longValue << 31 - to;
                        _xifexpression_3 = _xblockexpression_4 = (hexValue |= valmask);
                    } else {
                        _xifexpression_3 = hexValue;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            long longValue = this.getLongValue(instValue);
            long valmask = longValue << 31 - to;
            longValue = mask & valmask;
            _xifexpression = _xblockexpression_2 = (hexValue |= valmask);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long getBitFieldValue(FieldType field, String instValue, long hexInput, int from) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        long mask = 1L << 31 - from;
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = this.getLongValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = this.getLongValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                _xifexpression_2 = enumDisplay != null ? Long.parseLong(enumDisplay.getValue().substring(2), 16) : -1L;
                long index = _xifexpression_2;
                long _xifexpression_3 = 0L;
                if (index != -1L) {
                    long _xblockexpression_3 = 0L;
                    long valmask = index << 31 - from;
                    _xifexpression_3 = _xblockexpression_3 = (hexValue |= valmask);
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_3;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            String rawValue = instValue.replace("\"", "");
            boolean _startsWith = rawValue.startsWith("0x");
            if (_startsWith) {
                long value = Long.parseLong(rawValue.substring(2), 16);
                long valmask = value << 31 - from;
                value = mask & valmask;
                hexValue |= valmask;
            }
            _xifexpression = _xblockexpression_2 = hexValue;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Object decode(RegisterType reg, String hexValue) {
        EList _field = reg.getField();
        for (FieldType bitField : _field) {
            int to = 0;
            long mask = 0L;
            String bits = PinCfgHelper.bits(bitField);
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.replaceAll("\"", "").split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    return null;
                }
                int from = Integer.parseInt(bitlist[0]);
                to = Integer.parseInt(bitlist[1]);
                if (from >= 32 || from < 0) {
                    return null;
                }
                if (to >= 32 || to < 0) {
                    return null;
                }
                if (from >= to) {
                    return null;
                }
                mask = 1L << 31 - from;
                for (int i = from + 1; i <= to; ++i) {
                    mask |= 1L << 31 - i;
                }
                long decValue = Long.parseLong(hexValue.substring(2), 16);
                decValue &= mask;
                decValue >>= 31 - to;
                continue;
            }
            to = Integer.parseInt(bits.replaceAll("\"", ""));
            if (to >= 32 || to < 0) {
                return null;
            }
            mask = 1L << 31 - to;
            long decValue_1 = Long.parseLong(hexValue.substring(2), 16);
            decValue_1 &= mask;
            decValue_1 >>= 31 - to;
        }
        return null;
    }

    public void createRegInstances(PinProperties props) {
        boolean _tripleEquals;
        EObject _eContainer = props.eContainer();
        PinSetting setting = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(setting);
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            return;
        }
        RegisterType reg = funcRef.getAlt().getRef();
        Functions.Function1 _function = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals("SSS");
        FieldInstance sss = (FieldInstance)IterableExtensions.findFirst(setting.getIoFields().getReg(), (Functions.Function1)_function);
        FunctionRef functionRef = this.getFunctionRef(setting);
        if (sss != null) {
            sss.setValue(Integer.toString(functionRef.getAlt().getSss()));
        } else {
            EList fields = functionRef.getAlt().getRef().getField();
            Functions.Function1 _function_1 = it -> it.getName().equals("SSS");
            FieldType sssField = (FieldType)IterableExtensions.findFirst((Iterable)fields, (Functions.Function1)_function_1);
            sss = PinCfgFactory.eINSTANCE.createFieldInstance();
            sss.setAttr(sssField);
            String _hexString = Long.toHexString(functionRef.getAlt().getSss());
            String _plus = "0x" + _hexString;
            sss.setValue(_plus);
            setting.getIoFields().getReg().add((Object)sss);
        }
        String hexValue = this.toHex(setting.getConfig());
        Functions.Function1 _function_2 = it -> {
            boolean _equals = it.getName().equals("SSS");
            return !_equals;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
        for (FieldType bitField : _filter) {
            this.createRegInstance(setting, bitField.getName(), hexValue);
        }
    }

    public boolean createRegInstance(PinSetting config, String bfName, String hexValue) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> it.getAttr() != null && it.getAttr().getDisplayName() != null && it.getAttr().getDisplayName().equals(bfName);
        FieldInstance regInst = (FieldInstance)IterableExtensions.findFirst(config.getIoFields().getReg(), (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (regInst == null) {
            boolean _xblockexpression_1 = false;
            FunctionRef functionRef = this.getFunctionRef(config);
            Functions.Function1 _function_1 = it -> it.getName().equals(bfName);
            FieldType bf = (FieldType)IterableExtensions.findFirst((Iterable)functionRef.getAlt().getRef().getField(), (Functions.Function1)_function_1);
            regInst = PinCfgFactory.eINSTANCE.createFieldInstance();
            regInst.setAttr(bf);
            this._utils = Utils.instance;
            this._converter = Converter.instance;
            String value = this._converter.adapt(functionRef.getAlt().getRef(), bfName, hexValue);
            regInst.setValue(value);
            _xifexpression = _xblockexpression_1 = config.getIoFields().getReg().add((Object)regInst);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getFunctionName(PinSetting pinSetting) {
        return pinSetting.getConfig().getAlt().getName();
    }

    public FunctionRef getFunctionRef(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Configuration pad = pinSetting.getPad();
        EObject _eContainer = pinSetting.eContainer();
        Module module = (Module)_eContainer;
        if (pad != null) {
            EList _functions = pad.getFunctions();
            for (FunctionRef f : _functions) {
                boolean _equals_1;
                boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
                if (!_equals || !(_equals_1 = f.getName().getName().equals(this.getFunctionName(pinSetting)))) continue;
                return f;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public boolean isPI(FunctionRef ref) {
        return ref != null && ref.getAlt() != null && ref.getAlt().getInput() == null && ref.getAlt().getOutput() == null && ref.getAlt().getInputOutput() == null;
    }

    public FunctionRef getFirstFunctionRef(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Configuration pad = pinSetting.getPad();
        if (pad != null) {
            return (FunctionRef)pad.getFunctions().get(0);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public FunctionRef getFunctionRefMux(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Configuration pad = pinSetting.getPad();
        EObject _eContainer = pinSetting.eContainer();
        Module module = (Module)_eContainer;
        if (pad != null) {
            EList _functions = pad.getFunctions();
            for (FunctionRef f : _functions) {
                boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
                if (!_equals || f.getAlt() == null || !f.getName().getName().equals(this.getFunctionName(pinSetting)) || f.getAlt().getIndex() <= 511) continue;
                return f;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public FunctionRef getFunctionRefMux(Configuration pad, Module module, String functionName) {
        Object _xblockexpression = null;
        EList _functions = pad.getFunctions();
        for (FunctionRef f : _functions) {
            boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
            if (!_equals || f.getAlt() == null || !f.getName().getName().equals(functionName) || f.getAlt().getIndex() <= 511) continue;
            return f;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public FunctionRef getFunctionRefMux(Configuration pad, String functionName) {
        Object _xblockexpression = null;
        EList _functions = pad.getFunctions();
        for (FunctionRef f : _functions) {
            if (f.getAlt() == null || !f.getName().getName().equals(functionName) || f.getAlt().getIndex() <= 511) continue;
            return f;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public QualifiedName getQualifiedFunctionName(PinSetting pinSetting) {
        if (this.qnprovider != null) {
            return this.qnprovider.getFullyQualifiedName((EObject)pinSetting.getConfig().getAlt());
        }
        return null;
    }

    public String getAssociatedPeripheral(PinSetting pinSetting) {
        String _xblockexpression = null;
        FunctionRef funcRef = this.getFunctionRef(pinSetting);
        _xblockexpression = funcRef.getName().getPeripheralRef().getName();
        return _xblockexpression;
    }

    public String getMscrIndex(PinSetting pinSetting) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        FunctionRef funcRef = this.getFunctionRef(pinSetting);
        String _xifexpression = null;
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            FunctionRef siul = this.siulFunction(pinSetting);
            _xifexpression = _xblockexpression_1 = String.valueOf(siul.getAlt().getIndex());
        } else {
            _xifexpression = String.valueOf(funcRef.getAlt().getIndex());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getMscrSSS(PinSetting pinSetting) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        FunctionRef funcRef = this.getFunctionRef(pinSetting);
        String _xifexpression = null;
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            String _xblockexpression_1 = null;
            FunctionRef siul = this.siulFunction(pinSetting);
            _xifexpression = _xblockexpression_1 = String.valueOf(siul.getAlt().getSss());
        } else {
            _xifexpression = String.valueOf(funcRef.getAlt().getSss());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public FunctionRef siulFunction(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Configuration pad = pinSetting.getPad();
        if (pad != null) {
            Functions.Function1 _function = it -> it.getAlt() != null && it.getAlt().getSss() == 0;
            FunctionRef siul = (FunctionRef)IterableExtensions.findFirst((Iterable)pad.getFunctions(), (Functions.Function1)_function);
            return siul;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public FunctionRef getSiulFunction(Configuration pad) {
        Functions.Function1 _function = it -> it.getAlt() != null && it.getAlt().getSss() == 0;
        FunctionRef siul = (FunctionRef)IterableExtensions.findFirst((Iterable)pad.getFunctions(), (Functions.Function1)_function);
        return siul;
    }

    public FunctionRef getIOorSiulFunction(Configuration pinConfig, String functionName) {
        Functions.Function1 _function;
        EList functions = pinConfig.getFunctions();
        FunctionRef siul = (FunctionRef)IterableExtensions.findFirst((Iterable)functions, (Functions.Function1)(_function = it -> it.getAlt() != null && it.getAlt().getSss() != 0 && it.getDirection() == com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT && it.getName().getName().equals(functionName)));
        if (siul == null) {
            InputOutput.println((Object)functionName);
            siul = this.getSiulFunction(pinConfig);
        }
        return siul;
    }

    public static ArrayList<String> getDirections(PinSetting ps, String proposal) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> directions = new ArrayList<String>();
        Configuration pad = ps.getPad();
        EList _functions = pad.getFunctions();
        for (FunctionRef fct : _functions) {
            boolean comp = PinCfgValidator.directionsAreCompatible(fct.getDirection(), Direction.get(proposal));
            if (!comp || directions.contains(fct.getDirection().getLiteral())) continue;
            directions.add(fct.getDirection().getLiteral());
        }
        _xblockexpression = directions;
        return _xblockexpression;
    }

    public static ArrayList<String> getDirections(PinSetting ps) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> directions = new ArrayList<String>();
        Configuration pad = ps.getPad();
        Functions.Function1 _function = it -> it.getName().getName().equals(ps.getConfig().getAlt().getName());
        Iterable _filter = IterableExtensions.filter((Iterable)pad.getFunctions(), (Functions.Function1)_function);
        for (FunctionRef fct : _filter) {
            directions.add(directionMap.get(fct.getDirection()));
        }
        _xblockexpression = directions;
        return _xblockexpression;
    }

    public static List<Package> getPackages(PinSettings ps) {
        EList _xblockexpression = null;
        Board board = PinCfgHelper.getBoard(ps);
        com.st.stellar.pinmap.pinCfg.Include inc = board.getIncludes();
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)inc.eResource(), (String)inc.getImportURI()));
        PinmapModel importedPinmap = (PinmapModel)_resourceToEObject;
        _xblockexpression = ((Family)importedPinmap.getFamilies().get(0)).getPackages();
        return _xblockexpression;
    }

    public PinmapModel getPinmapModel(PinSettings ps) {
        PinmapModel importedPinmap;
        PinmapModel _xblockexpression = null;
        Board board = PinCfgHelper.getBoard(ps);
        com.st.stellar.pinmap.pinCfg.Include inc = board.getIncludes();
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)inc.eResource(), (String)inc.getImportURI()));
        _xblockexpression = importedPinmap = (PinmapModel)_resourceToEObject;
        return _xblockexpression;
    }

    public static List<PinSetting> getPinSettings(PinSettings settings) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        if (settings == null) {
            return pins;
        }
        EList<Module> _modules = settings.getModules();
        for (Module mod : _modules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getAllPinSettings(PinSettings settings) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        EList<Module> _allModules = PinCfgHelper.getAllModules(settings);
        for (Module mod : _allModules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                Functions.Function1 _function = it -> it.getName() != null && it.getName().equals(pin.getName());
                Iterable filter = IterableExtensions.filter(pins, (Functions.Function1)_function);
                int _size = IterableExtensions.size((Iterable)filter);
                boolean _equals = _size == 0;
                if (!_equals) continue;
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getAllPinSettings(PinConfiguration cfg) {
        Board board_1;
        boolean _tripleNotEquals;
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        PinSettings _pinSetting = cfg.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            EList<Module> _modules = cfg.getPinSetting().getModules();
            for (Module mod : _modules) {
                EList<PinSetting> _pins = mod.getPins();
                Iterator iterator = _pins.iterator();
                while (iterator.hasNext()) {
                    PinSetting pin = (PinSetting)iterator.next();
                    pins.add(pin);
                }
            }
            Board board = PinCfgHelper.getBoard(cfg.getPinSetting());
            if (board != null) {
                EList<Module> _modules_1 = board.getModules();
                for (Module mod_1 : _modules_1) {
                    EList<PinSetting> _pins_1 = mod_1.getPins();
                    for (PinSetting pin_1 : _pins_1) {
                        pins.add(pin_1);
                    }
                }
            }
        }
        if ((board_1 = cfg.getBoard()) != null) {
            EList<Module> _modules_2 = board_1.getModules();
            for (Module mod_2 : _modules_2) {
                EList<PinSetting> _pins_2 = mod_2.getPins();
                for (PinSetting pin_2 : _pins_2) {
                    pins.add(pin_2);
                }
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getPinSettings(Board board) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        if (board == null) {
            return pins;
        }
        EList<Module> _modules = board.getModules();
        for (Module mod : _modules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public boolean isMUX(PinSetting pin) {
        String _name_3;
        String _name_1;
        boolean _xblockexpression = false;
        String _name = pin.getConfig().getDirection().getName();
        boolean _equals = Objects.equals(_name, _name_1 = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT.getName());
        if (_equals) {
            return true;
        }
        String _name_2 = pin.getConfig().getDirection().getName();
        boolean _equals_1 = Objects.equals(_name_2, _name_3 = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT.getName());
        if (_equals_1) {
            boolean _tripleNotEquals;
            FunctionRef funcRef = this.getFunctionRef(pin);
            RegisterConfig _alt = funcRef.getAlt();
            boolean bl = _tripleNotEquals = _alt != null;
            if (_tripleNotEquals) {
                boolean _notEquals;
                int _sss = funcRef.getAlt().getSss();
                boolean bl2 = _notEquals = _sss != 0;
                if (_notEquals) {
                    return true;
                }
            }
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean hasMUX(PinSetting pin) {
        String _name_3;
        String _name_1;
        boolean _xblockexpression = false;
        String _name = pin.getConfig().getDirection().getName();
        boolean _equals = Objects.equals(_name, _name_1 = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT.getName());
        if (_equals) {
            FunctionRef _functionRefMux = this.getFunctionRefMux(pin);
            return _functionRefMux != null;
        }
        String _name_2 = pin.getConfig().getDirection().getName();
        boolean _equals_1 = Objects.equals(_name_2, _name_3 = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT.getName());
        if (_equals_1) {
            boolean _tripleNotEquals;
            FunctionRef funcRef = this.getFunctionRef(pin);
            RegisterConfig _alt = funcRef.getAlt();
            boolean bl = _tripleNotEquals = _alt != null;
            if (_tripleNotEquals) {
                boolean _notEquals;
                int _sss = funcRef.getAlt().getSss();
                boolean bl2 = _notEquals = _sss != 0;
                if (_notEquals) {
                    return true;
                }
            }
            return false;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public RegisterConfig getAlt(PinProperties config) {
        boolean _tripleNotEquals;
        Object _xblockexpression = null;
        EObject _eContainer = config.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(ps);
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            return funcRef.getAlt();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected int _getIO_SSS(PinSetting pin) {
        FunctionRef funcRefMux;
        int _xblockexpression = 0;
        FunctionRef functionRef = this.getFunctionRef(pin);
        if (functionRef.getAlt() != null && functionRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX") && (funcRefMux = this.getFunctionRefMux(pin)) != null) {
            functionRef = this.siulFunction(pin);
        }
        int _xifexpression = 0;
        _xifexpression = functionRef != null && functionRef.getAlt() != null ? functionRef.getAlt().getSss() : 0;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected int _getMUX_SSS(PinSetting pin) {
        int _xblockexpression = 0;
        FunctionRef funcRefMux = this.getFunctionRefMux(pin);
        FunctionRef functionRef = this.getFunctionRef(pin);
        if (funcRefMux == null) {
            functionRef = this.getFunctionRef(pin);
            if (functionRef == null) {
                functionRef = this.siulFunction(pin);
            }
        } else {
            functionRef = funcRefMux;
        }
        _xblockexpression = functionRef.getAlt().getSss();
        return _xblockexpression;
    }

    protected int _getIO_SSS(PinProperties pp) {
        int _xblockexpression = 0;
        EObject _eContainer = pp.eContainer();
        PinSetting pin = (PinSetting)_eContainer;
        _xblockexpression = this.getIO_SSS(pin);
        return _xblockexpression;
    }

    protected int _getMUX_SSS(PinProperties pp) {
        int _xblockexpression = 0;
        EObject _eContainer = pp.eContainer();
        PinSetting pin = (PinSetting)_eContainer;
        _xblockexpression = this.getMUX_SSS(pin);
        return _xblockexpression;
    }

    public int getIndex(PinProperties properties) {
        EObject _eContainer = properties.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef functionRef = this.getFunctionRef(ps);
        return functionRef.getAlt().getIndex();
    }

    public RegisterType getRef(PinProperties properties) {
        EObject _eContainer = properties.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef functionRef = this.getFunctionRef(ps);
        RegisterConfig _alt = null;
        if (functionRef != null) {
            _alt = functionRef.getAlt();
        }
        RegisterType _ref = null;
        if (_alt != null) {
            _ref = _alt.getRef();
        }
        return _ref;
    }

    public static List<com.st.stellar.pinmap.pinmapDsl.Direction> getFunctionDirections(Module module, com.st.stellar.pinmap.pinmapDsl.Function function) {
        List _xblockexpression = null;
        HashSet<com.st.stellar.pinmap.pinmapDsl.Direction> directions = new HashSet<com.st.stellar.pinmap.pinmapDsl.Direction>();
        try {
            EObject _eContainer = module.eContainer();
            Board board = PinCfgHelper.getBoard((PinSettings)_eContainer);
            EList _pins = board.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        com.st.stellar.pinmap.pinmapDsl.Direction _direction;
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals || (_direction = fct.getDirection()) == null) continue;
                        switch (_direction) {
                            case INPUT_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT);
                                break;
                            }
                            case INPUT: {
                                directions.add(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                                break;
                            }
                            case OUTPUT: {
                                directions.add(com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT);
                                break;
                            }
                            case INPUT_OR_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                                directions.add(com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT);
                                break;
                            }
                            case GROUND: {
                                break;
                            }
                            case INPUT_ALTERNATE: {
                                break;
                            }
                            case OUTPUT_ALTERNATE: {
                                break;
                            }
                            case POWER: {
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(directions);
        return _xblockexpression;
    }

    public static List<Pin> getFunctionPins(PinSettings pinSettings, com.st.stellar.pinmap.pinmapDsl.Function function) {
        List _xblockexpression = null;
        HashSet<Pin> pins = new HashSet<Pin>();
        Board includeBoard = PinCfgHelper.getBoard(pinSettings);
        try {
            EList _pins = includeBoard.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals) continue;
                        pins.add(pin);
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(pins);
        return _xblockexpression;
    }

    public static List<Pin> getFunctionPins(Board includeBoard, com.st.stellar.pinmap.pinmapDsl.Function function) {
        List _xblockexpression = null;
        HashSet<Pin> pins = new HashSet<Pin>();
        try {
            EList _pins = includeBoard.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals) continue;
                        pins.add(pin);
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(pins);
        return _xblockexpression;
    }

    public String defaultValue(RegisterType reg, FieldType field) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String hexValueStr = "";
        String bits = PinCfgHelper.bits(field);
        long resetValue = 0L;
        ResetType1 _reset = reg.getReset();
        boolean bl = _tripleNotEquals = _reset != null;
        if (_tripleNotEquals) {
            resetValue = Long.parseLong(reg.getReset().getValue().getValue().substring(2), 16);
        }
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl2 = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from_1);
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public String defaultValue(RegisterType reg, long resetValue, FieldType field) {
        String _xblockexpression = null;
        String hexValueStr = "";
        String bits = PinCfgHelper.bits(field);
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from_1);
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public static void binaryFormat(long value, String label) {
        String _replace = String.format("%64s", Long.toBinaryString(value)).replace(" ", "0");
        String _plus = label + ": 0b" + _replace;
        logger.debug((Object)_plus);
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        PinCfgHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        long mask = 1L << 31 - from;
        PinCfgHelper.binaryFormat(hexValue &= mask, "value");
        PinCfgHelper.binaryFormat(hexValue >>= 31 - from, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = this.getLongValue(it.getValue());
                return _longValue == compval;
            };
            EnumeratedValueType en = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            String enumValue = en.getValue();
            return enumValue;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from, int to) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        PinCfgHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return "";
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        PinCfgHelper.binaryFormat(mask, "mask ");
        PinCfgHelper.binaryFormat(hexValue &= mask, "value");
        PinCfgHelper.binaryFormat(hexValue >>= 31 - to, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = this.getLongValue(it.getValue());
                return _longValue == compval;
            };
            EnumeratedValueType en = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            String enumValue = en.getValue();
            return enumValue;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public ArrayList<String> getValues(RegisterType reg, String hexValueStr) {
        ArrayList _xblockexpression = null;
        ArrayList values = CollectionLiterals.newArrayList();
        if (hexValueStr == null) {
            return values;
        }
        long hexValue = Long.parseLong(hexValueStr.substring(2), 16);
        int nb = 0;
        Functions.Function1 _function = it -> {
            AccessType _access = it.getAccess();
            return !Objects.equals(_access, AccessType.READ_ONLY);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
        for (FieldType field : _filter) {
            String attr = field.getName();
            String value = this.defaultValue(reg, hexValue, field);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(attr);
            _builder.append("(\"");
            _builder.append(value);
            _builder.append("\")");
            String macro = _builder.toString();
            String fieldStrMacro = this.getBitFieldMacro(macro);
            if (fieldStrMacro != null) {
                values.add(macro);
            }
            ++nb;
        }
        _xblockexpression = values;
        return _xblockexpression;
    }

    public String getValues(RegisterType reg, List<FieldInstance> fields) {
        String _xblockexpression = null;
        Object fieldStr = "";
        for (FieldInstance field : fields) {
            boolean _equals;
            String regName = reg.getName();
            String _name = field.getAttr().getName();
            String attr = regName + "." + _name;
            String fieldValue = field.getValue();
            fieldValue = this.valueAsString(field.getAttr(), field.getValue());
            int _length = ((String)fieldStr).length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                String _fieldStr = fieldStr;
                fieldStr = _fieldStr + attr + " -> " + fieldValue;
                continue;
            }
            String _fieldStr_1 = fieldStr;
            fieldStr = _fieldStr_1 + ", " + attr + " -> " + fieldValue;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String valueAsString(FieldType field, String value) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        if (value == null) {
            return "";
        }
        String fieldValue = value;
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            EnumeratedValueType enumDisplay = null;
            long valueLong = this.getLongValue(value);
            if (valueLong < 0L) {
                String nameStr = value.replaceAll("'", "").replaceAll("\"", "");
                Functions.Function1 _function = it -> it.getName().equals(nameStr);
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            } else {
                Functions.Function1 _function_1 = it -> {
                    boolean _xblockexpression_1 = false;
                    long enumvalue = this.getLongValue(it.getValue());
                    _xblockexpression_1 = Long.valueOf(enumvalue).equals(valueLong);
                    return _xblockexpression_1;
                };
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
            }
            if (enumDisplay != null) {
                fieldValue = enumDisplay.getName();
            }
        }
        _xblockexpression = fieldValue;
        return _xblockexpression;
    }

    public long getLongValue(String valueIn) {
        long _xblockexpression = 0L;
        if (valueIn == null) {
            return 0L;
        }
        long longValue = 0L;
        String value = valueIn;
        try {
            boolean _startsWith = value.startsWith("\"");
            if (_startsWith) {
                value = value.replaceAll("\"", "");
            } else {
                boolean _startsWith_1 = value.startsWith("'");
                if (_startsWith_1) {
                    value = value.replaceAll("'", "");
                }
            }
            boolean _startsWith_2 = value.startsWith("0x");
            longValue = _startsWith_2 ? Long.parseLong(value.substring(2), 16) : Long.parseLong(value);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                longValue = -1L;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = longValue;
        return _xblockexpression;
    }

    public String getGenerationFileName(PinSettings pinSettings, String ext) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        Object outputFolder = "";
        String _outputFolder = pinSettings.getOutputFolder();
        boolean bl = _tripleNotEquals = _outputFolder != null;
        if (_tripleNotEquals) {
            String _outputFolder_1 = pinSettings.getOutputFolder();
            String _plus = "../" + _outputFolder_1;
            String _plus_1 = _plus + "/";
            outputFolder = _plus_1;
        } else {
            outputFolder = "./src-gen/";
            outputFolder = "../" + (String)outputFolder;
        }
        String _name = pinSettings.getName();
        String _plus_2 = (String)outputFolder + _name;
        String _plus_3 = _plus_2 + ".";
        _xblockexpression = _plus_3 + ext;
        return _xblockexpression;
    }

    public IFile getGenerationFile(PinSettings pinSettings, String ext) {
        IFile res;
        boolean _tripleNotEquals;
        IFile _xblockexpression = null;
        URI uri = pinSettings.eResource().getURI();
        uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        String _platformString = uri.toPlatformString(true);
        Path _path = new Path(_platformString);
        IFile file = _root.getFile((IPath)_path);
        IProject project = file.getProject();
        IPath _fullPath = project.getFullPath();
        String filePath = String.valueOf(_fullPath) + "/";
        Object outputFolder = "";
        String _outputFolder = pinSettings.getOutputFolder();
        boolean bl = _tripleNotEquals = _outputFolder != null;
        if (_tripleNotEquals) {
            String _outputFolder_1 = pinSettings.getOutputFolder();
            String _plus = _outputFolder_1 + "/";
            outputFolder = _plus;
        } else {
            outputFolder = "src-gen/";
        }
        String _filePath = filePath;
        String _name = pinSettings.getName();
        String _plus_1 = (String)outputFolder + _name;
        String _plus_2 = _plus_1 + ".";
        String _plus_3 = _plus_2 + ext;
        filePath = _filePath + _plus_3;
        uri = URI.createPlatformResourceURI((String)filePath, (boolean)true);
        IWorkspaceRoot _root_1 = ResourcesPlugin.getWorkspace().getRoot();
        Path _path_1 = new Path(filePath);
        _xblockexpression = res = _root_1.getFile((IPath)_path_1);
        return _xblockexpression;
    }

    public Package getPack(Module module) {
        Package _xblockexpression = null;
        Package pack = null;
        EObject _eContainer = module.eContainer();
        if (_eContainer instanceof PinSettings) {
            EObject _eContainer_1 = module.eContainer();
            IncludeBoard _includedBoard = ((PinSettings)_eContainer_1).getIncludedBoard();
            Board _board = null;
            if (_includedBoard != null) {
                _board = PinCfgHelper.getBoard(_includedBoard);
            }
            Package _package = null;
            if (_board != null) {
                _package = _board.getPackage();
            }
            pack = _package;
        } else {
            EObject _eContainer_2 = module.eContainer();
            if (_eContainer_2 instanceof Board) {
                EObject _eContainer_3 = module.eContainer();
                pack = ((Board)_eContainer_3).getPackage();
            }
        }
        _xblockexpression = pack;
        return _xblockexpression;
    }

    public Package getPack(PinConfiguration config) {
        boolean _tripleNotEquals;
        Package _xblockexpression = null;
        Package pack = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            Board _board = null;
            if (_includedBoard != null) {
                _board = PinCfgHelper.getBoard(_includedBoard);
            }
            Package _package = null;
            if (_board != null) {
                _package = _board.getPackage();
            }
            pack = _package;
        } else {
            boolean _tripleNotEquals_1;
            Board _board_1 = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board_1 != null;
            if (_tripleNotEquals_1) {
                pack = config.getBoard().getPackage();
            }
        }
        _xblockexpression = pack;
        return _xblockexpression;
    }

    public Package getPack(PinSettings ps) {
        Package _xblockexpression = null;
        Package pack = null;
        IncludeBoard _includedBoard = ps.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = PinCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        _xblockexpression = pack = _package;
        return _xblockexpression;
    }

    public static EList<Module> getAllModules(PinSettings settings) {
        boolean _tripleEquals;
        BasicEList _xifexpression = null;
        Board _board = PinCfgHelper.getBoard(settings);
        boolean bl = _tripleEquals = _board == null;
        if (_tripleEquals) {
            _xifexpression = settings.getModules();
        } else {
            BasicEList _xblockexpression = null;
            BasicEList mods = new BasicEList();
            mods.addAll(settings.getModules());
            EList<Module> boardModules = PinCfgHelper.getBoard(settings.getIncludedBoard()).getModules();
            mods.addAll(boardModules);
            _xifexpression = _xblockexpression = mods;
        }
        return _xifexpression;
    }

    public String getFamilyDescription(PinSettings ps) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        PinConfiguration config = (PinConfiguration)_eContainer;
        Family family = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            EObject cont = PinCfgHelper.getBoard(includedBoard).getPackage().eContainer();
            family = (Family)cont;
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                EObject cont_1 = config.getBoard().getPackage().eContainer();
                family = (Family)cont_1;
            }
        }
        String _xifexpression = null;
        _xifexpression = family != null ? family.getDesc() : "";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getFamilyLabel(PinSettings ps) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        PinConfiguration config = (PinConfiguration)_eContainer;
        Family family = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            EObject cont = PinCfgHelper.getBoard(includedBoard).getPackage().eContainer();
            family = (Family)cont;
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                EObject cont_1 = config.getBoard().getPackage().eContainer();
                family = (Family)cont_1;
            }
        }
        String _xifexpression = null;
        _xifexpression = family != null ? family.getLabel() : "";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public com.st.stellar.pinmap.pinCfg.Include getIncludes(PinConfiguration config) {
        boolean _tripleNotEquals;
        com.st.stellar.pinmap.pinCfg.Include _xblockexpression = null;
        com.st.stellar.pinmap.pinCfg.Include includes = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            Board board;
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            if (includedBoard != null && (board = PinCfgHelper.getBoard(includedBoard)) != null) {
                includes = board.getIncludes();
            }
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                includes = config.getBoard().getIncludes();
            }
        }
        _xblockexpression = includes;
        return _xblockexpression;
    }

    public com.st.stellar.pinmap.pinCfg.Include getIncludes(PinSetting ps) {
        com.st.stellar.pinmap.pinCfg.Include _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        Module module = (Module)_eContainer;
        com.st.stellar.pinmap.pinCfg.Include includes = null;
        EObject _eContainer_1 = module.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            Board board;
            EObject _eContainer_2 = module.eContainer();
            IncludeBoard includedBoard = ((PinSettings)_eContainer_2).getIncludedBoard();
            if (includedBoard != null && (board = PinCfgHelper.getBoard(includedBoard)) != null) {
                includes = board.getIncludes();
            }
        } else {
            EObject _eContainer_3 = module.eContainer();
            if (_eContainer_3 instanceof Board) {
                EObject _eContainer_4 = module.eContainer();
                includes = ((Board)_eContainer_4).getIncludes();
            }
        }
        _xblockexpression = includes;
        return _xblockexpression;
    }

    public Resource getResource(PinSetting ps) {
        Resource _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        Module module = (Module)_eContainer;
        _xblockexpression = module.eResource();
        return _xblockexpression;
    }

    public static Board getBoard(PinSettings ps) {
        boolean _tripleEquals;
        Board _xblockexpression = null;
        Board res = null;
        IncludeBoard _includedBoard = ps.getIncludedBoard();
        boolean bl = _tripleEquals = _includedBoard == null;
        if (_tripleEquals) {
            return res;
        }
        String inc = ps.getIncludedBoard().getImportURI();
        if (inc != null) {
            res = PinCfgHelper.getBoard(ps.eResource(), inc);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Resource getResource(Resource context, String uriStr) {
        Resource _xblockexpression = null;
        Resource res = null;
        if (uriStr != null && context != null) {
            try {
                boolean _greaterThan;
                Resource r = EcoreUtil2.getResource((Resource)context, (String)uriStr);
                if (r != null) {
                    r.load(null);
                }
                if (r == null) {
                    return null;
                }
                int _size = r.getContents().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    res = r;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    System.err.println(e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Board getBoard(Resource context, String uriStr) {
        Board _xblockexpression = null;
        Board res = null;
        Resource r = PinCfgHelper.getResource(context, uriStr);
        if (r != null) {
            boolean _greaterThan;
            int _size = r.getContents().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                EObject _get = (EObject)r.getContents().get(0);
                PinConfiguration pinCfg = (PinConfiguration)_get;
                res = pinCfg.getBoard();
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Board getBoard(PinSetting pin) {
        EObject _eContainer = pin.eContainer();
        Module mod = (Module)_eContainer;
        EObject _eContainer_1 = mod.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            EObject _eContainer_2 = mod.eContainer();
            PinSettings ps = (PinSettings)_eContainer_2;
            return PinCfgHelper.getBoard(ps.getIncludedBoard());
        }
        EObject _eContainer_3 = mod.eContainer();
        if (_eContainer_3 instanceof Board) {
            EObject _eContainer_4 = mod.eContainer();
            return (Board)_eContainer_4;
        }
        return null;
    }

    public static Board getBoard(IncludeBoard includeBoard) {
        String inc;
        Board _xblockexpression = null;
        Board res = null;
        String _importURI = null;
        if (includeBoard != null) {
            _importURI = includeBoard.getImportURI();
        }
        if ((inc = _importURI) != null) {
            res = PinCfgHelper.getBoard(includeBoard.eResource(), inc);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public List<com.st.stellar.pinmap.pinmapDsl.Function> getFunctionForPeripheral(PinConfiguration config, Peripheral peripheral) {
        List functions;
        List _xblockexpression = null;
        Family family = this.getFamily(config);
        Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getName().equals(peripheral.getName());
        _xblockexpression = functions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)family.getFunctions(), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public boolean isEnabledPeripheral(PinSettings settings, Peripheral peripheral) {
        boolean _xblockexpression = false;
        ArrayList peripherals = new ArrayList();
        Functions.Function1 _function = m -> m.getPins();
        Functions.Function1 _function_1 = p -> p.getConfig();
        Functions.Function1 _function_2 = p -> {
            com.st.stellar.pinmap.pinmapDsl.Function _alt = p.getAlt();
            return _alt != null;
        };
        Functions.Function1 _function_3 = p -> p.getAlt();
        Consumer<com.st.stellar.pinmap.pinmapDsl.Function> _function_4 = f -> {
            boolean _tripleNotEquals;
            Peripheral _peripheralRef = f.getPeripheralRef();
            boolean bl = _tripleNotEquals = _peripheralRef != null;
            if (_tripleNotEquals) {
                peripherals.add(f.getPeripheralRef().getName());
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(PinCfgHelper.getAllModules(settings), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3).forEach(_function_4);
        _xblockexpression = peripherals.contains(peripheral.getName());
        return _xblockexpression;
    }

    public Family getFamily(PinConfiguration config) {
        boolean _tripleNotEquals;
        Family _xblockexpression = null;
        Family family = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            EObject cont = PinCfgHelper.getBoard(includedBoard).getPackage().eContainer();
            family = (Family)cont;
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                EObject cont_1 = config.getBoard().getPackage().eContainer();
                family = (Family)cont_1;
            }
        }
        _xblockexpression = family;
        return _xblockexpression;
    }

    public List<PinSetting> getConfiguredPins(PinSettings settings) {
        Functions.Function1 _function = m -> m.getPins();
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap(PinCfgHelper.getAllModules(settings), (Functions.Function1)_function));
    }

    public List<Configuration> getPadsForFunction(PinSettings settings, com.st.stellar.pinmap.pinmapDsl.Function function) {
        IncludeBoard _includedBoard = settings.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = PinCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        Package pckg = _package;
        ArrayList<Configuration> pins = new ArrayList<Configuration>();
        Functions.Function1 _function = m -> m.getPinConfigurations();
        Iterable configurations = Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)pckg.getPins(), (Functions.Function1)_function), ConfigurablePin.class);
        for (ConfigurablePin configuration : configurations) {
            EList _functions = configuration.getRef().getFunctions();
            for (FunctionRef fct : _functions) {
                boolean _equals = fct.getName().getName().equals(function.getName());
                if (!_equals || configuration == null || pins.contains(configuration.getRef())) continue;
                pins.add(configuration.getRef());
            }
        }
        return pins;
    }

    public List<PinSetting> getConfiguredPins(PinSettings settings, com.st.stellar.pinmap.pinmapDsl.Function function) {
        List<PinSetting> _xblockexpression = null;
        Functions.Function1 _function = m -> m.getPins();
        List configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(PinCfgHelper.getAllModules(settings), (Functions.Function1)_function));
        Predicate<PinSetting> _function_1 = it -> it.getConfig().getAlt() != null && it.getConfig().getAlt().equals((Object)function);
        Stream<PinSetting> a = configuredPins.stream().filter(_function_1);
        _xblockexpression = a.toList();
        return _xblockexpression;
    }

    public Pin getPinForConfiguration(Package pckg, Configuration configuration) {
        EList _pins = pckg.getPins();
        for (Pin pin : _pins) {
            Functions.Function1 _function = it -> it.getRef().getName().equals(configuration.getName());
            Iterable configurablePins = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)configurablePins);
            boolean _not = !_isEmpty;
            if (!_not) continue;
            return pin;
        }
        return null;
    }

    public void getRegInstances(PinProperties props) {
        EObject _eContainer = props.eContainer();
        PinSetting setting = (PinSetting)_eContainer;
        FunctionRef funcRef = this.getFunctionRef(setting);
        if (funcRef == null || funcRef.getAlt() == null) {
            return;
        }
        RegisterType reg = funcRef.getAlt().getRef();
        Functions.Function1 _function = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals("SSS");
        FieldInstance sss = (FieldInstance)IterableExtensions.findFirst(setting.getIoFields().getReg(), (Functions.Function1)_function);
        FunctionRef functionRef = this.getFunctionRef(setting);
        if (sss != null) {
            sss.setValue(Integer.toString(functionRef.getAlt().getSss()));
        } else {
            EList fields = functionRef.getAlt().getRef().getField();
            Functions.Function1 _function_1 = it -> it.getName().equals("SSS");
            FieldType sssField = (FieldType)IterableExtensions.findFirst((Iterable)fields, (Functions.Function1)_function_1);
            sss = PinCfgFactory.eINSTANCE.createFieldInstance();
            sss.setAttr(sssField);
            String _hexString = Long.toHexString(functionRef.getAlt().getSss());
            String _plus = "0x" + _hexString;
            sss.setValue(_plus);
            setting.getIoFields().getReg().add((Object)sss);
        }
        String hexValue = this.toHex(setting.getConfig());
        Functions.Function1 _function_2 = it -> {
            boolean _equals = it.getName().equals("SSS");
            return !_equals;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
        for (FieldType bitField : _filter) {
            this.getRegInstance(setting, bitField.getName(), hexValue);
        }
    }

    public boolean getRegInstance(PinSetting config, String bfName, String hexValue) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> it.getAttr() != null && it.getAttr().getDisplayName() != null && it.getAttr().getDisplayName().equals(bfName);
        FieldInstance regInst = (FieldInstance)IterableExtensions.findFirst(config.getIoFields().getReg(), (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (regInst == null) {
            boolean _xblockexpression_1 = false;
            FunctionRef functionRef = this.getFunctionRef(config);
            Functions.Function1 _function_1 = it -> it.getName().equals(bfName);
            FieldType bf = (FieldType)IterableExtensions.findFirst((Iterable)functionRef.getAlt().getRef().getField(), (Functions.Function1)_function_1);
            regInst = PinCfgFactory.eINSTANCE.createFieldInstance();
            regInst.setAttr(bf);
            this._utils = Utils.instance;
            this._converter = Converter.instance;
            String value = this._converter.adapt(functionRef.getAlt().getRef(), bfName, hexValue);
            regInst.setValue(value);
            _xifexpression = _xblockexpression_1 = config.getIoFields().getReg().add((Object)regInst);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Map<String, String> getDefaultFieldInstances(Module module, Configuration pad, String functionName, List<FieldInstance> alreadyThere) {
        boolean _tripleNotEquals;
        FunctionRef funcRefMux;
        boolean _tripleEquals;
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> regValues = new HashMap<String, String>();
        if (pad == null) {
            return regValues;
        }
        FunctionRef functionRef = null;
        if (pad == null) {
            return regValues;
        }
        EList _functions = pad.getFunctions();
        for (FunctionRef f : _functions) {
            boolean _equals_1;
            boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
            if (!_equals || !(_equals_1 = f.getName().getName().equals(functionName))) continue;
            functionRef = f;
        }
        RegisterConfig _alt = functionRef.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            functionRef = this.getIOorSiulFunction(pad, functionName);
        } else if (functionRef.getAlt() != null && functionRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX") && (funcRefMux = this.getFunctionRefMux(pad, module, functionName)) != null) {
            functionRef = this.getIOorSiulFunction(pad, functionName);
        }
        com.st.stellar.pinmap.pinmapDsl.Direction direction = functionRef.getDirection();
        String hexValueStr = null;
        RegisterConfig _alt_1 = functionRef.getAlt();
        boolean bl2 = _tripleNotEquals = _alt_1 != null;
        if (_tripleNotEquals) {
            long hexValue;
            RegisterType reg = functionRef.getAlt().getRef();
            if (direction != null) {
                switch (direction) {
                    case INPUT: {
                        String _elvis = null;
                        String _input = functionRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_1 = null;
                        String _inputOutput = functionRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_2 = null;
                        String _output = functionRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
            logger.debug((Object)("toHex:" + hexValueStr));
            if (hexValueStr == null) {
                hexValueStr = "0x0";
            }
            if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L && functionRef.getAlt() != null && functionRef.getAlt().getInput() == null && functionRef.getAlt().getInputOutput() == null && functionRef.getAlt().getOutput() == null) {
                FunctionRef fisrt = this.getIOorSiulFunction(pad, functionName);
                if (direction != null) {
                    switch (direction) {
                        case INPUT: {
                            String _elvis_3 = null;
                            String _input_1 = fisrt.getAlt().getInput();
                            _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                            hexValueStr = _elvis_3;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case INPUT_OUTPUT: {
                            String _elvis_4 = null;
                            String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                            _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                            hexValueStr = _elvis_4;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case OUTPUT: {
                            String _elvis_5 = null;
                            String _output_1 = fisrt.getAlt().getOutput();
                            _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                            hexValueStr = _elvis_5;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        default: {
                            hexValueStr = null;
                            break;
                        }
                    }
                } else {
                    hexValueStr = null;
                }
            }
            ArrayList<String> defaultValues = this.getValues(reg, hexValueStr);
            Functions.Function1 _function = it -> {
                boolean _equals_2 = it.getName().equals("SSS");
                return !_equals_2;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType bitField : _filter) {
                Functions.Function1 _function_1 = it -> it.getAttr();
                boolean _contains = ListExtensions.map(alreadyThere, (Functions.Function1)_function_1).contains(bitField);
                boolean _not = !_contains;
                if (!_not) continue;
                String v = "";
                Functions.Function1 _function_2 = it -> it.startsWith(bitField.getName());
                String defValue = (String)IterableExtensions.findFirst(defaultValues, (Functions.Function1)_function_2);
                if (defValue != null) {
                    int i = defValue.indexOf("(");
                    int l = defValue.length();
                    if (i <= 0) continue;
                    v = defValue.substring(i + 2, l - 2);
                    regValues.put(bitField.getName(), v);
                    continue;
                }
                v = this.defaultValue(reg, bitField);
                regValues.put(bitField.getName(), v);
            }
        }
        _xblockexpression = regValues;
        return _xblockexpression;
    }

    public List<Pair<FieldType, String>> getDefaultFieldInstanceList(PinConfiguration conf, Configuration pad, FunctionRef funcRef, List<FieldType> alreadyThere) {
        RegisterConfig _alt_2;
        boolean _tripleNotEquals;
        boolean _tripleEquals_1;
        String functionName;
        FunctionRef funcRefMux;
        boolean _tripleEquals;
        ArrayList _xblockexpression = null;
        ArrayList res = CollectionLiterals.newArrayList();
        FunctionRef functionRef = funcRef;
        RegisterConfig _alt = functionRef.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            functionRef = this.getSiulFunction(pad);
        } else if (functionRef.getAlt() != null && functionRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX") && (funcRefMux = this.getFunctionRefMux(pad, functionName = functionRef.getName().getName())) != null) {
            functionRef = this.getSiulFunction(pad);
        }
        com.st.stellar.pinmap.pinmapDsl.Direction direction = functionRef.getDirection();
        String hexValueStr = null;
        RegisterConfig _alt_1 = functionRef.getAlt();
        boolean bl2 = _tripleEquals_1 = _alt_1 == null;
        if (_tripleEquals_1) {
            functionRef = (FunctionRef)pad.getFunctions().get(0);
        }
        boolean bl3 = _tripleNotEquals = (_alt_2 = functionRef.getAlt()) != null;
        if (_tripleNotEquals) {
            long hexValue;
            RegisterType reg = functionRef.getAlt().getRef();
            if (direction != null) {
                switch (direction) {
                    case INPUT: {
                        String _elvis = null;
                        String _input = functionRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_1 = null;
                        String _inputOutput = functionRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_2 = null;
                        String _output = functionRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
            if (hexValueStr == null) {
                hexValueStr = "0x0";
            }
            if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L && functionRef.getAlt() != null && functionRef.getAlt().getInput() == null && functionRef.getAlt().getInputOutput() == null && functionRef.getAlt().getOutput() == null) {
                FunctionRef fisrt = this.getSiulFunction(pad);
                if (direction != null) {
                    switch (direction) {
                        case INPUT: {
                            String _elvis_3 = null;
                            String _input_1 = fisrt.getAlt().getInput();
                            _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                            hexValueStr = _elvis_3;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case INPUT_OUTPUT: {
                            String _elvis_4 = null;
                            String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                            _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                            hexValueStr = _elvis_4;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case OUTPUT: {
                            String _elvis_5 = null;
                            String _output_1 = fisrt.getAlt().getOutput();
                            _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                            hexValueStr = _elvis_5;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        default: {
                            hexValueStr = null;
                            break;
                        }
                    }
                } else {
                    hexValueStr = null;
                }
            }
            ArrayList<String> defaultValues = this.getValues(reg, hexValueStr);
            Functions.Function1 _function = it -> {
                boolean _equals = it.getName().equals("SSS");
                return !_equals;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType bitField : _filter) {
                boolean _contains = alreadyThere.contains(bitField);
                boolean _not = !_contains;
                if (!_not) continue;
                String v = "";
                Functions.Function1 _function_1 = it -> it.startsWith(bitField.getName());
                String defValue = (String)IterableExtensions.findFirst(defaultValues, (Functions.Function1)_function_1);
                if (defValue != null) {
                    int i = defValue.indexOf("(");
                    int l = defValue.length();
                    if (i <= 0) continue;
                    v = defValue.substring(i + 2, l - 2);
                    Pair<FieldType, String> pair = new Pair<FieldType, String>(bitField, v);
                    res.add(pair);
                    continue;
                }
                v = this.defaultValue(reg, bitField);
                Pair<FieldType, String> pair_1 = new Pair<FieldType, String>(bitField, v);
                res.add(pair_1);
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public Map<String, String> getDefaultMUXFieldInstances(Module module, Configuration pad, String functionName, List<FieldInstance> alreadyThere) {
        boolean _tripleNotEquals;
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> regValues = new HashMap<String, String>();
        FunctionRef functionRef = null;
        EList _functions = pad.getFunctions();
        for (FunctionRef f : _functions) {
            boolean _equals_1;
            boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
            if (!_equals || !(_equals_1 = f.getName().getName().equals(functionName))) continue;
            functionRef = f;
        }
        if (functionRef.getAlt() != null && functionRef.getAlt().getRef().getTypeIdentifier().equals("MSCR_MUX")) {
            FunctionRef funcRefMux = this.getFunctionRefMux(pad, module, functionName);
            if (funcRefMux == null) {
                return regValues;
            }
            functionRef = funcRefMux;
        }
        com.st.stellar.pinmap.pinmapDsl.Direction direction = functionRef.getDirection();
        String hexValueStr = null;
        RegisterConfig _alt = functionRef.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            long hexValue;
            RegisterType reg = functionRef.getAlt().getRef();
            if (direction != null) {
                switch (direction) {
                    case INPUT: {
                        String _elvis = null;
                        String _input = functionRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_1 = null;
                        String _inputOutput = functionRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_2 = null;
                        String _output = functionRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
            if (hexValueStr == null) {
                hexValueStr = "0x0";
            }
            if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L && functionRef.getAlt() != null && functionRef.getAlt().getInput() == null && functionRef.getAlt().getInputOutput() == null && functionRef.getAlt().getOutput() == null) {
                FunctionRef fisrt = this.getSiulFunction(pad);
                if (direction != null) {
                    switch (direction) {
                        case INPUT: {
                            String _elvis_3 = null;
                            String _input_1 = fisrt.getAlt().getInput();
                            _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                            hexValueStr = _elvis_3;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case INPUT_OUTPUT: {
                            String _elvis_4 = null;
                            String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                            _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                            hexValueStr = _elvis_4;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        case OUTPUT: {
                            String _elvis_5 = null;
                            String _output_1 = fisrt.getAlt().getOutput();
                            _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                            hexValueStr = _elvis_5;
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        default: {
                            hexValueStr = null;
                            break;
                        }
                    }
                } else {
                    hexValueStr = null;
                }
            }
            ArrayList<String> defaultValues = this.getValues(reg, hexValueStr);
            Functions.Function1 _function = it -> {
                boolean _equals_2 = it.getName().equals("SSS");
                return !_equals_2;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType bitField : _filter) {
                Functions.Function1 _function_1 = it -> it.getAttr();
                boolean _contains = ListExtensions.map(alreadyThere, (Functions.Function1)_function_1).contains(bitField);
                boolean _not = !_contains;
                if (!_not) continue;
                String v = "";
                Functions.Function1 _function_2 = it -> it.startsWith(bitField.getName());
                String defValue = (String)IterableExtensions.findFirst(defaultValues, (Functions.Function1)_function_2);
                if (defValue != null) {
                    int i = defValue.indexOf("(");
                    int l = defValue.length();
                    if (i <= 0) continue;
                    v = defValue.substring(i + 2, l - 2);
                    regValues.put(bitField.getName(), v);
                    continue;
                }
                v = this.defaultValue(reg, bitField);
                regValues.put(bitField.getName(), v);
            }
        }
        _xblockexpression = regValues;
        return _xblockexpression;
    }

    public EList<EnumeratedValueType> getRegisterValues(Iterable<RegisterType> registers, int index, String registerName) {
        BasicEList res = new BasicEList();
        for (RegisterType reg : registers) {
            Functions.Function1 _function = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType field : _filter) {
                boolean _startsWith;
                boolean _equals = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index));
                if (!_equals || !(_startsWith = field.getName().startsWith(registerName))) continue;
                res = field.getEnumeratedValues().getEnumeratedValue();
                return res;
            }
        }
        return res;
    }

    public List<com.st.stellar.pinmap.pinmapDsl.Function> getFunctions(PinSettings config, Peripheral periph) {
        Package pack;
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        IncludeBoard _includedBoard = config.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = PinCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        if ((pack = _package) != null) {
            EObject _eContainer = pack.eContainer();
            Family family = (Family)_eContainer;
            EList functions = family.getFunctions();
            Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getName().equals(periph.getName());
            Iterables.addAll((Collection)list, (Iterable)IterableExtensions.filter((Iterable)functions, (Functions.Function1)_function));
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(PinSetting registerConfig) {
        List<RegisterType> _xblockexpression = null;
        EObject _eContainer = registerConfig.eContainer();
        Module module = (Module)_eContainer;
        _xblockexpression = this.getRegisters(module);
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(PinConfiguration conf) {
        boolean _tripleNotEquals;
        ArrayList _xblockexpression = null;
        List registers = CollectionLiterals.newArrayList();
        com.st.stellar.pinmap.pinCfg.Include inc = this.getIncludes(conf);
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            EObject _get;
            PinmapModel root;
            Include pinmapinc;
            boolean _isNullOrEmpty;
            boolean _not;
            Resource resource = null;
            if (resource == null) {
                Resource r;
                resource = conf.eResource();
                resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
                _resourceCache.put(inc.getImportURI(), resource);
            }
            boolean bl2 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)resource.getContents()));
            if (_not && (pinmapinc = (Include)(root = (PinmapModel)(_get = (EObject)resource.getContents().get(0))).getIncludes().get(0)) != null) {
                boolean _isNullOrEmpty_1;
                boolean _not_1;
                resource = null;
                if (resource == null) {
                    Resource r_1;
                    resource = conf.eResource();
                    resource = r_1 = EcoreUtil2.getResource((Resource)resource, (String)pinmapinc.getImportURI());
                    _resourceCache.put(pinmapinc.getImportURI(), resource);
                }
                boolean bl3 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)resource.getContents()));
                if (_not_1) {
                    EObject _get_1 = (EObject)resource.getContents().get(0);
                    DocumentRoot iomux = (DocumentRoot)_get_1;
                    ComponentType comp = iomux.getComponent();
                    EList _memoryMap = comp.getMemoryMaps().getMemoryMap();
                    for (MemoryMapType mm : _memoryMap) {
                        EList _addressBlock = mm.getAddressBlock();
                        for (AddressBlockType ab : _addressBlock) {
                            Functions.Function1 _function = it -> {
                                boolean _contains = it.getName().contains("_Reserved_");
                                return !_contains;
                            };
                            registers = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ab.getRegister(), (Functions.Function1)_function));
                        }
                    }
                }
            }
        }
        _xblockexpression = registers;
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(Module module) {
        List<RegisterType> _xblockexpression = null;
        EObject _eContainer = module.eContainer().eContainer();
        PinConfiguration conf = (PinConfiguration)_eContainer;
        _xblockexpression = this.getRegisters(conf);
        return _xblockexpression;
    }

    public String getPadName(Pin pin) {
        String _xblockexpression = null;
        Object padName = "";
        Predicate<PinConfig> _function = it -> ConfigurablePin.class.isInstance(it);
        Function<PinConfig, ConfigurablePin> _function_1 = it -> (ConfigurablePin)ConfigurablePin.class.cast(it);
        List configs = pin.getPinConfigurations().stream().filter(_function).map(_function_1).collect(Collectors.toList());
        for (ConfigurablePin config : configs) {
            Configuration pad = config.getRef();
            String _padName = padName;
            String _label = pad.getLabel();
            padName = _padName + _label;
        }
        _xblockexpression = padName;
        return _xblockexpression;
    }

    public Configuration findPin(PinConfiguration config, String lookup) {
        Functions.Function1 _function = ps -> ps.getPad();
        Functions.Function1 _function_1 = it -> it.getName() != null && it.getName().equals(lookup);
        return (Configuration)IterableExtensions.findFirst((Iterable)ListExtensions.map(PinCfgHelper.getAllPinSettings(config), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public ArrayList<com.st.stellar.pinmap.pinmapDsl.Function> getPackageFunctions(Package pack) {
        ArrayList _xblockexpression = null;
        ArrayList functionList = CollectionLiterals.newArrayList();
        if (pack != null) {
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                Iterable configurablePins = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : configurablePins) {
                    Configuration ref = pinConfig.getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef f : _functions) {
                        functionList.add(f.getName());
                    }
                }
            }
        }
        _xblockexpression = functionList;
        return _xblockexpression;
    }

    public String getIODetails(PinSetting ps) {
        boolean _equals;
        PinProperties pin = ps.getConfig();
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        FunctionRef funcRef = this.getFunctionRef(ps);
        EList<FieldInstance> regInstances = CollectionLiterals.newArrayList();
        int sss = this.getIO_SSS(pin);
        if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            regInstances = ps.getIoFields().getReg();
        }
        Object fieldStr1 = "";
        int _size = regInstances.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            String _fieldStr1 = fieldStr1;
            fieldStr1 = _fieldStr1 + "SSS -> " + Integer.valueOf(sss);
        }
        int nb = 0;
        Object fieldStr2 = "";
        int _size_1 = regInstances.size();
        int max = _size_1 - 1;
        for (FieldInstance inst : regInstances) {
            if (inst.getAttr() != null && inst.getValue() != null) {
                FieldType field = inst.getAttr();
                String attr = field.getName();
                String value = inst.getValue();
                if (nb == 0) {
                    String _fieldStr2 = fieldStr2;
                    fieldStr2 = _fieldStr2 + "SSS -> " + Integer.valueOf(sss) + ", ";
                }
                if (nb < max) {
                    String _fieldStr2_1 = fieldStr2;
                    fieldStr2 = _fieldStr2_1 + attr + " -> " + (String)value + ", ";
                } else {
                    String _fieldStr2_2 = fieldStr2;
                    fieldStr2 = _fieldStr2_2 + attr + " -> " + (String)value;
                }
            }
            ++nb;
        }
        Object _fieldStr1_1 = fieldStr1;
        fieldStr1 = (String)_fieldStr1_1 + (String)fieldStr2;
        String fieldStr = "";
        ArrayList macrosList = CollectionLiterals.newArrayList();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)sss);
        macrosList.add(_builder.toString());
        nb = 0;
        for (FieldInstance inst_1 : regInstances) {
            if (inst_1.getAttr() != null && inst_1.getValue() != null) {
                FieldType field = inst_1.getAttr();
                String attr = field.getName();
                CharSequence value = this.toHexString(inst_1.getValue());
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(attr);
                _builder_1.append("(");
                _builder_1.append((Object)value);
                _builder_1.append(")");
                String macro = _builder_1.toString();
                String fieldStrMacro = this.getBitFieldMacro(macro);
                if (fieldStrMacro != null) {
                    macrosList.add(macro);
                }
            }
            ++nb;
        }
        String hexValueStr = this.getHexValue(ps);
        RegisterType r = this.siulFunction(ps).getAlt().getRef();
        ArrayList<String> values = this.getValues(r, hexValueStr);
        for (Object v : values) {
            boolean _alreadyPresentIn = this.alreadyPresentIn((String)v, macrosList);
            boolean _not = !_alreadyPresentIn;
            if (!_not) continue;
            macrosList.add(v);
        }
        Object macros = fieldStr;
        for (String m : macrosList) {
            String fieldStrMacro = this.getBitFieldMacro(m);
            if (fieldStrMacro != null) {
                String _macros = macros;
                macros = _macros + fieldStrMacro;
                continue;
            }
            try {
                int v_1 = Integer.parseInt(m);
                String _macros_1 = macros;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("SSS(");
                _builder_1.append((Object)v_1);
                _builder_1.append(")");
                macros = _macros_1 + String.valueOf(_builder_1);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        String res = ((String)macros).replace(" | ", ",").replaceAll("SIUL2_MSCR_IO_", "");
        return res;
    }

    public String getHexValue(PinSetting ps) {
        long hexValue;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        PinProperties pin = ps.getConfig();
        com.st.stellar.pinmap.pinmapDsl.Function fct = pin.getAlt();
        FunctionRef funcRef = this.getFunctionRef(ps);
        String hexValueStr = null;
        RegisterConfig _alt = funcRef.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            Direction _direction = pin.getDirection();
            if (_direction != null) {
                switch (_direction) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = funcRef.getAlt().getRef().getReset().getValue().getValue();
                            break;
                        }
                        hexValueStr = null;
                        break;
                    }
                    case INPUT: {
                        String _elvis = null;
                        String _input = funcRef.getAlt().getInput();
                        _elvis = _input != null ? _input : hexValueStr;
                        hexValueStr = _elvis;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_1 = null;
                        String _inputOutput = funcRef.getAlt().getInputOutput();
                        _elvis_1 = _inputOutput != null ? _inputOutput : hexValueStr;
                        hexValueStr = _elvis_1;
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_2 = null;
                        String _output = funcRef.getAlt().getOutput();
                        _elvis_2 = _output != null ? _output : hexValueStr;
                        hexValueStr = _elvis_2;
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
            }
        }
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L && funcRef.getAlt() != null && funcRef.getAlt().getInput() == null && funcRef.getAlt().getInputOutput() == null && funcRef.getAlt().getOutput() == null) {
            FunctionRef fisrt = this.siulFunction(ps);
            Direction _direction_1 = pin.getDirection();
            if (_direction_1 != null) {
                switch (_direction_1) {
                    case DEFAULT_INPUT: {
                        if (fct != null) {
                            hexValueStr = fisrt.getAlt().getRef().getReset().getValue().getValue();
                            hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                            break;
                        }
                        hexValueStr = null;
                        hexValue = 0L;
                        break;
                    }
                    case INPUT: {
                        String _elvis_3 = null;
                        String _input_1 = fisrt.getAlt().getInput();
                        _elvis_3 = _input_1 != null ? _input_1 : hexValueStr;
                        hexValueStr = _elvis_3;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    case INPUT_OUTPUT: {
                        String _elvis_4 = null;
                        String _inputOutput_1 = fisrt.getAlt().getInputOutput();
                        _elvis_4 = _inputOutput_1 != null ? _inputOutput_1 : hexValueStr;
                        hexValueStr = _elvis_4;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    case OUTPUT: {
                        String _elvis_5 = null;
                        String _output_1 = fisrt.getAlt().getOutput();
                        _elvis_5 = _output_1 != null ? _output_1 : hexValueStr;
                        hexValueStr = _elvis_5;
                        hexValue = Long.parseLong(hexValueStr.substring(2), 16);
                        break;
                    }
                    default: {
                        hexValueStr = null;
                        hexValue = 0L;
                        break;
                    }
                }
            } else {
                hexValueStr = null;
                hexValue = 0L;
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public String getMUXDetails(PinSetting ps) {
        String _xblockexpression = null;
        String muxDef = "";
        boolean _isMUX = this.isMUX(ps);
        if (_isMUX) {
            FunctionRef funcRef = this.getFunctionRef(ps);
            if (funcRef.getAlt() != null && funcRef.getAlt().getIndex() > 511) {
                StringConcatenation _builder = new StringConcatenation();
                int _index = funcRef.getAlt().getIndex();
                _builder.append((Object)_index);
                _builder.append(": ");
                long _parseLong = Long.parseLong(this.toMUXHex(ps.getConfig()).substring(2), 16);
                _builder.append((Object)_parseLong);
                muxDef = _builder.toString();
            }
        } else {
            FunctionRef funcRefMux;
            boolean _hasMUX = this.hasMUX(ps);
            if (_hasMUX && (funcRefMux = this.getFunctionRefMux(ps)) != null && funcRefMux.getAlt().getIndex() > 511) {
                StringConcatenation _builder_1 = new StringConcatenation();
                int _index_1 = funcRefMux.getAlt().getIndex();
                _builder_1.append((Object)_index_1);
                _builder_1.append(": ");
                long _parseLong_1 = Long.parseLong(this.toMUXHex(ps.getConfig(), funcRefMux).substring(2), 16);
                _builder_1.append((Object)_parseLong_1);
                muxDef = _builder_1.toString();
            }
        }
        _xblockexpression = muxDef;
        return _xblockexpression;
    }

    public List<Pair<Configuration, com.st.stellar.pinmap.pinmapDsl.Function>> getConfiguredPADs(PinConfiguration config) {
        ArrayList _xblockexpression = null;
        ArrayList res = CollectionLiterals.newArrayList();
        List<PinSetting> pinSettings = PinCfgHelper.getAllPinSettings(config);
        for (PinSetting ps : pinSettings) {
            Configuration _pad = ps.getPad();
            com.st.stellar.pinmap.pinmapDsl.Function _alt = ps.getConfig().getAlt();
            Pair<Configuration, com.st.stellar.pinmap.pinmapDsl.Function> pair = new Pair<Configuration, com.st.stellar.pinmap.pinmapDsl.Function>(_pad, _alt);
            res.add(pair);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Pin getPinForConfiguration(PinSetting ps) {
        Board board = PinCfgHelper.getBoard(ps);
        Package pckg = board.getPackage();
        EList _pins = pckg.getPins();
        for (Pin pin : _pins) {
            Functions.Function1 _function = it -> it.getRef().getName().equals(ps.getPad().getName());
            Iterable configurablePins = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)configurablePins);
            boolean _not = !_isEmpty;
            if (!_not) continue;
            return pin;
        }
        return null;
    }

    @XbaseGenerated
    public int getIO_SSS(EObject pp) {
        if (pp instanceof PinProperties) {
            return this._getIO_SSS((PinProperties)pp);
        }
        if (pp instanceof PinSetting) {
            return this._getIO_SSS((PinSetting)pp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pp).toString());
    }

    @XbaseGenerated
    public int getMUX_SSS(EObject pp) {
        if (pp instanceof PinProperties) {
            return this._getMUX_SSS((PinProperties)pp);
        }
        if (pp instanceof PinSetting) {
            return this._getMUX_SSS((PinSetting)pp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pp).toString());
    }
}

