/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.Include;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.MUXFields;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinCfgPackage;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.validation.AbstractPinCfgValidator;
import com.st.stellar.pinmap.validation.PinCfgValidationMessageAcceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe2.language.scoping.QualifiedNameProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class PinCfgValidator
extends AbstractPinCfgValidator {
    @Inject
    @Extension
    private Utils _utils;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    @Inject
    private QualifiedNameProvider qnprovider;
    protected static final String ISSUE_CODE_PREFIX = "com.st.stellar.pinmap.";
    public static final String INVALID_FIELD_INSTANCE_VALUE = "com.st.stellar.pinmap.invalidFieldInstanceValue";
    public static final String INVALID_OUTPUTFOLDER = "com.st.stellar.pinmap.invalidOutputFolder";
    private PinCfgValidationMessageAcceptor errorAcceptor = null;
    public static final String INVALID_REGISTER_CONFIG = "invalidRegisterConfig";
    public static final String MISSING_REG_INSTANCES = "com.st.stellar.pinmap.missingReg Instances";
    public static final String DUPLICATED_ELEMENT = "com.st.stellar.pinmap.duplicatedElement";
    public static final String UNIQUE_FUNCTION_USAGE = "com.st.stellar.pinmap.uniqueFunctionUsage";
    public static final String UNIQUE_PIN_USAGE = "com.st.stellar.pinmap.uniquePinUsage";
    public static final String DUPLICATED_PINCONFIG = "com.st.stellar.pinmap.duplicatedPinConfig";
    public static final String WRONG_FUNCTION = "com.st.stellar.pinmap.wrongFunction";
    public static final String WRONG_DIRECTION = "com.st.stellar.pinmap.wrongDirection";
    public static final String BAD_URI = "com.st.stellar.pinmap.badURI";

    public PinCfgValidationMessageAcceptor getAcceptor() {
        PinCfgValidationMessageAcceptor _xifexpression = null;
        if (this.errorAcceptor == null) {
            PinCfgValidationMessageAcceptor _pinCfgValidationMessageAcceptor;
            PinCfgValidator _cast = (PinCfgValidator)((Object)PinCfgValidator.class.cast((Object)this));
            _xifexpression = this.errorAcceptor = (_pinCfgValidationMessageAcceptor = new PinCfgValidationMessageAcceptor(_cast));
        } else {
            _xifexpression = this.errorAcceptor;
        }
        return _xifexpression;
    }

    public Pair<Boolean, String> checkValue(FieldInstance regInstance, IOFields fieldType, String valueStr) {
        FieldType field = regInstance.getAttr();
        if (field.getEnumeratedValues() == null || field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            if (field.getName() != null && field.getName().equals("SSS")) {
                EObject _eContainer = regInstance.eContainer().eContainer();
                PinSetting ps = (PinSetting)_eContainer;
                PinProperties pp = ps.getConfig();
                RegisterType element = this._pinCfgHelper.getRef(pp);
                Function regConfig = pp.getAlt();
                Object value = "";
                long longVal = 0L;
                int sss = this._pinCfgHelper.getIO_SSS(ps);
                String _hexString = Long.toHexString(sss);
                String _plus = "0x" + _hexString;
                value = _plus;
                longVal = this._pinCfgHelper.getLongValue(Integer.toString(sss));
                String message = NLS.bind((String)"The only possible value for field: ''{0}'' is ''{1}''", (Object)field.getName(), (Object)value);
                long inputValLong = this._pinCfgHelper.getLongValue(valueStr);
                boolean _equals = Long.valueOf(inputValLong).equals(longVal);
                return new Pair((Object)_equals, (Object)message);
            }
            return new Pair((Object)Boolean.TRUE, (Object)"");
        }
        EnumeratedValueType enumValue = this.findEnumeratedValue(field, valueStr);
        if (enumValue == null) {
            String message_1 = NLS.bind((String)"Wrong value ''{0}'' for bit field ''{1}''", (Object)valueStr, (Object)field.getName());
            Boolean error = Boolean.FALSE;
            return new Pair((Object)error, (Object)message_1);
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    public EnumeratedValueType findEnumeratedValue(FieldType field, String valueStr) {
        EnumeratedValueType _xblockexpression = null;
        EList values = field.getEnumeratedValues().getEnumeratedValue();
        EnumeratedValueType enumValue = null;
        long valueLong = this._pinCfgHelper.getLongValue(valueStr);
        if (valueLong < 0L) {
            String nameStr = valueStr.replaceAll("'", "").replaceAll("\"", "");
            Functions.Function1 _function = it -> it.getName().equals(nameStr);
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function);
        } else {
            Functions.Function1 _function_1 = it -> {
                boolean _xblockexpression_1 = false;
                long enumLong = this._pinCfgHelper.getLongValue(it.getValue());
                _xblockexpression_1 = Long.valueOf(enumLong).equals(valueLong);
                return _xblockexpression_1;
            };
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function_1);
        }
        _xblockexpression = enumValue;
        return _xblockexpression;
    }

    public Pair<Boolean, String> checkValue(FieldInstance regInstance, MUXFields fieldType, String valueStr) {
        FieldType field = regInstance.getAttr();
        if (field.getEnumeratedValues() == null || field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            if (field.getName() != null && field.getName().equals("SSS")) {
                EObject _eContainer = regInstance.eContainer().eContainer();
                PinSetting ps = (PinSetting)_eContainer;
                PinProperties pp = ps.getConfig();
                RegisterType element = this._pinCfgHelper.getRef(pp);
                Object value = "";
                long longVal = 0L;
                if (element != null) {
                    int sss = this._pinCfgHelper.getIO_SSS(pp);
                    String _hexString = Long.toHexString(sss);
                    String _plus = "0x" + _hexString;
                    value = _plus;
                    longVal = this._pinCfgHelper.getLongValue(Integer.toString(sss));
                }
                String message = NLS.bind((String)"The only possible value for field: ''{0}'' is ''{1}''", (Object)field.getName(), (Object)value);
                long inputValLong = this._pinCfgHelper.getLongValue(valueStr);
                boolean _equals = Long.valueOf(inputValLong).equals(longVal);
                return new Pair((Object)_equals, (Object)message);
            }
            return new Pair((Object)Boolean.TRUE, (Object)"");
        }
        EnumeratedValueType enumValue = this.findEnumeratedValue(field, valueStr);
        if (enumValue == null) {
            String message_1 = NLS.bind((String)"Wrong value ''{0}'' for bit field ''{1}''", (Object)valueStr, (Object)field.getName());
            Boolean error = Boolean.FALSE;
            return new Pair((Object)error, (Object)message_1);
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    @Check
    public void checkFieldInstanceValue(FieldInstance instance) {
        EObject parent = instance.eContainer();
        this.checkFieldInstanceValues(parent, instance);
    }

    protected void _checkFieldInstanceValues(IOFields fieldType, FieldInstance instance) {
        this._utils = Utils.instance;
        FieldType bf = instance.getAttr();
        String value = instance.getValue();
        if (bf == null || value == null) {
            return;
        }
        Pair<Boolean, String> res = this.checkValue(instance, fieldType, value);
        Boolean _key = (Boolean)res.getKey();
        boolean valid = _key;
        if (!valid) {
            String _value;
            String message = _value = (String)res.getValue();
            List<String> values = this.possibleValues(instance, fieldType);
            this.error(message, (EStructuralFeature)PinCfgPackage.Literals.FIELD_INSTANCE__VALUE, INVALID_FIELD_INSTANCE_VALUE, (String[])Iterables.toArray(values, String.class));
        }
    }

    protected void _checkFieldInstanceValues(MUXFields fieldType, FieldInstance instance) {
        this._utils = Utils.instance;
        FieldType bf = instance.getAttr();
        String value = instance.getValue();
        if (bf == null || value == null) {
            return;
        }
        Pair<Boolean, String> res = this.checkValue(instance, fieldType, value);
        Boolean _key = (Boolean)res.getKey();
        boolean valid = _key;
        if (!valid) {
            String _value;
            String message = _value = (String)res.getValue();
            List<String> values = this.possibleValues(instance, fieldType);
            this.error(message, (EStructuralFeature)PinCfgPackage.Literals.FIELD_INSTANCE__VALUE, INVALID_FIELD_INSTANCE_VALUE, (String[])Iterables.toArray(values, String.class));
        }
    }

    protected void _checkFieldInstanceValues(EObject fieldType, FieldInstance instance) {
    }

    protected List<String> _possibleValues(FieldInstance regInstance, IOFields fieldType) {
        ArrayList<String> _xblockexpression = null;
        FieldType field = regInstance.getAttr();
        ArrayList<String> _xifexpression = null;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            ArrayList _arrayList;
            ArrayList _elvis = null;
            Functions.Function1 _function = it -> it.getValue();
            ArrayList _map = ListExtensions.map((List)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            _elvis = _map != null ? _map : (_arrayList = new ArrayList());
            _xifexpression = _elvis;
        } else {
            boolean _equals_1;
            EObject _eContainer;
            PinSetting ps;
            RegisterType element;
            ArrayList<String> _xblockexpression_1 = null;
            ArrayList<String> list = new ArrayList<String>();
            boolean _equals = field.getName().equals("SSS");
            if (_equals && (element = this._pinCfgHelper.getRef((ps = (PinSetting)(_eContainer = fieldType.eContainer())).getConfig())) != null && (_equals_1 = element.getTypeIdentifier().equals("MSCR_MUX"))) {
                FunctionRef siulFunction = this._pinCfgHelper.siulFunction(ps);
                element = siulFunction.getAlt().getRef();
                String _hexString = Long.toHexString(siulFunction.getAlt().getSss());
                String value = "0x" + _hexString;
                list.add(value);
            }
            _xifexpression = _xblockexpression_1 = list;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected List<String> _possibleValues(FieldInstance regInstance, MUXFields fieldType) {
        ArrayList<String> _xblockexpression = null;
        FieldType field = regInstance.getAttr();
        ArrayList<String> _xifexpression = null;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            ArrayList _arrayList;
            ArrayList _elvis = null;
            Functions.Function1 _function = it -> it.getValue();
            ArrayList _map = ListExtensions.map((List)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            _elvis = _map != null ? _map : (_arrayList = new ArrayList());
            _xifexpression = _elvis;
        } else {
            ArrayList<String> _xblockexpression_1 = null;
            ArrayList<String> list = new ArrayList<String>();
            boolean _equals = field.getName().equals("SSS");
            if (_equals) {
                PinSetting ps = null;
                EObject _eContainer = fieldType.eContainer();
                ps = (PinSetting)_eContainer;
                FunctionRef funcRef = this._pinCfgHelper.getFunctionRef(ps);
                String _hexString = Long.toHexString(funcRef.getAlt().getSss());
                String value = "0x" + _hexString;
                list.add(value);
            }
            _xifexpression = _xblockexpression_1 = list;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static List<String> possibleFunctionLocations(PinSetting ps) {
        EObject _eContainer_3;
        ArrayList _xblockexpression = null;
        Function function = ps.getConfig().getAlt();
        EObject _eContainer = ps.eContainer();
        Module module = (Module)_eContainer;
        ArrayList list = CollectionLiterals.newArrayList();
        EObject _eContainer_1 = module.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            EObject _eContainer_2 = module.eContainer();
            List<Pin> _functionPins = PinCfgHelper.getFunctionPins((PinSettings)_eContainer_2, function);
            for (Pin pin : _functionPins) {
                boolean _equals = ps.getPad().getName().equals(pin.getName());
                boolean _not = !_equals;
                if (!_not) continue;
                list.add(pin.getName());
            }
        }
        if ((_eContainer_3 = module.eContainer()) instanceof Board) {
            EObject _eContainer_4 = module.eContainer();
            List<Pin> _functionPins_1 = PinCfgHelper.getFunctionPins((Board)_eContainer_4, function);
            for (Pin pin_1 : _functionPins_1) {
                boolean _equals_1 = ps.getPad().getName().equals(pin_1.getName());
                boolean _not_1 = !_equals_1;
                if (!_not_1) continue;
                list.add(pin_1.getName());
            }
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static boolean directionsAreCompatible(com.st.stellar.pinmap.pinmapDsl.Direction fctDirection, Direction pinDirection) {
        boolean _xblockexpression = false;
        boolean res = false;
        if (pinDirection != null) {
            switch (pinDirection) {
                case INPUT: {
                    res = Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT) || Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case OUTPUT: {
                    res = Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT) || Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case INPUT_OUTPUT: {
                    boolean _equals;
                    res = _equals = Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT);
                    break;
                }
                case DEFAULT_INPUT: {
                    boolean _equals_1;
                    res = _equals_1 = Objects.equals(fctDirection, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                    break;
                }
                default: {
                    res = false;
                    break;
                }
            }
        } else {
            res = false;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Check
    public void checkMissingRegInstances(PinSetting ps) {
        PinCfgValidator.checkMissingRegInstances(ps, this.getAcceptor());
    }

    public static void checkMissingRegInstances(PinSetting ps, PinCfgValidationMessageAcceptor acceptor) {
    }

    @Check
    public void checkNoDuplicatedPinNames(PinConfiguration cfg) {
        PinCfgValidator.checkNoDuplicatedPinNames(cfg, this.getAcceptor());
    }

    public static void checkNoDuplicatedPinNames(PinConfiguration cfg, PinCfgValidationMessageAcceptor acceptor) {
        PinSettings _pinSetting;
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals;
        HashMultimap multiMap = HashMultimap.create();
        Board _board = cfg.getBoard();
        boolean bl = _tripleNotEquals = _board != null;
        if (_tripleNotEquals) {
            List<PinSetting> _pinSettings = PinCfgHelper.getPinSettings(cfg.getBoard());
            for (PinSetting e : _pinSettings) {
                String _name = e.getName();
                boolean bl2 = _name != null;
                if (!bl2) continue;
                multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
            }
        }
        boolean bl3 = _tripleNotEquals_2 = (_pinSetting = cfg.getPinSetting()) != null;
        if (_tripleNotEquals_2) {
            List<PinSetting> _allPinSettings = PinCfgHelper.getAllPinSettings(cfg);
            for (PinSetting pinSetting : _allPinSettings) {
                String _name_1 = pinSetting.getName();
                boolean _tripleNotEquals_3 = _name_1 != null;
                if (!_tripleNotEquals_3) continue;
                multiMap.put((Object)pinSetting.getName().toLowerCase(Locale.ENGLISH), (Object)pinSetting);
            }
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                try {
                    String _name_2 = d.getName();
                    String _plus = "Duplicated pin identifier: " + _name_2;
                    acceptor.collectError(_plus, (EObject)d, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Name(), -1, DUPLICATED_ELEMENT, new String[0]);
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalArgumentException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    @Check
    public void checkUniqueFunctionUsage(PinConfiguration config) {
        PinCfgValidator.checkUniqueFunctionUsage(config, this.getAcceptor());
    }

    public static void checkUniqueFunctionUsage(PinConfiguration config, PinCfgValidationMessageAcceptor acceptor) {
        Board _board;
        boolean _tripleNotEquals_1;
        HashMultimap multiMap = HashMultimap.create();
        PinSettings settings = config.getPinSetting();
        if (settings != null) {
            boolean _tripleNotEquals;
            List<PinSetting> _pinSettings = PinCfgHelper.getPinSettings(settings);
            for (PinSetting e : _pinSettings) {
                if (e.getConfig() == null || e.getConfig().getAlt() == null || e.getConfig().getAlt().getName() == null) continue;
                multiMap.put((Object)e.getConfig().getAlt().getName(), (Object)e);
            }
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            boolean bl = _tripleNotEquals = _includedBoard != null;
            if (_tripleNotEquals) {
                Board board = PinCfgHelper.getBoard(config.getPinSetting().getIncludedBoard());
                List<PinSetting> boardSettings = PinCfgHelper.getPinSettings(board);
                for (PinSetting e_1 : boardSettings) {
                    if (e_1.getConfig() == null || e_1.getConfig().getAlt() == null || e_1.getConfig().getAlt().getName() == null) continue;
                    multiMap.put((Object)e_1.getConfig().getAlt().getName(), (Object)e_1);
                }
            }
        }
        boolean bl = _tripleNotEquals_1 = (_board = config.getBoard()) != null;
        if (_tripleNotEquals_1) {
            List<PinSetting> boardSettings_1 = PinCfgHelper.getPinSettings(config.getBoard());
            for (PinSetting e_2 : boardSettings_1) {
                if (e_2.getConfig() == null || e_2.getConfig().getAlt() == null || e_2.getConfig().getAlt().getName() == null) continue;
                multiMap.put((Object)e_2.getConfig().getAlt().getName(), (Object)e_2);
            }
        }
        URI currentURI = config.eResource().getURI();
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Functions.Function1 _function;
            Iterable pins;
            int _size_3;
            boolean _greaterThan_2;
            boolean _greaterThan_1;
            Collection duplicates = (Collection)entry.getValue();
            Set resources = PinCfgValidator.getResources(duplicates).asMap().entrySet();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            int _size_1 = resources.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                for (Map.Entry uri : resources) {
                    Collection pinSettings = (Collection)uri.getValue();
                    for (PinSetting d : pinSettings) {
                        if (((URI)uri.getKey()).equals(currentURI) && !acceptor.acceptsExternalResource()) continue;
                        Functions.Function1 _function2 = it -> {
                            boolean _equals = it.eResource().getURI().equals(uri.getKey());
                            return !_equals;
                        };
                        acceptor.collectError(NLS.bind((String)"Function ''{0}'' cannot be used twice on different pins. Already defined in ''{1}''", (Object)d.getConfig().getAlt().getName(), uri.getKey()), (EObject)IterableExtensions.findFirst((Iterable)duplicates, (Functions.Function1)_function2), (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Config(), -1, UNIQUE_FUNCTION_USAGE, new String[0]);
                    }
                }
                continue;
            }
            Set entries = resources;
            int _size_2 = entries.size();
            boolean _equals = _size_2 == 1;
            if (!_equals || !(_greaterThan_2 = (_size_3 = IterableExtensions.size((Iterable)(pins = IterableExtensions.filter((Iterable)duplicates, (Functions.Function1)(_function = it -> it.eResource().getURI().equals(((Map.Entry[])Conversions.unwrapArray((Object)entries, Map.Entry.class))[0].getKey())))))) > 1)) continue;
            for (PinSetting d : pins) {
                URI uri_1 = d.eResource().getURI();
                if (uri_1 != currentURI && !acceptor.acceptsExternalResource()) continue;
                acceptor.collectError(NLS.bind((String)"Function cannot be used twice on different pins: ''{0}''", (Object)d.getConfig().getAlt().getName()), (EObject)d.getConfig(), (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinProperties_Alt(), -1, UNIQUE_FUNCTION_USAGE, new String[0]);
            }
        }
    }

    @Check
    public void checkPinAlreadyUsed(PinConfiguration config) {
        PinCfgValidator.checkPinAlreadyUsed(config, this.getAcceptor());
    }

    public static void checkPinAlreadyUsed(PinConfiguration config, PinCfgValidationMessageAcceptor acceptor) {
        Board _board;
        boolean _tripleNotEquals_3;
        HashMultimap multiMap = HashMultimap.create();
        PinSettings settings = config.getPinSetting();
        Functions.Function1 _function = it -> it.getPad().getName();
        List cfgPins = ListExtensions.map(PinCfgHelper.getPinSettings(settings), (Functions.Function1)_function);
        if (settings != null) {
            boolean _tripleNotEquals_1;
            List<PinSetting> _pinSettings = PinCfgHelper.getPinSettings(settings);
            for (PinSetting e : _pinSettings) {
                Configuration _pad = e.getPad();
                boolean _tripleNotEquals = _pad != null;
                if (!_tripleNotEquals) continue;
                multiMap.put((Object)e.getPad(), (Object)e);
            }
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            boolean bl = _tripleNotEquals_1 = _includedBoard != null;
            if (_tripleNotEquals_1) {
                Board board = PinCfgHelper.getBoard(config.getPinSetting().getIncludedBoard());
                List<PinSetting> boardSettings = PinCfgHelper.getPinSettings(board);
                for (PinSetting e_1 : boardSettings) {
                    Configuration _pad_1 = e_1.getPad();
                    boolean _tripleNotEquals_2 = _pad_1 != null;
                    if (!_tripleNotEquals_2) continue;
                    multiMap.put((Object)e_1.getPad(), (Object)e_1);
                }
            }
        }
        boolean bl = _tripleNotEquals_3 = (_board = config.getBoard()) != null;
        if (_tripleNotEquals_3) {
            List<PinSetting> boardSettings_1 = PinCfgHelper.getPinSettings(config.getBoard());
            for (PinSetting e_2 : boardSettings_1) {
                Configuration _pad_2 = e_2.getPad();
                boolean _tripleNotEquals_4 = _pad_2 != null;
                if (!_tripleNotEquals_4) continue;
                multiMap.put((Object)e_2.getPad(), (Object)e_2);
            }
        }
        URI currentURI = config.eResource().getURI();
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan_1;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Multimap<URI, PinSetting> resources = PinCfgValidator.getResources(duplicates);
            int _size_1 = resources.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                Set _entrySet_1 = resources.asMap().entrySet();
                for (Map.Entry uri : _entrySet_1) {
                    Collection pinSettings = (Collection)uri.getValue();
                    for (PinSetting d : pinSettings) {
                        List<String> values = PinCfgValidator.possibleFunctionLocations(d);
                        if (uri.getKey() == currentURI || acceptor.acceptsExternalResource()) {
                            acceptor.collectWarning(NLS.bind((String)"Pin ''{0}'' cannot be configured twice. Already defined in ''{1}''", (Object)d.getPad().getName(), uri.getKey()), (EObject)d, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Pad(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
                            continue;
                        }
                        boolean _contains = cfgPins.contains(d.getPad().getName());
                        if (!_contains) continue;
                        Functions.Function1 _function_1 = it -> {
                            boolean _equals = it.eResource().getURI().equals(uri.getKey());
                            return !_equals;
                        };
                        acceptor.collectError(NLS.bind((String)"Pin ''{0}'' cannot be configured twice. Already defined in ''{1}''", (Object)d.getPad().getName(), uri.getKey()), (EObject)IterableExtensions.findFirst((Iterable)duplicates, (Functions.Function1)_function_1), (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Pad(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
                    }
                }
                continue;
            }
            for (PinSetting d : duplicates) {
                List<String> values = PinCfgValidator.possibleFunctionLocations(d);
                Resource uri_1 = d.eResource();
                if (uri_1 != currentURI && !acceptor.acceptsExternalResource()) continue;
                acceptor.collectWarning(NLS.bind((String)"Pin ''{0}''cannot be configured twice.", (Object)d.getPad().getName()), (EObject)d.getConfig(), (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Pad(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
            }
        }
    }

    public static Multimap<URI, PinSetting> getResources(Collection<PinSetting> settings) {
        boolean _greaterThan;
        HashMultimap resources = HashMultimap.create();
        int _size = settings.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (PinSetting d : settings) {
                URI boardUri;
                boolean _equals;
                boolean _not;
                URI pinResourceUri = d.eResource().getURI();
                resources.put((Object)pinResourceUri, (Object)d);
                Board board = PinCfgHelper.getBoard(d);
                if (board == null || !(_not = !(_equals = (boardUri = board.eResource().getURI()).equals(pinResourceUri)))) continue;
                resources.put((Object)pinResourceUri, (Object)d);
            }
        } else {
            boolean _greaterThan_1;
            int _size_1 = settings.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                PinSetting d_1 = ((PinSetting[])Conversions.unwrapArray(settings, PinSetting.class))[0];
                resources.put((Object)d_1.eResource().getURI(), (Object)d_1);
            }
        }
        return resources;
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        this.getChain().add(this.createDiagnostic(Severity.ERROR, message, object, feature, -1, code, issueData));
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        this.getChain().add(this.createDiagnostic(Severity.WARNING, message, object, feature, -1, code, issueData));
    }

    @Check
    public void checkPinConfig(PinConfiguration config) {
        PinCfgValidator.checkPinConfig(config, this.getAcceptor());
    }

    public static void checkPinConfig(PinConfiguration config, PinCfgValidationMessageAcceptor acceptor) {
        boolean _tripleNotEquals;
        HashMultimap multiMap = HashMultimap.create();
        List<PinSetting> pinsList = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            pinsList = PinCfgHelper.getPinSettings(config.getPinSetting());
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                pinsList = PinCfgHelper.getPinSettings(config.getBoard());
            }
        }
        for (PinSetting e : pinsList) {
            if (e.getPad() == null || e.getPad().getName() == null) continue;
            multiMap.put((Object)e.getPad().getName(), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                String _name = d.getPad().getName();
                String _plus = "Duplicated pin configuration: " + _name;
                acceptor.collectWarning(_plus, (EObject)d, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSetting_Pad(), -1, DUPLICATED_PINCONFIG, new String[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Check
    public void checkPinDirection(PinProperties config) {
        EObject _eContainer = config.eContainer();
        PinSetting setting = (PinSetting)_eContainer;
        Function fct = setting.getConfig().getAlt();
        Direction direction = setting.getConfig().getDirection();
        if (fct != null) {
            Function function = fct;
            synchronized (function) {
                boolean _tripleNotEquals;
                QualifiedName fctName = this.qnprovider.getFullyQualifiedName((EObject)fct);
                Configuration _pad = setting.getPad();
                boolean bl = _tripleNotEquals = _pad != null;
                if (_tripleNotEquals) {
                    boolean _lessThan;
                    Functions.Function1 _function_1;
                    Functions.Function1 _function = it -> this.qnprovider.getFullyQualifiedName((EObject)it.getName()).equals((Object)fctName);
                    Iterable functionNames = IterableExtensions.filter((Iterable)setting.getPad().getFunctions(), (Functions.Function1)_function);
                    Iterable functions = IterableExtensions.filter((Iterable)functionNames, (Functions.Function1)(_function_1 = it -> PinCfgValidator.directionsAreCompatible(it.getDirection(), setting.getConfig().getDirection())));
                    int _size = IterableExtensions.size((Iterable)functions);
                    boolean bl2 = _lessThan = _size < 1;
                    if (_lessThan) {
                        String message = NLS.bind((String)"Cannot set function ''{0}'' in ''{1}''", (Object)fct.getName(), (Object)direction.getName());
                        ArrayList<String> validDirections = PinCfgHelper.getDirections(setting);
                        this.error(message, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), WRONG_DIRECTION, (String[])Iterables.toArray(validDirections, String.class));
                    }
                }
            }
        }
    }

    @Check
    public void checkOutputFolder(PinSettings settings) {
        String outputfolder = settings.getOutputFolder();
        if (outputfolder != null && outputfolder.contains("..")) {
            this.error("Relative path not allowed.", settings, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSettings_OutputFolder(), INVALID_OUTPUTFOLDER, new String[0]);
        }
    }

    @Check
    public void checkImports(PinSettings ps) {
        Board board = PinCfgHelper.getBoard(ps.getIncludedBoard());
        if (board == null && ps != null && ps.getIncludedBoard() != null) {
            String message = NLS.bind((String)"Cannot import URI ''{0}''", (Object)ps.getIncludedBoard().getImportURI());
            this.error(message, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
        }
    }

    @Check
    public void checkImports(Board board) {
        Include inc = board.getIncludes();
        if (inc != null && inc.getImportURI() != null) {
            EObject config = board.eContainer();
            Resource resource = config.eResource();
            Resource r = PinCfgHelper.getResource(resource, inc.getImportURI());
            if (r != null && !r.getContents().isEmpty()) {
                EcoreUtil.resolveAll((Resource)r);
                EList _errors = r.getErrors();
                for (Resource.Diagnostic error : _errors) {
                    String _message = error.getMessage();
                    String _plus = "This URI contains the following error: " + _message;
                    this.error(_plus, (EStructuralFeature)PinCfgPackage.eINSTANCE.getBoard_Includes(), BAD_URI, null);
                }
            } else {
                String message = NLS.bind((String)"Cannot load URI ''{0}''", (Object)inc.getImportURI());
                this.error(message, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
            }
        }
    }

    @Check
    public void checkPinSettings(PinSettings setting) {
        IncludeBoard inc = setting.getIncludedBoard();
        if (inc != null && inc.getImportURI() != null) {
            Resource resource = setting.eResource();
            Resource r = PinCfgHelper.getResource(resource, inc.getImportURI());
            if (r != null && !r.getContents().isEmpty()) {
                EcoreUtil.resolveAll((Resource)r);
                EList _errors = r.getErrors();
                for (Resource.Diagnostic error : _errors) {
                    String _message = error.getMessage();
                    String _plus = "This URI contains the following error: " + _message;
                    this.error(_plus, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
                }
            } else {
                String message = NLS.bind((String)"Cannot load URI ''{0}''", (Object)inc);
                this.error(message, (EStructuralFeature)PinCfgPackage.eINSTANCE.getPinSettings_Name(), BAD_URI, null);
            }
        }
    }

    @XbaseGenerated
    public void checkFieldInstanceValues(EObject fieldType, FieldInstance instance) {
        if (fieldType instanceof IOFields) {
            this._checkFieldInstanceValues((IOFields)fieldType, instance);
            return;
        }
        if (fieldType instanceof MUXFields) {
            this._checkFieldInstanceValues((MUXFields)fieldType, instance);
            return;
        }
        if (fieldType != null) {
            this._checkFieldInstanceValues(fieldType, instance);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fieldType, instance).toString());
    }

    @XbaseGenerated
    public List<String> possibleValues(FieldInstance regInstance, EObject fieldType) {
        if (fieldType instanceof IOFields) {
            return this._possibleValues(regInstance, (IOFields)fieldType);
        }
        if (fieldType instanceof MUXFields) {
            return this._possibleValues(regInstance, (MUXFields)fieldType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(regInstance, fieldType).toString());
    }
}

