/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.formatting2;

import com.google.inject.Inject;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Import;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Part;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import com.st.stellar.pinmap.pinmapDsl.SpecialFunction;
import com.st.stellar.pinmap.services.PinmapDslGrammarAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class PinmapDslFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private PinmapDslGrammarAccess _pinmapDslGrammarAccess;

    protected void _format(PinmapModel model, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)model).keyword("package"), _function);
        EList<Import> _imports = model.getImports();
        for (Object import_ : _imports) {
            document.format(import_);
        }
        EList<Family> _families = model.getFamilies();
        for (Family family : _families) {
            document.format((Object)family);
        }
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)model).keyword(","), _function_1), _function_2);
    }

    protected void _format(Family family, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("Family"), _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(this.textRegionExtensions.regionFor((EObject)family).keyword("}"), _function_1);
        EList<Part> _parts = family.getParts();
        for (Part part : _parts) {
            document.format((Object)part);
        }
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)family).keyword("Peripherals");
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)family).keyword("Functions");
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.newLine();
        Procedures.Procedure1 _function_4 = it -> it.indent();
        document.interior(document.append(begin, _function_2), document.prepend(end, _function_3), _function_4);
        Procedures.Procedure1 _function_5 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("Peripheral"), _function_5);
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Peripheral peripheral : _peripherals) {
            document.format((Object)peripheral);
        }
        Procedures.Procedure1 _function_6 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("Functions"), _function_6);
        begin = this.textRegionExtensions.regionFor((EObject)family).keyword("Functions");
        end = this.textRegionExtensions.regionFor((EObject)family).keyword("SpecialFunctions");
        Procedures.Procedure1 _function_7 = it -> it.newLine();
        Procedures.Procedure1 _function_8 = it -> it.newLine();
        Procedures.Procedure1 _function_9 = it -> it.indent();
        document.interior(document.append(begin, _function_7), document.prepend(end, _function_8), _function_9);
        EList<Function> _functions = family.getFunctions();
        for (Function function : _functions) {
            document.format((Object)function);
        }
        Procedures.Procedure1 _function_10 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("SpecialFunctions"), _function_10);
        begin = this.textRegionExtensions.regionFor((EObject)family).keyword("SpecialFunctions");
        end = this.textRegionExtensions.regionFor((EObject)family).keyword("Configurations");
        Procedures.Procedure1 _function_11 = it -> it.newLine();
        Procedures.Procedure1 _function_12 = it -> it.newLine();
        Procedures.Procedure1 _function_13 = it -> it.indent();
        document.interior(document.append(begin, _function_11), document.prepend(end, _function_12), _function_13);
        EList<SpecialFunction> _specialFunctions = family.getSpecialFunctions();
        for (SpecialFunction specialFunction : _specialFunctions) {
            document.format((Object)specialFunction);
        }
        Procedures.Procedure1 _function_14 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("Configurations"), _function_14);
        begin = this.textRegionExtensions.regionFor((EObject)family).keyword("Configurations");
        end = this.textRegionExtensions.regionFor((EObject)IterableExtensions.lastOrNull(family.getConfigurations())).keyword("}");
        Procedures.Procedure1 _function_15 = it -> it.newLine();
        Procedures.Procedure1 _function_16 = it -> it.newLine();
        Procedures.Procedure1 _function_17 = it -> it.indent();
        document.interior(document.append(begin, _function_15), document.prepend(end, _function_16), _function_17);
        EList<Configuration> _configurations = family.getConfigurations();
        for (Configuration configuration : _configurations) {
            document.format((Object)configuration);
        }
        Procedures.Procedure1 _function_18 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)family).keyword("Packages"), _function_18);
        begin = this.textRegionExtensions.regionFor((EObject)family).keyword("Packages");
        end = this.textRegionExtensions.regionFor((EObject)IterableExtensions.lastOrNull(family.getPackages())).keyword("}");
        Procedures.Procedure1 _function_19 = it -> it.newLine();
        Procedures.Procedure1 _function_20 = it -> it.newLine();
        Procedures.Procedure1 _function_21 = it -> it.indent();
        document.interior(document.append(begin, _function_19), document.prepend(end, _function_20), _function_21);
        EList<Package> _packages = family.getPackages();
        for (Package _package : _packages) {
            document.format((Object)_package);
        }
    }

    protected void _format(Import imp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)imp).keyword("import"), _function);
    }

    protected void _format(Peripheral peripheral, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)peripheral).keyword("Peripheral"), _function);
    }

    protected void _format(Function function, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        document.surround((EObject)function, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)function).keyword("Function"), _function_1);
    }

    protected void _format(SpecialFunction function, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)function).keyword("SpecialFunction"), _function);
    }

    protected void _format(Configuration cfg, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)cfg).keyword("Configuration"), _function);
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)cfg).keyword("Functions");
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)IterableExtensions.lastOrNull(cfg.getFunctions())).keyword("}");
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(begin, _function_1), document.prepend(end, _function_2), _function_3);
        EList<FunctionRef> _functions = cfg.getFunctions();
        for (FunctionRef fr : _functions) {
            document.format((Object)fr);
        }
    }

    protected void _format(FunctionRef function, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        document.surround((EObject)function, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.prepend((EObject)function, _function_1);
    }

    protected void _format(Package pack, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)pack).keyword("Pins"), _function);
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)pack).keyword("Pins");
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)IterableExtensions.lastOrNull(pack.getPins())).keyword("}");
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(document.append(begin, _function_1), document.prepend(end, _function_2), _function_3);
        EList<Pin> _pins = pack.getPins();
        for (Pin pin : _pins) {
            document.format((Object)pin);
        }
    }

    protected void _format(Pin cfg, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)cfg).keyword("Pin"), _function);
    }

    @XbaseGenerated
    public void format(Object cfg, IFormattableDocument document) {
        if (cfg instanceof XtextResource) {
            this._format((XtextResource)cfg, document);
            return;
        }
        if (cfg instanceof Configuration) {
            this._format((Configuration)cfg, document);
            return;
        }
        if (cfg instanceof Family) {
            this._format((Family)cfg, document);
            return;
        }
        if (cfg instanceof Function) {
            this._format((Function)cfg, document);
            return;
        }
        if (cfg instanceof FunctionRef) {
            this._format((FunctionRef)cfg, document);
            return;
        }
        if (cfg instanceof Import) {
            this._format((Import)cfg, document);
            return;
        }
        if (cfg instanceof Package) {
            this._format((Package)cfg, document);
            return;
        }
        if (cfg instanceof Peripheral) {
            this._format((Peripheral)cfg, document);
            return;
        }
        if (cfg instanceof Pin) {
            this._format((Pin)cfg, document);
            return;
        }
        if (cfg instanceof PinmapModel) {
            this._format((PinmapModel)cfg, document);
            return;
        }
        if (cfg instanceof SpecialFunction) {
            this._format((SpecialFunction)cfg, document);
            return;
        }
        if (cfg instanceof EObject) {
            this._format((EObject)cfg, document);
            return;
        }
        if (cfg == null) {
            this._format(null, document);
            return;
        }
        if (cfg != null) {
            this._format(cfg, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cfg, document).toString());
    }
}

