/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.generator;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.NotConnectedPin;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import com.st.stellar.pinmap.pinmapDsl.impl.ConfigurablePinImpl;
import com.st.stellar.pinmap.pinmapDsl.impl.SpecialPinImpl;
import com.st.stellar.pinmap.pinmapDsl.impl.SystemFunctionPinImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class GeneratePinmapView {
    public final int pinWidth = 40;
    public final int pinHeight = 40;
    public final int pinMarginWidth = 3;
    public final int pinMarginHeight = 3;
    public final int fontSize;
    private final String rowLetters = "A,B,C,D,E,F,G,H,J,K,L,M,N,P,R,T,U,V,W,Y,AA,AB,AC,AD,AE,AF,AG,AH,AJ,AK";
    private final Splitter SPLITTER;
    private final List<String> rowLettersListOrdered;
    private final List<String> rowLettersList;
    private int deltaY;

    public GeneratePinmapView() {
        Objects.requireNonNull(this);
        this.fontSize = 40 / 3;
        this.rowLetters = "A,B,C,D,E,F,G,H,J,K,L,M,N,P,R,T,U,V,W,Y,AA,AB,AC,AD,AE,AF,AG,AH,AJ,AK";
        this.SPLITTER = Splitter.on((String)",");
        this.rowLettersListOrdered = this.SPLITTER.splitToList((CharSequence)this.rowLetters);
        this.rowLettersList = ListExtensions.reverseView(this.rowLettersListOrdered);
    }

    public String generatePackage(Package p) {
        return this.generatePackage(p, "");
    }

    public String generatePackage(Package p, String additional) {
        String header;
        StringConcatenation _builder;
        int _minus;
        String _xblockexpression = null;
        Utils util = Utils.instance;
        ArrayList<String> rowEnabledLetters = new ArrayList<String>();
        Object pins = "";
        HashMap<String, ArrayList<Pin>> peripheralLayers = new HashMap<String, ArrayList<Pin>>();
        Object layers = "";
        int nbColumns = 0;
        EList<Pin> _pins = p.getPins();
        for (Pin pin : _pins) {
            String id = pin.getName();
            String letter = id.replaceAll("[0-9]", "");
            int _indexOf = this.rowLettersListOrdered.indexOf(letter);
            int _plus = _indexOf + 1;
            nbColumns = Math.max(nbColumns, _plus);
            PinConfig _get = (PinConfig)pin.getPinConfigurations().get(0);
            PinConfig config = _get;
            if (config instanceof NotConnectedPin) continue;
            Pair<String, List<String>> res = this.generatePin(pin);
            String _pins_1 = pins;
            String _key = (String)res.getKey();
            pins = _pins_1 + _key;
            List peripherals = (List)res.getValue();
            for (String periph : peripherals) {
                ArrayList<Pin> layer = (ArrayList<Pin>)peripheralLayers.get(periph);
                if (layer == null) {
                    ArrayList<Pin> _arrayList;
                    layer = _arrayList = new ArrayList<Pin>();
                    peripheralLayers.put(periph, layer);
                }
                layer.add(pin);
            }
        }
        ++nbColumns;
        for (int i = 1; i < nbColumns; ++i) {
            String letter = this.rowLettersListOrdered.get(i - 1);
            rowEnabledLetters.add(letter);
        }
        int _length = ((Object[])Conversions.unwrapArray(this.rowLettersList, Object.class)).length;
        int _length_1 = ((Object[])Conversions.unwrapArray(rowEnabledLetters, Object.class)).length;
        this.deltaY = _minus = _length - _length_1;
        int nbRows = nbColumns;
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        int width = (40 + 3) * nbColumns;
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        int height = (40 + 3) * nbRows;
        Object xAxis = "";
        String color = "black";
        for (int i = 1; i < nbColumns; ++i) {
            String _xAxis = xAxis;
            _builder = new StringConcatenation();
            _builder.append("<g transform=\"translate(");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder.append((Object)(i * (40 + 3)));
            _builder.append(", ");
            Objects.requireNonNull(this);
            _builder.append((Object)(-3 * 4));
            _builder.append(")\"><text x=\"0\" y=\"");
            _builder.append((Object)(this.fontSize / 2));
            _builder.append("\" class=\"xaxistext\">");
            _builder.append((Object)i);
            _builder.append("</text></g>");
            _builder.newLineIfNotEmpty();
            Object _xAxis_1 = xAxis = _xAxis + String.valueOf(_builder);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<g transform=\"translate(");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder_1.append((Object)(i * (40 + 3)));
            _builder_1.append(", ");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder_1.append((Object)(nbRows * (40 + 3) + 3 * 4));
            _builder_1.append(")\"><text x=\"0\" y=\"");
            _builder_1.append((Object)(this.fontSize / 2));
            _builder_1.append("\" class=\"xaxistext\">");
            _builder_1.append((Object)i);
            _builder_1.append("</text></g>");
            _builder_1.newLineIfNotEmpty();
            xAxis = (String)_xAxis_1 + String.valueOf(_builder_1);
        }
        Object yAxis = "";
        for (int i = rowEnabledLetters.size(); i > 0; --i) {
            String y = this.rowLettersList.get(i + this.deltaY - 1);
            String _yAxis = yAxis;
            StringConcatenation _builder2 = new StringConcatenation();
            _builder2.append("<g transform=\"translate(");
            Objects.requireNonNull(this);
            _builder2.append((Object)(-3));
            _builder2.append(", ");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder2.append((Object)(i * (40 + 3)));
            _builder2.append(")\"><text x=\"0\" y=\"");
            _builder2.append((Object)(this.fontSize / 2));
            _builder2.append("\" class=\"end_y_axistext\">");
            _builder2.append(y);
            _builder2.append("</text></g>");
            _builder2.newLineIfNotEmpty();
            Object _yAxis_1 = yAxis = _yAxis + String.valueOf(_builder2);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<g transform=\"translate(");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder_1.append((Object)(nbColumns * (40 + 3) + 3 * 4 - this.fontSize + 3));
            _builder_1.append(", ");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder_1.append((Object)(i * (40 + 3) + 2));
            _builder_1.append(")\"><text x=\"0\" y=\"");
            _builder_1.append((Object)(this.fontSize / 2));
            _builder_1.append("\" class=\"begin_y_axistext\">");
            _builder_1.append(y);
            _builder_1.append("</text></g>");
            _builder_1.newLineIfNotEmpty();
            yAxis = (String)_yAxis_1 + String.valueOf(_builder_1);
        }
        Set _keySet = peripheralLayers.keySet();
        for (String layer : _keySet) {
            Object layerPins = "";
            List _get = (List)peripheralLayers.get(layer);
            for (Pin layerPin : _get) {
                int x = this.getX(layerPin);
                int y = this.getY(layerPin);
                StringConcatenation _builder3 = new StringConcatenation();
                _builder3.append(" ");
                _builder3.append("onmouseenter=\"stt(evt,'");
                String _name = layerPin.getName();
                _builder3.append(_name, " ");
                _builder3.append("');\"");
                String tooltip = _builder3.toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("<g transform=\"translate(");
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                _builder_1.append((Object)(x * (40 + 3)));
                _builder_1.append(", ");
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                _builder_1.append((Object)((y + 1) * (40 + 3)));
                _builder_1.append(")\" ");
                _builder_1.append(tooltip);
                _builder_1.append(">");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("<circle class=\"pPin ");
                String _truncatedPad = util.getTruncatedPad(layerPin);
                _builder_1.append(_truncatedPad, "\t");
                _builder_1.append("\" r=\"");
                Objects.requireNonNull(this);
                _builder_1.append((Object)(40 / 2), "\t");
                _builder_1.append("\"/>");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("<text class=\"pinText\" y=\"");
                _builder_1.append((Object)(this.fontSize / 2), "\t");
                _builder_1.append("\">");
                String _truncatedPad_1 = util.getTruncatedPad(layerPin);
                _builder_1.append(_truncatedPad_1, "\t");
                _builder_1.append("</text>");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("</g>");
                String generatedPin = _builder_1.toString();
                String _layerPins = layerPins;
                layerPins = _layerPins + generatedPin;
            }
            String _layers = layers;
            StringConcatenation _builder4 = new StringConcatenation();
            _builder4.append("<g id=\"animation_layer_");
            _builder4.append(layer);
            _builder4.append("\"");
            _builder4.newLineIfNotEmpty();
            _builder4.append("\t");
            _builder4.append("style=\"display:none\">");
            _builder4.newLine();
            _builder4.append("\t");
            _builder4.append("<g transform=\"translate(20, ");
            int n = -this.deltaY;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _builder4.append((Object)(20 + n * (40 + 3)), "\t");
            _builder4.append(")\">");
            _builder4.newLineIfNotEmpty();
            _builder4.append("\t\t");
            _builder4.append((String)layerPins, "\t\t");
            _builder4.newLineIfNotEmpty();
            _builder4.append("\t");
            _builder4.append("</g>");
            _builder4.newLine();
            _builder4.append("</g>");
            layers = _layers + String.valueOf(_builder4);
        }
        _builder = new StringConcatenation();
        _builder.append("<g");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("transform=\"translate(20,20)\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=\"main_layer\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("style=\"display:inline\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<rect");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("style=\"display:inline;opacity:0.33000004;fill:url(#linearGradient_1);fill-opacity:1;fill-rule:nonzero;stroke:#000000;stroke-width:0.70145893;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:40.5;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"rect_");
        String _name = p.getName();
        _builder.append(_name, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("width=\"");
        _builder.append((Object)width, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("height=\"");
        _builder.append((Object)height, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("x=\"0\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("y=\"0\" />");
        _builder.newLine();
        _builder.append("\t");
        _builder.append((String)xAxis, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append((String)yAxis, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<g transform=\"translate(");
        _builder.append((Object)0, "\t");
        _builder.append(", ");
        int n = -this.deltaY;
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(n * (40 + 3)), "\t");
        _builder.append(")\" >");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append((String)pins, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(additional, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<circle transform=\"translate(6,");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(this.deltaY * (40 + 3) + height - 6), "\t\t");
        _builder.append(")\" fill=\"black\" stroke=\"");
        _builder.append(color, "\t\t");
        _builder.append("\" stroke-width=\"1px\" r=\"");
        _builder.append((Object)3, "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("</g>");
        String animationLayer = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("<svg");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:cc=\"http://creativecommons.org/ns#\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:svg=\"http://www.w3.org/2000/svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns=\"http://www.w3.org/2000/svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("id=\"svg-doc\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("version=\"1.1\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("inkscape:version=\"0.92.2 (5c3e80d, 2017-08-06)\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("width=\"");
        _builder_1.append((Object)width, "\t");
        _builder_1.append("\"");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("height=\"");
        _builder_1.append((Object)height, "\t");
        _builder_1.append("\"");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("xml:space=\"preserve\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("sodipodi:docname=\"pinmap.svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("viewBox=\"0 0 ");
        _builder_1.append((Object)(width + 50), "\t");
        _builder_1.append(" ");
        _builder_1.append((Object)(height + 50), "\t");
        _builder_1.append("\">");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<defs");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("id=\"defs4495\">");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<linearGradient");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("id=\"linearGradient_1\" >");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<stop offset=\"0%\" style=\"stop-color:gray(16);stop-opacity:1\" />");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<stop offset=\"100%\" style=\"stop-color:gainsboro;stop-opacity:1\" />");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</linearGradient>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</defs>");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append(animationLayer, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append((String)layers, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("</svg>");
        _xblockexpression = header = _builder_1.toString();
        return _xblockexpression;
    }

    public Pair<String, List<String>> generatePin(Pin pin) {
        Utils utils = Utils.instance;
        int x = this.getX(pin);
        int y = this.getY(pin);
        String pinClass = "";
        ArrayList<String> peripherals = new ArrayList<String>();
        Pair _mappedTo = Pair.of(ConfigurablePinImpl.class, (Object)"cPin");
        Pair _mappedTo_1 = Pair.of(SpecialPinImpl.class, (Object)"sPin");
        Pair _mappedTo_2 = Pair.of(SystemFunctionPinImpl.class, (Object)"fPin");
        Map pinClasses = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2}));
        pinClass = (String)pinClasses.get(((PinConfig)pin.getPinConfigurations().get(0)).getClass());
        EList<PinConfig> _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            if (cfg instanceof SystemFunctionPin) {
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                Peripheral _peripheralRef = sfp.getRef().getPeripheralRef();
                boolean _tripleNotEquals = _peripheralRef != null;
                if (!_tripleNotEquals) continue;
                boolean _contains = peripherals.contains(sfp.getRef().getPeripheralRef().getLabel());
                boolean bl = _not = !_contains;
                if (_not) {
                    String _label = sfp.getRef().getPeripheralRef().getLabel();
                    peripherals.add(_label);
                }
                if (!(_not_1 = !(_contains_1 = peripherals.contains(sfp.getRef().getPeripheralRef().getName())))) continue;
                String _name = sfp.getRef().getPeripheralRef().getName();
                peripherals.add(_name);
                continue;
            }
            if (!(cfg instanceof ConfigurablePin)) continue;
            ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
            EList<FunctionRef> functions = sfp_1.getRef().getFunctions();
            for (FunctionRef fct : functions) {
                boolean _contains_4;
                boolean _not_4;
                boolean _contains_3;
                boolean _not_3;
                boolean _not_2;
                boolean _contains_2 = peripherals.contains(fct.getName().getPeripheralRef().getLabel());
                boolean bl = _not_2 = !_contains_2;
                if (_not_2) {
                    String _label_1 = fct.getName().getPeripheralRef().getLabel();
                    peripherals.add(_label_1);
                }
                boolean bl2 = _not_3 = !(_contains_3 = peripherals.contains(fct.getName().getPeripheralRef().getName()));
                if (_not_3) {
                    String _name_1 = fct.getName().getPeripheralRef().getName();
                    peripherals.add(_name_1);
                }
                if (!(_not_4 = !(_contains_4 = peripherals.contains(fct.getName().getName())))) continue;
                String _name_2 = fct.getName().getName();
                peripherals.add(_name_2);
            }
        }
        String _fullPadName = this.getFullPadName(pin);
        String pinId = "pad_" + _fullPadName;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("onmouseenter=\"stt(evt,'");
        String _name_1 = pin.getName();
        _builder.append(_name_1, " ");
        _builder.append("');\"");
        String tooltip = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<g transform=\"translate(");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder_1.append((Object)(x * (40 + 3)));
        _builder_1.append(", ");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder_1.append((Object)((y + 1) * (40 + 3)));
        _builder_1.append(")\">");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("<circle id=\"");
        _builder_1.append(pinId);
        _builder_1.append("\" class=\"");
        _builder_1.append(pinClass);
        _builder_1.append("\" r=\"");
        Objects.requireNonNull(this);
        _builder_1.append((Object)(40 / 2));
        _builder_1.append("\" ");
        _builder_1.append(tooltip);
        _builder_1.append("/>");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("<text class=\"pinText\" y=\"");
        _builder_1.append((Object)(this.fontSize / 2));
        _builder_1.append("\" ");
        _builder_1.append(tooltip);
        _builder_1.append(">");
        String _truncatedPad = utils.getTruncatedPad(pin);
        _builder_1.append(_truncatedPad);
        _builder_1.append("</text></g>");
        _builder_1.newLineIfNotEmpty();
        String generatedPin2 = _builder_1.toString();
        return new Pair((Object)generatedPin2, peripherals);
    }

    public String getFullPadName(Pin pin) {
        Iterable _filter = Iterables.filter(pin.getPinConfigurations(), ConfigurablePin.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            ConfigurablePin cfg = (ConfigurablePin)iterator.next();
            return cfg.getRef().getName();
        }
        return pin.getName();
    }

    public int getX(Package pack, Configuration pad) {
        int _xblockexpression = 0;
        Pin pin = Utils.getPinForConfiguration(pack, pad);
        String _elvis = null;
        String _name = pin.getName();
        _elvis = _name != null ? _name : "0";
        String id = _elvis;
        String number = id.replaceAll("[a-zA-Z]", "");
        _xblockexpression = Integer.parseInt(number);
        return _xblockexpression;
    }

    public int getY(Package pack, Configuration pad) {
        int _xblockexpression = 0;
        Pin pin = Utils.getPinForConfiguration(pack, pad);
        String _elvis = null;
        String _name = pin.getName();
        _elvis = _name != null ? _name : "0";
        String id = _elvis;
        String letter = id.replaceAll("[0-9]", "");
        _xblockexpression = this.rowLettersList.indexOf(letter);
        return _xblockexpression;
    }

    public int getX(Pin pin) {
        int _xblockexpression = 0;
        String _elvis = null;
        String _name = pin.getName();
        _elvis = _name != null ? _name : "0";
        String id = _elvis;
        String number = id.replaceAll("[a-zA-Z]", "");
        _xblockexpression = Integer.parseInt(number);
        return _xblockexpression;
    }

    public int getY(Pin pin) {
        int _xblockexpression = 0;
        String _elvis = null;
        String _name = pin.getName();
        _elvis = _name != null ? _name : "0";
        String id = _elvis;
        String letter = id.replaceAll("[0-9]", "");
        _xblockexpression = this.rowLettersList.indexOf(letter);
        return _xblockexpression;
    }
}

