/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.generator;

import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Direction;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.LQFPPackage;
import com.st.stellar.pinmap.pinmapDsl.NotConnectedPin;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class GeneratePinmapViewLQFP {
    @Inject
    @Extension
    private Utils _utils;
    public final int pinWidth = 24;
    public final int pinHeight = 12;
    public final int pinMarginWidth = 3;
    public final int pinMarginHeight = 3;
    public final int fontSize = this.pinWidth / 2;
    public final int generalOffsetX = 200;
    public final int generalOffsetY = 200;
    private static final String pin_in = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<image width=\"12\" height=\"12\" class=\"__class__\" id=\"__id__\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("preserveAspectRatio=\"none\" style=\"image-rendering:optimizeQuality\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABHSURBVChTldBRCgAgCARR6/53tiEiTDei+ZHgIVhzd3vV15y12XqEDkQsri4jqk4gSk4jiu6KEPtwjaIggZKgjKqg/x/XmQ2E7x4X3/QMDwAAAABJRU5ErkJggg==\"/>");
            return _builder.toString();
        }
    }.apply();
    private static final String pin_out = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<image width=\"12\" height=\"12\" class=\"__class__\" id=\"__id__\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("preserveAspectRatio=\"none\" style=\"image-rendering:optimizeQuality\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABISURBVChTpdBBCgAgCERR7f53tiECdVRa9DcRPUpSM5NX6645Pd1Ni3BM1zOqAiXUCuRoEsgRRBw2lp6bHA/eOkaouo8fT4lsFMgeF8UNtBMAAAAASUVORK5CYII=\"/>");
            return _builder.toString();
        }
    }.apply();
    private static final String pin_inout = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<image width=\"12\" height=\"12\" class=\"__class__\" id=\"__id__\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("preserveAspectRatio=\"none\" style=\"image-rendering:optimizeQuality\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABYSURBVChThZABCgAhCAS1///Z01ZsS+QGos2mjNTM5I9LUtVMIlxfOW+jNjzwgZTYAOyF1A1QXgw2UH0qi6/toEm0mzwYHvLh3SsjciWHvavOi4nzmSMiHxyEPAjvnWU6AAAAAElFTkSuQmCC\"/>");
            return _builder.toString();
        }
    }.apply();
    private static final String pin_ground = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<image width=\"12\" height=\"12\" class=\"__class__\" id=\"__id__\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("preserveAspectRatio=\"none\" style=\"image-rendering:optimizeQuality\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAIAAAC0tAIdAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAA5SURBVChTY/hPCsCumoEBhziURgWjqjEBPtVAOYIAoZp4gFANNQQDQKXBgFyz4QBqJjaPkmL2//8AHRBD2doLFjsAAAAASUVORK5CYII=\"/>");
            return _builder.toString();
        }
    }.apply();
    private static final String pin_power = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<image width=\"12\" height=\"12\" class=\"__class__\" id=\"__id__\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("preserveAspectRatio=\"none\" style=\"image-rendering:optimizeQuality\"");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("xlink:href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAtSURBVChTY/z//z8DQUBQEVABE5SJF6Bbx8jICCTRBIkyaTAqIiowqWUdAwMAEpwSBXO68hQAAAAASUVORK5CYII=\"/>");
            return _builder.toString();
        }
    }.apply();
    private static final LinkedHashMap<Direction, String> directionImages = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Direction.INPUT), (Object)pin_in), Pair.of((Object)((Object)Direction.OUTPUT), (Object)pin_out), Pair.of((Object)((Object)Direction.INPUT_OUTPUT), (Object)pin_inout), Pair.of((Object)((Object)Direction.INPUT_OR_OUTPUT), (Object)pin_inout), Pair.of((Object)((Object)Direction.GROUND), (Object)pin_ground), Pair.of((Object)((Object)Direction.POWER), (Object)pin_power), Pair.of((Object)((Object)Direction.INPUT_ALTERNATE), null), Pair.of((Object)((Object)Direction.OUTPUT_ALTERNATE), null)});
    private static final LinkedHashMap<Direction, String> directionImageNames = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Direction.INPUT), (Object)"pin_in"), Pair.of((Object)((Object)Direction.OUTPUT), (Object)"pin_out"), Pair.of((Object)((Object)Direction.INPUT_OUTPUT), (Object)"pin_inout"), Pair.of((Object)((Object)Direction.INPUT_OR_OUTPUT), (Object)"pin_inout"), Pair.of((Object)((Object)Direction.GROUND), (Object)"pin_ground"), Pair.of((Object)((Object)Direction.POWER), (Object)"pin_power"), Pair.of((Object)((Object)Direction.INPUT_ALTERNATE), (Object)""), Pair.of((Object)((Object)Direction.OUTPUT_ALTERNATE), (Object)"")});
    private static final LinkedHashMap<Direction, Boolean> rotateImages = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Direction.INPUT), (Object)Boolean.TRUE), Pair.of((Object)((Object)Direction.OUTPUT), (Object)Boolean.TRUE), Pair.of((Object)((Object)Direction.INPUT_OUTPUT), (Object)Boolean.TRUE), Pair.of((Object)((Object)Direction.INPUT_OR_OUTPUT), (Object)Boolean.TRUE), Pair.of((Object)((Object)Direction.GROUND), (Object)Boolean.FALSE), Pair.of((Object)((Object)Direction.POWER), (Object)Boolean.FALSE), Pair.of((Object)((Object)Direction.INPUT_ALTERNATE), (Object)Boolean.FALSE), Pair.of((Object)((Object)Direction.OUTPUT_ALTERNATE), (Object)Boolean.FALSE)});

    public String generatePackage(Package p) {
        return this.generatePackage(p, "");
    }

    public String createPin(String classStr, Pin pin, String color, String tooltipStr, String layerName) {
        PinConfig _get;
        String _xblockexpression = null;
        Utils util = Utils.instance;
        String _xifexpression = null;
        _xifexpression = tooltipStr != null ? tooltipStr : "";
        String tooltip = _xifexpression;
        PinConfig config = _get = (PinConfig)pin.getPinConfigurations().get(0);
        String direction = null;
        String directionName = null;
        if (config instanceof SystemFunctionPin) {
            String _plus;
            Direction dir = ((SystemFunctionPin)config).getDirection();
            direction = directionImages.get((Object)dir);
            String _get_1 = directionImageNames.get((Object)dir);
            directionName = _plus = " " + _get_1;
        } else if (config instanceof SpecialPin) {
            String _plus_1;
            Direction dir_1 = ((SpecialPin)config).getDirection();
            direction = directionImages.get((Object)dir_1);
            String _get_2 = directionImageNames.get((Object)dir_1);
            directionName = _plus_1 = " " + _get_2;
        }
        String rotate = "";
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        String id = pin.getName();
        Matcher matcher = pattern.matcher(id);
        String _xifexpression_1 = null;
        boolean _find = matcher.find();
        if (_find) {
            String _xblockexpression_1 = null;
            EObject _eContainer = pin.eContainer();
            LQFPPackage p = (LQFPPackage)_eContainer;
            int _size = p.getPins().size();
            int size = _size / 4;
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String anchor = "";
            int deltaX = 0;
            int labelOffset = 0;
            int imageOffsetX = 0;
            Objects.requireNonNull(this);
            int n = -3;
            Objects.requireNonNull(this);
            int imageOffsetY = n - 3;
            String objectClass = "";
            if (index <= size) {
                rotate = "";
                x = 0;
                y = index;
                int _x = x;
                Objects.requireNonNull(this);
                x = _x * (this.pinWidth + 3);
                int _y = y;
                Objects.requireNonNull(this);
                y = _y * (this.pinHeight + 3);
                anchor = "end";
                Objects.requireNonNull(this);
                deltaX = this.pinWidth - 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX - (this.pinWidth + 3) - this.pinHeight;
                imageOffsetX = deltaX - this.pinWidth - this.pinHeight;
                objectClass = "west";
            } else if (index <= size * 2 && index > size) {
                rotate = "rotate(-90)";
                x = index - size;
                y = size + 2;
                int _x_1 = x;
                Objects.requireNonNull(this);
                int _x_2 = x = _x_1 * (this.pinHeight + 3);
                x = _x_2 + this.pinHeight;
                int _y_1 = y;
                Objects.requireNonNull(this);
                int _y_2 = y = _y_1 * (this.pinHeight + 3);
                Objects.requireNonNull(this);
                y = _y_2 + (this.pinHeight - 3);
                anchor = "end";
                Objects.requireNonNull(this);
                deltaX = this.pinWidth - 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX - (this.pinWidth + this.pinHeight + 2 * 3);
                Objects.requireNonNull(this);
                imageOffsetX = deltaX - this.pinWidth + 3;
                int _imageOffsetY = imageOffsetY;
                Objects.requireNonNull(this);
                imageOffsetY = _imageOffsetY + 3;
                objectClass = "south";
            } else if (index <= size * 3 && index > size * 2) {
                rotate = "";
                x = size + 2;
                y = size * 3 - index + 1;
                int _x_3 = x;
                Objects.requireNonNull(this);
                x = _x_3 * (this.pinHeight + 3);
                int _y_3 = y;
                Objects.requireNonNull(this);
                y = _y_3 * (this.pinHeight + 3);
                anchor = "start";
                Objects.requireNonNull(this);
                deltaX = 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX + (3 * this.pinHeight + 3);
                Objects.requireNonNull(this);
                imageOffsetX = deltaX + this.pinWidth + 3 - 2;
                objectClass = "east";
            } else if (index > size * 3) {
                rotate = "rotate(-90)";
                x = size * 4 - index + 1;
                y = 1;
                int _x_4 = x;
                Objects.requireNonNull(this);
                int _x_5 = x = _x_4 * (this.pinHeight + 3);
                x = _x_5 + this.pinHeight;
                int _y_4 = y;
                Objects.requireNonNull(this);
                int _y_5 = y = _y_4 * (this.pinWidth + 3);
                Objects.requireNonNull(this);
                y = _y_5 - (this.pinHeight + 3);
                anchor = "start";
                Objects.requireNonNull(this);
                deltaX = 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX + (this.pinWidth + 3) + this.pinWidth;
                Objects.requireNonNull(this);
                imageOffsetX = deltaX - 3;
                int _imageOffsetY_1 = imageOffsetY;
                Objects.requireNonNull(this);
                imageOffsetY = _imageOffsetY_1 - (this.pinWidth + this.pinHeight + 3);
                objectClass = "north";
            }
            int _x_6 = x;
            Objects.requireNonNull(this);
            x = _x_6 + 200;
            int _y_6 = y;
            Objects.requireNonNull(this);
            y = _y_6 + 200;
            int width = this.pinWidth;
            int height = this.pinHeight;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("translate(");
            _builder.append((Object)x);
            _builder.append(", ");
            _builder.append((Object)y);
            _builder.append(") ");
            _builder.append(rotate);
            String transform = _builder.toString();
            String _xifexpression_2 = null;
            if (config instanceof ConfigurablePin) {
                String _xblockexpression_2 = null;
                String uniqueId = "";
                if (layerName == null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("PAD_");
                    String _name = ((ConfigurablePin)config).getRef().getName();
                    _builder_1.append(_name);
                    uniqueId = _builder_1.toString();
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(layerName);
                    _builder_2.append("_PAD_");
                    String _name_1 = ((ConfigurablePin)config).getRef().getName();
                    _builder_2.append(_name_1);
                    uniqueId = _builder_2.toString();
                }
                String _xifexpression_3 = null;
                boolean _equals = classStr.equals("pinNone");
                if (_equals) {
                    String pinRect;
                    String _xblockexpression_3 = null;
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("<g transform=\"");
                    _builder_3.append(transform);
                    _builder_3.append("\" class=\"nPin\">");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("<rect class=\"pin ");
                    _builder_3.append(classStr);
                    _builder_3.append("\" id=\"");
                    _builder_3.append(uniqueId);
                    _builder_3.append("\" ");
                    _builder_3.append(tooltip);
                    _builder_3.append(" width=\"");
                    _builder_3.append((Object)width);
                    _builder_3.append("\" height=\"");
                    _builder_3.append((Object)height);
                    _builder_3.append("\"/>");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("<text class=\"pinText_");
                    _builder_3.append(anchor);
                    _builder_3.append(" ");
                    _builder_3.append(classStr);
                    _builder_3.append("\" x=\"");
                    _builder_3.append((Object)deltaX);
                    _builder_3.append("\" y=\"");
                    int n2 = this.pinHeight / 2;
                    Objects.requireNonNull(this);
                    _builder_3.append((Object)(n2 + 3));
                    _builder_3.append("\" ");
                    _builder_3.append(tooltip);
                    _builder_3.append(">");
                    String _pinName = this.getPinName(pin);
                    _builder_3.append(_pinName);
                    _builder_3.append("</text>");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("</g>");
                    _builder_3.newLine();
                    _xifexpression_3 = _xblockexpression_3 = (pinRect = _builder_3.toString());
                } else {
                    String pinRect;
                    String _xblockexpression_4 = null;
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("<g transform=\"");
                    _builder_3.append(transform);
                    _builder_3.append("\">");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("<rect class=\"pin ");
                    _builder_3.append(classStr);
                    _builder_3.append("\" id=\"");
                    _builder_3.append(uniqueId);
                    _builder_3.append("\" ");
                    _builder_3.append(tooltip);
                    _builder_3.append(" width=\"");
                    _builder_3.append((Object)width);
                    _builder_3.append("\" height=\"");
                    _builder_3.append((Object)height);
                    _builder_3.append("\"/>");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("<text class=\"pinText_");
                    _builder_3.append(anchor);
                    _builder_3.append(" ");
                    _builder_3.append(classStr);
                    _builder_3.append("\" x=\"");
                    _builder_3.append((Object)deltaX);
                    _builder_3.append("\" y=\"");
                    int n3 = this.pinHeight / 2;
                    Objects.requireNonNull(this);
                    _builder_3.append((Object)(n3 + 3));
                    _builder_3.append("\" ");
                    _builder_3.append(tooltip);
                    _builder_3.append(">");
                    String _pinName = this.getPinName(pin);
                    _builder_3.append(_pinName);
                    _builder_3.append("</text>");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("</g>");
                    _builder_3.newLine();
                    _xifexpression_3 = _xblockexpression_4 = (pinRect = _builder_3.toString());
                }
                _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
            } else {
                String pinRect;
                String _xblockexpression_3 = null;
                String _xifexpression_3 = null;
                if (direction != null) {
                    Object _xifexpression_4 = null;
                    _xifexpression_4 = directionName != null ? directionName : "";
                    String _plus_2 = objectClass + (String)_xifexpression_4;
                    String _replace = direction.replace("__class__", _plus_2);
                    String _name = pin.getName();
                    String _plus_3 = "image_" + _name;
                    _xifexpression_3 = _replace.replace("__id__", _plus_3);
                }
                String directionImage = _xifexpression_3;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("translate(");
                _builder_1.append((Object)(x + imageOffsetX));
                _builder_1.append(", ");
                _builder_1.append((Object)(y + imageOffsetY + this.pinHeight / 2));
                _builder_1.append(")");
                String transformDirection = _builder_1.toString();
                String fullName = util.getFullPadName(pin);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("<g transform=\"");
                _builder_2.append(transformDirection);
                _builder_2.append("\">");
                _builder_2.append(directionImage);
                _builder_2.append("</g>");
                String dir_2 = _builder_2.toString();
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("<g transform=\"");
                _builder_3.append(transform);
                _builder_3.append("\" class=\"nonConfigurablePin ");
                _builder_3.append(classStr);
                _builder_3.append("\">");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t\t");
                _builder_3.append("<rect id=\"");
                String _pinName = this.getPinName(pin);
                _builder_3.append(_pinName, "\t\t\t\t");
                _builder_3.append("\" width=\"");
                _builder_3.append((Object)width, "\t\t\t\t");
                _builder_3.append("\" height=\"");
                _builder_3.append((Object)height, "\t\t\t\t");
                _builder_3.append("\" stroke=\"black\" ");
                _builder_3.append(tooltip, "\t\t\t\t");
                _builder_3.append("></rect>");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t\t");
                _builder_3.append("<text class=\"pinText_");
                _builder_3.append(anchor, "\t\t\t\t");
                _builder_3.append("\" x=\"");
                _builder_3.append((Object)deltaX, "\t\t\t\t");
                _builder_3.append("\" y=\"");
                int n4 = this.pinHeight / 2;
                Objects.requireNonNull(this);
                _builder_3.append((Object)(n4 + 3), "\t\t\t\t");
                _builder_3.append("\" ");
                _builder_3.append(tooltip, "\t\t\t\t");
                _builder_3.append(">");
                String _pinName_1 = this.getPinName(pin);
                _builder_3.append(_pinName_1, "\t\t\t\t");
                _builder_3.append("</text>");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t\t");
                _builder_3.append("<text class=\"pinText_");
                _builder_3.append(anchor, "\t\t\t\t");
                _builder_3.append("\" x=\"");
                _builder_3.append((Object)labelOffset, "\t\t\t\t");
                _builder_3.append("\" y=\"");
                int n5 = this.pinHeight / 2;
                Objects.requireNonNull(this);
                _builder_3.append((Object)(n5 + 3), "\t\t\t\t");
                _builder_3.append("\" ");
                _builder_3.append(tooltip, "\t\t\t\t");
                _builder_3.append(">");
                _builder_3.append(fullName, "\t\t\t\t");
                _builder_3.append("</text></g>");
                _builder_3.append(dir_2, "\t\t\t\t");
                _xifexpression_2 = _xblockexpression_3 = (pinRect = _builder_3.toString());
            }
            _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public String createConfiguredPin(Pin pin, String color, String tooltipStr, String tooltipStr2, String label, Direction dir, boolean isBoardPin, Map<EObject, Map<Integer, List<String>>> errorsMap) {
        String id;
        PinConfig _get;
        Utils util = Utils.instance;
        String _xifexpression = null;
        _xifexpression = tooltipStr != null ? tooltipStr : "";
        String tooltip = _xifexpression;
        PinConfig config = _get = (PinConfig)pin.getPinConfigurations().get(0);
        String direction = directionImages.get((Object)dir);
        Boolean imageRotate = rotateImages.get((Object)dir);
        String rotate = "";
        String rotateImage = "";
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        Matcher matcher = pattern.matcher(id = pin.getName());
        boolean _find = matcher.find();
        if (_find) {
            EObject _eContainer = pin.eContainer();
            LQFPPackage p = (LQFPPackage)_eContainer;
            int _size = p.getPins().size();
            int size = _size / 4;
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String anchor = "";
            int deltaX = 0;
            int labelOffset = 0;
            int imageOffsetX = 0;
            Objects.requireNonNull(this);
            int n = -3;
            Objects.requireNonNull(this);
            int imageOffsetY = n - 3;
            String objectClass = "";
            if (index <= size) {
                rotate = "";
                x = 0;
                y = index;
                int _x = x;
                Objects.requireNonNull(this);
                x = _x * (this.pinWidth + 3);
                int _y = y;
                Objects.requireNonNull(this);
                y = _y * (this.pinHeight + 3);
                anchor = "end";
                Objects.requireNonNull(this);
                deltaX = this.pinWidth - 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX - (this.pinWidth + 3) - this.pinHeight;
                imageOffsetX = deltaX - this.pinWidth - this.pinHeight;
                objectClass = "west";
            } else if (index <= size * 2 && index > size) {
                rotate = "rotate(-90)";
                rotateImage = "rotate(-90)";
                x = index - size;
                y = size + 2;
                int _x_1 = x;
                Objects.requireNonNull(this);
                int _x_2 = x = _x_1 * (this.pinHeight + 3);
                x = _x_2 + this.pinHeight;
                int _y_1 = y;
                Objects.requireNonNull(this);
                int _y_2 = y = _y_1 * (this.pinHeight + 3);
                Objects.requireNonNull(this);
                y = _y_2 + (this.pinHeight - 3);
                anchor = "end";
                Objects.requireNonNull(this);
                deltaX = this.pinWidth - 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX - (this.pinWidth + this.pinHeight + 2 * 3);
                Objects.requireNonNull(this);
                imageOffsetX = deltaX - this.pinWidth + 3;
                int _imageOffsetY = imageOffsetY;
                Objects.requireNonNull(this);
                imageOffsetY = _imageOffsetY + (this.pinHeight + 3);
                objectClass = "south";
            } else if (index <= size * 3 && index > size * 2) {
                rotate = "";
                rotateImage = "rotate(180)";
                x = size + 2;
                y = size * 3 - index + 1;
                int _x_3 = x;
                Objects.requireNonNull(this);
                x = _x_3 * (this.pinHeight + 3);
                int _y_3 = y;
                Objects.requireNonNull(this);
                y = _y_3 * (this.pinHeight + 3);
                anchor = "start";
                Objects.requireNonNull(this);
                deltaX = 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX + (3 * this.pinHeight + 3);
                Objects.requireNonNull(this);
                imageOffsetX = deltaX + this.pinWidth + 3 + this.pinHeight - 2;
                int _imageOffsetY_1 = imageOffsetY;
                imageOffsetY = _imageOffsetY_1 + this.pinHeight;
                objectClass = "east";
            } else if (index > size * 3) {
                rotate = "rotate(-90)";
                rotateImage = "rotate(90)";
                x = size * 4 - index + 1;
                y = 1;
                int _x_4 = x;
                Objects.requireNonNull(this);
                int _x_5 = x = _x_4 * (this.pinHeight + 3);
                x = _x_5 + this.pinHeight;
                int _y_4 = y;
                Objects.requireNonNull(this);
                int _y_5 = y = _y_4 * (this.pinWidth + 3);
                Objects.requireNonNull(this);
                y = _y_5 - (this.pinHeight + 3);
                anchor = "start";
                Objects.requireNonNull(this);
                deltaX = 3;
                Objects.requireNonNull(this);
                labelOffset = deltaX + (this.pinWidth + 3) + this.pinWidth;
                Objects.requireNonNull(this);
                imageOffsetX = deltaX + 3 * 3;
                int _imageOffsetY_2 = imageOffsetY;
                Objects.requireNonNull(this);
                imageOffsetY = _imageOffsetY_2 - (this.pinWidth + this.pinHeight + 2 * 3);
                objectClass = "north";
            }
            int _x_6 = x;
            Objects.requireNonNull(this);
            x = _x_6 + 200;
            int _y_6 = y;
            Objects.requireNonNull(this);
            y = _y_6 + 200;
            int width = this.pinWidth;
            int height = this.pinHeight;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("translate(");
            _builder.append((Object)x);
            _builder.append(", ");
            _builder.append((Object)y);
            _builder.append(") ");
            _builder.append(rotate);
            String transform = _builder.toString();
            String directionName = directionImageNames.get((Object)dir);
            String _xifexpression_1 = null;
            if (direction != null) {
                Object _xifexpression_2 = null;
                _xifexpression_2 = directionName != null ? " " + directionName : "";
                String _plus = objectClass + (String)_xifexpression_2;
                String _replace = direction.replace("__class__", _plus);
                String _name = pin.getName();
                String _plus_1 = "image_" + _name;
                _xifexpression_1 = _replace.replace("__id__", _plus_1);
            }
            String directionImage = _xifexpression_1;
            String _xifexpression_3 = null;
            if (imageRotate.booleanValue()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("translate(");
                _builder_1.append((Object)(x + imageOffsetX));
                _builder_1.append(", ");
                _builder_1.append((Object)(y + imageOffsetY + this.pinHeight / 2));
                _builder_1.append(") ");
                _builder_1.append(rotateImage);
                _xifexpression_3 = _builder_1.toString();
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("translate(");
                _builder_2.append((Object)(x + imageOffsetX));
                _builder_2.append(", ");
                _builder_2.append((Object)(y + imageOffsetY + this.pinHeight / 2));
                _builder_2.append(")");
                _xifexpression_3 = _builder_2.toString();
            }
            String transformDirection = _xifexpression_3;
            if (config instanceof ConfigurablePin) {
                String _xifexpression_4 = null;
                if (label != null) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("<text class=\"pinText_");
                    _builder_3.append(anchor);
                    _builder_3.append("\" x=\"");
                    _builder_3.append((Object)labelOffset);
                    _builder_3.append("\" y=\"");
                    int n2 = this.pinHeight / 2;
                    Objects.requireNonNull(this);
                    _builder_3.append((Object)(n2 + 3));
                    _builder_3.append("\" ");
                    _builder_3.append(tooltip);
                    _builder_3.append(">");
                    _builder_3.append(label);
                    _builder_3.append("</text>");
                    _xifexpression_4 = _builder_3.toString();
                } else {
                    _xifexpression_4 = "";
                }
                String labelText = _xifexpression_4;
                String _name_1 = ((ConfigurablePin)config).getRef().getName();
                String pinId = "configured_" + _name_1;
                ArrayList cssClass = CollectionLiterals.newArrayList();
                if (isBoardPin) {
                    cssClass.add("board");
                } else {
                    cssClass.add("cPin");
                }
                Map<Integer, List<String>> msgMap = errorsMap.get(pin);
                if (msgMap != null) {
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    List<String> errors = errorsMap.get(pin).get(4);
                    List<String> warnings = errorsMap.get(pin).get(2);
                    int _size_1 = errors.size();
                    boolean bl = _greaterThan = _size_1 > 0;
                    if (_greaterThan) {
                        cssClass.add("error");
                        String errorMessage = IterableExtensions.join(errors, (CharSequence)",").replace("'", "");
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append(" ");
                        _builder_4.append("onmouseenter=\"sttConfigured(evt,'");
                        _builder_4.append(errorMessage, " ");
                        _builder_4.append("');\"");
                        String tooltips = _builder_4.toString();
                        String _xifexpression_5 = null;
                        if (label != null) {
                            StringConcatenation _builder_5 = new StringConcatenation();
                            _builder_5.append("<text class=\"pinText_");
                            _builder_5.append(anchor);
                            _builder_5.append("\" x=\"");
                            _builder_5.append((Object)labelOffset);
                            _builder_5.append("\" y=\"");
                            int n3 = this.pinHeight / 2;
                            Objects.requireNonNull(this);
                            _builder_5.append((Object)(n3 + 3));
                            _builder_5.append("\" ");
                            _builder_5.append(tooltips);
                            _builder_5.append(">");
                            _builder_5.append(label);
                            _builder_5.append("</text>");
                            _xifexpression_5 = _builder_5.toString();
                        } else {
                            _xifexpression_5 = "";
                        }
                        labelText = _xifexpression_5;
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append("<g transform=\"");
                        _builder_6.append(transform);
                        _builder_6.append("\" class=\"");
                        String _join = IterableExtensions.join((Iterable)cssClass, (CharSequence)" ");
                        _builder_6.append(_join);
                        _builder_6.append("\">");
                        _builder_6.newLineIfNotEmpty();
                        _builder_6.append("\t");
                        _builder_6.append("<rect class=\"error pin\" id=\"");
                        _builder_6.append(pinId, "\t");
                        _builder_6.append("\" x=\"0\" y=\"0\" width=\"");
                        _builder_6.append((Object)width, "\t");
                        _builder_6.append("\" height=\"");
                        _builder_6.append((Object)height, "\t");
                        _builder_6.append("\" ");
                        _builder_6.append(tooltips, "\t");
                        _builder_6.append("></rect>");
                        _builder_6.newLineIfNotEmpty();
                        _builder_6.append("\t");
                        _builder_6.append("<text class=\"error pinText_");
                        _builder_6.append(anchor, "\t");
                        _builder_6.append("\" x=\"");
                        _builder_6.append((Object)deltaX, "\t");
                        _builder_6.append("\" y=\"");
                        int n4 = this.pinHeight / 2;
                        Objects.requireNonNull(this);
                        _builder_6.append((Object)(n4 + 3), "\t");
                        _builder_6.append("\" ");
                        _builder_6.append(tooltips, "\t");
                        _builder_6.append(">");
                        String _pinName = this.getPinName(pin);
                        _builder_6.append(_pinName, "\t");
                        _builder_6.append("</text>");
                        _builder_6.newLineIfNotEmpty();
                        _builder_6.append("\t");
                        _builder_6.append(labelText, "\t");
                        _builder_6.newLineIfNotEmpty();
                        _builder_6.append("</g>");
                        _builder_6.newLine();
                        _builder_6.append("<g transform=\"");
                        _builder_6.append(transformDirection);
                        _builder_6.append("\">");
                        _builder_6.append(directionImage);
                        _builder_6.append("</g>");
                        String pinRect = _builder_6.toString();
                        return pinRect;
                    }
                    int _size_2 = warnings.size();
                    boolean bl2 = _greaterThan_1 = _size_2 > 0;
                    if (_greaterThan_1) {
                        cssClass.add("warning");
                        String warningMessage = IterableExtensions.join(warnings, (CharSequence)",").replace("'", "");
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append(" ");
                        _builder_7.append("onmouseenter=\"sttConfigured(evt,'");
                        _builder_7.append(warningMessage, " ");
                        _builder_7.append("');\"");
                        String tooltips_1 = _builder_7.toString();
                        String _xifexpression_6 = null;
                        if (label != null) {
                            StringConcatenation _builder_8 = new StringConcatenation();
                            _builder_8.append("<text class=\"pinText_");
                            _builder_8.append(anchor);
                            _builder_8.append("\" x=\"");
                            _builder_8.append((Object)labelOffset);
                            _builder_8.append("\" y=\"");
                            int n5 = this.pinHeight / 2;
                            Objects.requireNonNull(this);
                            _builder_8.append((Object)(n5 + 3));
                            _builder_8.append("\" ");
                            _builder_8.append(tooltips_1);
                            _builder_8.append(">");
                            _builder_8.append(label);
                            _builder_8.append("</text>");
                            _xifexpression_6 = _builder_8.toString();
                        } else {
                            _xifexpression_6 = "";
                        }
                        labelText = _xifexpression_6;
                        StringConcatenation _builder_9 = new StringConcatenation();
                        _builder_9.append("<g transform=\"");
                        _builder_9.append(transform);
                        _builder_9.append("\" class=\"");
                        String _join_1 = IterableExtensions.join((Iterable)cssClass, (CharSequence)" ");
                        _builder_9.append(_join_1);
                        _builder_9.append("\">");
                        _builder_9.newLineIfNotEmpty();
                        _builder_9.append("\t");
                        _builder_9.append("<rect class=\"warning pin\" id=\"");
                        _builder_9.append(pinId, "\t");
                        _builder_9.append("\" x=\"0\" y=\"0\" width=\"");
                        _builder_9.append((Object)width, "\t");
                        _builder_9.append("\" height=\"");
                        _builder_9.append((Object)height, "\t");
                        _builder_9.append("\" ");
                        _builder_9.append(tooltips_1, "\t");
                        _builder_9.append("></rect>");
                        _builder_9.newLineIfNotEmpty();
                        _builder_9.append("\t");
                        _builder_9.append("<text class=\"warning pinText_");
                        _builder_9.append(anchor, "\t");
                        _builder_9.append("\" x=\"");
                        _builder_9.append((Object)deltaX, "\t");
                        _builder_9.append("\" y=\"");
                        int n6 = this.pinHeight / 2;
                        Objects.requireNonNull(this);
                        _builder_9.append((Object)(n6 + 3), "\t");
                        _builder_9.append("\" ");
                        _builder_9.append(tooltips_1, "\t");
                        _builder_9.append(">");
                        String _pinName_1 = this.getPinName(pin);
                        _builder_9.append(_pinName_1, "\t");
                        _builder_9.append("</text>");
                        _builder_9.newLineIfNotEmpty();
                        _builder_9.append("\t");
                        _builder_9.append(labelText, "\t");
                        _builder_9.newLineIfNotEmpty();
                        _builder_9.append("</g>");
                        _builder_9.newLine();
                        _builder_9.append("<g transform=\"");
                        _builder_9.append(transformDirection);
                        _builder_9.append("\">");
                        _builder_9.append(directionImage);
                        _builder_9.append("</g>");
                        String pinRect_1 = _builder_9.toString();
                        return pinRect_1;
                    }
                    StringConcatenation _builder_10 = new StringConcatenation();
                    _builder_10.append("<g transform=\"");
                    _builder_10.append(transform);
                    _builder_10.append("\" class=\"");
                    String _join_2 = IterableExtensions.join((Iterable)cssClass, (CharSequence)" ");
                    _builder_10.append(_join_2);
                    _builder_10.append("\">");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("\t");
                    _builder_10.append("<rect class=\"pin\" id=\"");
                    _builder_10.append(pinId, "\t");
                    _builder_10.append("\" x=\"0\" y=\"0\" width=\"");
                    _builder_10.append((Object)width, "\t");
                    _builder_10.append("\" height=\"");
                    _builder_10.append((Object)height, "\t");
                    _builder_10.append("\" ");
                    _builder_10.append(tooltip, "\t");
                    _builder_10.append("></rect>");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("\t");
                    _builder_10.append("<text class=\"pinText_");
                    _builder_10.append(anchor, "\t");
                    _builder_10.append("\" x=\"");
                    _builder_10.append((Object)deltaX, "\t");
                    _builder_10.append("\" y=\"");
                    int n7 = this.pinHeight / 2;
                    Objects.requireNonNull(this);
                    _builder_10.append((Object)(n7 + 3), "\t");
                    _builder_10.append("\" ");
                    _builder_10.append(tooltip, "\t");
                    _builder_10.append(">");
                    String _pinName_2 = this.getPinName(pin);
                    _builder_10.append(_pinName_2, "\t");
                    _builder_10.append("</text>");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("\t");
                    _builder_10.append(labelText, "\t");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("</g>");
                    _builder_10.newLine();
                    _builder_10.append("<g transform=\"");
                    _builder_10.append(transformDirection);
                    _builder_10.append("\">");
                    _builder_10.append(directionImage);
                    _builder_10.append("</g>");
                    String pinRect_2 = _builder_10.toString();
                    return pinRect_2;
                }
                StringConcatenation _builder_11 = new StringConcatenation();
                _builder_11.append("<g transform=\"");
                _builder_11.append(transform);
                _builder_11.append("\" class=\"");
                String _join_3 = IterableExtensions.join((Iterable)cssClass, (CharSequence)" ");
                _builder_11.append(_join_3);
                _builder_11.append("\">");
                _builder_11.newLineIfNotEmpty();
                _builder_11.append("\t");
                _builder_11.append("<rect class=\"pin\" id=\"");
                _builder_11.append(pinId, "\t");
                _builder_11.append("\" x=\"0\" y=\"0\" width=\"");
                _builder_11.append((Object)width, "\t");
                _builder_11.append("\" height=\"");
                _builder_11.append((Object)height, "\t");
                _builder_11.append("\" ");
                _builder_11.append(tooltip, "\t");
                _builder_11.append("></rect>");
                _builder_11.newLineIfNotEmpty();
                _builder_11.append("\t");
                _builder_11.append("<text class=\"pinText_");
                _builder_11.append(anchor, "\t");
                _builder_11.append("\" x=\"");
                _builder_11.append((Object)deltaX, "\t");
                _builder_11.append("\" y=\"");
                int n8 = this.pinHeight / 2;
                Objects.requireNonNull(this);
                _builder_11.append((Object)(n8 + 3), "\t");
                _builder_11.append("\" ");
                _builder_11.append(tooltip, "\t");
                _builder_11.append(">");
                String _pinName_3 = this.getPinName(pin);
                _builder_11.append(_pinName_3, "\t");
                _builder_11.append("</text>");
                _builder_11.newLineIfNotEmpty();
                _builder_11.append("\t");
                _builder_11.append(labelText, "\t");
                _builder_11.newLineIfNotEmpty();
                _builder_11.append("</g>");
                _builder_11.newLine();
                _builder_11.append("<g transform=\"");
                _builder_11.append(transformDirection);
                _builder_11.append("\">");
                _builder_11.append(directionImage);
                _builder_11.append("</g>");
                String pinRect_3 = _builder_11.toString();
                return pinRect_3;
            }
        }
        return null;
    }

    public String getTooltip(Pin pin) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("onmouseenter=\"stt(evt, '");
        String _name = pin.getName();
        _builder.append(_name, " ");
        _builder.append("');\"");
        return _builder.toString();
    }

    public String generatePackage(Package p, String additional) {
        String header;
        StringConcatenation _builder_1;
        int nbColumns;
        String _xblockexpression = null;
        if (!(p instanceof LQFPPackage)) {
            return additional;
        }
        Object pins = "";
        HashMap<String, ArrayList<Pin>> peripheralLayers = new HashMap<String, ArrayList<Pin>>();
        Object layers = "";
        EList<Pin> _pins = p.getPins();
        for (Pin pin : _pins) {
            PinConfig _get = (PinConfig)pin.getPinConfigurations().get(0);
            PinConfig config = _get;
            if (config instanceof NotConnectedPin) continue;
            Pair<String, List<String>> res = this.generatePin(pin);
            String _pins_1 = pins;
            String _key = (String)res.getKey();
            pins = _pins_1 + _key;
            List peripherals = (List)res.getValue();
            for (String periph : peripherals) {
                List<Pin> layer = (List)peripheralLayers.get(periph);
                if (layer == null) {
                    ArrayList<Pin> _arrayList;
                    layer = _arrayList = new ArrayList<Pin>();
                    peripheralLayers.put(periph, (ArrayList<Pin>)layer);
                }
                layer.add(pin);
            }
        }
        boolean deltaY = false;
        int _size = p.getPins().size();
        int nbRows = nbColumns = _size / 4;
        int pinSize = Math.min(this.pinWidth, this.pinHeight);
        Objects.requireNonNull(this);
        int width = (pinSize + 3) * nbColumns;
        Objects.requireNonNull(this);
        int height = (pinSize + 3) * nbRows;
        String bgColor = "#3498DB";
        String color = "black";
        Set _keySet = peripheralLayers.keySet();
        for (String layer : _keySet) {
            StringConcatenation _builder = new StringConcatenation();
            Object layerPins = _builder.toString();
            List _get = (List)peripheralLayers.get(layer);
            for (Pin layerPin : _get) {
                String tooltip = this.getTooltip(layerPin);
                String generatedPin = this.createPin("layerPin", layerPin, bgColor, tooltip, layer);
                String _layerPins = layerPins;
                layerPins = _layerPins + generatedPin;
            }
            String _layers = layers;
            _builder_1 = new StringConcatenation();
            _builder_1.append("<g transform=\"translate(");
            Objects.requireNonNull(this);
            _builder_1.append((Object)(this.pinWidth + 3));
            _builder_1.append(",");
            Objects.requireNonNull(this);
            _builder_1.append((Object)(this.pinHeight + 3));
            _builder_1.append(")\"");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("inkscape:groupmode=\"layer\"");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("id=\"animation_layer_");
            _builder_1.append(layer, "\t");
            _builder_1.append("\"");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("inkscape:label=\"animation_layer_");
            _builder_1.append(layer, "\t");
            _builder_1.append("\"");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("style=\"display:none\">");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("<g transform=\"translate(0, ");
            Objects.requireNonNull(this);
            _builder_1.append((Object)(0 * (this.pinHeight + 3)), "\t");
            _builder_1.append(")\" >");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append((String)layerPins, "\t\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("</g>");
            _builder_1.newLine();
            _builder_1.append("</g>");
            _builder_1.newLine();
            layers = _layers + String.valueOf(_builder_1);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<g transform=\"translate(");
        Objects.requireNonNull(this);
        _builder.append((Object)(this.pinWidth + 3));
        _builder.append(",");
        Objects.requireNonNull(this);
        _builder.append((Object)(this.pinHeight + 3));
        _builder.append(")\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("inkscape:groupmode=\"layer\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=\"main_layer\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inkscape:label=\"Animation layer for ");
        String _name = p.getName();
        _builder.append(_name, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("style=\"display:inline\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<rect style=\"display:inline;opacity:0.33;fill:url(#linearGradient_1);fill-opacity:1;fill-rule:nonzero;stroke:#000000;stroke-width:0.70145893;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:40.5;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"rect_");
        String _name_1 = p.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("width=\"");
        _builder.append((Object)width, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("height=\"");
        _builder.append((Object)height, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("x=\"");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 20 + 3 * 2), "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("y=\"");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 20 - 3 * 2), "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<rect style=\"display:inline;opacity:0.33;fill:url(#linearGradient_1);fill-opacity:1;fill-rule:nonzero;stroke:#000000;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stroke-width:1;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:40.5;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"rect_");
        String _name_2 = p.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("width=\"");
        _builder.append((Object)(width - 20), "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("height=\"");
        _builder.append((Object)(height - 20), "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("x=\"");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 30 + 3 * 2), "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("y=\"");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 30 - 3 * 2), "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<g transform=\"translate(");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 65), "\t");
        _builder.append(",");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 50), "\t");
        _builder.append(")\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<path class=\"st0\" d=\"M39.69,82.37C17.77,82.37,0,64.6,0,42.69C0,20.77,17.77,3,39.69,3s39.69,17.77,39.69,39.69 C79.37,64.6,61.6,82.37,39.69,82.37\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M21.16,66.11v0.36c0,1.14,0.32,1.87,1.62,1.87c0.75,0,1.46-0.48,1.46-1.5c0-1.11-0.56-1.51-2.18-2.07");
        _builder.newLine();
        _builder.append("c-2.18-0.75-3.18-1.65-3.18-3.67c0-2.36,1.45-3.57,3.76-3.57c2.18,0,3.76,0.93,3.76,3.26v0.34h-2.35c0-1.14-0.39-1.8-1.33-1.8");
        _builder.newLine();
        _builder.append("c-1.11,0-1.39,0.7-1.39,1.41c0,0.75,0.22,1.21,1.26,1.65l1.89,0.82c1.84,0.8,2.31,1.73,2.31,3.21c0,2.57-1.56,3.72-4.22,3.72");
        _builder.newLine();
        _builder.append("c-2.77,0-3.86-1.29-3.86-3.54v-0.49H21.16z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M28.45,58.14h2.35v2.62h1.36v1.6H30.8v4.95c0,0.71,0.15,1,0.83,1c0.19,0,0.37-0.02,0.53-0.03v1.63");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c-0.51,0.05-0.99,0.1-1.53,0.1c-1.84,0-2.18-0.56-2.18-2.41v-5.24h-1.19v-1.6h1.19V58.14z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M34.98,65.68v0.73c0,1.07,0.29,2.13,1.16,2.13c0.78,0,1.11-0.59,1.24-1.72h2.11");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c-0.08,2.13-1.1,3.31-3.31,3.31c-3.4,0-3.54-2.62-3.54-4.9c0-2.45,0.48-4.72,3.64-4.72c2.74,0,3.35,1.83,3.35,4.64v0.53H34.98z");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("M37.37,64.29c-0.05-1.39-0.22-2.18-1.19-2.18c-0.93,0-1.21,0.97-1.21,1.82v0.36H37.37z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M40.93,57.76h2.35V69.9h-2.35V57.76z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M45.01,57.76h2.35V69.9h-2.35V57.76z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M48.99,63.56v-0.22c0-2.11,1.45-2.82,3.21-2.82c2.79,0,3.31,1.16,3.31,2.8v4.81c0,0.85,0.05,1.24,0.29,1.77");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("h-2.24c-0.15-0.29-0.22-0.65-0.29-0.95h-0.03c-0.54,0.95-1.21,1.19-2.33,1.19c-1.63,0-2.21-1.39-2.21-2.62");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c0-1.72,0.7-2.41,2.31-2.86l1.33-0.36c0.7-0.19,0.94-0.46,0.94-1.07c0-0.7-0.31-1.12-1.09-1.12c-0.71,0-1.09,0.48-1.09,1.19v0.25");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("H48.99z M53.27,65.32c-0.32,0.24-0.71,0.39-1,0.46c-0.95,0.2-1.33,0.66-1.33,1.48c0,0.7,0.25,1.27,0.88,1.27s1.45-0.41,1.45-1.41");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("V65.32z\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M57.18,60.75h2.24v1.22h0.03c0.48-0.88,1.14-1.46,2.11-1.46c0.14,0,0.29,0.02,0.42,0.03v2.24");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c-0.24-0.02-0.49-0.03-0.73-0.03c-0.82,0-1.73,0.42-1.73,1.65v5.49h-2.35V60.75z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M39.97,18.17L30.67,0l-7.44,22.32L0.48,27.9l13.91,6.4c5.47-5.66,22.42-17.01,47.52-17.97l7.53-5.59");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("L39.97,18.17z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M17.25,39.05l-4.46,13.74l16.31-11.87l29.47,13.31L47.04,31.43C31.5,31.53,21.93,36.1,17.25,39.05z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M29.43,30.25l-0.71-1.65c-0.84,0.38-1.66,0.79-2.49,1.21c-0.82,0.43-1.62,0.87-2.42,1.33l0.66,1.27");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("c0.82-0.38,1.64-0.75,2.47-1.1C27.76,30.93,28.59,30.59,29.43,30.25z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M38.38,25.14c-1.78,0.47-3.54,1.03-5.28,1.66l0.65,1.82c1.7-0.59,3.41-1.14,5.13-1.63L38.38,25.14z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M48.65,24.76l-0.16-1.34c-0.92,0.08-1.83,0.17-2.75,0.28c-0.92,0.11-1.83,0.25-2.73,0.41l0.35,1.71");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c0.88-0.21,1.76-0.39,2.64-0.58C46.88,25.07,47.76,24.91,48.65,24.76z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M18.37,35.61c0.64-0.35,1.31-0.72,1.98-1.06l0.09-0.05l-0.59-0.97l-0.09,0.06c-0.76,0.54-1.5,1.08-2.21,1.65");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("c-0.63,0.51-1.38,1.12-2.08,1.82l-0.6,0.6l0.72-0.44c0.68-0.42,1.41-0.84,2.36-1.37L18.37,35.61z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<path class=\"st1\" d=\"M55.47,23.96c0.72-0.07,1.46-0.16,2.22-0.26l0.86-0.11l-0.86-0.08c-0.76-0.07-1.51-0.13-2.23-0.18");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c-0.67-0.05-1.4-0.09-2.24-0.13l-0.11-0.01l0.05,0.99l0.1-0.01C54.08,24.1,54.8,24.03,55.47,23.96z\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<g transform=\"translate(");
        _builder.append((Object)0, "\t");
        _builder.append(", ");
        Objects.requireNonNull(this);
        _builder.append((Object)(0 * (this.pinHeight + 3)), "\t");
        _builder.append(")\" >");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((String)pins, "  ");
        _builder.append(additional, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<circle transform=\"translate(");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 50 + 3 * 2), "\t");
        _builder.append(",");
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + 40 + 3 * 2), "\t");
        _builder.append(")\" fill=\"none\" stroke=\"");
        _builder.append(color, "\t");
        _builder.append("\" stroke-width=\"1px\" r=\"");
        _builder.append((Object)10, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<text x=\"");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + width / 2), "\t");
        _builder.append("\" y=\"");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + height / 2), "\t");
        _builder.append("\" font-family=\"Verdana\" font-size=\"14\" stroke=\"");
        _builder.append(color, "\t");
        _builder.append("\">SR5E1</text>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<text x=\"");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + width / 2), "\t");
        _builder.append("\" y=\"");
        Objects.requireNonNull(this);
        _builder.append((Object)(200 + height / 2 + this.pinHeight + 2), "\t");
        _builder.append("\"  font-family=\"Verdana\" font-size=\"14\" stroke=\"");
        _builder.append(color, "\t");
        _builder.append("\">Package ");
        String _name_3 = p.getName();
        _builder.append(_name_3, "\t");
        _builder.append("</text>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</g>");
        _builder.newLine();
        _builder.append("</g>");
        String animationLayer = _builder.toString();
        _builder_1 = new StringConcatenation();
        _builder_1.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder_1.newLine();
        _builder_1.append("<!-- Created with Inkscape (http://www.inkscape.org/) -->");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("<svg");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:cc=\"http://creativecommons.org/ns#\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:svg=\"http://www.w3.org/2000/svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns=\"http://www.w3.org/2000/svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("id=\"svg-doc\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("version=\"1.1\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("inkscape:version=\"0.92.2 (5c3e80d, 2017-08-06)\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("width=\"");
        _builder_1.append((Object)(400 + width), "\t");
        _builder_1.append("\"");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("height=\"");
        _builder_1.append((Object)(400 + height), "\t");
        _builder_1.append("\"");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("xml:space=\"preserve\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("sodipodi:docname=\"pinmap.svg\"");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("viewBox=\"0 0 1300 1300\">");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<metadata id=\"metadata4497\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<rdf:RDF>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<cc:Work rdf:about=\"\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t\t");
        _builder_1.append("<dc:format>image/svg+xml</dc:format>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t\t");
        _builder_1.append("<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t\t");
        _builder_1.append("<dc:title></dc:title>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("</cc:Work>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</rdf:RDF>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</metadata>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<defs id=\"defs4495\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<linearGradient id=\"linearGradient_1\" x1=\"0\" y1=\"0\" x2=\"100%\" y2=\"100%\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<stop offset=\"0%\" stop-color=\"#CCCCCC\" />");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<stop offset=\"100%\" stop-color=\"#111111\" />");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</linearGradient>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</defs>");
        _builder_1.newLine();
        _builder_1.append(animationLayer);
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((String)layers);
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("</svg>");
        _xblockexpression = header = _builder_1.toString();
        return _xblockexpression;
    }

    public Pair<String, List<String>> generatePin(Pin pin) {
        ArrayList<String> peripherals = new ArrayList<String>();
        EList<PinConfig> _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            if (cfg instanceof SystemFunctionPin) {
                boolean _contains_3;
                boolean _not_3;
                boolean _contains_2;
                boolean _not_2;
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                Peripheral _peripheralRef = sfp.getRef().getPeripheralRef();
                boolean _tripleNotEquals = _peripheralRef != null;
                if (!_tripleNotEquals) continue;
                boolean _contains = peripherals.contains(sfp.getRef().getPeripheralRef().getLabel());
                boolean bl = _not = !_contains;
                if (_not) {
                    String _label = sfp.getRef().getPeripheralRef().getLabel();
                    peripherals.add(_label);
                }
                boolean bl2 = _not_1 = !(_contains_1 = peripherals.contains(sfp.getRef().getLabel()));
                if (_not_1) {
                    String _label_1 = sfp.getRef().getPeripheralRef().getLabel();
                    peripherals.add(_label_1);
                }
                boolean bl3 = _not_2 = !(_contains_2 = peripherals.contains(sfp.getRef().getPeripheralRef().getName()));
                if (_not_2) {
                    String _name = sfp.getRef().getPeripheralRef().getName();
                    peripherals.add(_name);
                }
                if (!(_not_3 = !(_contains_3 = peripherals.contains(sfp.getRef().getName())))) continue;
                String _name_1 = sfp.getRef().getName();
                peripherals.add(_name_1);
                continue;
            }
            if (!(cfg instanceof ConfigurablePin)) continue;
            ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
            EList<FunctionRef> functions = sfp_1.getRef().getFunctions();
            for (FunctionRef fct : functions) {
                boolean _contains_6;
                boolean _not_6;
                boolean _contains_5;
                boolean _not_5;
                boolean _not_4;
                boolean _contains_4 = peripherals.contains(fct.getName().getPeripheralRef().getLabel());
                boolean bl = _not_4 = !_contains_4;
                if (_not_4) {
                    String _label_2 = fct.getName().getPeripheralRef().getLabel();
                    peripherals.add(_label_2);
                }
                boolean bl4 = _not_5 = !(_contains_5 = peripherals.contains(fct.getName().getLabel()));
                if (_not_5) {
                    String _label_3 = fct.getName().getLabel();
                    peripherals.add(_label_3);
                }
                if (!(_not_6 = !(_contains_6 = peripherals.contains(fct.getName().getPeripheralRef().getName())))) continue;
                String _name_2 = fct.getName().getPeripheralRef().getName();
                peripherals.add(_name_2);
            }
        }
        String tooltipElt = this.getTooltip(pin);
        String generatedPin = this.createPin("pinNone", pin, "none", tooltipElt, null);
        return new Pair((Object)generatedPin, peripherals);
    }

    public String getPinName(Pin pin) {
        String id;
        Pattern pattern = Pattern.compile("^(.*)_([0-9]+)$");
        Matcher matcher = pattern.matcher(id = pin.getName());
        boolean _find = matcher.find();
        if (_find) {
            String number = matcher.group(2);
            return number;
        }
        return "";
    }

    public static enum PinStatus {
        Configured,
        NotUsed,
        NotConnected,
        NotConfigurable;

    }

    public static enum PinStyle {
        VerticalUp,
        HorizontalLeft,
        VerticalDown,
        HorizontalRight,
        Square,
        Empty;

    }
}

