/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pinmapDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Direction implements Enumerator
{
    INPUT(0, "Input", "I"),
    OUTPUT(1, "Output", "O"),
    INPUT_OUTPUT(2, "InputOutput", "IO"),
    INPUT_OR_OUTPUT(3, "InputOrOutput", "I/O"),
    INPUT_ALTERNATE(4, "InputAlternate", "I_A"),
    OUTPUT_ALTERNATE(5, "OutputAlternate", "O_A"),
    POWER(6, "Power", "POWER"),
    GROUND(7, "Ground", "GROUND"),
    NA(8, "NA", "NA");

    public static final int INPUT_VALUE = 0;
    public static final int OUTPUT_VALUE = 1;
    public static final int INPUT_OUTPUT_VALUE = 2;
    public static final int INPUT_OR_OUTPUT_VALUE = 3;
    public static final int INPUT_ALTERNATE_VALUE = 4;
    public static final int OUTPUT_ALTERNATE_VALUE = 5;
    public static final int POWER_VALUE = 6;
    public static final int GROUND_VALUE = 7;
    public static final int NA_VALUE = 8;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Direction get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Direction result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Direction getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Direction result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return INPUT;
            }
            case 1: {
                return OUTPUT;
            }
            case 2: {
                return INPUT_OUTPUT;
            }
            case 3: {
                return INPUT_OR_OUTPUT;
            }
            case 4: {
                return INPUT_ALTERNATE;
            }
            case 5: {
                return OUTPUT_ALTERNATE;
            }
            case 6: {
                return POWER;
            }
            case 7: {
                return GROUND;
            }
            case 8: {
                return NA;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Direction[]{INPUT, OUTPUT, INPUT_OUTPUT, INPUT_OR_OUTPUT, INPUT_ALTERNATE, OUTPUT_ALTERNATE, POWER, GROUND, NA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

