/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.validation;

import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.PinmapDslPackage;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import com.st.stellar.pinmap.scoping.PinmapDslIndex;
import com.st.stellar.pinmap.validation.AbstractPinmapDslValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.SpiritPackage;

public class PinmapDslValidator
extends AbstractPinmapDslValidator {
    protected static final String ISSUE_CODE_PREFIX = "com.st.stellar.pinmap.";
    public static final String DUPLICATED_ELEMENT = "com.st.stellar.pinmap.duplicatedElement";
    @Inject
    @Extension
    private PinmapDslIndex _pinmapDslIndex;
    public static final String UNUSED_PERIPHERAL = "com.st.stellar.pinmap.UnusedPeripheral";

    @Check
    public void checkNoDuplicatedPinNames(Family family) {
        HashMultimap multiMapPeripherals = HashMultimap.create();
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Object e : _peripherals) {
            multiMapPeripherals.put((Object)e.getName(), e);
        }
        Set _entrySet = multiMapPeripherals.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Peripheral d = (Peripheral)IterableExtensions.head((Iterable)duplicates);
            String _name = d.getName();
            String _plus = "Duplicated identifier: " + _name;
            this.error(_plus, d, (EStructuralFeature)PinmapDslPackage.eINSTANCE.getPeripheral_Name(), DUPLICATED_ELEMENT, new String[0]);
        }
        HashMultimap multiMapFunctions = HashMultimap.create();
        EList<Function> _functions = family.getFunctions();
        for (Function f : _functions) {
            multiMapFunctions.put((Object)f.getName(), (Object)f);
        }
        Set _entrySet_1 = multiMapFunctions.asMap().entrySet();
        for (Map.Entry entry_1 : _entrySet_1) {
            Collection duplicates = (Collection)entry_1.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Function d = (Function)IterableExtensions.head((Iterable)duplicates);
            String _name = d.getName();
            String _plus = "Duplicated identifier: " + _name;
            this.error(_plus, d, (EStructuralFeature)PinmapDslPackage.eINSTANCE.getFunction_Name(), DUPLICATED_ELEMENT, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(PinmapModel model) {
        EList<Family> _families = model.getFamilies();
        for (Family f : _families) {
            this.checkNoDuplicatedPinNames(f);
        }
    }

    @Override
    protected List<EPackage> getEPackages() {
        List<EPackage> _xblockexpression = null;
        List<EPackage> result = super.getEPackages();
        result.add((EPackage)SpiritPackage.eINSTANCE);
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Check
    public void checkPeripherals(PinmapModel model) {
        EList<Family> _families = model.getFamilies();
        for (Family f : _families) {
            this.checkFamillyPeripherals(f);
        }
    }

    @Check
    public void checkFamillyPeripherals(Family family) {
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Peripheral p : _peripherals) {
            Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getName().equals(p.getName());
            Iterable functions = IterableExtensions.filter(family.getFunctions(), (Functions.Function1)_function);
            if (functions != null && !IterableExtensions.isEmpty((Iterable)functions)) continue;
            String _name = p.getName();
            String _plus = "Peripheral not used: " + _name;
            this.error(_plus, p, (EStructuralFeature)PinmapDslPackage.eINSTANCE.getPeripheral_Name(), UNUSED_PERIPHERAL, new String[0]);
        }
    }
}

