/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.consumption.model.consumption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PeriphRunMode implements Enumerator
{
    RUN(0, "RUN", "RUN"),
    SP(1, "SP", "SP"),
    STANDBY(2, "STANDBY", "STANDBY");

    public static final int RUN_VALUE = 0;
    public static final int SP_VALUE = 1;
    public static final int STANDBY_VALUE = 2;
    private static final PeriphRunMode[] VALUES_ARRAY;
    public static final List<PeriphRunMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static PeriphRunMode get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PeriphRunMode result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static PeriphRunMode getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PeriphRunMode result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static PeriphRunMode get(int value) {
        switch (value) {
            case 0: {
                return RUN;
            }
            case 1: {
                return SP;
            }
            case 2: {
                return STANDBY;
            }
        }
        return null;
    }

    private PeriphRunMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new PeriphRunMode[]{RUN, SP, STANDBY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

