/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.consumption.model.consumption.util;

import com.st.stellar.consumption.model.consumption.Cluster;
import com.st.stellar.consumption.model.consumption.Configuration;
import com.st.stellar.consumption.model.consumption.CoreCluster;
import com.st.stellar.consumption.model.consumption.IdentifiableType;
import com.st.stellar.consumption.model.consumption.InvalidConfig;
import com.st.stellar.consumption.model.consumption.MConsumptionPackage;
import com.st.stellar.consumption.model.consumption.PeriphCluster;
import com.st.stellar.consumption.model.consumption.PeriphRunMode;
import com.st.stellar.consumption.model.consumption.Peripheral;
import com.st.stellar.consumption.model.consumption.RunMode;
import com.st.stellar.consumption.model.consumption.SystemResource;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ConsumptionValidator
extends EObjectValidator {
    public static final ConsumptionValidator INSTANCE = new ConsumptionValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.st.stellar.consumption.model.consumption";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    public static final double MULTIPLY_FACTOR__MIN__VALUE = 0.0;
    public static final double VDD_FACTOR__MIN__VALUE = 0.0;

    protected EPackage getEPackage() {
        return MConsumptionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateIdentifiableType((IdentifiableType)value, diagnostics, context);
            }
            case 1: {
                return this.validateSystemResource((SystemResource)value, diagnostics, context);
            }
            case 2: {
                return this.validatePeripheral((Peripheral)value, diagnostics, context);
            }
            case 3: {
                return this.validateCluster((Cluster)value, diagnostics, context);
            }
            case 4: {
                return this.validateCoreCluster((CoreCluster)value, diagnostics, context);
            }
            case 5: {
                return this.validatePeriphCluster((PeriphCluster)value, diagnostics, context);
            }
            case 6: {
                return this.validateConfiguration((Configuration)value, diagnostics, context);
            }
            case 7: {
                return this.validateInvalidConfig((InvalidConfig)value, diagnostics, context);
            }
            case 8: {
                return this.validateRunMode((RunMode)((Object)value), diagnostics, context);
            }
            case 9: {
                return this.validatePeriphRunMode((PeriphRunMode)((Object)value), diagnostics, context);
            }
            case 10: {
                return this.validateCurrent_type((Double)value, diagnostics, context);
            }
            case 11: {
                return this.validateMultiplyFactor((Double)value, diagnostics, context);
            }
            case 12: {
                return this.validateClockPoint((String)value, diagnostics, context);
            }
            case 13: {
                return this.validateVDDFactor((Double)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateIdentifiableType(IdentifiableType identifiableType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(identifiableType, diagnostics, context);
    }

    public boolean validateSystemResource(SystemResource systemResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(systemResource, diagnostics, context);
    }

    public boolean validatePeripheral(Peripheral peripheral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(peripheral, diagnostics, context);
    }

    public boolean validateCluster(Cluster cluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(cluster, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(cluster, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(cluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCluster_checkClock(cluster, diagnostics, context);
        }
        return result;
    }

    public boolean validateCluster_checkClock(Cluster cluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCoreCluster(CoreCluster coreCluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(coreCluster, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(coreCluster, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(coreCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCluster_checkClock(coreCluster, diagnostics, context);
        }
        return result;
    }

    public boolean validatePeriphCluster(PeriphCluster periphCluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(periphCluster, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(periphCluster, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(periphCluster, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCluster_checkClock(periphCluster, diagnostics, context);
        }
        return result;
    }

    public boolean validateConfiguration(Configuration configuration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(configuration, diagnostics, context);
    }

    public boolean validateInvalidConfig(InvalidConfig invalidConfig, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invalidConfig, diagnostics, context);
    }

    public boolean validateRunMode(RunMode runMode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePeriphRunMode(PeriphRunMode periphRunMode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCurrent_type(double current_type, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMultiplyFactor(double multiplyFactor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMultiplyFactor_Min(multiplyFactor, diagnostics, context);
        return result;
    }

    public boolean validateMultiplyFactor_Min(double multiplyFactor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = multiplyFactor >= 0.0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(MConsumptionPackage.Literals.MULTIPLY_FACTOR, multiplyFactor, 0.0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateClockPoint(String clockPoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateVDDFactor(double vddFactor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateVDDFactor_Min(vddFactor, diagnostics, context);
        return result;
    }

    public boolean validateVDDFactor_Min(double vddFactor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = vddFactor >= 0.0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(MConsumptionPackage.Literals.VDD_FACTOR, vddFactor, 0.0, true, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

