package com.st.stellar.consumption.model.consumption.impl

import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.Configuration
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper

// This class overrides the generated class and will be instantiated by factory
class ConfigurationImpl extends MConfigurationImpl implements Configuration {
	
	new() {
		// Enabled by default
		enabled = true
	}

	override isAllowed() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if( cluster === null) return true;
		val chipMode = cluster.chipModeString
		
		isEnabled && validChipModes.contains(chipMode)
	}
}
