package com.st.stellar.consumption.model.consumption.impl

import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.Configuration
import com.st.stellar.consumption.model.consumption.Peripheral
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper

// This class overrides the generated class and will be instantiated by factory
class PeripheralImpl extends MPeripheralImpl implements Peripheral {

//	Logger logger = LogManager.getLogger(PeripheralImpl)

	def Configuration getValidConfig() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return null
		val chipMode = cluster.chipModeString

		val configs = eContents.filter(Configuration)
		if (configs.size == 1) {
			return configs.get(0)
		}

		var nbValidConfigs = 0
		var Configuration validConfig = null

		for (config : configs) {
			if (config.isValid(chipMode)) {
				nbValidConfigs++
				validConfig = config
			}
		}
		if (nbValidConfigs == 1) {
			validConfig
		} else {
//			logger.error(id + ": cannot find valid configuration for mode '" + chipMode + "' (" + nbValidConfigs + ")")
			return invalidConfig
		}
	}

	override String describe(int indent) {
		if (isAllowed()) {
			val res = "\t".repeat(indent) + this.getId() + "\n"
			res
		} else {
			""
		}
	}

	override isAllowed() {
		val cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return true;
		val chipMode = cluster.getChipModeString();
		return isEnabled() && validChipModes().contains(chipMode);
//		val cfg = validConfig
//		val peripherals = ConsumptionHelper.getCluster(this)
//		if(peripherals === null) return true
//		val allowed = cfg.isValid(peripherals.chipModeString)
//		println(id + " (" + allowed + ")")
//		return allowed
	}

}
