package com.st.stellar.consumption.model.consumption.impl

import com.google.inject.Inject
import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.ConsumptionPackage
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.SystemResource
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import org.eclipse.emf.ecore.EValidator
import com.st.stellar.consumption.model.consumption.util.MyConsumptionValidator

// This class overrides the generated class and will be instantiated by factory
class SystemResourceImpl extends MSystemResourceImpl implements SystemResource {

	@Inject extension ConsumptionHelper

	protected boolean initialized = false

	protected new() {
		// Register package validator
		EValidator.Registry.INSTANCE.put
			(ConsumptionPackage.eINSTANCE,
			 new EValidator.Descriptor() {
				 override EValidator getEValidator() {
					 return MyConsumptionValidator.INSTANCE;
				 }
			 });
		
	}

	@DependsOn(source=MConsumptionPackage.SYSTEM_RESOURCE__IDD_HV_ADC, dependencies=#[
		MConsumptionPackage.SYSTEM_RESOURCE__ALLOWED
	])
	override getIDD_HV_ADC() {
		_consumptionHelper = ConsumptionHelper.instance
		if (this.isAllowed) {
			return globalIDD_HV_ADC
		}
		return 0.0
	}

	@DependsOn(source=MConsumptionPackage.SYSTEM_RESOURCE__IDD_HV_IO, dependencies=#[
		MConsumptionPackage.SYSTEM_RESOURCE__ALLOWED
	])
	override getIDD_HV_IO() {
		_consumptionHelper = ConsumptionHelper.instance
		if (this.isAllowed) {
			return globalIDD_HV_IO
		}
		return 0.0
	}

	@DependsOn(source=MConsumptionPackage.SYSTEM_RESOURCE__IDD_LV, dependencies=#[
		MConsumptionPackage.SYSTEM_RESOURCE__ALLOWED
	])
	override getIDD_LV() {
		_consumptionHelper = ConsumptionHelper.instance
		if (this.isAllowed) {
			return globalIDD_LV
		}
		return 0.0
	}

	@DependsOn(source=MConsumptionPackage.SYSTEM_RESOURCE__IDD_HV, dependencies=#[
		MConsumptionPackage.SYSTEM_RESOURCE__ALLOWED
	])
	override getIDD_HV() {
		_consumptionHelper = ConsumptionHelper.instance
		if (this.isAllowed) {
			return globalIDD_HV
		}
		return 0.0
	}

	@DependsOn(source=MConsumptionPackage.SYSTEM_RESOURCE__IDD_HV_LP, dependencies=#[
		MConsumptionPackage.SYSTEM_RESOURCE__ALLOWED
	])
	override getIDD_HV_LP() {
		_consumptionHelper = ConsumptionHelper.instance
		if (this.isAllowed) {
			return globalIDD_HV_LP
		}
		return 0.0
	}
}
