package com.st.stellar.consumption.model.consumption.util

import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.SystemResource
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EStructuralFeature

class ConsumptionHelper {
	static public ConsumptionHelper instance = new ConsumptionHelper

	def double getGlobalIDD_LV(EObject sys) {
		val children = sys.eContents.filter(SystemResource)
		var consumption = 0.0
		for (child : children) {
			consumption += child.IDD_LV
		}
		consumption
	}

	def double getGlobalIDD_HV_ADC(EObject sys) {
		val children = sys.eContents.filter(SystemResource)
		var consumption = 0.0
		for (child : children) {
			consumption += child.IDD_HV_ADC
		}
		consumption
	}

	def double getGlobalIDD_HV_IO(EObject sys) {
		val children = sys.eContents.filter(SystemResource)
		var consumption = 0.0
		for (child : children) {
			consumption += child.IDD_HV_IO
		}
		consumption
	}

	def double getGlobalIDD_HV(EObject sys) {
		val children = sys.eContents.filter(SystemResource)
		var consumption = 0.0
		for (child : children) {
			consumption += child.IDD_HV
		}
		consumption
	}

	def double getGlobalIDD_HV_LP(EObject sys) {
		val children = sys.eContents.filter(SystemResource)
		var consumption = 0.0
		for (child : children) {
			consumption += child.IDD_HV_LP
		}
		consumption
	}

	def static Cluster getCluster(EObject obj) {
		var Cluster cluster = null
		var EObject parent = obj
		while (cluster === null && parent.eContainer !== null) {
			if (parent instanceof Cluster) {
				cluster = parent
			}
			parent = parent.eContainer
		}
		cluster
	}
	
//	public static Configuration invalidConfig = MConsumptionFactory.eINSTANCE.createConfiguration
	
	def static String getUnit(EStructuralFeature attr) {
		val clkType = attr.EType
		val annotation = clkType.getEAnnotation("com.st.stellar.annotation"); // $NON-NLS-1$
		if (annotation !== null) {
			val unit = annotation.getDetails().get("Unit"); // $NON-NLS-1$
			unit ?: ""
		} else {
			""
		}
	}

}
