package com.st.stellar.consumption.model.consumption.util

import com.st.stellar.component.ComponentValidation
import com.st.stellar.consumption.model.consumption.Cluster
import java.util.Map
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject

class MyConsumptionValidator extends ConsumptionValidator {

	public static final MyConsumptionValidator INSTANCE = new MyConsumptionValidator();

//	SystemResource currentSystemResource
//	Cluster currentCluster

//	override validateSystemResource(SystemResource systemResource, DiagnosticChain diagnostics,
//		Map<Object, Object> context) {
//		currentSystemResource = systemResource
//		super.validateSystemResource(systemResource, diagnostics, context)
//	}

	override boolean validateCluster(Cluster cluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(cluster, diagnostics, context);
	}

	override protected boolean validate_DataValueConforms(EObject eObject, EAttribute eAttribute,
		DiagnosticChain diagnostics, Map<Object, Object> context) {

		ComponentValidation.validate_DataValueConforms(eObject, eAttribute, diagnostics, context)
	}

	override validateCluster_checkClock(Cluster cluster, DiagnosticChain diagnostics, Map<Object, Object> context) {
		val res = cluster.availableFrequencies.contains(cluster.SYS_CLK)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic",
						#["checkClock", getObjectLabel(cluster, context)], #[cluster], context))
			}
		}
		return res
	}

}
