/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui;

import com.st.stellar.wizard.engine.WizardState;
import com.st.stellar.wizard.engine.extension.IExternalWizard;
import com.st.stellar.wizard.engine.ui.handlers.IExternalWizardCommandHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractExternalWizard
implements Runnable,
IExternalWizard {
    private WizardState status = WizardState.STATUS_IDLE;
    private String id;
    private Listener dirtyListener = null;
    private IEditorPart editor = null;
    private IExternalWizardCommandHandler handler;
    protected EObject root;
    protected boolean rootState = true;
    protected IEditorPart baseEditor;
    private boolean isRunning = false;
    Queue<WizardEvent> _orders = new LinkedList<WizardEvent>();
    private boolean _endRequested = false;
    private String initialization;
    public static final Logger logger = LogManager.getLogger((String)AbstractExternalWizard.class.getName());
    HashMap<String, Callable<Boolean>> _handlers = new HashMap<String, Callable<Boolean>>(){
        private static final long serialVersionUID = 5431421761017698050L;
        {
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_IDLE, WizardEvent.BEGIN_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STARTING);
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeStart();
                    } else {
                        AbstractExternalWizard.this.handler.start();
                    }
                    if (AbstractExternalWizard.this.start(AbstractExternalWizard.this.root)) {
                        logger.info((Object)("Starting wizard " + AbstractExternalWizard.this.getId()));
                        AbstractExternalWizard.this.sendEvent(WizardEvent.START_OK);
                    } else {
                        logger.error((Object)("Cannot start wizard " + AbstractExternalWizard.this.getId()));
                        AbstractExternalWizard.this.sendEvent(WizardEvent.START_KO);
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_IDLE, WizardEvent.END_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_END);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_IDLE, WizardEvent.SYNC_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_IDLE);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_IDLE, WizardEvent.STOP_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_IDLE);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTING, WizardEvent.START_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STARTED);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTING, WizardEvent.START_KO), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_IDLE);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTING, WizardEvent.STOP_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPING);
                    if (!AbstractExternalWizard.this.stop()) {
                        AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_KO);
                    } else {
                        AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_OK);
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTED, WizardEvent.STOP_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPING);
                    if (!AbstractExternalWizard.this.stop()) {
                        AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_KO);
                    } else {
                        AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_OK);
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTED, WizardEvent.SYNC_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_SYNCHRONIZING);
                    AbstractExternalWizard.this.sync();
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeCommit();
                    } else {
                        AbstractExternalWizard.this.handler.commit(null);
                    }
                    AbstractExternalWizard.this.syncOK();
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTED, WizardEvent.UPDATE_WIZARD_CONTENT), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.sync();
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTED, WizardEvent.END_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this._endRequested = true;
                    AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_TRANSACTION);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STARTED, WizardEvent.STOP_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)("Terminating wizard " + AbstractExternalWizard.this.getId()));
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeCommitWithRefresh();
                    } else {
                        AbstractExternalWizard.this.handler.commit(null);
                        AbstractExternalWizard.this.handler.stop();
                    }
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPED);
                    if (AbstractExternalWizard.this._endRequested) {
                        AbstractExternalWizard.this._endRequested = false;
                        AbstractExternalWizard.this.endTransaction();
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPING, WizardEvent.STOP_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)("Terminating wizard " + AbstractExternalWizard.this.getId()));
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeCommitWithRefresh();
                    } else {
                        AbstractExternalWizard.this.handler.commit(null);
                        AbstractExternalWizard.this.handler.stop();
                    }
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPED);
                    if (AbstractExternalWizard.this._endRequested) {
                        AbstractExternalWizard.this._endRequested = false;
                        AbstractExternalWizard.this.endTransaction();
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPING, WizardEvent.STOP_KO), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.error((Object)("Can not terminate wizard " + AbstractExternalWizard.this.getId() + ". Forcing close"));
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeCommitWithRefresh();
                    } else {
                        AbstractExternalWizard.this.handler.commit(null);
                        AbstractExternalWizard.this.handler.stop();
                    }
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_IDLE);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPING, WizardEvent.SYNC_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPED);
                    if (AbstractExternalWizard.this._endRequested) {
                        AbstractExternalWizard.this._endRequested = false;
                        AbstractExternalWizard.this.endTransaction();
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPING, WizardEvent.END_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPED);
                    AbstractExternalWizard.this._endRequested = true;
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPING, WizardEvent.STOP_TRANSACTION), new Callable<Boolean>(this){

                @Override
                public Boolean call() {
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_SYNCHRONIZING, WizardEvent.SYNC_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)(AbstractExternalWizard.this.getId() + " is synchronized"));
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_SYNCHRONIZED);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_SYNCHRONIZING, WizardEvent.SYNC_KO), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)(AbstractExternalWizard.this.getId() + " is not synchronized"));
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_SYNCHRONIZED);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_SYNCHRONIZED, WizardEvent.STOP_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)(AbstractExternalWizard.this.getId() + " is stopped"));
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STOPPED);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_SYNCHRONIZED, WizardEvent.STOP_KO), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.info((Object)(AbstractExternalWizard.this.getId() + " is not stopped"));
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_IDLE);
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.END_OK), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.stop();
                    if (AbstractExternalWizard.this.handler != null) {
                        AbstractExternalWizard.this.handler.stop();
                    }
                    return false;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.END_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.stop();
                    if (AbstractExternalWizard.this.handler != null) {
                        AbstractExternalWizard.this.handler.stop();
                    }
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_END);
                    return false;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.SYNC_OK), new Callable<Boolean>(this){

                @Override
                public Boolean call() {
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.SYNC_KO), new Callable<Boolean>(this){

                @Override
                public Boolean call() {
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.BEGIN_TRANSACTION), new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AbstractExternalWizard.this.setWizardStatus(WizardState.STATUS_STARTING);
                    if (AbstractExternalWizard.this.dirtyListener != null) {
                        AbstractExternalWizard.this.handleCompositeStart();
                    } else {
                        AbstractExternalWizard.this.handler.start();
                    }
                    if (AbstractExternalWizard.this.start(AbstractExternalWizard.this.root)) {
                        logger.info((Object)("Starting wizard " + AbstractExternalWizard.this.getId()));
                        AbstractExternalWizard.this.sendEvent(WizardEvent.START_OK);
                    } else {
                        logger.error((Object)("Can not start wizard " + AbstractExternalWizard.this.getId()));
                        AbstractExternalWizard.this.sendEvent(WizardEvent.START_KO);
                    }
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.STOP_OK), new Callable<Boolean>(this){

                @Override
                public Boolean call() {
                    return true;
                }
            });
            this.put(AbstractExternalWizard.this.index(WizardState.STATUS_STOPPED, WizardEvent.STOP_TRANSACTION), new Callable<Boolean>(this){

                @Override
                public Boolean call() {
                    return true;
                }
            });
        }
    };
    private boolean _shouldRefresh = false;

    public String getId() {
        return this.id;
    }

    public String getInitialization() {
        return this.initialization;
    }

    public void setInitialization(String initialization) {
        this.initialization = initialization;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setHandler(IExternalWizardCommandHandler handler) {
        this.handler = handler;
    }

    public synchronized WizardState getWizardStatus() {
        return this.status;
    }

    public synchronized void sendEvent(WizardEvent event) {
        if (this.isRunning) {
            logger.info((Object)("send event " + event.toString()));
            this._orders.add(event);
        } else {
            this.setWizardStatus(WizardState.STATUS_IDLE);
        }
    }

    public synchronized void setWizardStatus(WizardState status) {
        logger.info((Object)("setWizardStatus to " + status.toString()));
        this.status = status;
    }

    public synchronized void beginTransaction() {
        logger.setLevel(Level.WARN);
        this.setWizardStatus(WizardState.STATUS_IDLE);
        logger.info((Object)("Status : " + String.valueOf(this.getWizardStatus())));
        if (this.isRunning) {
            logger.info((Object)"Wizard already launched");
        }
        this.isRunning = true;
        this.sendEvent(WizardEvent.BEGIN_TRANSACTION);
    }

    public synchronized void endTransaction() {
        this.sendEvent(WizardEvent.END_TRANSACTION);
    }

    public void syncTransaction() {
        this.sendEvent(WizardEvent.SYNC_TRANSACTION);
    }

    public void updateWizard() {
        this.sendEvent(WizardEvent.UPDATE_WIZARD_CONTENT);
    }

    public void stopOK() {
        this.sendEvent(WizardEvent.STOP_OK);
    }

    public void stopKO() {
        this.sendEvent(WizardEvent.STOP_KO);
    }

    public void syncOK() {
        this.sendEvent(WizardEvent.SYNC_OK);
    }

    public void syncKO() {
        this.sendEvent(WizardEvent.SYNC_KO);
    }

    public void stopTransaction() {
        this.sendEvent(WizardEvent.STOP_TRANSACTION);
    }

    public abstract boolean start(EObject var1);

    public abstract boolean stop();

    public abstract boolean sync();

    public EObject getRoot() {
        return this.root;
    }

    private String index(WizardState state, WizardEvent event) {
        return state.toString() + ":" + event.toString();
    }

    private boolean handle(WizardEvent event) {
        boolean running = false;
        Callable<Boolean> function = this._handlers.get(this.index(this.getWizardStatus(), event));
        if (function != null) {
            try {
                running = function.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String msg = "Unexpected event '" + event.toString() + "' received in '" + String.valueOf(this.getWizardStatus()) + "'";
            logger.warn((Object)msg);
            return true;
        }
        return running;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            WizardState currentState = this.getWizardStatus();
            WizardEvent receivedOrder = this._orders.poll();
            if (receivedOrder == null) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                }
                continue;
            }
            logger.info((Object)("processing " + receivedOrder.toString() + " in " + currentState.toString()));
            this.isRunning = this.handle(receivedOrder);
        }
        this.cleanUp();
    }

    public abstract void cleanUp();

    private void handleCompositeCommit() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                event.data = null;
                AbstractExternalWizard.this.dirtyListener.handleEvent(event);
            }
        });
    }

    private void handleCompositeCommitWithRefresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                event.data = null;
                AbstractExternalWizard.this.dirtyListener.handleEvent(event);
                AbstractExternalWizard.this.syncOK();
            }
        });
    }

    public void handleCompositeStop() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractExternalWizard.this.sendEvent(WizardEvent.STOP_OK);
            }
        });
    }

    private void handleCompositeStart() {
        Display.getDefault().asyncExec(new Runnable(this){

            @Override
            public void run() {
            }
        });
    }

    public void setDirtyListener(Listener dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractExternalWizard && this.getId() != null && ((AbstractExternalWizard)obj).getId() != null) {
            return super.equals(obj) || this.getId().equals(((AbstractExternalWizard)obj).getId());
        }
        return super.equals(obj);
    }

    public boolean shouldRefresh() {
        return this._shouldRefresh;
    }

    public String getTitle() {
        if (this.editor != null) {
            return this.editor.getTitle();
        }
        return "";
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public void setEditor(IEditorPart ed) {
        this.editor = ed;
    }

    public void closeIt() {
    }

    public void bringToTop() {
    }

    public Image getActivityWizardImage() {
        return null;
    }

    public static enum WizardEvent {
        BEGIN_TRANSACTION,
        END_TRANSACTION,
        STOP_TRANSACTION,
        SYNC_TRANSACTION,
        UPDATE_WIZARD_CONTENT,
        START_OK,
        START_KO,
        STOP_OK,
        STOP_KO,
        SYNC_OK,
        SYNC_KO,
        END_OK,
        END_KO;

    }
}

