/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.AbstractExternalWizard;
import com.st.stellar.wizard.engine.ui.handlers.ExternalWizardCommandHandler;
import com.st.stellar.wizard.engine.ui.handlers.WizardsEngineExtensionParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.st.stellar.wizard.engine.ui";
    public static final String IMG_ZOOM_IN = "zoom.in";
    public static final String IMG_ZOOM_OUT = "zoom.out";
    public static final String IMG_ZOOM_DEFAULT = "zoom.default";
    public static final String IMG_ENABLED = "enabled";
    public static final String IMG_DISABLED = "disabled";
    public static final String IMG_FIT_MODE = "fitMode";
    public static final String IMG_WIZARD = "wizard";
    public static final String IMG_WIZARD_DIS = "wizard_dis";
    public static final String IMG_EMPTY = "empty";
    public static final String IMG_RESET = "reset";
    public static final Cursor cursorWait = new Cursor((Device)Display.getDefault(), 1);
    public static final Cursor cursorArrow = new Cursor((Device)Display.getDefault(), 0);
    public static final Cursor cursorMove = new Cursor((Device)Display.getDefault(), 5);
    public static final Cursor cursorHand = new Cursor((Device)Display.getDefault(), 21);
    private static Activator plugin;
    private static Logger logger;
    private static BundleContext context;
    private Map<String, WizardItem> wizardsRegistry = null;

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        super.start(context);
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_ZOOM_IN, "zoomin.png");
        this.registerImage(registry, IMG_ZOOM_OUT, "zoomout.png");
        this.registerImage(registry, IMG_ZOOM_DEFAULT, "zoomdefault.png");
        this.registerImage(registry, IMG_DISABLED, "disabled.png");
        this.registerImage(registry, IMG_ENABLED, "enabled.png");
        this.registerImage(registry, IMG_FIT_MODE, "zoomFit.png");
        this.registerImage(registry, IMG_WIZARD, "wizard.gif");
        this.registerImage(registry, IMG_WIZARD_DIS, "wizard_dis.gif");
        this.registerImage(registry, IMG_EMPTY, "empty.png");
        this.registerImage(registry, IMG_RESET, "reset.png");
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        Activator.context = null;
        cursorArrow.dispose();
        cursorWait.dispose();
        cursorMove.dispose();
        cursorHand.dispose();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public AbstractExternalWizard getActiveWizard(String key, Component comp) {
        WizardItem item = this.getWizardsRegistry().get(key);
        if (item != null) {
            return item.activeWizards.get(comp);
        }
        return null;
    }

    private Map<String, WizardItem> getWizardsRegistry() {
        if (this.wizardsRegistry == null) {
            this.initializeWizardsRegistry(Platform.getExtensionRegistry());
        }
        return this.wizardsRegistry;
    }

    public void setActiveWizard(String key, Component comp, AbstractExternalWizard wizard) {
        WizardItem item = this.getWizardsRegistry().get(key);
        if (item != null) {
            item.activeWizards.put(comp, wizard);
        }
    }

    public void resetActiveWizard(String key, Component comp, AbstractExternalWizard wizard) {
        WizardItem item = this.getWizardsRegistry().get(key);
        if (item != null) {
            item.activeWizards.remove(comp);
            item = this.getWizardsRegistry().get(key);
        }
    }

    public Set<String> getWizardsRegistryKeys() {
        return this.getWizardsRegistry().keySet();
    }

    private void initializeWizardsRegistry(IExtensionRegistry registry) {
        this.wizardsRegistry = new HashMap<String, WizardItem>();
        IExtension[] extensions = WizardsEngineExtensionParser.getWizardsEngineExtensions();
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Category category = cmdService.getCategory("com.st.stellar.wizard.category");
        if (!category.isDefined()) {
            logger.error((Object)"com.st.stellar.wizard.category not defined");
            return;
        }
        for (IExtension extension : extensions) {
            if (!extension.isValid()) continue;
            Command cmd = cmdService.getCommand(extension.getUniqueIdentifier() + ".command");
            if (!cmd.isDefined()) {
                cmd.define("Command " + extension.getUniqueIdentifier(), "Execute external wizard for " + extension.getUniqueIdentifier(), category);
            }
            cmd.setHandler((IHandler)new ExternalWizardCommandHandler());
            this.wizardsRegistry.put(extension.getUniqueIdentifier(), new WizardItem(this, extension));
        }
    }

    public IExtension getWizardExtension(String key) {
        WizardItem item = this.getWizardsRegistry().get(key);
        if (item != null) {
            return item.extension;
        }
        return null;
    }

    public static BundleContext getContext() {
        return context;
    }

    static {
        logger = LogManager.getLogger(Activator.class);
    }

    class WizardItem {
        IExtension extension;
        private Map<Component, AbstractExternalWizard> activeWizards = new HashMap<Component, AbstractExternalWizard>();

        WizardItem(Activator this$0, IExtension extension) {
            this.extension = extension;
        }
    }
}

