/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.IWizardsEngineEditor;
import com.st.stellar.wizard.engine.WizardState;
import com.st.stellar.wizard.engine.ui.AbstractExternalWizard;
import com.st.stellar.wizard.engine.ui.Activator;
import com.st.stellar.wizard.engine.ui.IActivityWizardResources;
import com.st.stellar.wizard.engine.ui.editors.WizardEngineEditorInput;
import com.st.stellar.wizard.engine.ui.handlers.WizardsEngineExtensionParser;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class WizardsEngine
extends AbstractExternalWizard
implements IActivityWizardResources {
    private String _name;
    private String _description;
    private Image _image;
    private Image _activitywizardimage;
    private Image _disabledImage;
    private boolean _useFreemarker;
    private URL _template;
    private WizardEngineEditorInput _editorInput;
    private Bundle _bundle;

    @Override
    public void setInitialization(String initialization) {
        super.setInitialization(initialization);
        this.initWizard(initialization);
    }

    private void initWizard(String key) {
        IExtension extension = Activator.getDefault().getWizardExtension(key);
        if (extension == null) {
            String message = NLS.bind((String)"Wrong identifier ''{0}'' for wizard.engine Extension\\!", (Object)key);
            logger.error((Object)message);
            return;
        }
        this._description = WizardsEngineExtensionParser.getDescription(extension);
        Assert.isNotNull((Object)this._description);
        this._image = WizardsEngineExtensionParser.getImage(extension);
        Assert.isNotNull((Object)this._image);
        this._disabledImage = WizardsEngineExtensionParser.getDisabledImage(extension);
        Assert.isNotNull((Object)this._disabledImage);
        this._template = WizardsEngineExtensionParser.getTemplate(extension);
        Assert.isNotNull((Object)this._template);
        String contributor = extension.getContributor().getName();
        this._bundle = Platform.getBundle((String)contributor);
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public URL getTemplate() {
        return this._template;
    }

    public Image getImage() {
        return this._image;
    }

    @Override
    public Image getActivityWizardImage() {
        return this._activitywizardimage;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this._image);
    }

    public Image getDisableImage() {
        return this._disabledImage;
    }

    public ImageDescriptor getDisableImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this._disabledImage);
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean init(Component root, IEditorPart baseEditor, ResourceSet input, String title) {
        this.root = root;
        this.baseEditor = baseEditor;
        boolean doInit = true;
        this._editorInput = new WizardEngineEditorInput(root, title);
        this._editorInput.setWizard(this);
        this._name = title;
        return doInit;
    }

    @Override
    public boolean start(EObject propertyTypeGroup) {
        String message = NLS.bind((String)"Opening Wizard Engine for {0} ...", (Object)this._name);
        UIJob job = new UIJob(message){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = wbw.getActivePage();
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)WizardsEngine.this._editorInput, (String)"com.st.stellar.wizard.engine.editors.WizardsEngineEditor", (boolean)true);
                    WizardsEngine.this.setEditor(editorPart);
                    if (editorPart instanceof IWizardsEngineEditor) {
                        WizardsEngine.this.setEditor(editorPart);
                        if (!(editorPart.getEditorInput() instanceof WizardEngineEditorInput)) {
                            WizardsEngine.this.stopTransaction();
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                catch (PartInitException e) {
                    AbstractExternalWizard.logger.error((Object)e);
                    WizardsEngine.this.setWizardStatus(WizardState.STATUS_IDLE);
                    WizardsEngine.this.handleCompositeStop();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return true;
    }

    @Override
    public boolean stop() {
        return true;
    }

    @Override
    public boolean sync() {
        return true;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public boolean shouldRefresh() {
        return false;
    }

    public boolean useFreemarker() {
        return this._useFreemarker;
    }

    public void setUseFreemarker(boolean useFreemarker) {
        this._useFreemarker = useFreemarker;
    }
}

