/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.actions;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.AbstractExternalWizard;
import com.st.stellar.wizard.engine.ui.Activator;
import com.st.stellar.wizard.engine.ui.actions.ExternalWizardThread;
import com.st.stellar.wizard.engine.ui.handlers.WizardsEngineExtensionParser;
import com.st.stellar.wizard.engine.ui.handlers.WizardsExtensionParser;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class ExternalWizardAction
extends Action {
    private IExtension extension;
    private AbstractExternalWizard executable;
    private IFile _file = null;
    private ResourceSet rs;
    private static Logger logger = LogManager.getLogger(ExternalWizardAction.class);

    public ExternalWizardAction(IExtension extension, ResourceSet rs) {
        this.extension = extension;
        this.rs = rs;
        this.executable = (AbstractExternalWizard)WizardsExtensionParser.getExecutable(extension);
        this.setId(extension.getUniqueIdentifier());
        this.executable.setId(this.getId());
        this.setId(extension.getUniqueIdentifier());
        if (this.executable.getName() != null) {
            this.setText(this.executable.getName());
        } else {
            this.setText("External Wizard " + this.executable.getId());
        }
        if (this.executable.getDescription() != null) {
            this.setToolTipText(this.executable.getDescription());
        } else {
            this.setToolTipText("Click to execute wizard " + this.executable.getId() + "'");
        }
        if (this.executable.getImageDescriptor() != null) {
            this.setImageDescriptor(this.executable.getImageDescriptor());
            this.setDisabledImageDescriptor(this.executable.getDisableImageDescriptor());
        } else {
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("wizard"));
            this.setDisabledImageDescriptor(Activator.getDefault().getImageDescriptor("wizard_dis"));
        }
    }

    public AbstractExternalWizard getExecutable() {
        return this.executable;
    }

    public void run() {
        Component comp = null;
        for (Resource r : this.rs.getResources()) {
            if (r.getContents().size() > 0 && r.getContents().get(0) instanceof Component) {
                comp = (Component)r.getContents().get(0);
                this.run(comp);
                continue;
            }
            logger.error((Object)"Cannot launch wizard !");
        }
    }

    public void run(Component comp) {
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = cmdService.getCommand(this.getId() + ".command");
        String key = this.getId();
        AbstractExternalWizard executable = Activator.getDefault().getActiveWizard(key, comp);
        if (executable == null) {
            executable = (AbstractExternalWizard)WizardsExtensionParser.getExecutable(this.extension);
            executable.setId(this.getId());
            ExternalWizardThread thread = new ExternalWizardThread(key, comp, executable);
            thread.start();
            IEditorPart editor = null;
            if (!executable.init(comp, editor, this.rs, WizardsEngineExtensionParser.getName(this.extension))) {
                logger.error((Object)("Error initializing wizard " + key));
            }
        }
        try {
            Object editor = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("param.editor", editor);
            ExecutionEvent event = new ExecutionEvent(cmd, params, null, (Object)executable);
            cmd.executeWithChecks(event);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
        catch (NotDefinedException e) {
            logger.error((Object)e);
        }
        catch (NotEnabledException e) {
            logger.error((Object)e);
        }
        catch (NotHandledException e) {
            logger.error((Object)e);
        }
        super.run();
    }
}

