/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.dialogs;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import com.st.stellar.wizard.engine.ui.widgets.WidgetProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PropertiesControl
extends AbstractInformationControl {
    private List<EStructuralFeature> properties = null;
    protected EStructuralFeature property = null;
    protected WizardsEnginePage page = null;
    private Logger logger = LogManager.getLogger(PropertiesControl.class);
    protected Component model;
    private String path;

    public PropertiesControl(Shell parentShell, Component model, EStructuralFeature property, String href, WizardsEnginePage page) {
        super(parentShell, (String)null);
        this.properties = new ArrayList<EStructuralFeature>();
        this.property = property;
        this.model = model;
        this.page = page;
        this.path = href;
        this.create();
        Point size = this.computeSizeHint();
        this.setSize(size.x, size.y);
    }

    public PropertiesControl(Shell parentShell, Component model, List<EStructuralFeature> property, String href, WizardsEnginePage page) {
        super(parentShell, (String)null);
        this.properties = property;
        this.property = null;
        this.model = model;
        this.page = page;
        this.path = href;
        this.create();
        Point size = this.computeSizeHint();
        this.setSize(size.x, size.y);
    }

    public PropertiesControl(Shell parentShell, Component model, List<EStructuralFeature> property, String href, WizardsEnginePage page, String description) {
        super(parentShell, description);
        this.properties = new ArrayList<EStructuralFeature>();
        this.property = null;
        this.page = page;
        this.model = model;
        this.path = href;
    }

    public boolean hasContents() {
        return true;
    }

    protected void createContent(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        parent.setBackgroundMode(0);
        WidgetProvider provider = new WidgetProvider(this.page);
        try {
            if (this.property != null) {
                provider.createPropertyField(parent, this.model, this.property, this.path);
            } else if (this.path.contains(":")) {
                String[] pathArray = this.path.split(":");
                String group = pathArray[0];
                String[] propertiesNames = pathArray[1].split(",");
                provider.createPropertyField(parent, this.model, this.properties, group, propertiesNames);
            } else {
                provider.createPropertyField(parent, this.model, this.properties.get(0), this.path);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }
}

