/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticFileServlet
extends HttpServlet {
    private final File baseDirectory;
    private String serverId = null;

    public StaticFileServlet(String baseDirectoryPath, String serverId) {
        this.baseDirectory = new File(baseDirectoryPath);
        if (!this.baseDirectory.exists() || !this.baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid base directory: " + baseDirectoryPath);
        }
        this.serverId = serverId;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestedPath = req.getPathInfo();
        if (requestedPath == null || requestedPath.equals("/")) {
            requestedPath = "/wizard.html";
        }
        requestedPath.replace(this.serverId, "");
        File requestedFile = new File(this.baseDirectory, requestedPath);
        if (!requestedFile.exists() || !requestedFile.isFile()) {
            resp.setStatus(404);
            resp.setContentType("text/plain");
            resp.getWriter().write("404 Not Found");
            return;
        }
        String mimeType = Files.probeContentType(requestedFile.toPath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        resp.setStatus(200);
        resp.setContentType(mimeType);
        try (FileInputStream fis = new FileInputStream(requestedFile);
             ServletOutputStream os = resp.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
    }
}

