/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.editors;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.AbstractExternalWizard;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class WizardEngineEditorInput
implements IEditorInput {
    private Component _model;
    String _name = "";
    private Image _image;
    private String _fileName = null;
    private AbstractExternalWizard _wizard;
    private String _title;

    public WizardEngineEditorInput(Component model, String title) {
        this._model = model;
        this._title = title;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFile.class)) {
            IFile file = WizardEngineEditorInput.getModelFile(this._model);
            return file;
        }
        return null;
    }

    static String getProjectName(Component comp) {
        return WizardEngineEditorInput.getProjectNameFromURI(comp.eResource().getURI());
    }

    static IProject getProject(Component comp) {
        String projectName = WizardEngineEditorInput.getProjectName(comp);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    static String getProjectNameFromURI(URI genModelUri) {
        URI rootUri = URI.createURI((String)ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString());
        String lastSegOfRootUri = rootUri.lastSegment();
        String genModelUriStr = genModelUri.toString();
        if (genModelUriStr.startsWith("platform:/resource/")) {
            String s = genModelUriStr.replace("platform:/resource/", "");
            int lastSlash = s.indexOf("/");
            return s.substring(0, lastSlash);
        }
        List segments = genModelUri.segmentsList();
        int lastIndex = segments.lastIndexOf(lastSegOfRootUri);
        return (String)segments.get(lastIndex + 1);
    }

    static IFile getModelFile(Component comp) {
        if (comp.eResource() != null) {
            IProject pro = WizardEngineEditorInput.getProject(comp);
            URI genModelUri = comp.eResource().getURI();
            String uriString = genModelUri.toString();
            int pos = uriString.indexOf(pro.getName());
            String localPath = uriString.substring(pos);
            Path p = new Path(localPath);
            IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
            return ws.getFile((IPath)p);
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public String getName() {
        return this._title;
    }

    public void setName(String name) {
        this._name = name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public Component getModel() {
        return this._model;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void generate() {
        Component comp = this._model;
        Generator generator = new Generator();
        generator.setInput((Object)comp);
        String extension = comp.eResource().getURI().fileExtension();
        Diagnostic diag = generator.generate((Object)comp, (Object)extension, (Monitor)new BasicMonitor.Printing(System.out));
    }

    public AbstractExternalWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(AbstractExternalWizard wizard) {
        this._wizard = wizard;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }
}

