/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.editors;

import com.st.stellar.wizard.engine.ui.WizardsEngine;
import com.st.stellar.wizard.engine.ui.editors.WizardEngineEditorInput;
import com.st.stellar.wizard.engine.ui.editors.WizardPreferenceStore;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import com.st.stellar.wizard.engine.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class WizardsEngineEditor
extends FormEditor
implements IResourceChangeListener {
    private static final String WIZARD_SVG_NAME = "wizard.html";
    private WizardPreferenceStore _store;
    private WizardEngineEditorInput _editorInput;
    private WizardsEnginePage _page;
    private boolean _disposed = false;
    private File _destTempFolder;
    private String _fileName;
    private static Logger _logger = LogManager.getLogger(WizardsEngineEditor.class);
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();

    public WizardsEngineEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void addPages() {
        try {
            this._page = new WizardsEnginePage(this, "com.st.stellar.wizard.engine.wizardspage", this._editorInput.getName(), this._editorInput);
            this._store = new WizardPreferenceStore("root");
            this._page.setStore(this._store);
            int index = this.addPage((IFormPage)this._page);
            this.setPageText(index, this._editorInput.getName());
            this.setPageImage(index, this._editorInput.getImage());
        }
        catch (PartInitException e) {
            _logger.error((Object)e);
        }
    }

    public void dispose() {
        if (!this._disposed) {
            this._disposed = true;
            super.dispose();
            if (this._destTempFolder != null) {
                this.removeFolder(this._destTempFolder);
            }
        }
    }

    private void removeFolder(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.removeFolder(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
            path.delete();
            path.deleteOnExit();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof WizardEngineEditorInput)) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
                for (int i = 0; i < pages.length; ++i) {
                    IEditorPart editorPart = pages[i].findEditor(this.getEditor(0).getEditorInput());
                    System.out.println(editorPart.getTitle());
                }
            });
        }
        super.init(site, editorInput);
        this._editorInput = (WizardEngineEditorInput)editorInput;
        this.setPartName(this._editorInput.getName());
        this.setTitleImage(this.getDefaultImage());
        try {
            this._destTempFolder = Utils.createTempFolder((String)(this._editorInput.getModel().eResource().getURI().lastSegment() + "_" + this._editorInput.hashCode()));
            WizardsEngine engine = (WizardsEngine)this._editorInput.getWizard();
            String templateFolder = FileLocator.toFileURL((URL)engine.getTemplate()).getPath();
            File folder = new File(templateFolder);
            String[] files = folder.list();
            if (files != null) {
                for (String file : files) {
                    Utils.copyfile((String)(templateFolder + file), (String)(String.valueOf(this._destTempFolder) + File.separator + file));
                    if (file == null || !file.equalsIgnoreCase(WIZARD_SVG_NAME)) continue;
                    this._fileName = String.valueOf(this._destTempFolder) + File.separator + file;
                    this._editorInput.setFileName(this._fileName);
                }
            }
        }
        catch (IOException e) {
            throw new PartInitException("", (Throwable)e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(() -> {
                IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
                for (int i = 0; i < pages.length; ++i) {
                    if (!((FileEditorInput)this.getEditor(0).getEditorInput()).getFile().getProject().equals((Object)event.getResource())) continue;
                    IEditorPart editorPart = pages[i].findEditor(this.getEditor(0).getEditorInput());
                    pages[i].closeEditor(editorPart, true);
                }
            });
        }
    }
}

