/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.editors;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.Messages;
import com.st.stellar.wizard.engine.exceptions.WizardException;
import com.st.stellar.wizard.engine.model.FunctionType;
import com.st.stellar.wizard.engine.model.WizardBrowserFunction;
import com.st.stellar.wizard.engine.ui.Activator;
import com.st.stellar.wizard.engine.ui.dialogs.PropertiesControl;
import com.st.stellar.wizard.engine.ui.dialogs.TooltipMessageControl;
import com.st.stellar.wizard.engine.ui.dialogs.VirtualPropertiesControl;
import com.st.stellar.wizard.engine.ui.editors.ChangeCursorFunction;
import com.st.stellar.wizard.engine.ui.editors.DisplayTooltipFunction;
import com.st.stellar.wizard.engine.ui.editors.EditPropertyFunction;
import com.st.stellar.wizard.engine.ui.editors.GetPropertyErrorFunction;
import com.st.stellar.wizard.engine.ui.editors.GetPropertyValueFunction;
import com.st.stellar.wizard.engine.ui.editors.IWizardsEnginePage;
import com.st.stellar.wizard.engine.ui.editors.MenuChangePropertyFunction;
import com.st.stellar.wizard.engine.ui.editors.RefreshImageFunction;
import com.st.stellar.wizard.engine.ui.editors.SetValueFunction;
import com.st.stellar.wizard.engine.ui.editors.StaticFileServlet;
import com.st.stellar.wizard.engine.ui.editors.ToggleBooleanPropertyFunction;
import com.st.stellar.wizard.engine.ui.editors.WizardEngineEditorInput;
import com.st.stellar.wizard.engine.ui.editors.WizardInitFunction;
import com.st.stellar.wizard.engine.ui.editors.WizardsEngineEditor;
import com.st.stellar.wizard.engine.ui.listeners.MoveListener;
import com.st.stellar.wizard.engine.utils.OsUtils;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class WizardsEnginePage
extends FormPage
implements IWizardsEnginePage,
IPropertyChangeListener,
PropertyChangeListener {
    private static final String WIZARD_INTERACTION_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardInteraction.js";
    private static final String WIZARD_ENGINE_JS = "platform:/plugin/com.st.stellar.wizard.engine/scripts/wizardEngine.js";
    private static final String PATH_SEPARATOR = "/";
    private static final String GROUP_SEPARATOR = ":";
    private static final String SEGMENT_SEPARATOR = "@";
    private static final String HREF_PREFIX_SPC5 = "spc5:";
    private static final String HREF_PREFIX_JS = "js:";
    private static final String HREF_PREFIX_MENU = "menu:";
    public static final String DATA_GROUP = "group";
    public static final String DATA_COMPONENT = "component";
    public static final String DATA_MODEL = "model";
    private static Logger logger = LogManager.getLogger(WizardsEnginePage.class);
    public static final String ID = "com.st.stellar.wizard.engine.wizardspage";
    private Adapter _updateAdapter = new ComponentAdapter();
    private final BasicCommandStack _commandStack = new BasicCommandStack();
    private FormToolkit _toolkit;
    private ScrolledForm _form;
    private String _title;
    private WizardEngineEditorInput _editorInput;
    private Map<String, Object> _data = new HashMap<String, Object>();
    private PropertiesControl _infoCtrl;
    private TooltipMessageControl _tooltipCtrl;
    private Browser _browser;
    private MouseListener _mouseListener;
    private int _width = 1000;
    private int _height = 1000;
    private Map<String, BrowserFunction> _browserFunctions = new HashMap<String, BrowserFunction>();
    private MoveListener _moveListener;
    private IPreferenceStore _store = null;
    private UIJob _updateJob = new UIJob("Update UI"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            WizardsEnginePage.this.internalUpdateWizardImage();
            return Status.OK_STATUS;
        }
    };
    private HttpService httpService = null;
    private boolean disposed = false;
    private static int port = 0;
    private static int nbServers = 0;
    private static final String getSVGSize = "function getSVGSize() {\n    var svg = document.getElementById('wizard-svg');\n    if( svg ) {        var svgDoc = svg.contentDocument;\n        var width = svgDoc.documentElement.getAttribute('width');\n        var height = svgDoc.documentElement.getAttribute('height');\n        res = '<'+width+','+height+'>';\n        return res;\n    }\n}\n";
    private static final String loadScript = "function loadScript(url) {\n    var head = document.getElementsByTagName('head')[0];\n    var script = document.createElement('script');\n    script.type = 'text/javascript';\n    script.src = url;\n    head.appendChild(script);\n}\nfunction loadUserBindings(url, callback) {\n    var head = document.getElementsByTagName('head')[0];\n    var script = document.createElement('script');\n    script.type = 'text/javascript';\n    script.src = url;\n    if( typeof callback != 'undefined' ) {\n        script.onreadystatechange = callback;\n        script.onload = callback;\n     }\n    head.appendChild(script);\n    return 1;\n}\n";
    private static final String HTTP_SERVER_NAME = "WizardEngineHttpServer";

    public WizardsEnginePage(WizardsEngineEditor editor, String id, String title, WizardEngineEditorInput editorInput) {
        super((FormEditor)editor, id, title);
        this._title = title;
        this._editorInput = editorInput;
    }

    public void setStore(IPreferenceStore store) {
        this._store = store;
    }

    protected void createFormContent(final IManagedForm managedForm) {
        this._toolkit = managedForm.getToolkit();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.WizardsEnginePage_2, -1);
                    managedForm.getForm().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            WizardsEnginePage.this.dispose();
                        }
                    });
                    WizardsEnginePage.this._form = managedForm.getForm();
                    WizardsEnginePage.this._form.setText(WizardsEnginePage.this._title);
                    WizardsEnginePage.this._toolkit.decorateFormHeading(WizardsEnginePage.this._form.getForm());
                    WizardsEnginePage.this._form.getBody().setLayout((Layout)new GridLayout());
                    WizardsEnginePage.this.buildWizardUI(null);
                    WizardsEnginePage.this._form.reflow(true);
                }
            }, null);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    static void setZoom(Browser browser, float zoom) {
    }

    private void buildWizardUI(Composite container) {
        Composite wizardContainer = null;
        if (container == null) {
            wizardContainer = this._toolkit.createComposite(this._form.getBody(), 0);
            wizardContainer.setLayout((Layout)new GridLayout());
            wizardContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            container.setRedraw(false);
            for (Control c : container.getChildren()) {
                c.dispose();
            }
            wizardContainer = container;
            if (this._moveListener != null) {
                this._moveListener.dispose();
            }
        }
        Component model = this._editorInput.getModel();
        this.setData(DATA_MODEL, model);
        if (!model.eAdapters().contains((Object)this._updateAdapter)) {
            model.eAdapters().add((Object)this._updateAdapter);
        }
        this._browser = OsUtils.isMac() || OsUtils.isLinux() ? new Browser(wizardContainer, 65536) : (OsUtils.is64() ? new Browser(wizardContainer, 262144) : new Browser(wizardContainer, 32768));
        this._browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this._editorInput.generate();
        try {
            File f = new File(this._editorInput.getFileName());
            int port = this.startHttpServer();
            this._browser.setUrl("http://localhost:" + port + PATH_SEPARATOR + this.getServerId() + "/wizard.html");
            String interactionSrcPath = this.getUrlFromFile(WIZARD_INTERACTION_JS);
            String interactionDstPath = this.getUrlFromFile(WIZARD_ENGINE_JS);
            String engineSrcPath = this.getUrlFromFile(f.toURI().toString().replace("wizard.html", "wizardInteraction.js"));
            this.copyFile("file://" + interactionSrcPath, "file://" + engineSrcPath);
            String engineDestPath = this.getUrlFromFile(f.toURI().toString().replace("wizard.html", "wizardEngine.js"));
            this.copyFile("file://" + interactionDstPath, "file://" + engineDestPath);
            this._browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    String hrefStr = event.location;
                    if (hrefStr != null && !hrefStr.isEmpty()) {
                        if (hrefStr.contains(WizardsEnginePage.HREF_PREFIX_MENU)) {
                            event.doit = false;
                        } else if (hrefStr.contains(WizardsEnginePage.HREF_PREFIX_JS)) {
                            event.doit = false;
                        } else if (hrefStr.contains(WizardsEnginePage.HREF_PREFIX_SPC5)) {
                            event.doit = false;
                        }
                    } else {
                        event.doit = false;
                    }
                }

                public void changed(LocationEvent event) {
                    int posH = WizardsEnginePage.this._store.getInt("wizard.zoom.scrollbar.pos.h");
                    int posV = WizardsEnginePage.this._store.getInt("wizard.zoom.scrollbar.pos.v");
                    WizardsEnginePage.this.setScrollbarPos(posH, posV);
                }
            });
            this._browser.addMenuDetectListener(new MenuDetectListener(this){

                public void menuDetected(MenuDetectEvent e) {
                    e.doit = false;
                }
            });
            this._browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    Pattern pattern;
                    Matcher matcher;
                    WizardsEnginePage.this._form.getBody().layout(true, true);
                    Object script = WizardsEnginePage.getSVGSize;
                    script = (String)script + "return getSVGSize();\n";
                    Object res = WizardsEnginePage.this._browser.evaluate((String)script);
                    if (res != null && (matcher = (pattern = Pattern.compile("^<([0-9]+\\.*[0-9]+)mm,([0-9]+\\.*[0-9]+)mm>$")).matcher(res.toString())).find()) {
                        String w = matcher.group(1);
                        String h = matcher.group(2);
                        WizardsEnginePage.this._width = (int)Float.parseFloat(w) + 100;
                        WizardsEnginePage.this._height = (int)Float.parseFloat(h) + 100;
                        WizardsEnginePage.this._store.setValue("wizard.window.width", WizardsEnginePage.this._width);
                        WizardsEnginePage.this._store.setValue("wizard.window.height", WizardsEnginePage.this._height);
                    }
                    WizardsEnginePage.this.loadScripts();
                }

                public void changed(ProgressEvent event) {
                }
            });
        }
        catch (SWTError e) {
            logger.error((Object)(Messages.WizardsEnginePage_33 + e.getMessage()));
            return;
        }
        catch (Exception e) {
            logger.error((Object)(Messages.WizardsEnginePage_33 + e.getMessage()));
            return;
        }
        new SetValueFunction(this, this._browser);
        new MenuChangePropertyFunction(this, this._browser);
        new EditPropertyFunction(this, this._browser);
        new ChangeCursorFunction(this, this._browser);
        new GetPropertyValueFunction(this, this._browser);
        new GetPropertyErrorFunction(this, this._browser);
        new DisplayTooltipFunction(this, this._browser);
        new WizardInitFunction(this, this._browser);
        new ToggleBooleanPropertyFunction(this, this._browser);
        new RefreshImageFunction(this, this._browser);
        if (container != null) {
            container.setRedraw(true);
        }
        this._browser.addMouseWheelListener(new MouseWheelListener(this){

            public void mouseScrolled(MouseEvent e) {
                if ((e.stateMask & 0x40000) != 0) {
                    System.out.println("mousewheel listener");
                }
            }
        });
        this._moveListener = new MoveListener(this);
    }

    private void loadScripts() {
        if (this._form.getBody().isDisposed()) {
            logger.info((Object)"loadScripts:disposed");
            return;
        }
        boolean decoded = true;
        String url1Path = this.getUrlFromFile(WIZARD_INTERACTION_JS);
        decoded = decoded && url1Path != null;
        String url2Path = this.getUrlFromFile(WIZARD_ENGINE_JS);
        boolean bl = decoded = decoded && url2Path != null;
        if (decoded) {
            Object script = loadScript;
            script = (String)script + "function myInitFunction() {\n";
            script = (String)script + "    wizInit()\n";
            script = (String)script + "};\n";
            script = (String)script + "return loadUserBindings('wizardBinding.js', myInitFunction);\n";
            try {
                if (this._browser.evaluate((String)script) == null) {
                    logger.error((Object)"Cannot evaluate loadScript");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            logger.error((Object)"cannot load wizard javascript");
        }
    }

    private String getUrlFromBrowserFile(String fileName) {
        String urlPath = "";
        try {
            URL url = new URL(this._browser.getUrl().replace("wizard.html", fileName));
            try {
                urlPath = FileLocator.toFileURL((URL)url).getPath();
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.WizardsEnginePage_16, (Object)fileName);
                logger.error((Object)message);
                urlPath = null;
            }
        }
        catch (MalformedURLException e1) {
            String message = NLS.bind((String)Messages.WizardsEnginePage_16, (Object)fileName);
            logger.error((Object)message);
            urlPath = null;
        }
        return urlPath;
    }

    private String readJavascriptFromFile(String urlPath) {
        String content = "";
        try {
            java.net.URI fileUri = new java.net.URI("file://" + urlPath);
            content = Files.lines(Paths.get(fileUri)).collect(Collectors.joining(System.lineSeparator()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            content = "";
        }
        catch (IOException e) {
            e.printStackTrace();
            content = "";
        }
        return content;
    }

    private String getUrlFromFile(String fileName) {
        String urlPath = "";
        try {
            URL url = new URL(fileName);
            try {
                urlPath = FileLocator.toFileURL((URL)url).getPath();
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.WizardsEnginePage_16, (Object)fileName);
                logger.error((Object)message);
                urlPath = null;
            }
        }
        catch (MalformedURLException e1) {
            String message = NLS.bind((String)Messages.WizardsEnginePage_16, (Object)fileName);
            logger.error((Object)message);
            urlPath = null;
        }
        return urlPath;
    }

    @Override
    public Object buildCallJSHandler(String href, Object[] arguments) {
        String[] tokens = href.split(GROUP_SEPARATOR);
        if (tokens.length == 2) {
            FunctionType function = this.buildFunction(tokens[1]);
            return this.executeFunction(function, arguments);
        }
        String message = NLS.bind((String)Messages.WizardsEnginePage_35, (Object[])new Object[]{href});
        logger.error((Object)message);
        return null;
    }

    private FunctionType buildFunction(String string) {
        FunctionType function = null;
        Pattern pattern = Pattern.compile("^(.*)\\(([^}]+)\\).*$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String path = matcher.group(2);
            String _name = matcher.group(1);
            path = path.replaceAll("'", "");
            Component component = (Component)this.getData(DATA_MODEL);
            function = new FunctionTypeBuilder(_name, path, component).setBrowserFunction(this._browserFunctions.get(_name)).build();
        } else {
            String message = NLS.bind((String)Messages.WizardsEnginePage_38, (Object[])new Object[]{string});
            logger.error((Object)message);
        }
        return function;
    }

    protected Object executeFunction(FunctionType function, Object[] arguments) {
        Object res = null;
        String path = function.getPathToProperty();
        EObject property = null;
        try {
            property = this.buildPropertyFromPath(path);
        }
        catch (WizardException e1) {
            logger.error((Object)e1.getMessage());
            return null;
        }
        res = function.execute(property, arguments);
        return res;
    }

    @Override
    public Object getPropertyValue(String href) {
        Component model = this._editorInput.getModel();
        return this.getPropertyValueFromPath((EObject)model, href);
    }

    private Object getPropertyValueFromPath(EObject root, String path) {
        if (path.contains(PATH_SEPARATOR)) {
            Object result = null;
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)path).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                String seg = SEGMENT_SEPARATOR + pathSegments[i];
                segments.add((CallSite)((Object)seg));
                groupSegment = ((String)groupSegment).length() > 0 ? (String)groupSegment + PATH_SEPARATOR + seg : (String)groupSegment + seg;
            }
            String propName = pathSegments[pathSegments.length - 1];
            try {
                EObject group = EcoreUtil.getEObject((EObject)root, (String)groupSegment);
                EStructuralFeature property = group.eClass().getEStructuralFeature(propName);
                result = group.eGet(property);
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("Cannot find property named '" + path + "'"));
            }
            return result;
        }
        EStructuralFeature property = root.eClass().getEStructuralFeature(path);
        if (property != null) {
            return root.eGet(property);
        }
        logger.error((Object)("Cannot find property named '" + path + "'"));
        return null;
    }

    public List<EStructuralFeature> getPropertyFromPath(EObject root, String path) {
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
        if (path.contains(GROUP_SEPARATOR)) {
            String[] propertiesNames;
            String[] pathArray = path.split(GROUP_SEPARATOR);
            String group = pathArray[0];
            for (String ppath : propertiesNames = pathArray[1].split(",")) {
                list.add(this.getSinglePropertyFromPath(root, ppath));
            }
        } else {
            EStructuralFeature property = this.getSinglePropertyFromPath(root, path);
            list.add(property);
        }
        return list;
    }

    public EStructuralFeature getSinglePropertyFromPath(EObject root, String path) {
        if (path.contains(PATH_SEPARATOR)) {
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)path).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                String seg = SEGMENT_SEPARATOR + pathSegments[i];
                segments.add((CallSite)((Object)seg));
                groupSegment = ((String)groupSegment).length() > 0 ? (String)groupSegment + PATH_SEPARATOR + seg : (String)groupSegment + seg;
            }
            String propName = pathSegments[pathSegments.length - 1];
            EObject group = EcoreUtil.getEObject((EObject)root, (String)groupSegment);
            EStructuralFeature property = group.eClass().getEStructuralFeature(propName);
            return property;
        }
        return root.eClass().getEStructuralFeature(path);
    }

    public EObject getPropertyParentFromPath(EObject root, String path) {
        if (path.contains(PATH_SEPARATOR)) {
            String[] pathSegments = SegmentSequence.create((String)PATH_SEPARATOR, (String)path).segments();
            ArrayList<CallSite> segments = new ArrayList<CallSite>();
            Object groupSegment = "";
            for (int i = 0; i < pathSegments.length - 1; ++i) {
                String seg = SEGMENT_SEPARATOR + pathSegments[i];
                segments.add((CallSite)((Object)seg));
                groupSegment = ((String)groupSegment).length() > 0 ? (String)groupSegment + PATH_SEPARATOR + seg : (String)groupSegment + seg;
            }
            EObject group = EcoreUtil.getEObject((EObject)root, (String)groupSegment);
            return group;
        }
        return root;
    }

    @Override
    public void setPropertyValue(String path, Object value) {
        Component model = this._editorInput.getModel();
        EObject parent = this.getPropertyParentFromPath((EObject)model, path);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)parent);
        List<EStructuralFeature> properties = this.getPropertyFromPath((EObject)model, path);
        for (EStructuralFeature property : properties) {
            if (property != null) {
                EClassifier eClassifier = property.getEType();
                if (eClassifier instanceof EDataType) {
                    EDataType eDataType = (EDataType)eClassifier;
                    EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                    Object newValue = eFactory.createFromString(eDataType, (String)value);
                    Command command = SetCommand.create((EditingDomain)editingDomain, (Object)parent, (Object)property, (Object)newValue);
                    editingDomain.getCommandStack().execute(command);
                    continue;
                }
                logger.error((Object)("wrong type for '" + path + "'"));
                continue;
            }
            logger.error((Object)("Cannot find property named '" + path + "'"));
        }
    }

    @Override
    public void toggleBooleanValue(String href) {
        Component model = this._editorInput.getModel();
        EObject parent = this.getPropertyParentFromPath((EObject)model, href);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)parent);
        List<EStructuralFeature> properties = this.getPropertyFromPath((EObject)model, href);
        for (EStructuralFeature property : properties) {
            if (property != null) {
                EClassifier eClassifier = property.getEType();
                if (eClassifier instanceof EDataType) {
                    EDataType eDataType = (EDataType)eClassifier;
                    if (eDataType.getName().equals("EBoolean")) {
                        EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                        Boolean propValue = (Boolean)parent.eGet(property);
                        Object newValue = eFactory.createFromString(eDataType, propValue != false ? "false" : "true");
                        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)parent, (Object)property, (Object)newValue);
                        System.out.println("property '" + property.getName() + "' set to " + newValue.toString());
                        editingDomain.getCommandStack().execute(command);
                        continue;
                    }
                    logger.error((Object)("wrong type for '" + href + "', expected type is Boolean"));
                    continue;
                }
                logger.error((Object)("wrong type for '" + href + "'"));
                continue;
            }
            logger.error((Object)("Cannot find property named '" + href + "'"));
        }
    }

    private void printChildrenMessages(Diagnostic diagnostic, List<String> errors) {
        errors.add(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            errors.add(child.getMessage());
        }
    }

    private void printDiagnostic(EObject model, EStructuralFeature property, Diagnostic diagnostic, String indent, List<String> errors) {
        EAttribute att;
        List data = diagnostic.getData();
        if (data.size() == 2) {
            if (data.get(1) instanceof EAttributeImpl && (att = (EAttribute)data.get(1)).getName().equals(property.getName())) {
                this.printChildrenMessages(diagnostic, errors);
            }
        } else if (data.size() == 1 && data.get(0) instanceof EAttributeImpl && (att = (EAttribute)data.get(1)).getName().equals(property.getName())) {
            this.printChildrenMessages(diagnostic, errors);
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(model, property, child, indent + "  ", errors);
        }
    }

    @Override
    public Object getPropertyError(String href) {
        Component model = this._editorInput.getModel();
        List<EStructuralFeature> properties = this.getPropertyFromPath((EObject)model, href);
        ArrayList<String> errors = new ArrayList<String>();
        for (EStructuralFeature property : properties) {
            Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)model);
            this.printDiagnostic((EObject)model, property, diag, "", errors);
        }
        return errors;
    }

    @Override
    public void displayTooltip(String errorMsg, int x, int y) {
        if (this._tooltipCtrl == null && errorMsg != null && !errorMsg.isEmpty()) {
            this._tooltipCtrl = new TooltipMessageControl(this._browser.getShell(), errorMsg);
        }
        if (this._tooltipCtrl != null && !this._tooltipCtrl.isVisible()) {
            this._tooltipCtrl.setLocation(new Point(x, y));
            this._tooltipCtrl.setVisible(true);
        }
        if ((errorMsg == null || errorMsg.isEmpty()) && this._tooltipCtrl != null) {
            this._tooltipCtrl.dispose();
            this._tooltipCtrl = null;
        }
    }

    @Override
    public void buildMenuHandler(Browser br, String hrefStr, int x, int y) {
        final Component model = this._editorInput.getModel();
        final EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
        Pattern pattern = Pattern.compile("^.*\\{([^}]+)\\}.*$");
        Matcher matcher = pattern.matcher(hrefStr);
        if (matcher.find()) {
            String subHref = matcher.group(1);
            final Menu menu = new Menu((Control)br);
            for (String token : subHref.split(",")) {
                String[] entryTokens = token.split(GROUP_SEPARATOR);
                if (entryTokens.length == 2) {
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(entryTokens[0].trim());
                    final FunctionType function = this.buildFunction(entryTokens[1]);
                    final String path = function.getPathToProperty();
                    final EStructuralFeature property = model.eClass().getEStructuralFeature(path);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Object res = function.execute((EObject)property, new Object[]{function.getFunction() + WizardsEnginePage.GROUP_SEPARATOR + path});
                            if (res != null) {
                                if (property != null) {
                                    EClassifier eClassifier = property.getEType();
                                    if (eClassifier instanceof EDataType) {
                                        EDataType eDataType = (EDataType)eClassifier;
                                        EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                                        Object newValue = eFactory.createFromString(eDataType, (String)res);
                                        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)property, (Object)newValue);
                                        editingDomain.getCommandStack().execute(command);
                                    } else {
                                        logger.error((Object)("wrong type for '" + path + "'"));
                                    }
                                }
                                WizardsEnginePage.this.updateWizardImage();
                            }
                            menu.dispose();
                        }
                    });
                    continue;
                }
                String message = NLS.bind((String)Messages.WizardsEnginePage_43, (Object[])new Object[]{hrefStr, token});
                logger.error((Object)message);
            }
            br.setMenu(menu);
            menu.setVisible(true);
            menu.setLocation(new Point(x, y));
        } else {
            String message = NLS.bind((String)Messages.WizardsEnginePage_44, (Object[])new Object[]{hrefStr});
            logger.error((Object)message);
        }
    }

    private void internalUpdateWizardImage() {
        this.loadScripts();
    }

    private String getFileName() {
        return this._editorInput.getFileName();
    }

    public void updateWizardImage(int delay) {
        if (delay > 0) {
            Display.getDefault().timerExec(delay, new Runnable(){

                @Override
                public void run() {
                    WizardsEnginePage.this.internalUpdateWizardImage();
                }
            });
        } else {
            this.internalUpdateWizardImage();
        }
    }

    public void updateWizardImage() {
        this.updateWizardImage(0);
    }

    protected void showPropertiesShell(int x, int y) {
        if (this._infoCtrl != null && !this._infoCtrl.isVisible()) {
            this._infoCtrl.setLocation(new Point(x, y));
            this._infoCtrl.setVisible(true);
            this._infoCtrl.setFocus();
        }
        this._mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                WizardsEnginePage.this.hidePropertiesShell(e.x, e.y);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this._browser.addMouseListener(this._mouseListener);
    }

    protected void hidePropertiesShell(int x, int y) {
        if (this._infoCtrl != null) {
            this._infoCtrl.dispose();
            this._infoCtrl = null;
        }
        if (this._mouseListener != null) {
            this._browser.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        this.refreshConfiguration();
    }

    public void refreshConfiguration() {
        this.updateWizardImage(10);
    }

    @Override
    public void buildPropertyHandler(String href, int x, int y) {
        Component model = this._editorInput.getModel();
        List<EStructuralFeature> properties = this.getPropertyFromPath((EObject)model, href);
        this.buildPropertiesShell(model, properties, href);
        this.showPropertiesShell(x, y);
    }

    private void buildPropertiesShell(Component model, EStructuralFeature property, String href) {
        if (this._infoCtrl == null) {
            this._infoCtrl = new PropertiesControl(this._browser.getShell(), model, property, href, this);
            FocusListener focusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    WizardsEnginePage.this.hidePropertiesShell(-1, -1);
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this._infoCtrl.addFocusListener(focusListener);
        }
    }

    private void buildPropertiesShell(Component model, List<EStructuralFeature> property, String href) {
        if (this._infoCtrl == null) {
            this._infoCtrl = new PropertiesControl(this._browser.getShell(), model, property, href, this);
            FocusListener focusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    WizardsEnginePage.this.hidePropertiesShell(-1, -1);
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this._infoCtrl.addFocusListener(focusListener);
        }
    }

    private void buildPropertiesShell(Component model, ArrayList<EStructuralFeature> properties, String description) {
        if (this._infoCtrl == null) {
            this._infoCtrl = new VirtualPropertiesControl(this._browser.getShell(), model, properties, this, description);
            FocusListener focusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    WizardsEnginePage.this.hidePropertiesShell(-1, -1);
                }

                public void focusGained(FocusEvent e) {
                }
            };
            this._infoCtrl.addFocusListener(focusListener);
        }
    }

    public void update() {
        this.wizardInit();
    }

    public Object getData(String key) {
        return this._data.get(key);
    }

    public void setData(String key, Object data) {
        this._data.put(key, data);
    }

    public void dispose() {
        if (!this.disposed) {
            if (this._updateJob != null) {
                this._updateJob.cancel();
                this._updateJob = null;
            }
            if (this._browser != null && !this._browser.isDisposed()) {
                this.storeScrollbarPos();
                this._browser.dispose();
                this._browser = null;
            }
            if (this._tooltipCtrl != null) {
                this._tooltipCtrl.dispose();
                this._tooltipCtrl = null;
            }
            if (this._infoCtrl != null) {
                this._infoCtrl.dispose();
                this._infoCtrl = null;
            }
            this._editorInput.getModel().eAdapters().remove((Object)this._updateAdapter);
            super.dispose();
            this.stopHttpServer();
            this._store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.disposed = true;
    }

    @Override
    public Object wizardInit() {
        this.loadScripts();
        return true;
    }

    @Override
    public void addBrowserFunction(BrowserFunction f) {
        this._browserFunctions.put(f.getName(), f);
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        System.out.println("proterty change: " + event.getProperty());
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent event) {
        this.updateWizardImage(10);
    }

    public Browser getBrowser() {
        return this._browser;
    }

    public IPreferenceStore getStore() {
        return this._store;
    }

    private void storeScrollbarPos() {
        Object script = "";
        script = "let getOffset = function() {\n";
        script = (String)script + "    if(window) {\n";
        script = (String)script + "       let res = window.pageXOffset + \",\" +window.pageYOffset;\n";
        script = (String)script + "       return res;\n";
        script = (String)script + "    } else {\n";
        script = (String)script + "       return \"0,0\";\n";
        script = (String)script + "    }\n";
        script = (String)script + "}\n";
        script = (String)script + "return getOffset();";
        String res = (String)this._browser.evaluate((String)script);
        Pattern pattern = Pattern.compile(",");
        String[] dim = pattern.split(res);
        this._store.setValue("wizard.zoom.scrollbar.pos.h", Integer.parseInt(dim[0]));
        this._store.setValue("wizard.zoom.scrollbar.pos.v", Integer.parseInt(dim[1]));
    }

    private void setScrollbarPos(final int posH, final int posV) {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                String script = "window.scroll( " + posH + "," + posV + ");";
                WizardsEnginePage.this._browser.evaluate(script);
            }
        });
    }

    @Override
    public void refresh() {
        this.update();
    }

    @Override
    public EObject buildPropertyFromPath(String string) throws WizardException {
        return null;
    }

    protected ResourceSet loadResource(IEditorInput editorInput) throws PartInitException {
        ResourceSet resourceSet = ResourceSetHelpers.createResourceSet((CommandStack)this.getCommandStack());
        URI resourceURI = EditUIUtil.getURI((IEditorInput)editorInput);
        try {
            resourceSet = ResourceSetHelpers.loadResourceWithProxies((URI)resourceURI, (ResourceSet)resourceSet, this.getResourceLoadOptions());
            this.verifyEditorResource(resourceURI, resourceSet);
            return resourceSet;
        }
        catch (Exception e) {
            throw new PartInitException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected Map<Object, Object> getResourceLoadOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        return options;
    }

    protected Map<Object, Object> getResourceSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("ENCODING", "UTF-8");
        return saveOptions;
    }

    protected void verifyEditorResource(URI resourceURI, ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(resourceURI, true);
        if (XMLResource.class.isInstance(resource) && !((XMLResource)XMLResource.class.cast(resource)).getEObjectToExtensionMap().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Problems while loading the model", (String)"The model loading was incomplete. A migration to the latest model version might be required.\\nPlease visit our migration guide for more information.");
        }
    }

    protected BasicCommandStack getCommandStack() {
        return this._commandStack;
    }

    public boolean isDirty() {
        return false;
    }

    private String getServerId() {
        return String.valueOf(this._editorInput.hashCode());
    }

    private int startHttpServer() throws Exception {
        if (port == 0) {
            Server server = new Server();
            ServerConnector connector = new ServerConnector(server);
            connector.setPort(0);
            server.addConnector((Connector)connector);
            server.start();
            port = connector.getLocalPort();
            server.stop();
            Hashtable<String, Object> settings = new Hashtable<String, Object>();
            ((Dictionary)settings).put("http.port", port);
            ((Dictionary)settings).put("context.path", PATH_SEPARATOR);
            ((Dictionary)settings).put("other.info", "Equinox HTTP Server");
            JettyConfigurator.startServer((String)HTTP_SERVER_NAME, settings);
        }
        System.out.println("Equinox HTTP server started at http://localhost:" + port);
        System.out.println("http://localhost:" + port + PATH_SEPARATOR + this.getServerId());
        BundleContext context = Activator.getContext();
        File f = new File(this._editorInput.getFileName());
        this.httpService = (HttpService)context.getService(context.getServiceReference(HttpService.class));
        StaticFileServlet staticFileServer = new StaticFileServlet(f.getAbsolutePath().replace("wizard.html", ""), this.getServerId());
        this.httpService.registerServlet(PATH_SEPARATOR + this.getServerId(), (Servlet)staticFileServer, null, null);
        ++nbServers;
        return port;
    }

    private void stopHttpServer() {
        BundleContext context;
        ServiceReference sr;
        if (--nbServers < 1) {
            try {
                JettyConfigurator.stopServer((String)HTTP_SERVER_NAME);
                nbServers = 0;
                port = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((sr = (context = Activator.getContext()).getServiceReference(HttpService.class)) != null) {
            this.httpService = (HttpService)context.getService(sr);
            this.httpService.unregister(PATH_SEPARATOR + this.getServerId());
        }
    }

    private void copyFile(String fileUri, String destUri) {
        try {
            java.net.URI uri = new java.net.URI(fileUri);
            Path sourcePath = Paths.get(uri);
            java.net.URI destinationUri = new java.net.URI(destUri);
            Path destinationPath = Paths.get(destinationUri);
            Files.copy(sourcePath, destinationPath, new CopyOption[0]);
            System.out.println("File copied successfully! from " + fileUri + " to " + destUri);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void refreshImage() {
        this.refreshConfiguration();
    }

    private class ComponentAdapter
    extends EContentAdapter {
        private ComponentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: {
                    if (notification.getOldValue() == null || notification.getOldValue().equals(notification.getNewValue()) || WizardsEnginePage.this._updateJob == null) break;
                    WizardsEnginePage.this._updateJob.cancel();
                    WizardsEnginePage.this._updateJob.schedule();
                    break;
                }
            }
        }
    }

    public static class FunctionTypeBuilder {
        private String _function;
        private String _pathToProperty;
        private Component _component;
        private BrowserFunction _browserFunction = null;

        public FunctionTypeBuilder(String functionName, String path, Component component) {
            Assert.isNotNull((Object)functionName);
            Assert.isNotNull((Object)path);
            Assert.isNotNull((Object)component);
            this._function = functionName;
            this._pathToProperty = path;
            this._component = component;
        }

        public FunctionType build() {
            if (this._browserFunction != null) {
                return new WizardBrowserFunction(this._function, this._pathToProperty, this._component, this._browserFunction);
            }
            return null;
        }

        public FunctionTypeBuilder setBrowserFunction(BrowserFunction _browserFunction) {
            this._browserFunction = _browserFunction;
            return this;
        }
    }
}

