/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.handlers;

import com.google.common.collect.Lists;
import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.Component;
import com.st.stellar.component.ComponentPackage;
import com.st.stellar.component.model.ui.ComponentEditor;
import com.st.stellar.wizard.engine.ui.Activator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ResetToDefaultHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    private Component getComponent(ResourceSet resourceSet) {
        for (Resource r : resourceSet.getResources()) {
            if (r.getContents().size() <= 0 || !(r.getContents().get(0) instanceof Component)) continue;
            return (Component)r.getContents().get(0);
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iworkbenchpage;
        IWorkbenchWindow iworkbenchwindow;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        if (iworkbench != null && (iworkbenchwindow = iworkbench.getActiveWorkbenchWindow()) != null && (iworkbenchpage = iworkbenchwindow.getActivePage()) != null) {
            IEditorPart ieditorpart = iworkbenchpage.getActiveEditor();
            ComponentEditor clkEditor = (ComponentEditor)ieditorpart;
            final Component comp = this.getComponent(clkEditor.getResourceSet());
            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Reset confirmation", (String)"Clock values are going to be reset to their default values. Do you aggree?")) {
                Command command;
                Object newValue;
                EFactory eFactory;
                EDataType eDataType;
                String wizard = comp.getWizard();
                EFactory componentFactory = comp.eClass().getEPackage().getEFactoryInstance();
                EObject defaultComponent = componentFactory.create(comp.eClass());
                EObjectState state = new EObjectState(defaultComponent);
                state.copyStateTo((EObject)comp);
                Component model = comp;
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
                EAttribute featureID = ComponentPackage.eINSTANCE.getComponent_Wizard();
                EClassifier eClassifier = featureID.getEType();
                if (eClassifier instanceof EDataType) {
                    eDataType = (EDataType)eClassifier;
                    eFactory = eDataType.getEPackage().getEFactoryInstance();
                    newValue = eFactory.createFromString(eDataType, wizard);
                    command = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)featureID, (Object)newValue);
                    editingDomain.getCommandStack().execute(command);
                }
                if ((eClassifier = (featureID = ComponentPackage.eINSTANCE.getComponent_Name()).getEType()) instanceof EDataType) {
                    eDataType = (EDataType)eClassifier;
                    eFactory = eDataType.getEPackage().getEFactoryInstance();
                    newValue = eFactory.createFromString(eDataType, this.fileName(comp.eResource().getURI()));
                    command = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)featureID, (Object)newValue);
                    editingDomain.getCommandStack().execute(command);
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComponentAPI.resetConfigurator((EObject)comp);
                    }
                });
            }
        }
        return null;
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(0, i);
    }

    public boolean isEnabled() {
        IEditorPart ieditorpart;
        IWorkbenchPage iworkbenchpage;
        IWorkbenchWindow iworkbenchwindow;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        return iworkbench != null && (iworkbenchwindow = iworkbench.getActiveWorkbenchWindow()) != null && (iworkbenchpage = iworkbenchwindow.getActivePage()) != null && (ieditorpart = iworkbenchpage.getActiveEditor()) instanceof ComponentEditor;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public class EObjectState
    extends HashMap<EStructuralFeature, Object> {
        private static final long serialVersionUID = 7174747402142218513L;

        public EObjectState(EObject o) {
            if (o == null) {
                return;
            }
            for (EStructuralFeature f : o.eClass().getEAllStructuralFeatures()) {
                Object eGet;
                if (!f.isChangeable() || f.isDerived() || (eGet = o.eGet(f)) instanceof FeatureMap) continue;
                this.updateMap(f, eGet);
            }
        }

        private void updateMap(EStructuralFeature f, Object eGet) {
            if (eGet instanceof EList) {
                EList list = (EList)eGet;
                this.put(f, Lists.newArrayList((Iterable)list));
            } else {
                this.put(f, eGet);
            }
        }

        public void copyStateTo(EObject o) {
            for (Map.Entry e : this.entrySet()) {
                o.eSet((EStructuralFeature)e.getKey(), e.getValue());
            }
        }
    }

    protected static final class ResetAction
    extends Action {
        public ResetAction() {
            this.setToolTipText("");
            this.setDescription("");
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("empty"));
            this.setEnabled(false);
        }

        public void run() {
        }
    }
}

