/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.handlers;

import com.st.stellar.wizard.engine.extension.IWizardsEngineExtensionParser;
import com.st.stellar.wizard.engine.utils.ObjectCache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class WizardsEngineExtensionParser
implements IWizardsEngineExtensionParser {
    private static final Logger logger = LogManager.getLogger(WizardsEngineExtensionParser.class);
    private static Map<String, Image> _images = new ObjectCache(200);

    public static IExtension[] getWizardsEngineExtensions() {
        ArrayList<IExtension> list = new ArrayList<IExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.st.stellar.wizard.engine");
        if (point != null) {
            IExtension[] extensions;
            for (IExtension extension : extensions = point.getExtensions()) {
                if (!extension.isValid()) continue;
                list.add(extension);
            }
        }
        return list.toArray(new IExtension[list.size()]);
    }

    public static String getName(IExtension extension) {
        try {
            IConfigurationElement config = WizardsEngineExtensionParser.getEngineConfig(extension);
            if (config != null) {
                return config.getAttribute("name");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static String getDescription(IExtension extension) {
        IConfigurationElement[] descConfig;
        IConfigurationElement config = WizardsEngineExtensionParser.getEngineConfig(extension);
        if (config != null && (descConfig = config.getChildren("description")).length > 0) {
            return descConfig[0].getValue();
        }
        return null;
    }

    public static URL getTemplate(IExtension extension) {
        try {
            IConfigurationElement config = WizardsEngineExtensionParser.getEngineConfig(extension);
            if (config != null) {
                String template = config.getAttribute("template");
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                return bundle.getResource(template);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static Image getImage(IExtension extension) {
        try {
            IConfigurationElement config = WizardsEngineExtensionParser.getEngineConfig(extension);
            if (config != null) {
                String icon = config.getAttribute("icon");
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                URL url = bundle.getResource(icon);
                if (url != null) {
                    Image image = _images.get(url.toString());
                    if (image == null) {
                        image = new Image((Device)Display.getCurrent(), url.openStream());
                        _images.put(url.toString(), image);
                    }
                    return image;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static Image getDisabledImage(IExtension extension) {
        try {
            IConfigurationElement config = WizardsEngineExtensionParser.getEngineConfig(extension);
            if (config != null) {
                String icon = config.getAttribute("disabledIcon");
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                URL url = bundle.getResource(icon);
                if (url != null) {
                    Image image = _images.get(url.toString());
                    if (image == null) {
                        image = new Image((Device)Display.getCurrent(), url.openStream());
                        _images.put(url.toString(), image);
                    }
                    return image;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private static IConfigurationElement getEngineConfig(IExtension extension) {
        for (IConfigurationElement config : extension.getConfigurationElements()) {
            if (!config.getName().equals("WizardEngine")) continue;
            return config;
        }
        return null;
    }
}

