/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.handlers;

import com.st.stellar.wizard.engine.ui.AbstractExternalWizard;
import com.st.stellar.wizard.engine.ui.handlers.ExternalWizardDelegate;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.osgi.framework.BundleException;

public class WizardsExtensionParser {
    private static final Logger logger = LogManager.getLogger(WizardsExtensionParser.class);

    public static Object getExecutable(IExtension extension) {
        Object executable = null;
        if (extension != null) {
            IConfigurationElement[] configs;
            for (IConfigurationElement config : configs = extension.getConfigurationElements()) {
                if (!config.getName().equals("WizardEngine")) continue;
                try {
                    executable = config.createExecutableExtension("class");
                    String initialization = config.getAttribute("initialization");
                    Assert.isTrue((boolean)(executable instanceof AbstractExternalWizard));
                    if (!(executable instanceof ExternalWizardDelegate)) break;
                    AbstractExternalWizard delegate = ((ExternalWizardDelegate)executable).retrieveDelegate(initialization);
                    ((ExternalWizardDelegate)executable).setDelegate(delegate);
                }
                catch (CoreException e) {
                    logger.error((Object)e);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                }
                catch (BundleException e) {
                    logger.error((Object)e);
                }
                break;
            }
        }
        return executable;
    }
}

