/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.listeners;

import com.st.stellar.wizard.engine.ui.Activator;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;

public class MoveListener
implements Listener {
    private Point _point = null;
    private Browser _browser = null;
    private WizardsEnginePage _page = null;
    private static final Cursor cursorArrow = new Cursor((Device)Display.getDefault(), 0);
    private static Cursor cursorHand = null;

    public MoveListener(WizardsEnginePage wizardsEnginePage) {
        Browser parent;
        this._page = wizardsEnginePage;
        this._browser = parent = wizardsEnginePage.getBrowser();
        parent.addListener(3, (Listener)this);
        parent.addListener(5, (Listener)this);
        parent.addListener(4, (Listener)this);
        parent.addListener(6, (Listener)this);
        parent.addListener(7, (Listener)this);
        parent.addListener(29, (Listener)this);
        if (cursorHand == null) {
            Path location = new Path("icons/cursorHand.png");
            URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)location, null);
            if (url != null) {
                ImageDescriptor descSource = ImageDescriptor.createFromURL((URL)url);
                ImageData sourceData = descSource.getImageData();
                cursorHand = new Cursor((Device)Display.getDefault(), sourceData, 3, 3);
            }
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 6: 
            case 7: {
                this._point = null;
                this._browser.setCursor(cursorArrow);
                break;
            }
            case 3: {
                if ((event.stateMask & 0x40000) != 0) {
                    this._point = new Point(event.x, event.y);
                    this._browser.setCursor(cursorHand);
                    break;
                }
                this._point = null;
                this._browser.setCursor(cursorArrow);
                break;
            }
            case 29: {
                this._browser.setCursor(cursorArrow);
                this._point = null;
                break;
            }
            case 5: {
                if (this._point == null) {
                    return;
                }
                if ((event.stateMask & 0x40000) != 0) {
                    int deltaX = this._point.x - event.x;
                    int deltaY = this._point.y - event.y;
                    Point delta = new Point(deltaX, deltaY);
                    this.setScrollbarPos(delta);
                    this._point = new Point(event.x, event.y);
                    break;
                }
                this._point = null;
                this._browser.setCursor(cursorArrow);
                break;
            }
            case 4: {
                this._point = null;
                this._browser.setCursor(cursorArrow);
            }
        }
    }

    public void dispose() {
        this._browser.removeListener(3, (Listener)this);
        this._browser.removeListener(5, (Listener)this);
        this._browser.removeListener(4, (Listener)this);
        this._browser.removeListener(6, (Listener)this);
        this._browser.removeListener(7, (Listener)this);
        this._browser.removeListener(29, (Listener)this);
    }

    private void setScrollbarPos(Point delta) {
    }
}

