/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.widgets;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import com.st.stellar.wizard.engine.ui.listeners.DirtyListener;
import com.st.stellar.wizard.engine.ui.widgets.PropertyWidget;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class EnumWidget
extends PropertyWidget {
    private Combo combo;

    public EnumWidget(WizardsEnginePage page, Composite parent, Component component, EStructuralFeature featureID, String path) {
        super(page, parent, component, featureID, path);
    }

    @Override
    public PropertyWidget create() {
        EClassifier eClassifier;
        if (this.featureID != null && (eClassifier = this.featureID.getEType()) instanceof EEnum) {
            EEnum eEnum = (EEnum)eClassifier;
            String[] strArray = new String[eEnum.getELiterals().size()];
            ArrayList<String> list = new ArrayList<String>();
            for (EEnumLiteral c : eEnum.getELiterals()) {
                list.add(c.toString());
            }
            strArray = list.toArray(new String[list.size()]);
            this.combo = new Combo((Composite)this, 8);
            this.combo.setItems(strArray);
            Enumerator val = (Enumerator)this.page.getPropertyValue(this.path);
            int index = list.indexOf(val.getLiteral());
            this.combo.select(index);
            this.combo.setEnabled(true);
            this.combo.setLayoutData((Object)new TableWrapData(256, 32));
            this.combo.setToolTipText("");
            this.combo.addListener(13, (Listener)new DirtyListener((IFormPage)this.page, this));
            this.combo.addListener(24, (Listener)new DirtyListener((IFormPage)this.page, this));
        }
        super.setControl((Control)this.combo);
        return this;
    }

    @Override
    public void load() {
        Enumerator val = (Enumerator)this.component.eGet(this.featureID);
        this.combo.select(val.getValue());
    }

    @Override
    protected String getValue() {
        return null;
    }

    @Override
    public void commit() {
        EClassifier eClassifier;
        EObject model = this.getProperty();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
        if (this.featureID != null && (eClassifier = this.featureID.getEType()) instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, this.combo.getText());
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)this.featureID, (Object)newValue);
            editingDomain.getCommandStack().execute(command);
        }
    }
}

