/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.widgets;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import com.st.stellar.wizard.engine.ui.listeners.DirtyListener;
import com.st.stellar.wizard.engine.ui.widgets.AbstractPropertyWidget;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class PropertyWidget
extends AbstractPropertyWidget {
    private Text text;
    protected int alignment = 131072;

    public PropertyWidget(WizardsEnginePage page, Composite parent, Component component, EStructuralFeature featureID, String path) {
        super(page, parent, 0, 1);
        this.featureID = featureID;
        this.path = path;
        this.component = this.property = page.getPropertyParentFromPath((EObject)component, path);
    }

    public PropertyWidget create() {
        ETypedElement elt;
        String strValue = this.getValue();
        TableWrapData layoutData = new TableWrapData(256, 32);
        layoutData.maxWidth = 150;
        this.text = this.toolkit.createText((Composite)this, strValue, 0x800 | this.alignment);
        this.text.setEnabled(true);
        this.text.setLayoutData((Object)layoutData);
        this.text.addListener(24, (Listener)new DirtyListener((IFormPage)this.page, this));
        this.text.addListener(16, (Listener)new DirtyListener((IFormPage)this.page, this));
        if (ETypedElement.class.isInstance(this.property) && (elt = (ETypedElement)ETypedElement.class.cast(this.property)).isRequired()) {
            this.text.setMessage("Required Field");
        }
        super.setControl((Control)this.text);
        return this;
    }

    @Override
    public void commit() {
        EClassifier eClassifier;
        EObject model = this.getProperty();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
        if (this.featureID != null && (eClassifier = this.featureID.getEType()) instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier;
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            Object newValue = eFactory.createFromString(eDataType, this.text.getText());
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)this.featureID, (Object)newValue);
            editingDomain.getCommandStack().execute(command);
        }
    }
}

