/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.ui.widgets;

import com.st.stellar.component.Component;
import com.st.stellar.wizard.engine.ui.editors.WizardsEnginePage;
import com.st.stellar.wizard.engine.ui.widgets.AbstractPropertyWidget;
import com.st.stellar.wizard.engine.ui.widgets.BooleanWidget;
import com.st.stellar.wizard.engine.ui.widgets.EnumWidget;
import com.st.stellar.wizard.engine.ui.widgets.FloatWidget;
import com.st.stellar.wizard.engine.ui.widgets.LongWidget;
import com.st.stellar.wizard.engine.ui.widgets.Messages;
import com.st.stellar.wizard.engine.ui.widgets.SignedWidget;
import com.st.stellar.wizard.engine.ui.widgets.StringWidget;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class WidgetProvider {
    private WizardsEnginePage page;
    private FormEditor editor;
    private static Logger logger = LogManager.getLogger(WidgetProvider.class);

    public WidgetProvider(WizardsEnginePage page) {
        this.page = page;
        this.editor = page.getEditor();
    }

    public AbstractPropertyWidget createPropertyField(Composite parent, Component model, EStructuralFeature property, String path) {
        AbstractPropertyWidget widget = null;
        if (property instanceof EAttribute) {
            EAttribute attr = (EAttribute)property;
            EClassifier type = attr.getEType();
            if (type.getInstanceClass().equals(Integer.TYPE)) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new SignedWidget(this.page, parent, model, property, path).create();
            } else if (type.getInstanceClass().equals(Float.TYPE)) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new FloatWidget(this.page, parent, model, property, path).create();
            } else if (type.getInstanceClass().equals(Long.TYPE)) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new LongWidget(this.page, parent, model, property, path).create();
            } else if (type.getInstanceClass().equals(Boolean.TYPE)) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new BooleanWidget(this.page, parent, model, property, path).create();
            } else if (type.getInstanceClass().equals(String.class)) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new StringWidget(this.page, parent, model, property, path).create();
            } else if (type instanceof EEnum) {
                this.createLabel(parent, (ENamedElement)property);
                widget = new EnumWidget(this.page, parent, model, property, path).create();
            }
        }
        if (widget != null) {
            widget.validate();
        }
        return widget;
    }

    public AbstractPropertyWidget createPropertyField(Composite parent, Component model, List<EStructuralFeature> properties, String group, String[] paths) {
        AbstractPropertyWidget widget = null;
        Group composite = new Group(parent, 8);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setText(group);
        this.editor.getToolkit().adapt((Composite)composite);
        int i = 0;
        for (EStructuralFeature property : properties) {
            this.createPropertyField((Composite)composite, model, property, paths[i++]);
        }
        if (widget != null) {
            widget.validate();
        }
        return widget;
    }

    public void createLabel(Composite parent, ENamedElement property) {
        Label label = this.editor.getToolkit().createLabel(parent, property.getName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        label.setToolTipText(Messages.WidgetProvider_1);
    }
}

