/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.utils;

import com.st.stellar.wizard.engine.utils.Utils;
import java.io.File;
import java.io.IOException;

public class OsUtils {
    private static String OS = null;
    private static String arch = null;

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static String getArch() {
        if (arch == null) {
            arch = System.getProperty("os.arch");
        }
        return arch;
    }

    public static boolean isWindows() {
        return OsUtils.getOsName().startsWith("Windows");
    }

    public static boolean isLinux() {
        return OsUtils.getOsName().startsWith("Linux");
    }

    public static boolean isMac() {
        return OsUtils.getOsName().startsWith("Mac");
    }

    public static boolean is64() {
        return OsUtils.getArch().startsWith("x86_64") || OsUtils.getArch().startsWith("amd64");
    }

    public static File createTempFolder(String tempFolderName) throws IOException {
        boolean created;
        String destPath = System.getProperty("java.io.tmpdir");
        if (destPath == null) {
            throw new IOException("System property 'java.io.tmpdir' does not specify a tmp dir");
        }
        File tmpDir = new File(destPath + File.separator + Utils.sanitize(tempFolderName));
        if (!tmpDir.exists() && !(created = tmpDir.mkdirs())) {
            throw new IOException("Unable to create temp dir for wizard.engine: " + String.valueOf(tmpDir));
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }
}

