/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.wizard.engine.utils;

import com.st.stellar.wizard.engine.IWizardsEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.osgi.framework.Bundle;

public class Utils {
    public static final String CONSOLE_NAME = "Console";
    public static final Color DEFAULT_MESSAGE = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
    public static final Color DEFAULT_OUTPUT = new Color((Device)Display.getDefault(), new RGB(0, 0, 0));
    public static final Color DEFAULT_WARNING = new Color((Device)Display.getDefault(), new RGB(255, 100, 0));
    public static final Color DEFAULT_ERROR = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
    public static final Color DEFAULT_PATCH = new Color((Device)Display.getDefault(), new RGB(0, 100, 0));
    private static final Logger logger = LogManager.getLogger(Utils.class);
    private static final String TAG_ROOT = "root";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_FACTORY_ID = "factoryID";
    public static String REGEX_SYMBOL_NAME = "[a-zA-Z0-9_]+";
    private static final String NON_THIN = "[^iIl1\\.,']";
    public static final String C_NATURE_ID = "org.eclipse.cdt.core.cnature";

    public static Object getProjectProperty(IResource resource, QualifiedName property) throws CoreException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)property);
        Object res = null;
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if (project.exists() && project.isOpen()) {
                try {
                    res = project.getSessionProperty(property);
                }
                catch (ResourceException e) {
                    logger.error((Object)e.getMessage());
                }
            } else {
                res = null;
            }
        } else {
            IProject project = resource.getProject();
            if (project.exists() && project.isOpen()) {
                try {
                    res = project.getSessionProperty(property);
                }
                catch (ResourceException e) {
                    logger.error((Object)e.getMessage());
                }
            } else {
                res = null;
            }
        }
        return res;
    }

    public static void setProjectProperty(IResource resource, QualifiedName property, Object object) throws CoreException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)property);
        if (object != null && property.equals((Object)IWizardsEngine.PROJECT_USER_PROPERTY)) {
            Assert.isTrue((boolean)(object instanceof String));
        }
        IProject project = null;
        project = resource instanceof IProject ? (IProject)resource : resource.getProject();
        if (project.isOpen()) {
            project.setSessionProperty(property, object);
        }
    }

    public static String sanitize(Object object) {
        String dest = new String();
        if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < string.length(); ++i) {
                String c = string.substring(i, i + 1);
                dest = Pattern.matches(REGEX_SYMBOL_NAME, c) ? dest.concat(c) : dest.concat("_");
            }
        }
        return dest.toLowerCase(Locale.ENGLISH);
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        for (int i = 0; i < existing.length; ++i) {
            if (!name.equals(existing[i].getName())) continue;
            return (MessageConsole)existing[i];
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void activateConsole(MessageConsole console) {
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        try {
            IConsoleView view;
            if (page != null && (view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 2)) != null) {
                view.display((IConsole)console);
            }
        }
        catch (PartInitException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void showConsole() {
        MessageConsole console = Utils.findConsole(CONSOLE_NAME);
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        try {
            IConsoleView view;
            if (page != null && (view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 1)) != null) {
                view.display((IConsole)console);
            }
        }
        catch (PartInitException e) {
            logger.error((Object)e);
        }
    }

    private static IStatus showPropView() {
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Status.CANCEL_STATUS;
        }
        try {
            if (page != null) {
                page.showView("org.eclipse.ui.views.PropertySheet", null, 2);
            }
        }
        catch (PartInitException e) {
            logger.error((Object)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static void showPropertyView() {
        Utils.showPropertyView(true);
    }

    public static void showPropertyView(boolean delayed) {
        if (delayed) {
            new UIJob("showPropertyView"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    return Utils.showPropView();
                }
            }.schedule();
        } else {
            Utils.showPropView();
        }
    }

    public static INavigatorContentService getCNFService() {
        INavigatorContentService service = null;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            IWorkbenchPage page = activeWindow.getActivePage();
            ProjectExplorer explorer = (ProjectExplorer)page.findView("org.eclipse.ui.navigator.ProjectExplorer");
            service = explorer != null ? explorer.getNavigatorContentService() : (INavigatorContentService)PlatformUI.getWorkbench().getService(INavigatorContentService.class);
        }
        return service;
    }

    public static void activateLinkWithEditor() {
        ProjectExplorer explorer = (ProjectExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (explorer != null && !explorer.isLinkingEnabled()) {
            explorer.setLinkingEnabled(true);
        }
    }

    public static void InputStreamToFile(InputStream inputStream, String fullname, String revision) throws IOException {
        int bytesRead;
        FileOutputStream os = new FileOutputStream(fullname + revision);
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        inputStream.close();
        os.flush();
        ((OutputStream)os).close();
    }

    public static void InputStreamToFile(InputStream inputStream, String fullname) throws IOException {
        int bytesRead;
        FileOutputStream os = new FileOutputStream(fullname);
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        inputStream.close();
        os.flush();
        ((OutputStream)os).close();
    }

    public static InputStream FindEntry(String filename, ArrayList<String> bundleslist) throws IOException, URISyntaxException {
        InputStream inputStream = null;
        Bundle b = null;
        for (String bString : bundleslist) {
            b = Platform.getBundle((String)bString);
            Enumeration urlbundlefile = b.findEntries("/", filename, true);
            if (urlbundlefile == null) continue;
            URL url = (URL)urlbundlefile.nextElement();
            URI uri = url.toURI();
            Path path = new Path(uri.getPath());
            inputStream = FileLocator.openStream((Bundle)b, (IPath)path, (boolean)true);
            return inputStream;
        }
        return inputStream;
    }

    public static IFile FindIFileEntry(String filename, ArrayList<String> bundleslist) throws IOException, URISyntaxException {
        IFile pluginFile = null;
        Bundle b = null;
        for (String bString : bundleslist) {
            b = Platform.getBundle((String)bString);
            Enumeration urlbundlefile = b.findEntries("/", filename, true);
            if (urlbundlefile == null) continue;
            URL url = (URL)urlbundlefile.nextElement();
            Path location = new Path(b.getLocation() + url.getPath());
            IPath base = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            location = location.makeRelativeTo(base);
            pluginFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)location);
            return pluginFile;
        }
        return pluginFile;
    }

    public static List<String> StringToList(String string) {
        String[] words = string.split("\n");
        ArrayList<String> list = new ArrayList<String>(words.length);
        for (String s : words) {
            list.add(s);
        }
        return list;
    }

    private static int textWidth(String str) {
        return str.length() - str.replaceAll(NON_THIN, "").length() / 2;
    }

    public static Bundle FileToStringBundle(String filename, ArrayList<String> bundleslist) {
        Bundle b = null;
        String fileentry = Utils.FilePluginRootPath(filename);
        if (bundleslist == null) {
            return null;
        }
        for (String bString : bundleslist) {
            URL urlbundlefile;
            b = Platform.getBundle((String)bString);
            if (b == null || (urlbundlefile = b.getEntry(fileentry)) == null) continue;
            return b;
        }
        return null;
    }

    public static String FilePluginRootPath(String filename) {
        String linuxfilename = filename.replace('\\', '/');
        String[] filesteps = linuxfilename.split("/");
        Object out = "component/";
        boolean bLibToPatch = false;
        for (int i = 0; i < filesteps.length - 1; ++i) {
            if (filesteps[i].equals("lib")) {
                bLibToPatch = true;
            }
            if (!bLibToPatch) continue;
            out = (String)out + filesteps[i] + "/";
        }
        out = (String)out + filesteps[filesteps.length - 1];
        return out;
    }

    public static String listToString(List<String> stringlist) {
        Object out = "";
        for (int index = 0; index < stringlist.size(); ++index) {
            out = (String)out + stringlist.get(index);
            out = (String)out + "\n";
        }
        return out;
    }

    public static String ellipsize(String text, int max) {
        if (Utils.textWidth(text) <= max) {
            return text;
        }
        int end = text.lastIndexOf(32, max - 3);
        if (end == -1) {
            return text.substring(0, max - 3) + "...";
        }
        int newEnd = end;
        do {
            if ((newEnd = text.indexOf(32, (end = newEnd) + 1)) != -1) continue;
            newEnd = text.length();
        } while (Utils.textWidth(text.substring(0, newEnd) + "...") < max);
        return text.substring(0, end) + "...";
    }

    public static boolean isUDEPerspectiveAvailable() {
        return Platform.getBundle((String)"com.pls.ude.eclipse") != null;
    }

    public static String getPluginDir(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new RuntimeException("Could not resolve plugin: " + pluginId + "\r\nProbably the plugin has not been correctly installed.\r\nRunning eclipse from shell with -clean option may rectify installation.");
        }
        URL pluginURL = null;
        try {
            pluginURL = FileLocator.resolve((URL)bundle.getEntry("/"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get installation directory of the plugin: " + pluginId);
        }
        String pluginInstallDir = null;
        try {
            Path libpath = new Path(FileLocator.toFileURL((URL)pluginURL).getPath());
            pluginInstallDir = URLDecoder.decode(libpath.toOSString(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get installation directory of the plugin: " + pluginId);
        }
        if (pluginInstallDir.length() == 0) {
            throw new RuntimeException("Could not get installation directory of the plugin: " + pluginId);
        }
        return pluginInstallDir;
    }

    public static String findCFGFile(IProject project) throws CoreException {
        IFolder udeFolder = project.getFolder("UDE");
        IResource[] udeFiles = udeFolder.members();
        if (udeFiles == null) {
            return null;
        }
        for (int i = 0; i < udeFiles.length; ++i) {
            String extension = udeFiles[i].getFileExtension();
            if (extension == null || udeFiles[i].getType() != 1 || !extension.equalsIgnoreCase("cfg") || !udeFiles[i].getName().contains("stm")) continue;
            if (project.getName().toLowerCase(Locale.ENGLISH).contains("discovery")) {
                if (!udeFiles[i].getName().toLowerCase(Locale.ENGLISH).contains("discovery")) continue;
                return udeFiles[i].getName();
            }
            udeFiles[i].getName();
        }
        return null;
    }

    public static void openWizard(String id, IStructuredSelection selection) {
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
        }
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
        }
        try {
            if (descriptor != null) {
                IWorkbenchWizard wizard = descriptor.createWizard();
                wizard.init(PlatformUI.getWorkbench(), selection);
                WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                wd.setTitle(wizard.getWindowTitle());
                wd.open();
            }
        }
        catch (CoreException e) {
            logger.error((Object)e);
        }
    }

    public static XMLMemento saveWorkingSetsState(IWorkingSet[] iWorkingSets) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_ROOT);
        IWorkingSet[] iWorkingSetArray = iWorkingSets;
        int n = iWorkingSetArray.length;
        for (int i = 0; i < n; ++i) {
            IWorkingSet set;
            IWorkingSet persistable = set = iWorkingSetArray[i];
            SafeRunner.run((ISafeRunnable)new WorkingSetRunnable((IPersistableElement)persistable, memento){
                final /* synthetic */ IPersistableElement val$persistable;
                final /* synthetic */ XMLMemento val$memento;
                {
                    this.val$persistable = iPersistableElement;
                    this.val$memento = xMLMemento;
                }

                public void run() throws Exception {
                    XMLMemento dummy = XMLMemento.createWriteRoot((String)Utils.TAG_WORKING_SET);
                    dummy.putString(Utils.TAG_FACTORY_ID, this.val$persistable.getFactoryId());
                    this.val$persistable.saveState((IMemento)dummy);
                    IMemento workingSetMemento = this.val$memento.createChild(Utils.TAG_WORKING_SET);
                    workingSetMemento.putMemento((IMemento)dummy);
                }
            });
        }
        return memento;
    }

    public static void copydirExclude(File srcPath, IContainer destFolder, String[] excluded) throws IOException, CoreException {
        if (Utils.exclude(excluded, srcPath)) {
            return;
        }
        File[] files = srcPath.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (Utils.exclude(excluded, f)) continue;
            if (f.isDirectory()) {
                IFolder newFolder = destFolder.getFolder((IPath)new Path(f.getName()));
                if (!newFolder.exists()) {
                    newFolder.create(true, true, null);
                }
                Utils.copydirExclude(f, (IContainer)newFolder, excluded);
                continue;
            }
            IFile newFile = destFolder.getFile((IPath)new Path(f.getName()));
            if (newFile.exists()) {
                newFile.delete(true, null);
            }
            newFile.create((InputStream)new FileInputStream(f), true, null);
        }
    }

    private static boolean exclude(String[] excluded, File srcPath) {
        for (String s : excluded) {
            if (!srcPath.getName().contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void setReadonly(IFolder folder) {
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    ResourceAttributes attrs = resource.getResourceAttributes();
                    attrs.setReadOnly(true);
                    resource.setResourceAttributes(attrs);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String normalizeSlashes(String source) {
        return source != null ? source.replace("\\", "/") : null;
    }

    public static File createTempFolder(String folderName) throws IOException {
        boolean created;
        String destPath = System.getProperty("java.io.tmpdir");
        if (destPath == null) {
            throw new IOException("System property 'java.io.tmpdir' does not specify a tmp dir");
        }
        File tmpDir = new File(destPath + File.separator + Utils.sanitize(folderName));
        if (!tmpDir.exists() && !(created = tmpDir.mkdirs())) {
            throw new IOException("Unable to create temp dir for Wizards Engine: " + String.valueOf(tmpDir));
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    public static void copyfile(String srFile, String dtFile) throws IOException {
        byte[] buf = new byte[1024];
        srFile = URLDecoder.decode(srFile, "utf-8");
        dtFile = URLDecoder.decode(dtFile, "utf-8");
        FileInputStream in = new FileInputStream(new File(srFile));
        FileOutputStream out = new FileOutputStream(new File(dtFile));
        try {
            int len;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("An exception occurred while copying file");
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    static abstract class WorkingSetRunnable
    implements ISafeRunnable {
        WorkingSetRunnable() {
        }

        public void handleException(Throwable exception) {
            logger.error((Object)exception.getMessage());
        }
    }
}

