function wizEngChangeProperty(event,arg,value) {
	var href = arg;
	if( arg === "inherited" || typeof(arg) === "undefined") {
		var elt = event.target.parentNode;
		href = elt.getAttribute("href");
		while( href === null ) {
			elt = elt.parentNode;
			href = elt.getAttribute("href");
		}
	}
	if( javaSetPropertyValue ) {
		javaSetPropertyValue(href,value);
	}
}
	
function wizEngGetAbsolutePosition(element) {
		var r = { x: element.screenX, y: element.screenY };
		return r;
	  }
	  
function wizEngCallMenu(event,arg) {
	if( javaMenuChangeProperty ) {
		var href = arg;
		if( arg === "inherited" || typeof(arg) === "undefined") {
			var elt = event.target.parentNode;
			href = elt.getAttribute("href");
			while( href === null ) {
				elt = elt.parentNode;
				href = elt.getAttribute("href");
			}
		}
		var pos = wizEngGetAbsolutePosition(event);
		x = pos.x;
		y = pos.y;
		javaMenuChangeProperty(href,x,y);
	}
}

function wizEngDisplayTooltip(event,arg) {
	if( javaDisplayTooltip ) {
		var tooltipMsg = arg;
		var pos = wizEngGetAbsolutePosition(event);
		x = pos.x;
		y = pos.y;
		javaDisplayTooltip(tooltipMsg,x,y);
	}
}

function wizEngCallEdit(event,arg) {
	if( EditPropertyFunction ) {
		var href = arg;
		if( arg === "inherited" || typeof(arg) === "undefined") {
			var elt = event.target.parentNode;
			href = elt.getAttribute("href");
			while( href === null ) {
				elt = elt.parentNode;
				href = elt.getAttribute("href");
			}
		}
		var pos = wizEngGetAbsolutePosition(event);
		x = pos.x;
		y = pos.y;
		EditPropertyFunction(href,x,y);
	}
}

function wizEngCallSet(event,arg) {
	if( javaSetProperty ) {
		var href = arg;
		if( arg === "inherited" || typeof(arg) === "undefined") {
			var elt = event.target.parentNode;
			href = elt.getAttribute("href");
			while( href === null ) {
				elt = elt.parentNode;
				href = elt.getAttribute("href");
			}
		}
		var pos = wizEngGetAbsolutePosition(event);
		x = pos.x;
		y = pos.y;
		javaSetProperty(href,arg);
	}
}

function wizEngGetPropertyValue(event,arg) {
	var args = Array.prototype.slice.call(arguments, 2);
	if( javaGetPropertyValue ) {
		return javaGetPropertyValue(arg);
	}
}

function wizEngGetPropertyValueDiv(event,arg) {
	var args = Array.prototype.slice.call(arguments, 2);
	if( javaGetPropertyValue ) {
		var calc = javaGetPropertyValue(arg);
		calc = (parseInt(calc, 10) / 1000000);
		return calc;
	}
}

function wizEngGetPropertyError(event,arg) {
	var args = Array.prototype.slice.call(arguments, 2);
	if( javaGetPropertyError ) {
		return javaGetPropertyError(arg);
	}
}



// Simulated events on javascript objects
// Thanks to http://stackoverflow.com/questions/6157929/how-to-simulate-a-mouse-click-using-javascript
function simulatedClick(target, optionsArg) {
	  var event = target.ownerDocument.createEvent('MouseEvents'),
	      options = optionsArg || {},
	      opts = { // These are the default values, set up for un-modified left clicks
	        type: 'mouseover',
	        canBubble: true,
	        cancelable: true,
	        view: target.ownerDocument.defaultView,
	        detail: 1,
	        screenX: 0, //The coordinates within the entire page
	        screenY: 0,
	        clientX: 0, //The coordinates within the viewport
	        clientY: 0,
	        ctrlKey: false,
	        altKey: false,
	        shiftKey: false,
	        metaKey: false, //I *think* 'meta' is 'Cmd/Apple' on Mac, and 'Windows key' on Win. Not sure, though!
	        button: 0, //0 = left, 1 = middle, 2 = right
	        relatedTarget: null,
	      };

	  //Merge the options with the defaults
	  for (var key in optionsArg) {
	    if (optionsArg.hasOwnProperty(key)) {
	      opts[key] = optionsArg[key];
	    }
	  }

	  //Pass in the options
	  event.initMouseEvent(
	      opts.type,
	      opts.canBubble,
	      opts.cancelable,
	      opts.view,
	      opts.detail,
	      opts.screenX,
	      opts.screenY,
	      opts.clientX,
	      opts.clientY,
	      opts.ctrlKey,
	      opts.altKey,
	      opts.shiftKey,
	      opts.metaKey,
	      opts.button,
	      opts.relatedTarget
	  );

	  //Fire the event
	  target.dispatchEvent(event);
	  //logerror('done');
	}

function simulate(element, eventName)
{
    var options = extend(defaultOptions, arguments[2] || {});
    var oEvent, eventType = null;

    for (var name in eventMatchers)
    {
        if (eventMatchers[name].test(eventName)) { eventType = name; break; }
    }

    if (!eventType)
        throw new SyntaxError('Only HTMLEvents and MouseEvents interfaces are supported');

    if (document.createEvent)
    {
        oEvent = document.createEvent(eventType);
        if (eventType == 'HTMLEvents')
        {
            oEvent.initEvent(eventName, options.bubbles, options.cancelable);
        }
        else
        {
            oEvent.initMouseEvent(eventName, options.bubbles, options.cancelable, document.defaultView,
            options.button, options.pointerX, options.pointerY, options.pointerX, options.pointerY,
            options.ctrlKey, options.altKey, options.shiftKey, options.metaKey, options.button, element);
        }
        element.dispatchEvent(oEvent);
    }
    else
    {
        options.clientX = options.pointerX;
        options.clientY = options.pointerY;
        var evt = document.createEventObject();
        oEvent = extend(evt, options);
        element.fireEvent('on' + eventName, oEvent);
    }
    return element;
}

function extend(destination, source) {
    for (var property in source)
      destination[property] = source[property];
    return destination;
}

var eventMatchers = {
    'HTMLEvents': /^(?:load|unload|abort|error|select|change|submit|reset|focus|blur|resize|scroll)$/,
    'MouseEvents': /^(?:click|dblclick|mouse(?:down|up|over|move|out))$/
}
var defaultOptions = {
    pointerX: 0,
    pointerY: 0,
    button: 0,
    ctrlKey: false,
    altKey: false,
    shiftKey: false,
    metaKey: false,
    bubbles: true,
    cancelable: true
}
