/**
 * List of available functions:
 * javaChangeCursor
 * javaDisplayTooltip
 * EditPropertyFunction
 * javaGetPropertyError
 * javaGetPropertyValue
 * javaGotoPropertyEditionPage
 * javaMenuChangeProperty
 * javaSetPropertyValue
 * javaWizardInit
 */

let Wizard = {};
Wizard.svg = null;
Wizard.svgDoc = null;


function freq_conversion(a) {
	if (a>=1000000) {
		return Math.round((a/1000000)*100)/100+" MHz";
	}
	else if (a>=1000)
	{
		return Math.round((a/1000)*100)/100+" kHz";
	}
	else
	{
		return Math.round((a)*100)/100+" Hz";
	}
}

function wizIntSetCursorByID(id, cursorStyle) {
	var elem;
	if (document.getElementById && (elem = document.getElementById(id))) {
		if (elem.style) {
			elem.style.cursor = cursorStyle;
		}
	}
}

function wizIntChangeStroke(elt, oldStroke, newStroke) {
	if( elt ) {
		var str = elt.getAttribute('style');
		var res = str.replace(oldStroke, newStroke);
		elt.setAttribute('style', res);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntChangeColor(elem, color) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt ) {
		elt.style.setProperty('fill', color, null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntChangeCursor(event) {
	event.target.style.cursor = 'pointer';
}

function wizIntCursorDefault(event) {
	event.target.style.cursor = 'default';
	javaChangeCursor('default');
}

function wizIntRedToggle(event) {
	var elem = event.target;
	if (elem.style.stroke != "rgb(255, 0, 0)") {
		// logerror("alert1 : ");
		elem.style.stroke = "rgb(255, 0, 0)";
	} else {
		// logerror("alert : ");
		elem.style.stroke = "none";
	}
}

function wizIntRedToggleElem(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		if (elt.style.stroke != "rgb(255, 0, 0)") {
			elt.style.stroke = "rgb(255, 0, 0)";
		} else {
			elt.style.stroke = "rgb(0, 0, 0)";
		}
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntRedElem(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.stroke = "rgb(255, 0, 0)";
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntRedoffElem(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.stroke = "rgb(0, 0, 0)";
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntBlueElem(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty('opacity','0.6', null);
		elt.style.setProperty('stroke-line-join','round', null);
		elt.style.setProperty('stroke-width','0.5', null);
		var blue = "#0000FF";
		elt.style.setProperty('stroke', blue, null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntErrorElem(elem, errorValue) {
	var leaveColor = "#FFFFFF";
	var enterColor = "#c8ffff";

	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty('opacity','1', null);
		elt.style.setProperty('stroke-line-join','round', null);
		elt.style.setProperty('stroke-width','0.5', null);
		var red = "#FF0000";
		elt.style.setProperty('stroke', red, null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntGreyElem(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty('opacity','0.6', null);
		elt.style.setProperty('stroke-line-join','round', null);
		elt.style.setProperty('stroke-width','0.5', null);
		var blue = "#0000FF";
		elt.style.setProperty('stroke', blue, null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntCheckColor(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt ) {
		return elt.style.getPropertyValue('stroke');
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntGetVisible(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		return elt.style.getPropertyValue('display');
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntDashDisable(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty("stroke-dasharray", "none", null);
		elt.style.setProperty('stroke-opacity', "1", null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntDashEnable(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty("stroke-dasharray", "2, 3", null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntDashEmpty(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if( elt) {
		elt.style.setProperty('stroke-opacity', "0", null);
	} else {
		logerror("Cannot find element: "+elem);
	}
}

function wizIntToggleDisplay(elem) {
	var elt = Wizard.svgDoc.getElementById(elem);
	if (elt.style.display == "inline") {
		elt.style.display = "none";
	} else {
		elt.style.display = "inline";
	}
	;
}

function wizIntDisplayOff(elem) {

	;
	if (elem) {
		var elt = Wizard.svgDoc.getElementById(elem);
		if (elt) {
			elt.style.display = "none";
		} else {
			logerror("wizIntDisplayOff: please provide a valid element id ("
					+ elem + " does not exist)");
		}
	}
}

function wizIntDisplayOn(elem) {

	;
	if (elem) {
		var elt = Wizard.svgDoc.getElementById(elem);
		if (elt) {
			elt.style.display = "inline";
		} else {
			logerror("wizIntDisplayOn: please provide a valid element id (" + elem
					+ " does not exist)");
		}
	}
}

function wizIntDisplayChoiceElem(selectElt, elem, toggleElt) {

	;
	var elt = Wizard.svgDoc.getElementById(toggleElt);
	for (e = 0; e < elem.length; e++) {
		if (selectElt == elem[e]) {
			elt.style.display = "inline";
			break;
		} else {
			elt.style.display = "none";
		}
	}
}

function manageSelectionError(Value, SelA, ValA) {
/* 	var colorError = "rgb(255, 0, 0)";
	var colorBlack = "rgb(0, 0, 0)";

	if( ValA && ValA.length > 0 && ValA[0] == '!' ) {
		
		if( ValA.substring(1) == Value) {
			var elt = Wizard.svgDoc.getElementById(SelA);
			var errorValue = "wrong selection: '"+Value+"'";
			elt.style.setProperty('stroke', colorError, null);
			elt.style.setProperty("stroke-dasharray", "none", null);
			elt.style.setProperty('stroke-opacity', "1", null);
	
			elt.parentNode.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, errorValue);
			};
		
		} else {
			var elt = Wizard.svgDoc.getElementById(SelA);
			elt.style.setProperty('stroke', colorBlack, null);
			elt.parentNode.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, '');
			}
		}
	} else {
		var elt = Wizard.svgDoc.getElementById(SelA);
		elt.style.setProperty('stroke', colorBlack, null);
		elt.parentNode.onmouseover = function(evt) {
			wizEngDisplayTooltip(evt, '');
		}
	}
 */}

function wizIntMUX21Selection(PropertyPath, SelA, SelB, ValA, ValB) 
{
	var Value = wizEngGetPropertyValue('',PropertyPath);
	if( Value == null ) {
		logerror('Cannot find: '+PropertyPath);
	}
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		console.log(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		console.log(SelB);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
}

function wizIntMUX31Selection(PropertyPath, SelA, SelB, SelC, ValA,
		ValB, ValC) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
}

function wizIntMUX41Selection(PropertyPath, SelA, SelB, SelC, SelD,
		ValA, ValB, ValC, ValD) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
}

function wizIntMUX51Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, ValA,
		ValB, ValC, ValD, ValE) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	}

	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
}

function wizIntMUX61Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, 
		ValA, ValB, ValC, ValD, ValE, ValF) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
}

function wizIntMUX71Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
}


function wizIntMUX81Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG, SelH,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG, ValH) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	wizIntDashEmpty(SelH);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	case ValH:
		wizIntDashDisable(SelH);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
	manageSelectionError(Value, SelH, ValH);
}

function wizIntMUX111Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG, SelH, SelI, SelJ, SelK,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG, ValH, ValI, ValJ, ValK) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	wizIntDashEmpty(SelH);
	wizIntDashEmpty(SelI);
	wizIntDashEmpty(SelJ);
	wizIntDashEmpty(SelK);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	case ValH:
		wizIntDashDisable(SelH);
		break;
	case ValI:
		wizIntDashDisable(SelI);
		break;
	case ValJ:
		wizIntDashDisable(SelJ);
		break;
	case ValK:
		wizIntDashDisable(SelK);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
	manageSelectionError(Value, SelH, ValH);
	manageSelectionError(Value, SelI, ValI);
	manageSelectionError(Value, SelJ, ValJ);
	manageSelectionError(Value, SelK, ValK);
}


function wizIntMUX121Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG, SelH, SelI, SelJ, SelK, SelL,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG, ValH, ValI, ValJ, ValK, ValL) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	wizIntDashEmpty(SelH);
	wizIntDashEmpty(SelI);
	wizIntDashEmpty(SelJ);
	wizIntDashEmpty(SelK);
	wizIntDashEmpty(SelL);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	case ValH:
		wizIntDashDisable(SelH);
		break;
	case ValI:
		wizIntDashDisable(SelI);
		break;
	case ValJ:
		wizIntDashDisable(SelJ);
		break;
	case ValK:
		wizIntDashDisable(SelK);
		break;
	case ValL:
		wizIntDashDisable(SelL);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
	manageSelectionError(Value, SelH, ValH);
	manageSelectionError(Value, SelI, ValI);
	manageSelectionError(Value, SelJ, ValJ);
	manageSelectionError(Value, SelK, ValK);
	manageSelectionError(Value, SelL, ValL);
}

function wizIntMUX141Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG, SelH, SelI, SelJ, SelK, SelL, SelM, SelN,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG, ValH, ValI, ValJ, ValK, ValL, ValM, ValN) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	wizIntDashEmpty(SelH);
	wizIntDashEmpty(SelI);
	wizIntDashEmpty(SelJ);
	wizIntDashEmpty(SelK);
	wizIntDashEmpty(SelL);
	wizIntDashEmpty(SelM);
	wizIntDashEmpty(SelN);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	case ValH:
		wizIntDashDisable(SelH);
		break;
	case ValI:
		wizIntDashDisable(SelI);
		break;
	case ValJ:
		wizIntDashDisable(SelJ);
		break;
	case ValK:
		wizIntDashDisable(SelK);
		break;
	case ValL:
		wizIntDashDisable(SelL);
		break;
	case ValM:
		wizIntDashDisable(SelM);
		break;
	case ValN:
		wizIntDashDisable(SelN);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
	manageSelectionError(Value, SelH, ValH);
	manageSelectionError(Value, SelI, ValI);
	manageSelectionError(Value, SelJ, ValJ);
	manageSelectionError(Value, SelK, ValK);
	manageSelectionError(Value, SelL, ValL);
	manageSelectionError(Value, SelM, ValM);
	manageSelectionError(Value, SelN, ValN);
}


function wizIntMUX151Selection(PropertyPath, SelA, SelB, SelC, SelD, SelE, SelF, SelG, SelH, SelI, SelJ, SelK, SelL, SelM, SelN, SelO,
		ValA, ValB, ValC, ValD, ValE, ValF, ValG, ValH, ValI, ValJ, ValK, ValL, ValM, ValN, ValO) {
	var Value = wizEngGetPropertyValue('',PropertyPath);
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	wizIntDashEmpty(SelE);
	wizIntDashEmpty(SelF);
	wizIntDashEmpty(SelG);
	wizIntDashEmpty(SelH);
	wizIntDashEmpty(SelI);
	wizIntDashEmpty(SelJ);
	wizIntDashEmpty(SelK);
	wizIntDashEmpty(SelL);
	wizIntDashEmpty(SelM);
	wizIntDashEmpty(SelN);
	wizIntDashEmpty(SelO);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	case ValE:
		wizIntDashDisable(SelE);
		break;
	case ValF:
		wizIntDashDisable(SelF);
		break;
	case ValG:
		wizIntDashDisable(SelG);
		break;
	case ValH:
		wizIntDashDisable(SelH);
		break;
	case ValI:
		wizIntDashDisable(SelI);
		break;
	case ValJ:
		wizIntDashDisable(SelJ);
		break;
	case ValK:
		wizIntDashDisable(SelK);
		break;
	case ValL:
		wizIntDashDisable(SelL);
		break;
	case ValM:
		wizIntDashDisable(SelM);
		break;
	case ValN:
		wizIntDashDisable(SelN);
		break;
	case ValO:
		wizIntDashDisable(SelO);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	manageSelectionError(Value, SelE, ValE);
	manageSelectionError(Value, SelF, ValF);
	manageSelectionError(Value, SelG, ValG);
	manageSelectionError(Value, SelH, ValH);
	manageSelectionError(Value, SelI, ValI);
	manageSelectionError(Value, SelJ, ValJ);
	manageSelectionError(Value, SelK, ValK);
	manageSelectionError(Value, SelL, ValL);
	manageSelectionError(Value, SelM, ValM);
	manageSelectionError(Value, SelN, ValN);
	manageSelectionError(Value, SelO, ValO);
}

function wizIntMUX41SelectionEnabled(PropertyPath, isEnabled, rectId, SelA, SelB, SelC, SelD,
		ValA, ValB, ValC, ValD) {
	
	var Value = wizEngGetPropertyValue('',PropertyPath);
	var colorIn = '#E8F2FE';
	var colorEnabled = '#ffffff';
	var colorDisabled = '#c8c8c8';
	wizIntDashEmpty(SelA);
	wizIntDashEmpty(SelB);
	wizIntDashEmpty(SelC);
	wizIntDashEmpty(SelD);
	
	if( !isEnabled ) {
		wizIntChangeColor(rectId,colorDisabled);
		
	} else {
	wizIntChangeColor(rectId,colorEnabled);
	switch (Value) {
	case ValA:
		wizIntDashDisable(SelA);
		break;
	case ValB:
		wizIntDashDisable(SelB);
		break;
	case ValC:
		wizIntDashDisable(SelC);
		break;
	case ValD:
		wizIntDashDisable(SelD);
		break;
	}
	manageSelectionError(Value, SelA, ValA);
	manageSelectionError(Value, SelB, ValB);
	manageSelectionError(Value, SelC, ValC);
	manageSelectionError(Value, SelD, ValD);
	}
}

function wizIntGetPropertyValue(pathToProperty, objectId, formatFunction) {
	var colorError = "rgb(255, 0, 0)";
	var colorBlack = "rgb(0, 0, 0)";
	
	var propertyObject = Wizard.svgDoc.getElementById(objectId);
	if( propertyObject ) {
		var value_string = wizEngGetPropertyValue('', pathToProperty);
		if (formatFunction) {
			value_string = formatFunction(value_string);
		}
		propertyObject.textContent = value_string;
		var errorValue = wizEngGetPropertyError('', pathToProperty);
		if (errorValue.length > 0) {
			propertyObject.style.setProperty("fill", colorError, null);
			propertyObject.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, errorValue);
			};
		} else {
			propertyObject.style.setProperty("fill", colorBlack, null);
			propertyObject.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt, '');
			};
		}
		propertyObject.onmouseout = function(evt) {
			wizEngDisplayTooltip(evt, '');
		};
	} else {
		logerror('cannot find SVG id "'+objectId+'"');
	}
}

function wizIntEditPropertyValue(pathToProperty, editObjectId, rectId, isEnabledMechanism, isEnabledState) {
	
	var leaveColor = "#FFFFFF";
	var enterColor = "#c8ffff";
	var disabledColor = "#c8c8c8";
	
	// Get the SVG object from its id
	var propertyObject = Wizard.svgDoc.getElementById(editObjectId);

	if( propertyObject ) {

		var errorValue = wizEngGetPropertyError('', pathToProperty);

		// Change the rectangle color only if rectangle exists
		if (rectId) {
			wizIntChangeColor(rectId, leaveColor);
			if( errorValue.length > 0) {
				wizIntErrorElem(rectId, errorValue);
			} else {
				wizIntBlueElem(rectId);
				if( javaDisplayTooltip ) {
					javaDisplayTooltip('',0,0);
				}
			}
		}

		if (rectId) {
			if (isEnabledMechanism){
				if (isEnabledState){
					wizIntChangeColor(rectId, leaveColor);
				}
				else{
					wizIntChangeColor(rectId, disabledColor);
				}
			}
			else {
				wizIntChangeColor(rectId, leaveColor);
			} 
		}
		
		// Change color of rectangle when the mouse cursor enters or leaves
		propertyObject.onmouseover = function(evt) {
			wizIntChangeCursor(evt);
			wizEngDisplayTooltip(evt, errorValue);
			if (rectId) {
				wizIntChangeColor(rectId, enterColor);
			}
		};
		propertyObject.onmouseout = function(evt) {
			if (rectId) {
				if (isEnabledMechanism){
					if (isEnabledState){
						wizIntChangeColor(rectId, leaveColor);
					}
					else{
						wizIntChangeColor(rectId, disabledColor);
					}
				}
				else {
				wizIntChangeColor(rectId, leaveColor);
				}
				if( javaDisplayTooltip ) {
					javaDisplayTooltip('',0,0);
				}
			}
		};

		
		// left and right clicks produce the same effect:
		// displaying a menu described by the property paths
		propertyObject.oncontextmenu = function(evt) {
			wizEngCallEdit(evt, pathToProperty);
			wizInit();
		};
		propertyObject.onclick = function(evt) {
			wizEngCallEdit(evt, pathToProperty);
			wizInit();
		};
	} else {
		logerror('cannot find SVG id "'+editObjectId+'"');
	}
}

/**
 * 
 * Call wizIntEditPropertyValue function, using the enable mechanism
 * 
 * 
 *
 * @param pathToProperty the description of the paths to the properties to be modified
 * @param editObjectId
 *            the id of a SVG object on which the interaction is activated
 * @param rectId
 *            the id of the rectangle containing the graphical element to
 *            animate NB: rectId may be null if no animation is expected
 * @param isEnabled
 * 			  the enabled state of the selector          
 *            
 * @return
 */
function wizIntEditPropertyValueEnabled(pathToProperty, editObjectId, rectId, isEnabled) {
	
	wizIntEditPropertyValue(pathToProperty, editObjectId, rectId, true, isEnabled);
	
}

/**
 * Prepare a contextual menu from a description of the interaction.
 * 
 * Both left click and right click trigger the display of the contextual menu.
 * 
 * The background of the rectangle 'rectId' will be changed whenever the mouse
 * pointer enters or exits it.
 * 
 * Property paths description is defined as in the following example:
 * "menu:{<entry1>:function1(<path-to-prop1>), 
 *        <entry2>:function2(<path-to-prop2>),
 *        ... 
 *        <entryN>:functionN(<path-to-propN>) }"
 * Where:
 * - <entryX> will be the labels displayed in the contextual menus,
 * - functionY to functionN will be javascript functions that will be called when the user
 * chooses the corresponding menu entry,
 * - <path-to-propZ>: the XPATH expression identifying a property inside
 * the configuration model.
 * 
 * Example:
 * 		 wizIntCallMenu('menu:{Goto Clock init settings...:javaGotoPropertyEditionPage(instance[id=\'com.st.java.components.clock.java60bcxx_rla\']/initialization_settings)}','rect_CMU_512k');
 *
 * @see for a list of available predefined functions.
 * Other functions must be written inside the file component.js in the 
 * component plugin referred by the path to property.  
 *
 * @param propertyPaths
 *            the description of the properties
 * @param editObjectId
 *            the id of a SVG object on which the interaction is activated
 * @param rectId
 *            the id of the rectangle containing the graphical element to
 *            animate NB: rectId may be null if no animation is expected
 * @param message
 *            the tooltip message to be displayed when the mouse hovers the SVG
 *            graphical object. Message may be null: in that case no tooltip is
 *            displayed.
 * 
 * @return NA
 */
function wizIntCallMenu(propertyPaths, editObjectId, rectId, message) {

	var leaveColor = "#FFFFFF";
	var enterColor = "#c8ffff";
	
	// Change the rectangle color only if rectangle exists
	if (rectId) {
		wizIntChangeColor(rectId, leaveColor);
		wizIntBlueElem(rectId);		
	}

	// Get SVG property object from its id

	;
	var propertyObject = Wizard.svgDoc.getElementById(editObjectId);
	
	if( propertyObject ) {
		// Change color of rectangle when the mouse cursor enters or leaves
		propertyObject.onmouseover = function(evt) {
			wizIntChangeCursor(evt);
			if (rectId) {
				wizIntChangeColor(rectId, enterColor);
				wizIntBlueElem(rectId);
			}
	
			// Display tooltip only if necessary
			if (message) {
				wizEngDisplayTooltip(evt, message);
			}
		};
		propertyObject.onmouseout = function(evt) {
			if (rectId) {
				wizIntChangeColor(rectId, leaveColor);
			}
			wizEngDisplayTooltip(evt, '');
		};
	
		// left and right clicks produce the same effect:
		// displaying a menu described by the property paths
		propertyObject.oncontextmenu = function(evt) {
			wizEngCallMenu(evt, propertyPaths);
			wizEngDisplayTooltip(evt, '');
		};
		propertyObject.onclick = function(evt) {
			wizEngCallMenu(evt, propertyPaths);
			wizEngDisplayTooltip(evt, '');
		};
	} else {
		logerror('cannot find SVG id "'+editObjectId+'"');
	}

}

function wizIntAnimateColorBox(isEnabled,rectId,colorIn,colorEnabled,colorDisabled,enabledObjectId,message) {

	;
	var rectObj = Wizard.svgDoc.getElementById(rectId);
	wizIntBlueElem(rectId);

	rectObj.onmouseover = function(evt) {
		wizIntChangeCursor(evt);
		wizIntChangeColor(rectId,colorIn);
		if( message ) {
			wizEngDisplayTooltip(evt,message);
		}
	};
	wizIntChangeColor(rectId,colorEnabled);
	rectObj.onmouseout = function(evt) {
		if( isEnabled ) {
			wizIntChangeColor(rectId,colorEnabled);
		} else {
			wizIntChangeColor(rectId,colorDisabled);
		}
		if( message ) {
			wizEngDisplayTooltip(evt,'');
		}
		wizIntBlueElem(rectId);
	};
	if( isEnabled ) {
		wizIntDisplayOn(enabledObjectId);
		wizIntChangeColor(rectId,colorEnabled);
	} else {
		wizIntDisplayOff(enabledObjectId);
		wizIntChangeColor(rectId,colorDisabled);
	}
}



function wizIntNoAnimationOn(rectId,msg) {
	if( rectId) {
	

		var rectObj = Wizard.svgDoc.getElementById(rectId);
		if( rectObj ) {
			wizIntChangeColor(rectId,"#ffffff");
			//rectObj.style.setProperty('opacity','0.7', null);
			//rectObj.style.setProperty('fill',"#c8c8c8",null);

			rectObj.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt,msg+'\n'+'No available configuration for this element');
			};
			rectObj.onmouseout = function(evt) {
				wizEngDisplayTooltip(evt,'');
			};
		} else {
			logerror(rectId+"does not exist in svg file");
		}
	}
}

function wizIntSimpleToolTip(rectId,msg) {
	if( rectId) {
	

		var rectObj = Wizard.svgDoc.getElementById(rectId);
		if( rectObj ) {
			//wizIntChangeColor(rectId,"#ffffff");

			rectObj.onmouseover = function(evt) {
				wizEngDisplayTooltip(evt,msg);
			};
			rectObj.onmouseout = function(evt) {
				wizEngDisplayTooltip(evt,'');
			};
		} else {
			logerror(rectId+"does not exist in svg file");
		}
	}
}

function wizIntSetPropertyValue(pathToProperty, editObjectId, value, rectId) {
	
	var leaveColor = "#FFFFFF";
	var enterColor = "#c8ffff";
	var disabledColor = "#c8c8c8";
	
	// Get the SVG object from its id

	;
	var propertyObject = Wizard.svgDoc.getElementById(editObjectId);

	// Change the rectangle color only if rectangle exists
	if (rectId) {
		wizIntChangeColor(rectId, leaveColor);
		wizIntBlueElem(rectId);
//		if( javaDisplayTooltip ) {
//			javaDisplayTooltip('',0,0);
//		}
	}

	if( propertyObject ) {
		
		if (rectId) {
			wizIntChangeColor(rectId, leaveColor);
		}
		
		// Change color of rectangle when the mouse cursor enters or leaves
		propertyObject.onmouseover = function(evt) {
			wizIntChangeCursor(evt);
			if (rectId) {
				wizIntChangeColor(rectId, enterColor);
			}
		};
		propertyObject.onmouseout = function(evt) {
			if (rectId) {
				wizIntChangeColor(rectId, leaveColor);
				if( javaDisplayTooltip ) {
					javaDisplayTooltip('',0,0);
				}
			}
		};
		
		// left and right clicks produce the same effect:
		// displaying a menu described by the property paths
		propertyObject.oncontextmenu = function(evt) {
			wizEngChangeProperty(evt, pathToProperty, value);
			wizInit();
		};
		propertyObject.onclick = function(evt) {
			wizEngChangeProperty(evt, pathToProperty, value);
			wizInit();
		};
	} else {
		logerror('cannot find SVG id "'+editObjectId+'"');
	}
}


function wizIntCallMenu(propertyPaths, editObjectId, rectId, message) {

	var leaveColor = "#FFFFFF";
	var enterColor = "#c8ffff";
	

	;
	// Change the rectangle color only if rectangle exists
	if (rectId) {
		wizIntChangeColor(rectId, leaveColor);
		wizIntBlueElem(rectId);		
	}

	// Get SVG property object from its id
	var propertyObject = Wizard.svgDoc.getElementById(editObjectId);
	
	if( propertyObject ) {
		// Change color of rectangle when the mouse cursor enters or leaves
		propertyObject.onmouseover = function(evt) {
			wizIntChangeCursor(evt);
			if (rectId) {
				wizIntChangeColor(rectId, enterColor);
				wizIntBlueElem(rectId);
			}
	
			// Display tooltip only if necessary
			if (message) {
				wizEngDisplayTooltip(evt, message);
			}
		};
		propertyObject.onmouseout = function(evt) {
			if (rectId) {
				wizIntChangeColor(rectId, leaveColor);
			}
			wizEngDisplayTooltip(evt, '');
		};
	
		// left and right clicks produce the same effect:
		// displaying a menu described by the property paths
		propertyObject.oncontextmenu = function(evt) {
			wizEngCallMenu(evt, propertyPaths);
			wizEngDisplayTooltip(evt, '');
		};
		propertyObject.onclick = function(evt) {
			wizEngCallMenu(evt, propertyPaths);
			wizEngDisplayTooltip(evt, '');
		};
	} else {
		logerror('cannot find SVG id "'+editObjectId+'"');
	}
}
