/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.resources;

import com.st.stellar.app.wizard.resources.Activator;
import com.st.stellar.app.wizard.resources.Messages;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.resources.types.DeviceType;
import com.st.stellar.app.wizard.resources.types.ShieldType;
import com.st.stellar.exceptions.StellarException;
import com.st.stellar.extensions.res.handlers.StellarResourceType;
import com.st.stellar.extensions.res.handlers.StellarResources;
import com.st.stellar.utils.LogManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class StellarSupportedProducts {
    private static StellarSupportedProducts instance;
    private static ImageRegistry registry;
    public static final String LINE_ALL;
    public static final String DEVICE_ALL;
    public static final String SHIELDS_ALL;
    public static final String FAMILIES_ALL;
    private static ArrayList<BoardType> BOARDS;
    private static ArrayList<String> FAMILIES;
    private static ArrayList<String> FAMILIES_IDS;
    private static SortedMap<String, String> _linesMap;
    private static ArrayList<DeviceType> DEVICES;
    private static ArrayList<ShieldType> SHIELDS;

    protected StellarSupportedProducts() {
        this.initializeBoards();
        this.initializeLines();
        this.initializeFamilies();
        this.initializeDevices();
        this.initializeShields();
    }

    private void initializeLines() {
        this.registerImage(LINE_ALL, "Stellar_Family.png");
        List<StellarResourceType> resources = StellarResources.getResourcesByType(StellarResources.SUPPORTED[1]);
        for (StellarResourceType resource : resources) {
            String name = resource.getName();
            String id = resource.getId();
            Image image = (Image)resource.getResource();
            if (this.checkLineIdDouble(id)) continue;
            registry.put(id, image);
            _linesMap.put(id, name);
        }
        _linesMap.put(LINE_ALL, LINE_ALL);
    }

    private void initializeFamilies() {
        this.registerImage(FAMILIES_ALL, "Stellar_Family.png");
        FAMILIES.add(FAMILIES_ALL);
        FAMILIES_IDS.add(FAMILIES_ALL);
        List<StellarResourceType> resources = StellarResources.getResourcesByType(StellarResources.SUPPORTED[4]);
        for (StellarResourceType resource : resources) {
            String name = resource.getName();
            String id = resource.getId();
            Image image = (Image)resource.getResource();
            if (this.checkFamilyIdDouble(id)) continue;
            registry.put(id, image);
            FAMILIES.add(name);
            FAMILIES_IDS.add(id);
        }
    }

    private boolean checkLineIdDouble(String id) {
        String line = (String)_linesMap.get(id);
        return line != null;
    }

    private boolean checkFamilyIdDouble(String id) {
        for (String familyId : FAMILIES_IDS) {
            if (!familyId.equals(id)) continue;
            return true;
        }
        return false;
    }

    private void initializeBoards() {
        List<StellarResourceType> resources = StellarResources.getResourcesByType(StellarResources.SUPPORTED[0]);
        for (StellarResourceType resource : resources) {
            try {
                String name = resource.getName();
                String cpn = resource.getProperty(0);
                String id = resource.getId();
                String line = resource.getProperty(1);
                String description = resource.getProperty(2);
                String link = resource.getProperty(3);
                String family = resource.getProperty(4);
                Image image = (Image)resource.getResource();
                BoardType board = new BoardType(id, name, cpn, image, line, family);
                board.setDescription(description);
                board.setLink(link);
                BOARDS.add(board);
            }
            catch (StellarException e) {
                LogManager.getLogger().logError((Throwable)e);
            }
        }
    }

    private void initializeDevices() {
        DEVICES.add(new DeviceType(DEVICE_ALL, DEVICE_ALL, "All", "All", "All"));
        List<StellarResourceType> resources = StellarResources.getResourcesByType(StellarResources.SUPPORTED[2]);
        for (StellarResourceType resource : resources) {
            try {
                String name = resource.getName();
                String id = resource.getId();
                String line = resource.getProperty(0);
                String board = resource.getProperty(1);
                String family = resource.getProperty(2);
                DeviceType device = new DeviceType(id, name, line, board, family);
                DEVICES.add(device);
            }
            catch (StellarException e) {
                LogManager.getLogger().logError((Throwable)e);
            }
        }
    }

    private void initializeShields() {
        SHIELDS.add(new ShieldType(SHIELDS_ALL, "All", "All"));
        List<StellarResourceType> resources = StellarResources.getResourcesByType(StellarResources.SUPPORTED[3]);
        for (StellarResourceType resource : resources) {
            try {
                String name = resource.getName();
                String id = resource.getId();
                String board = resource.getProperty(1);
                ShieldType shield = new ShieldType(id, name, board);
                SHIELDS.add(shield);
            }
            catch (StellarException e) {
                LogManager.getLogger().logError((Throwable)e);
            }
        }
    }

    public static StellarSupportedProducts getInstance() {
        if (instance == null) {
            instance = new StellarSupportedProducts();
        }
        return instance;
    }

    private void registerImage(String key, String fileName) {
        try {
            Path path = new Path("images/" + fileName);
            URL url = FileLocator.find((Bundle)Activator.getContext().getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            LogManager.getLogger().logError((Throwable)e);
        }
    }

    public static Image getImage(String key) {
        return registry.get(key);
    }

    public static BoardType getBoard(String id) {
        for (BoardType board : BOARDS) {
            if (!board.getId().equals(id)) continue;
            return board;
        }
        return null;
    }

    public String getLine(String id) {
        return (String)_linesMap.get(id);
    }

    public String getLineID(String line) {
        for (Map.Entry<String, String> Line : _linesMap.entrySet()) {
            if (!Line.getValue().contentEquals(line)) continue;
            return Line.getKey();
        }
        return null;
    }

    public static ArrayList<BoardType> getBoardsFamily(String family) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        if (family.equals(FAMILIES_ALL)) {
            boards.addAll(BOARDS);
        } else {
            for (BoardType board : BOARDS) {
                if (board.getFamily() == null || !board.getFamily().equals(family)) continue;
                boards.add(board);
            }
        }
        return boards;
    }

    public static ArrayList<BoardType> getBoardsLine(String line) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        if (line.equals(LINE_ALL)) {
            boards.addAll(BOARDS);
        } else {
            for (BoardType board : BOARDS) {
                if (board.getLine() == null || !board.getLine().equals(line)) continue;
                boards.add(board);
            }
        }
        return boards;
    }

    private static ArrayList<BoardType> getBoardsLineDevice(String selectedLine, String selectedDevice) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        for (DeviceType device : DEVICES) {
            if (!device.getName().equals(selectedDevice)) continue;
            String boardDevice = device.getBoard();
            for (BoardType board : BOARDS) {
                if (board.getCpn() == null || !board.getCpn().equals(boardDevice) || !board.getLine().equals(selectedLine) && !selectedLine.equals(LINE_ALL)) continue;
                boolean boardFound = false;
                for (BoardType selectedBoard : boards) {
                    if (!board.getName().equals(selectedBoard.getName())) continue;
                    boardFound = true;
                }
                if (boardFound) continue;
                boards.add(board);
            }
        }
        return boards;
    }

    public static ArrayList<BoardType> getBoardsDeviceLine(String selectedLine, String selectedDevice) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        if (selectedLine.equals(LINE_ALL)) {
            if (selectedDevice.equals(DEVICE_ALL)) {
                boards.addAll(BOARDS);
            } else {
                boards = StellarSupportedProducts.getBoardsDevice(selectedDevice);
            }
        } else {
            boards = selectedDevice.equals(DEVICE_ALL) ? StellarSupportedProducts.getBoardsLine(selectedLine) : StellarSupportedProducts.getBoardsLineDevice(selectedLine, selectedDevice);
        }
        return boards;
    }

    public static ArrayList<BoardType> getBoardsFamilyLineDevice(String selectedFamily, String selectedLine, String selectedDevice) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        if (selectedFamily.equals(FAMILIES_ALL)) {
            if (selectedLine.equals(LINE_ALL)) {
                if (selectedDevice.equals(DEVICE_ALL)) {
                    boards.addAll(BOARDS);
                } else {
                    boards = StellarSupportedProducts.getBoardsDevice(selectedDevice);
                }
            } else {
                boards = selectedDevice.equals(DEVICE_ALL) ? StellarSupportedProducts.getBoardsLine(selectedLine) : StellarSupportedProducts.getBoardsLineDevice(selectedLine, selectedDevice);
            }
        } else {
            boards = selectedLine.equals(LINE_ALL) ? (selectedDevice.equals(DEVICE_ALL) ? StellarSupportedProducts.getBoardsFamily(selectedFamily) : StellarSupportedProducts.getBoardsFamilyDevice(selectedFamily, selectedDevice)) : (selectedDevice.equals(DEVICE_ALL) ? StellarSupportedProducts.getBoardsFamilyLine(selectedFamily, selectedLine) : StellarSupportedProducts.getBoardsLineDevice(selectedLine, selectedDevice));
        }
        return boards;
    }

    private static ArrayList<BoardType> getBoardsFamilyLine(String selectedFamily, String selectedLine) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        for (BoardType board : BOARDS) {
            if (board.getFamily() == null || !board.getFamily().equals(selectedFamily) || board.getLine() == null || !board.getLine().equals(selectedLine)) continue;
            boards.add(board);
        }
        return boards;
    }

    private static ArrayList<BoardType> getBoardsDevice(String selectedDevice) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        for (DeviceType device : DEVICES) {
            if (!device.getName().equals(selectedDevice)) continue;
            String boardDevice = device.getBoard();
            for (BoardType board : BOARDS) {
                if (!board.getCpn().equals(boardDevice)) continue;
                boards.add(board);
            }
        }
        return boards;
    }

    private static ArrayList<BoardType> getBoardsFamilyDevice(String selectedFamily, String selectedDevice) {
        ArrayList<BoardType> boards = new ArrayList<BoardType>();
        for (DeviceType device : DEVICES) {
            if (!device.getName().equals(selectedDevice)) continue;
            String boardDevice = device.getBoard();
            for (BoardType board : BOARDS) {
                if (!board.getCpn().equals(boardDevice) || board.getFamily() == null || !board.getFamily().equals(selectedFamily)) continue;
                boolean boardFound = false;
                for (BoardType selectedBoard : boards) {
                    if (!board.getName().equals(selectedBoard.getName())) continue;
                    boardFound = true;
                }
                if (boardFound) continue;
                boards.add(board);
            }
        }
        return boards;
    }

    public static ArrayList<DeviceType> getDevicesLine(String line) {
        ArrayList<DeviceType> devices = new ArrayList<DeviceType>();
        if (line.equals(LINE_ALL)) {
            devices.addAll(DEVICES);
        } else {
            for (DeviceType device : DEVICES) {
                String deviceLine = device.getLine();
                if (deviceLine.equals("All")) {
                    devices.add(device);
                }
                if (!deviceLine.equals(line)) continue;
                devices.add(device);
            }
        }
        return devices;
    }

    public static ArrayList<ShieldType> getShieldsBoard(String board) {
        ArrayList<ShieldType> shields = new ArrayList<ShieldType>();
        for (ShieldType shield : SHIELDS) {
            if (!shield.getBoard().equals(board)) continue;
            shields.add(shield);
        }
        return shields;
    }

    public static ArrayList<DeviceType> getDevicesBoard(String board) {
        ArrayList<DeviceType> devices = new ArrayList<DeviceType>();
        if (!board.isEmpty()) {
            for (DeviceType device : DEVICES) {
                String deviceboard = device.getBoard();
                if (!deviceboard.equals(board)) continue;
                devices.add(device);
            }
        }
        return devices;
    }

    public ArrayList<String> getFamilies() {
        return FAMILIES;
    }

    public ArrayList<String> getFamiliesIDs() {
        return FAMILIES_IDS;
    }

    public String[] getLines() {
        String[] y = _linesMap.values().toArray(new String[0]);
        return y;
    }

    public ArrayList<DeviceType> getDevices() {
        return DEVICES;
    }

    public ArrayList<ShieldType> getShields() {
        return SHIELDS;
    }

    public String getLinesIdFromValue() {
        return null;
    }

    static {
        registry = new ImageRegistry(Display.getDefault());
        LINE_ALL = Messages.StellarSupportedProducts_6;
        DEVICE_ALL = Messages.StellarSupportedProducts_7;
        SHIELDS_ALL = Messages.StellarSupportedProducts_8;
        FAMILIES_ALL = Messages.StellarSupportedProducts_9;
        BOARDS = new ArrayList();
        FAMILIES = new ArrayList();
        FAMILIES_IDS = new ArrayList();
        _linesMap = new TreeMap<String, String>();
        DEVICES = new ArrayList();
        SHIELDS = new ArrayList();
    }
}

