/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.extensions.res.handlers;

import com.st.stellar.exceptions.StellarException;
import com.st.stellar.extensions.res.handlers.ResourceHandler;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class LinesResourceHandler
extends ResourceHandler {
    public static final int PROPERTY_FAMILY = 0;
    public static final String[] SUPPORTED_PROPS = new String[]{"family"};

    @Override
    public Object create(URL url) throws StellarException {
        Image image = null;
        try {
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                image = desc.createImage();
            }
        }
        catch (Exception e) {
            throw new StellarException(url.getPath() + ": " + String.valueOf(e));
        }
        return image;
    }

    @Override
    public void dispose(Object resource) {
        Assert.isTrue((boolean)(resource instanceof Image));
        Image image = (Image)resource;
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    @Override
    public boolean isPropertySupported(String name) {
        boolean supported = false;
        for (String p : SUPPORTED_PROPS) {
            if (!p.equals(name)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    @Override
    public String getProperty(int id, Map<String, String> info) throws StellarException {
        switch (id) {
            case 0: {
                return info.get(SUPPORTED_PROPS[id]);
            }
        }
        throw new StellarException("Unsupported property identifier!");
    }
}

