/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.extensions.res.handlers;

import com.st.stellar.app.wizard.resources.extensions.IResourcesExtension;
import com.st.stellar.exceptions.StellarException;
import com.st.stellar.extensions.res.handlers.BoardsResourceHandler;
import com.st.stellar.extensions.res.handlers.DevicesResourceHandler;
import com.st.stellar.extensions.res.handlers.FamiliesResourceHandler;
import com.st.stellar.extensions.res.handlers.LinesResourceHandler;
import com.st.stellar.extensions.res.handlers.Messages;
import com.st.stellar.extensions.res.handlers.ResourceHandler;
import com.st.stellar.extensions.res.handlers.ShieldsResourceHandler;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class StellarResourceType {
    private String name;
    private String id;
    private String type;
    private URL url;
    private Object resource;
    private Map<String, String> info = new HashMap<String, String>();
    private ResourceHandler handler = null;

    public StellarResourceType() throws StellarException {
        this.create();
    }

    public StellarResourceType(String name, String id, String type, URL url) throws StellarException {
        this.name = name;
        this.id = id;
        this.type = type;
        this.url = url;
        this.create();
    }

    public boolean isSupported() {
        for (String type : IResourcesExtension.SUPPORTED) {
            if (!type.equals(this.type)) continue;
            return true;
        }
        return false;
    }

    private void create() throws StellarException {
        if (this.isSupported()) {
            if (this.type.equals(IResourcesExtension.SUPPORTED[0])) {
                this.handler = new BoardsResourceHandler();
                if (this.url != null) {
                    this.resource = this.handler.create(this.url);
                    if (this.resource == null) {
                        throw new StellarException(Messages.StellarResourceType_0 + String.valueOf(this.url));
                    }
                }
                return;
            }
            if (this.type.equals(IResourcesExtension.SUPPORTED[1])) {
                this.handler = new LinesResourceHandler();
                if (this.url != null) {
                    this.resource = this.handler.create(this.url);
                    if (this.resource == null) {
                        throw new StellarException(Messages.StellarResourceType_0 + String.valueOf(this.url));
                    }
                }
                return;
            }
            if (this.type.equals(IResourcesExtension.SUPPORTED[2])) {
                this.handler = new DevicesResourceHandler();
                return;
            }
            if (this.type.equals(IResourcesExtension.SUPPORTED[3])) {
                this.handler = new ShieldsResourceHandler();
                return;
            }
            if (this.type.equals(IResourcesExtension.SUPPORTED[4])) {
                this.handler = new FamiliesResourceHandler();
                if (this.url != null) {
                    this.resource = this.handler.create(this.url);
                    if (this.resource == null) {
                        throw new StellarException(Messages.StellarResourceType_0 + String.valueOf(this.url));
                    }
                }
                return;
            }
        }
        throw new StellarException(Messages.StellarResourceType_1);
    }

    public void dispose() {
        this.handler.dispose(this.resource);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getResource() {
        return this.resource;
    }

    public void setResource(Object resource) throws StellarException {
        this.resource = resource;
        if (resource != null && this.handler != null) {
            this.handler.dispose(resource);
        }
        this.create();
    }

    public boolean isPropertySupported(String name) {
        return this.handler.isPropertySupported(name);
    }

    public String getProperty(int id) throws StellarException {
        return this.handler.getProperty(id, this.info);
    }

    public Map<String, String> getInfo() {
        return this.info;
    }
}

